/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.text.format.DateUtils;
import android.view.View;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.dialog.PromptDialog;
import com.transsion.widgetslib.widget.timepicker.OSDateTimePicker;
import java.util.Calendar;

public class OSDateTimePickerDialog {
    private Context mContext;
    private PromptDialog.Builder mBuilder;
    private Calendar mCalendar;
    private OSDateTimePicker mDateTimePicker;
    private OnChangeListener mOnChangeListener;
    private OnDateTimeSetListener mOnDateTimeSetListener;
    private PromptDialog mDialog;
    private String mFormat = "yyyy-MM-dd HH:mm";
    private int mStartYear;
    private int mEndYear;
    OSDateTimePicker.OnDateTimeChangeListener dateOnchangeListener = new OSDateTimePicker.OnDateTimeChangeListener(){

        @Override
        public void onChange(OSDateTimePicker picker, Calendar calendar) {
            OSDateTimePickerDialog.this.mCalendar = calendar;
            OSDateTimePickerDialog.this.onChanged();
        }
    };

    public OSDateTimePickerDialog(Context context) {
        this.mContext = context;
        this.mBuilder = new PromptDialog.Builder(this.mContext);
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
    }

    public OSDateTimePickerDialog(Context context, int year, int month, int day, int hour, int minute) {
        this.mContext = context;
        this.mBuilder = new PromptDialog.Builder(this.mContext);
        this.mCalendar = Calendar.getInstance();
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.mCalendar.set(11, hour);
        this.mCalendar.set(12, minute);
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
    }

    public OSDateTimePickerDialog(Context context, int year, int month, int day) {
        this.mContext = context;
        this.mBuilder = new PromptDialog.Builder(this.mContext);
        this.mCalendar = Calendar.getInstance();
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, day);
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
    }

    public OSDateTimePickerDialog(Context context, int hour, int minute) {
        this.mContext = context;
        this.mBuilder = new PromptDialog.Builder(this.mContext);
        this.mCalendar = Calendar.getInstance();
        this.mCalendar.set(11, hour);
        this.mCalendar.set(12, minute);
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
    }

    public OSDateTimePickerDialog setTitle(CharSequence title) {
        this.mBuilder.setTopTitle(title);
        return this;
    }

    public OSDateTimePickerDialog setTitle(int title) {
        this.mBuilder.setTopTitle(title);
        return this;
    }

    public OSDateTimePickerDialog setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setPositiveButton(text, listener);
        return this;
    }

    public OSDateTimePickerDialog setPositiveButton(int textId, DialogInterface.OnClickListener listener) {
        return this.setPositiveButton(this.mContext.getText(textId), listener);
    }

    public OSDateTimePickerDialog setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setNegativeButton(text, listener);
        return this;
    }

    public OSDateTimePickerDialog setNegativeButton(int textId, DialogInterface.OnClickListener listener) {
        return this.setNegativeButton(this.mContext.getText(textId), listener);
    }

    public OSDateTimePickerDialog setCancelable(boolean cancelAble) {
        this.mBuilder.setCancelable(cancelAble);
        return this;
    }

    public OSDateTimePickerDialog setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.mBuilder.setCanceledOnTouchOutside(canceledOnTouchOutside);
        return this;
    }

    public OSDateTimePickerDialog setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
        this.mBuilder.setOnCancelListener(onCancelListener);
        return this;
    }

    public OSDateTimePickerDialog setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
        this.mBuilder.setOnDismissListener(onDismissListener);
        return this;
    }

    public void disMiss() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.dismiss();
        }
    }

    public boolean isShowing() {
        return this.mDialog != null && this.mDialog.isShowing();
    }

    public OSDateTimePicker getDateTimePicker() {
        return this.mDateTimePicker;
    }

    public void setFormat(String format) {
        this.mFormat = format;
    }

    public PromptDialog create() {
        this.setPickerView();
        this.mDialog = this.mBuilder.create();
        this.mDialog.setTitleSingleLine();
        this.updateTitle();
        return this.mDialog;
    }

    private void setPickerView() {
        if (this.mCalendar == null) {
            this.mCalendar = Calendar.getInstance();
        }
        View view = View.inflate((Context)this.mContext, (int)R.layout.os_picker_date_time_layout, null);
        this.mDateTimePicker = (OSDateTimePicker)view.findViewById(R.id.datePicker);
        if (this.mStartYear != 0 || this.mEndYear != 0) {
            this.mDateTimePicker.setYearDuration(this.mStartYear, this.mEndYear);
        }
        this.mDateTimePicker.init(this.mCalendar, this.mFormat);
        this.mDateTimePicker.setOnDateChangeListener(this.dateOnchangeListener);
        this.mBuilder.setView(view);
    }

    public OSDateTimePickerDialog setOnChangeListener(OnChangeListener onChangeListener) {
        this.mOnChangeListener = onChangeListener;
        return this;
    }

    public OSDateTimePickerDialog setOnDateTimeSetListener(OnDateTimeSetListener onDateTimeSetListener) {
        this.mOnDateTimeSetListener = onDateTimeSetListener;
        this.mBuilder.setPositiveButton(R.string.os_preference_dialog_positive_string, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                if (OSDateTimePickerDialog.this.mOnDateTimeSetListener != null) {
                    OSDateTimePickerDialog.this.mOnDateTimeSetListener.onDateTimeSet(OSDateTimePickerDialog.this.mDateTimePicker, OSDateTimePickerDialog.this.mCalendar, OSDateTimePickerDialog.this.mCalendar.get(1), OSDateTimePickerDialog.this.mCalendar.get(2), OSDateTimePickerDialog.this.mCalendar.get(5), OSDateTimePickerDialog.this.mCalendar.get(11), OSDateTimePickerDialog.this.mCalendar.get(12), OSDateTimePickerDialog.this.mCalendar.get(9));
                }
            }
        });
        return this;
    }

    private void onChanged() {
        if (this.mOnChangeListener != null && this.isShowing()) {
            this.mOnChangeListener.onChange(this.mDateTimePicker, this.mCalendar, this.mCalendar.get(1), this.mCalendar.get(2), this.mCalendar.get(5), this.mCalendar.get(11), this.mCalendar.get(12), this.mCalendar.get(9));
            this.updateTitle();
        }
    }

    private String getTitle() {
        int flag = "yyyy-MM-dd".equals(this.mFormat) ? 22 : ("HH:mm".equals(this.mFormat) ? 1 : 23);
        String result = DateUtils.formatDateTime((Context)this.mContext, (long)this.mCalendar.getTimeInMillis(), (int)flag);
        return result;
    }

    private void updateTitle() {
        if (this.mDialog != null) {
            this.mDialog.setTitle(this.getTitle());
        }
    }

    public void updateTime(int hour, int minute) {
        if (this.mDateTimePicker != null) {
            this.mDateTimePicker.updateTime(hour, minute);
        }
    }

    public void updateDate(int year, int month, int day) {
        if (this.mDateTimePicker != null) {
            this.mDateTimePicker.updateDate(year, month, day);
        }
    }

    public void updateDateTime(int year, int month, int day, int hour, int minute) {
        if (this.mDateTimePicker != null) {
            this.mDateTimePicker.updateDateTime(year, month, day, hour, minute);
        }
    }

    public void setYearDuration(int startYear, int endYear) {
        this.mStartYear = startYear;
        this.mEndYear = endYear;
    }

    public static interface OnDateTimeSetListener {
        public void onDateTimeSet(OSDateTimePicker var1, Calendar var2, int var3, int var4, int var5, int var6, int var7, int var8);
    }

    public static interface OnChangeListener {
        public void onChange(OSDateTimePicker var1, Calendar var2, int var3, int var4, int var5, int var6, int var7, int var8);
    }
}

