/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.CursorAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.dialog.PromptParams;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.widget.timepicker.OSDateTimePicker;
import java.lang.ref.WeakReference;

public final class PromptController {
    private String TAG = PromptController.class.getSimpleName();
    private static final int LIST_ITEM_LAYOUT = R.layout.os_prompt_dialog_list_item;
    private static final int LIST_ITEM_SINGLE_CHOICE_LAYOUT = R.layout.os_prompt_dialog_list_singlechoice_item;
    private static final int LIST_ITEM_MULTI_CHOICE_LAYOUT = R.layout.os_prompt_dialog_list_multichoice_item;
    private static final int LIST_ITEM_ID = R.id.text_list_item;
    private final Context mContext;
    private final DialogInterface mDialogInterface;
    private final Window mWindow;
    private final LayoutInflater mInflater;
    private Handler mHandler;
    private FrameLayout mView;
    private LinearLayout mContainer;
    private LinearLayout mBtnLayout;
    private LinearLayout mTitleView;
    private TextView mTopTitleView;
    private ScrollView mScrollMessageView;
    private FrameLayout mFrameContainer;
    private ListView mListView;
    public int mCheckedItem = -1;
    public boolean[] mCheckedItems;
    private boolean mIsButtonVertical = false;
    private boolean mIsAlert;
    private boolean mHasPositiveButton;
    private boolean mPositiveButtonEnable = true;
    private Button mButtonPositive;
    private CharSequence mButtonPositiveText;
    private Message mButtonPositiveMessage;
    private boolean mHasNegativeButton;
    private Button mButtonNegative;
    private CharSequence mButtonNegativeText;
    private Message mButtonNegativeMessage;
    private boolean mHasNeutralButton;
    private Button mButtonNeutral;
    private CharSequence mButtonNeutralText;
    private Message mButtonNeutralMessage;
    private Drawable mIcon;
    private boolean mAutoDismiss = true;
    private boolean mIsInputDialog = false;
    private boolean mIsAppDialogFragment = false;
    private int mNoBtnBottomInsets;
    private final View.OnClickListener mButtonListener = new View.OnClickListener(){

        public void onClick(View v) {
            Object m = v == PromptController.this.mButtonPositive && PromptController.this.mButtonPositiveMessage != null ? Message.obtain((Message)PromptController.this.mButtonPositiveMessage) : (v == PromptController.this.mButtonNegative && PromptController.this.mButtonNegativeMessage != null ? Message.obtain((Message)PromptController.this.mButtonNegativeMessage) : (v == PromptController.this.mButtonNeutral && PromptController.this.mButtonNeutralMessage != null ? Message.obtain((Message)PromptController.this.mButtonNeutralMessage) : null));
            if (m != null) {
                m.sendToTarget();
            }
            if (PromptController.this.mAutoDismiss) {
                PromptController.this.mHandler.obtainMessage(1, (Object)PromptController.this.mDialogInterface).sendToTarget();
            }
        }
    };

    public PromptController(Context context, DialogInterface di, Window window) {
        this.mContext = context;
        this.mDialogInterface = di;
        this.mWindow = window;
        this.mHandler = new ButtonHandler(di);
        this.mInflater = LayoutInflater.from((Context)context);
        window.requestFeature(1);
        window.setGravity(80);
        this.mView = (FrameLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_container, null);
        this.mView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return true;
            }
        });
        this.mContainer = (LinearLayout)this.mView.findViewById(R.id.mContainer);
        this.mBtnLayout = (LinearLayout)this.mView.findViewById(R.id.btnLayout);
    }

    public void installContent() {
        this.mWindow.setContentView((View)this.mView);
        this.mWindow.setWindowAnimations(R.style.OsInputDialogAnimStyle);
        this.setupView();
        if (this.mIsInputDialog || this.mContainer != null && PromptController.canTextInput((View)this.mContainer)) {
            Utils.setInputDialogWindowBackGround(this.mWindow.getContext(), this.mWindow);
        }
    }

    public void setTitleView(CharSequence title) {
        if (!TextUtils.isEmpty((CharSequence)title)) {
            if (this.mTitleView == null) {
                this.mTitleView = (LinearLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_title, (ViewGroup)this.mContainer, false);
            }
            TextView textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title);
            textTitle.setText(title);
        }
    }

    public void setTopTitle(CharSequence topTitle) {
        if (!TextUtils.isEmpty((CharSequence)topTitle)) {
            if (this.mTitleView == null) {
                this.mTitleView = (LinearLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_title, (ViewGroup)this.mContainer, false);
            }
            this.mTopTitleView = (TextView)this.mTitleView.findViewById(R.id.text_top_title);
            this.mTopTitleView.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.os_text_tertiary_color));
            if (this.mTopTitleView != null) {
                this.mTopTitleView.setVisibility(0);
                this.mTopTitleView.setText(topTitle);
            }
        }
    }

    public void setMessageView(CharSequence message) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            this.mScrollMessageView = (ScrollView)this.mInflater.inflate(R.layout.os_prompt_dialog_message, (ViewGroup)this.mContainer, false);
            TextView messageView = (TextView)this.mScrollMessageView.findViewById(R.id.text_message);
            messageView.setText(message);
        }
    }

    public void setView(int resId, View view) {
        if (resId != 0 || view != null) {
            this.mFrameContainer = (FrameLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_view, (ViewGroup)this.mContainer, false);
            if (resId != 0) {
                this.mFrameContainer.addView(this.mInflater.inflate(resId, (ViewGroup)this.mFrameContainer, false));
            } else {
                this.mFrameContainer.addView(view);
            }
        }
    }

    public void setButton(int whichButton, CharSequence text, DialogInterface.OnClickListener listener, Message msg) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        if (msg == null && listener != null) {
            msg = this.mHandler.obtainMessage(whichButton, (Object)listener);
        }
        switch (whichButton) {
            case -1: {
                this.mButtonPositiveText = text;
                this.mButtonPositiveMessage = msg;
                this.mHasPositiveButton = true;
                break;
            }
            case -2: {
                this.mButtonNegativeText = text;
                this.mButtonNegativeMessage = msg;
                this.mHasNegativeButton = true;
                break;
            }
            case -3: {
                this.mButtonNeutralText = text;
                this.mButtonNeutralMessage = msg;
                this.mHasNeutralButton = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Button does not exist");
            }
        }
    }

    public void setPositiveButtonEnable(boolean positiveButtonEnable) {
        this.mPositiveButtonEnable = positiveButtonEnable;
    }

    public void setList(CharSequence[] items, DialogInterface.OnClickListener listener) {
        ArrayAdapter adapter = new ArrayAdapter(this.mContext, LIST_ITEM_LAYOUT, LIST_ITEM_ID, (Object[])items);
        this.setList((ListAdapter)adapter, listener);
    }

    public void setList(ListAdapter adapter, final DialogInterface.OnClickListener listener) {
        this.mListView = this.generateListView(adapter, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (listener != null) {
                    listener.onClick(PromptController.this.mDialogInterface, position);
                    PromptController.this.mDialogInterface.dismiss();
                }
            }
        });
    }

    public void setList(Cursor cursor, String labelColumn, DialogInterface.OnClickListener listener) {
        SimpleCursorAdapter adapter = new SimpleCursorAdapter(this.mContext, LIST_ITEM_LAYOUT, cursor, new String[]{labelColumn}, new int[]{LIST_ITEM_ID}, 2);
        this.setList((ListAdapter)adapter, listener);
    }

    public void setSingleChoiceList(CharSequence[] items, DialogInterface.OnClickListener listener) {
        CheckedItemAdapter adapter = new CheckedItemAdapter(this.mContext, LIST_ITEM_SINGLE_CHOICE_LAYOUT, LIST_ITEM_ID, items);
        this.setSingleChoiceList((ListAdapter)adapter, listener);
    }

    public void setSingleChoiceList(ListAdapter adapter, final DialogInterface.OnClickListener listener) {
        this.mListView = this.generateListView(adapter, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (listener != null) {
                    listener.onClick(PromptController.this.mDialogInterface, position);
                }
                PromptController.this.setListPositiveButtonStatus();
            }
        });
        this.mListView.setChoiceMode(1);
    }

    public void setSingleChoiceList(Cursor cursor, String labelColumn, DialogInterface.OnClickListener listener) {
        SimpleCursorAdapter adapter = new SimpleCursorAdapter(this.mContext, LIST_ITEM_SINGLE_CHOICE_LAYOUT, cursor, new String[]{labelColumn}, new int[]{LIST_ITEM_ID}, 2);
        this.setSingleChoiceList((ListAdapter)adapter, listener);
    }

    public void setMultiChoiceList(CharSequence[] items, boolean[] checkedItems, DialogInterface.OnMultiChoiceClickListener listener) {
        this.dealCheckItems(items, checkedItems);
        ArrayAdapter<CharSequence> adapter = new ArrayAdapter<CharSequence>(this.mContext, LIST_ITEM_MULTI_CHOICE_LAYOUT, LIST_ITEM_ID, items){

            public View getView(int position, View convertView, ViewGroup parent) {
                boolean isItemChecked;
                View view = super.getView(position, convertView, parent);
                if (PromptController.this.mCheckedItems != null && PromptController.this.mListView != null && (isItemChecked = PromptController.this.mCheckedItems[position])) {
                    PromptController.this.mListView.setItemChecked(position, true);
                }
                return view;
            }
        };
        this.setMultiChoiceList((ListAdapter)adapter, listener);
    }

    private void dealCheckItems(CharSequence[] items, boolean[] checkedItems) {
        if (checkedItems == null) {
            return;
        }
        if (items.length == checkedItems.length) {
            this.mCheckedItems = checkedItems;
        } else {
            this.mCheckedItems = new boolean[items.length];
            for (int i = 0; i < items.length; ++i) {
                this.mCheckedItems[i] = i < checkedItems.length && checkedItems[i];
            }
        }
    }

    public void setMultiChoiceList(Cursor cursor, final String labelColumn, final String isCheckedColumn, DialogInterface.OnMultiChoiceClickListener listener) {
        CursorAdapter adapter = new CursorAdapter(this.mContext, cursor, false){
            private final int mLabelIndex;
            private final int mIsCheckedIndex;
            {
                super(arg0, arg1, arg2);
                Cursor cursor = this.getCursor();
                this.mLabelIndex = cursor.getColumnIndexOrThrow(labelColumn);
                this.mIsCheckedIndex = cursor.getColumnIndexOrThrow(isCheckedColumn);
            }

            public void bindView(View view, Context context, Cursor cursor) {
                CheckedTextView text = (CheckedTextView)view.findViewById(LIST_ITEM_ID);
                text.setText((CharSequence)cursor.getString(this.mLabelIndex));
                if (PromptController.this.mListView != null) {
                    PromptController.this.mListView.setItemChecked(cursor.getPosition(), cursor.getInt(this.mIsCheckedIndex) == 1);
                }
            }

            public View newView(Context context, Cursor cursor, ViewGroup parent) {
                return PromptController.this.mInflater.inflate(LIST_ITEM_MULTI_CHOICE_LAYOUT, parent, false);
            }
        };
        this.setMultiChoiceList((ListAdapter)adapter, listener);
    }

    private void setMultiChoiceList(ListAdapter adapter, final DialogInterface.OnMultiChoiceClickListener listener) {
        this.mListView = this.generateListView(adapter, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (listener != null && PromptController.this.mListView != null) {
                    if (PromptController.this.mCheckedItems != null) {
                        PromptController.this.mCheckedItems[position] = PromptController.this.mListView.isItemChecked(position);
                    }
                    PromptController.this.setListPositiveButtonStatus();
                    listener.onClick(PromptController.this.mDialogInterface, position, PromptController.this.mListView.isItemChecked(position));
                }
            }
        });
        this.mListView.setChoiceMode(2);
    }

    private void setListPositiveButtonStatus() {
        if (!this.mPositiveButtonEnable && this.mButtonPositive != null && this.mListView != null) {
            this.mButtonPositive.setEnabled(this.mListView.getCheckedItemCount() > 0);
        }
    }

    private ListView generateListView(ListAdapter adapter, AdapterView.OnItemClickListener l) {
        ListView listView = (ListView)this.mInflater.inflate(R.layout.os_prompt_dialog_list, (ViewGroup)this.mContainer, false);
        listView.setAdapter(adapter);
        listView.setOnItemClickListener(l);
        listView.setDivider(null);
        return listView;
    }

    public void onPrepareListView(PromptParams.OnPrepareListViewListener listener) {
        if (this.mListView != null) {
            listener.onPrepareListView(this.mListView);
        }
    }

    public void setCheckedItem(int checkedItem) {
        this.mCheckedItem = checkedItem;
        if (this.mListView != null) {
            this.mListView.setItemChecked(checkedItem, true);
            this.mListView.setSelection(checkedItem);
        }
    }

    private void setupView() {
        TextView titleView;
        boolean hasListView;
        this.mContainer.removeAllViews();
        this.mBtnLayout.removeAllViews();
        boolean hasTitle = this.mTitleView != null;
        boolean hasMessage = this.mScrollMessageView != null;
        boolean hasCustomView = this.mFrameContainer != null;
        boolean bl = hasListView = this.mListView != null;
        if (hasTitle) {
            this.mContainer.addView((View)this.mTitleView);
        }
        if (hasMessage) {
            if (hasTitle) {
                this.mScrollMessageView.setPadding(0, (int)this.mContext.getResources().getDimension(R.dimen.os_dialog_message_padding_top), 0, 0);
            } else if (hasCustomView) {
                this.mScrollMessageView.setPadding(0, 0, 0, (int)this.mContext.getResources().getDimension(R.dimen.os_dialog_message_padding_top));
            } else {
                this.mScrollMessageView.setPadding(0, 0, 0, 0);
            }
            this.mScrollMessageView.setOverScrollMode(2);
            this.mContainer.addView((View)this.mScrollMessageView);
        }
        if (hasListView && !hasMessage) {
            this.mListView.setOverScrollMode(2);
            this.mContainer.addView((View)this.mListView);
        }
        if (hasListView && hasTitle && (titleView = this.getTitleView()) != null) {
            titleView.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.os_text_tertiary_color));
            titleView.setTextSize(0, this.mContext.getResources().getDimension(R.dimen.os_body_font));
            titleView.setTextAppearance(R.style.os_regular_fontweight);
            titleView.setPadding((int)this.mContext.getResources().getDimension(R.dimen.os_dialog_padding_left_right), 0, (int)this.mContext.getResources().getDimension(R.dimen.os_dialog_padding_left_right), (int)this.mContext.getResources().getDimension(R.dimen.os_dialog_message_padding_bottom));
        }
        if (hasListView && !hasTitle) {
            this.mContainer.setPadding(0, 0, 0, 0);
        }
        if (hasCustomView) {
            TextView textTitle;
            LinearLayout.LayoutParams lp;
            if (hasMessage) {
                lp = (LinearLayout.LayoutParams)this.mScrollMessageView.getLayoutParams();
                lp.height = -2;
                lp.weight = 0.0f;
                this.mScrollMessageView.setLayoutParams((ViewGroup.LayoutParams)lp);
            } else if (hasListView) {
                lp = (LinearLayout.LayoutParams)this.mFrameContainer.getLayoutParams();
                lp.height = -2;
                lp.weight = 0.0f;
                this.mFrameContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
            } else if (this.hasPickView((View)this.mFrameContainer) && this.mTitleView != null && (textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title)) != null) {
                textTitle.setTextSize(0, this.mContext.getResources().getDimension(R.dimen.os_body_font));
                int padding = this.mContext.getResources().getDimensionPixelSize(R.dimen.os_dialog_padding_left_right);
                textTitle.setPadding(padding, 0, (int)((float)padding / 1.5f), 0);
            }
            this.mContainer.addView((View)this.mFrameContainer);
        }
        this.setupButtons(hasCustomView);
    }

    public int getNoBtnBottomInsets() {
        return this.mNoBtnBottomInsets;
    }

    public void setNoBtnBottomInsets(int mNoBtnBottomInsets) {
        this.mNoBtnBottomInsets = mNoBtnBottomInsets;
    }

    private void noButtonInsets() {
        ((FrameLayout.LayoutParams)this.mContainer.getLayoutParams()).setMargins(0, 0, 0, this.mNoBtnBottomInsets);
    }

    private boolean hasPickView(View view) {
        if (view.getVisibility() == 0 && view instanceof OSDateTimePicker) {
            return true;
        }
        if (!(view instanceof ViewGroup)) {
            return false;
        }
        ViewGroup vg = (ViewGroup)view;
        int i = vg.getChildCount();
        while (i > 0) {
            if ((view = vg.getChildAt(--i)).getVisibility() != 0 || !this.hasPickView(view)) continue;
            return true;
        }
        return false;
    }

    private int dp2px(int dpValues) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValues, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
    }

    private void setupButtons(boolean hasCustomView) {
        if (!(this.mHasPositiveButton || this.mHasNegativeButton || this.mHasNeutralButton)) {
            this.noButtonInsets();
            return;
        }
        if (hasCustomView && PromptController.canTextInput((View)this.mFrameContainer)) {
            this.mIsButtonVertical = false;
        } else {
            this.mBtnLayout.addView(this.mInflater.inflate(R.layout.os_dialog_horizontal_divider, (ViewGroup)this.mBtnLayout, false));
            this.mWindow.setFlags(131072, 131072);
        }
        View buttonsView = this.mInflater.inflate(this.mIsButtonVertical ? R.layout.os_prompt_dialog_buttons_vertical : R.layout.os_prompt_dialog_buttons_horizontal, (ViewGroup)this.mBtnLayout, false);
        this.mButtonPositive = (Button)buttonsView.findViewById(R.id.btn_positive);
        if (this.mHasPositiveButton) {
            this.mButtonPositive.setText(this.mButtonPositiveText);
            this.mButtonPositive.setOnClickListener(this.mButtonListener);
            this.mButtonPositive.setEnabled(this.mPositiveButtonEnable);
            if (this.mIsAlert) {
                this.mButtonPositive.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.os_dialog_positive_btn_alert_color));
            }
        } else {
            this.mButtonPositive.setVisibility(8);
            if (!this.mIsButtonVertical) {
                // empty if block
            }
        }
        this.mButtonNegative = (Button)buttonsView.findViewById(R.id.btn_negative);
        if (this.mHasNegativeButton) {
            this.mButtonNegative.setText(this.mButtonNegativeText);
            this.mButtonNegative.setOnClickListener(this.mButtonListener);
        } else {
            this.mButtonNegative.setVisibility(8);
        }
        this.mButtonNeutral = (Button)buttonsView.findViewById(R.id.btn_neutral);
        if (this.mHasNeutralButton) {
            this.mButtonNeutral.setText(this.mButtonNeutralText);
            this.mButtonNeutral.setOnClickListener(this.mButtonListener);
        } else {
            this.mButtonNeutral.setVisibility(8);
            if (!this.mIsButtonVertical) {
                // empty if block
            }
        }
        this.mBtnLayout.addView(buttonsView);
        if (this.mContainer != null) {
            int btnHeight = (int)this.mContext.getResources().getDimension(R.dimen.os_dialog_button_height);
            if (this.mIsButtonVertical) {
                btnHeight = btnHeight * (this.mHasPositiveButton ? 1 : 0) + btnHeight * (this.mHasNegativeButton ? 1 : 0) + btnHeight * (this.mHasNeutralButton ? 1 : 0);
            }
            if (this.mIsInputDialog) {
                ((FrameLayout.LayoutParams)this.mContainer.getLayoutParams()).setMargins(0, 0, 0, btnHeight);
            } else {
                ((FrameLayout.LayoutParams)this.mContainer.getLayoutParams()).setMargins(0, 0, 0, btnHeight + (int)this.mContext.getResources().getDimension(this.mListView != null ? R.dimen.os_dialog_divider_margin_10 : R.dimen.os_dialog_divider_margin));
            }
        }
    }

    static boolean canTextInput(View v) {
        if (v.onCheckIsTextEditor()) {
            return true;
        }
        if (!(v instanceof ViewGroup)) {
            return false;
        }
        ViewGroup vg = (ViewGroup)v;
        int i = vg.getChildCount();
        while (i > 0) {
            if ((v = vg.getChildAt(--i)).getVisibility() != 0 || !PromptController.canTextInput(v)) continue;
            return true;
        }
        return false;
    }

    public Button getButton(int whichButton) {
        switch (whichButton) {
            case -1: {
                return this.mButtonPositive;
            }
            case -2: {
                return this.mButtonNegative;
            }
            case -3: {
                return this.mButtonNeutral;
            }
        }
        return null;
    }

    public TextView getTitleView() {
        TextView titleText = null;
        if (this.mTitleView != null) {
            titleText = (TextView)this.mTitleView.findViewById(R.id.text_title);
        }
        return titleText;
    }

    public ListView getListView() {
        return this.mListView;
    }

    public void setIsAlert(boolean isAlert) {
        this.mIsAlert = isAlert;
    }

    public void setTitle(CharSequence title) {
        if (this.mTitleView != null) {
            TextView textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title);
            textTitle.setText(title);
        } else {
            this.setTitleView(title);
        }
    }

    public void setTitleSingleLine() {
        if (this.mTitleView != null) {
            TextView textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title);
            textTitle.setSingleLine();
            textTitle.setEllipsize(TextUtils.TruncateAt.END);
        } else {
            this.mTitleView = (LinearLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_title, (ViewGroup)this.mContainer, false);
            TextView textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title);
            textTitle.setSingleLine();
            textTitle.setEllipsize(TextUtils.TruncateAt.END);
        }
    }

    public void setIcon(Drawable icon) {
        if (this.mIcon != icon || icon != null) {
            if (this.mTitleView != null) {
                this.setIconContent(icon);
            } else {
                this.mTitleView = (LinearLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_title, (ViewGroup)this.mContainer, false);
                this.setIconContent(icon);
            }
            this.mIcon = icon;
        }
    }

    private void setIconContent(Drawable icon) {
        ImageView iconImg = (ImageView)this.mTitleView.findViewById(R.id.iconImg);
        if (iconImg != null) {
            iconImg.setVisibility(0);
            iconImg.setImageDrawable(icon);
        }
    }

    public void setMessage(CharSequence message) {
        if (this.mScrollMessageView != null) {
            TextView messageView = (TextView)this.mScrollMessageView.findViewById(R.id.text_message);
            messageView.setText(message);
        } else {
            this.setMessageView(message);
        }
    }

    public void setIsInputDialog(boolean isInputDialog) {
        this.mIsInputDialog = isInputDialog;
    }

    public void setIsAppDialogFragment(boolean isAppDialogFragment) {
        this.mIsAppDialogFragment = isAppDialogFragment;
    }

    public boolean getIsAppDialogFragment() {
        return this.mIsAppDialogFragment;
    }

    private void addScrollChangeListener() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.mScrollMessageView.setOnScrollChangeListener(new View.OnScrollChangeListener(){

                public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                    if (scrollY > 0) {
                        if (PromptController.this.mScrollMessageView.getBackground() == null) {
                            PromptController.this.mScrollMessageView.setBackgroundResource(R.drawable.os_dialog_split_top_line);
                        }
                    } else {
                        PromptController.this.mScrollMessageView.setBackground(null);
                    }
                }
            });
        }
    }

    public void setElegantTextHeight(boolean elegant) {
        TextView message;
        if (this.mScrollMessageView != null && (message = (TextView)this.mScrollMessageView.findViewById(R.id.text_message)) != null && elegant != message.getPaint().isElegantTextHeight()) {
            message.setElegantTextHeight(elegant);
        }
    }

    public void setAutoDismiss(boolean autoDismiss) {
        this.mAutoDismiss = autoDismiss;
    }

    public void setButtonVertical(boolean buttonVertical) {
        this.mIsButtonVertical = buttonVertical;
    }

    private static class CheckedItemAdapter
    extends ArrayAdapter<CharSequence> {
        public CheckedItemAdapter(Context context, int resource, int textViewResourceId, CharSequence[] objects) {
            super(context, resource, textViewResourceId, (Object[])objects);
        }

        public boolean hasStableIds() {
            return true;
        }

        public long getItemId(int position) {
            return position;
        }
    }

    private static final class ButtonHandler
    extends Handler {
        private static final int MSG_DISMISS_DIALOG = 1;
        private WeakReference<DialogInterface> mDialog;

        ButtonHandler(DialogInterface dialog) {
            this.mDialog = new WeakReference<DialogInterface>(dialog);
        }

        public void handleMessage(Message msg) {
            try {
                switch (msg.what) {
                    case -3: 
                    case -2: 
                    case -1: {
                        ((DialogInterface.OnClickListener)msg.obj).onClick((DialogInterface)this.mDialog.get(), msg.what);
                        break;
                    }
                    case 1: {
                        ((DialogInterface)msg.obj).dismiss();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

