/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.transsion.widgetslib.dialog.PromptController;

public final class PromptParams {
    public final Context mContext;
    public CharSequence mTitle;
    public CharSequence mTopTitle;
    public Drawable mIcon;
    public CharSequence mMessage;
    public CharSequence mPositiveButtonText;
    public DialogInterface.OnClickListener mPositiveButtonListener;
    public boolean mPositiveButtonEnable = true;
    public CharSequence mNegativeButtonText;
    public DialogInterface.OnClickListener mNegativeButtonListener;
    public CharSequence mNeutralButtonText;
    public DialogInterface.OnClickListener mNeutralButtonListener;
    public boolean mCancelable;
    public boolean mCancelOutSide;
    public DialogInterface.OnCancelListener mOnCancelListener;
    public DialogInterface.OnDismissListener mOnDismissListener;
    public DialogInterface.OnKeyListener mOnKeyListener;
    public int mViewLayoutResId;
    public View mView;
    public CharSequence[] mItems;
    public ListAdapter mAdapter;
    public DialogInterface.OnClickListener mOnClickListener;
    public boolean mIsMultiChoice;
    public boolean mIsSingleChoice;
    public boolean[] mCheckedItems;
    public DialogInterface.OnMultiChoiceClickListener mOnCheckboxClickListener;
    public int mCheckedItem = -1;
    public Cursor mCursor;
    public String mLabelColumn;
    public String mIsCheckedColumn;
    public AdapterView.OnItemSelectedListener mOnItemSelectedListener;
    public OnPrepareListViewListener mOnPrepareListViewListener;
    public boolean mIsAlert;
    public boolean mAutoDismiss = true;
    public boolean mIsButtonVertical;
    public boolean mIsInputDialog;
    public boolean mIsAppDialogFragment;
    public int mNoBtnInsets;
    public boolean mElegant = true;

    public PromptParams(Context context) {
        this.mContext = context;
        this.mCancelable = true;
        this.mCancelOutSide = true;
    }

    public void apply(PromptController controller) {
        controller.setTopTitle(this.mTopTitle);
        controller.setTitleView(this.mTitle);
        controller.setIcon(this.mIcon);
        controller.setMessageView(this.mMessage);
        controller.setView(this.mViewLayoutResId, this.mView);
        controller.setIsAlert(this.mIsAlert);
        controller.setButton(-1, this.mPositiveButtonText, this.mPositiveButtonListener, null);
        controller.setPositiveButtonEnable(this.mPositiveButtonEnable);
        controller.setButton(-2, this.mNegativeButtonText, this.mNegativeButtonListener, null);
        controller.setButton(-3, this.mNeutralButtonText, this.mNeutralButtonListener, null);
        controller.setButtonVertical(this.mIsButtonVertical);
        controller.setNoBtnBottomInsets(this.mNoBtnInsets);
        if (this.mIsMultiChoice) {
            if (this.mItems != null) {
                controller.setMultiChoiceList(this.mItems, this.mCheckedItems, this.mOnCheckboxClickListener);
            } else if (this.mCursor != null) {
                controller.setMultiChoiceList(this.mCursor, this.mLabelColumn, this.mIsCheckedColumn, this.mOnCheckboxClickListener);
            }
        } else if (this.mIsSingleChoice) {
            if (this.mItems != null) {
                controller.setSingleChoiceList(this.mItems, this.mOnClickListener);
            } else if (this.mAdapter != null) {
                controller.setSingleChoiceList(this.mAdapter, this.mOnClickListener);
            } else if (this.mCursor != null) {
                controller.setSingleChoiceList(this.mCursor, this.mLabelColumn, this.mOnClickListener);
            }
        } else if (this.mItems != null) {
            controller.setList(this.mItems, this.mOnClickListener);
        } else if (this.mAdapter != null) {
            controller.setList(this.mAdapter, this.mOnClickListener);
        } else if (this.mCursor != null) {
            controller.setList(this.mCursor, this.mLabelColumn, this.mOnClickListener);
        }
        if (this.mOnPrepareListViewListener != null) {
            controller.onPrepareListView(this.mOnPrepareListViewListener);
        }
        if (this.mIsSingleChoice) {
            controller.setCheckedItem(this.mCheckedItem);
        }
        controller.setAutoDismiss(this.mAutoDismiss);
        controller.setIsInputDialog(this.mIsInputDialog);
        controller.setIsAppDialogFragment(this.mIsAppDialogFragment);
        controller.setElegantTextHeight(this.mElegant);
    }

    public static interface OnPrepareListViewListener {
        public void onPrepareListView(ListView var1);
    }
}

