/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.letter;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.transsion.sort.SortUtil;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.ImageUtils;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.widget.timepicker.wheel.EaseCubicInterpolator;
import io.github.inflationx.calligraphy3.HasTypeface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LetterSelectorLayout
extends FrameLayout
implements HasTypeface {
    public static final int LETTER_TOUCH_ACTION_DOWN = 1;
    public static final int LETTER_TOUCH_ACTION_UP = 2;
    public static final int LETTER_TOUCH_MOVE = 3;
    public static final String mHeart = "\u2661";
    private int mEnableColor;
    private int mDisableColor;
    private ValueAnimator mShowAnimation;
    private ValueAnimator mHideScaleAnimation;
    private ValueAnimator mHideAlphaAnimation;
    private Runnable mHideScaleRunnable;
    private int mAlpha;
    private float mScale;
    private final float SHOW_FROM_SCALE = 0.13f;
    private final float SHOW_TO_SCALE = 1.0f;
    private final int SHOW_TO_ALPHA = 255;
    private boolean mTouched;
    private boolean animationFinish;
    private boolean mAnimationShowed;
    private boolean mShowAnimationCancel;
    private float mLetterHeight;
    private int mLetterGridHeight;
    private final int MSG_SCROLL = 1;
    private int mDirection;
    private static final int DIRECTION_UP_TO_BOTTOM = 0;
    private static final int DIRECTION_BOTTOM_TO_UP = 1;
    private float mTextHeight = 0.0f;
    Interpolator animationInterpolator = new DecelerateInterpolator();
    private final Paint txtPaint = new Paint(1);
    private final Paint txtMaxPaint = new Paint(1);
    private final Paint txtAnimationPaint = new Paint(1);
    private final Paint indicatorPaint = new Paint(1);
    private final Paint indicatorLetterPaint = new Paint(1);
    private final Paint selectedLetterPaint = new Paint(1);
    private float letterSize;
    private float letterMaxSize;
    private float letterIndicatorSize;
    private float precLetterHeight;
    private float precLetterIndicatorHeight;
    private long duration = 200L;
    private long letterIndicatorMinDurationTime = 1000L;
    private boolean isLeft = false;
    private boolean alignRight = true;
    private LetterSelectorConfig alphabetSearchConfig;
    private List<String> mLetters;
    private final List<String> mAllLetters = new ArrayList<String>();
    private static final List<String> SPECIAL_LETTERS = Arrays.asList("\u2661", "#", "\u2026", "\u2664", "\u2606", "\u039b");
    private final List<String> mChangelessLetters = Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z");
    private float letterTouchAbleWidth = 0.0f;
    private float touchFrameOffset = 0.0f;
    private float letterTouchVerticalDistance;
    private LetterBlock[] mLetterBlocks = null;
    private int letterIndicatorRadius;
    private int letterIndicatorStart;
    private int selectorPaddingTop;
    private int selectorPaddingBottom;
    private int selectorPaddingStart;
    private boolean requestMeasure = false;
    private int width = 0;
    private int height = 0;
    private int mBottom;
    private int mTop;
    private int indicatorColor = -16731411;
    private int letterIndicatorColor = -1;
    private int selectedLetterColor = -8750470;
    private String selectedLetter;
    private ArrayList<String> selectedLetters;
    private boolean topAndBottomClickableEnable = false;
    private Bitmap letterIndicatorBitmap;
    private int letterIndicatorBitmapWidth;
    private boolean letterIndicatorBitmapEnable;
    private final RectF tmpRect = new RectF();
    private float touchSlot = 0.0f;
    private boolean touchSlotEnable = true;
    private boolean showSelector = true;
    private LetterSelectorConfig.LetterSelectorListener letterSelectorListener;
    private LetterAnimationStatus animationStatus = new LetterAnimationStatus();
    private LetterBlock mTouchBlock = null;
    private LetterBlock mLastTouchBlock;
    private float mMoveStart;
    float downX;
    float downY;
    float touchX;
    float touchY;
    float mEnableTouchY;
    float mLastTouchY;
    float mTouchY;
    boolean touching = false;
    boolean touchMoving = false;
    boolean touchIndicatorEnable = false;
    long touchTime;
    long touchMove;
    private final Runnable touchIndicatorRunnable = new Runnable(){

        @Override
        public void run() {
            LetterSelectorLayout.this.touchIndicatorEnable = false;
            LetterSelectorLayout.this.animationStatus.startIndicator();
            LetterSelectorLayout.this.invalidateClip();
        }
    };
    Handler mHandler = new Handler(Looper.myLooper()){

        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            if (msg.what == 1) {
                LetterSelectorLayout.this.scrollLetters();
            }
        }
    };

    public LetterSelectorLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public LetterSelectorLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LetterSelectorLayout(Context context) {
        super(context);
        this.init();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.requestMeasure = true;
    }

    private int dpToPx(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private int valueToDimen(int unit, int value) {
        return (int)TypedValue.applyDimension((int)unit, (float)value, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public boolean isShowSelector() {
        return this.showSelector;
    }

    public void setShowSelector(boolean showSelector) {
        this.showSelector = showSelector;
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setClickable(true);
        this.selectorPaddingTop = this.dpToPx(30);
        this.selectorPaddingBottom = this.dpToPx(30);
        this.selectorPaddingStart = this.dpToPx(14);
        this.touchFrameOffset = this.dpToPx(5);
        this.letterSize = this.valueToDimen(2, 12);
        this.letterMaxSize = this.valueToDimen(2, 40);
        this.letterIndicatorSize = this.valueToDimen(2, 30);
        this.letterIndicatorRadius = this.getContext().getResources().getDimensionPixelOffset(R.dimen.letter_indicator_radius);
        this.letterIndicatorStart = this.dpToPx(72);
        this.txtPaint.setTextSize(this.letterSize);
        this.txtPaint.setColor(this.mEnableColor);
        this.txtPaint.setStyle(Paint.Style.FILL);
        this.measureTextHeight(this.txtPaint);
        this.txtMaxPaint.setTextSize(this.letterMaxSize);
        this.txtMaxPaint.setColor(this.mEnableColor);
        this.selectedLetterPaint.setColor(this.selectedLetterColor);
        this.selectedLetterPaint.setTextSize(this.letterSize);
        this.indicatorLetterPaint.setColor(this.letterIndicatorColor);
        this.indicatorLetterPaint.setTextSize(this.letterIndicatorSize);
        this.indicatorPaint.setColor(this.toAlphaColor(0.5f, this.indicatorColor));
        this.indicatorPaint.setStyle(Paint.Style.FILL);
        this.touchSlot = ViewConfiguration.get((Context)this.getContext().getApplicationContext()).getScaledTouchSlop();
        this.letterIndicatorBitmapWidth = this.dpToPx(64);
        this.letterIndicatorBitmapEnable = this.letterIndicatorBitmap != null;
        this.updateFontHeight();
        this.initAnimation();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.getHandler() != null) {
            this.getHandler().removeCallbacks(this.touchIndicatorRunnable);
            this.getHandler().removeCallbacks(this.mHideScaleRunnable);
        }
        this.mHandler.removeMessages(1);
    }

    private void updateFontHeight() {
        this.txtAnimationPaint.setTextSize(this.letterSize);
        this.precLetterHeight = this.getTextHeightOffset(this.txtAnimationPaint);
        this.txtAnimationPaint.setTextSize(this.letterMaxSize);
        this.txtAnimationPaint.setTextSize(this.letterIndicatorSize);
        this.precLetterIndicatorHeight = this.getTextHeightOffset(this.txtAnimationPaint);
    }

    private void showSelector(boolean isShow) {
        if (isShow == this.showSelector) {
            return;
        }
        this.showSelector = isShow;
        this.selectedLetterPaint.setAlpha(this.showSelector ? 255 : 0);
        this.txtPaint.setAlpha(this.showSelector ? 255 : 0);
        this.txtAnimationPaint.setAlpha(this.showSelector ? 255 : 0);
        this.txtMaxPaint.setAlpha(this.showSelector ? 255 : 0);
        this.indicatorPaint.setAlpha(this.showSelector ? 255 : 0);
        this.indicatorLetterPaint.setAlpha(this.showSelector ? 255 : 0);
        this.invalidate();
    }

    private int toAlphaColor(float alpha, int color2) {
        return Color.argb((int)((int)(alpha * 255.0f) & 0xFF), (int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2));
    }

    private int toAlpha(float alpha) {
        return (int)(alpha * 255.0f);
    }

    public LetterSelectorConfig getLetterSelectorConfig(boolean alignRight, boolean dimenDP) {
        if (this.alphabetSearchConfig == null) {
            this.alphabetSearchConfig = new LetterSelectorConfig(this);
            this.requestMeasure = true;
        }
        this.alignRight = alignRight;
        this.alphabetSearchConfig.dimenDP = dimenDP;
        return this.alphabetSearchConfig;
    }

    private void checkLayoutDirection() {
        boolean isRTL = this.getLayoutDirection() == 1;
        this.isLeft = isRTL && this.alignRight || !isRTL && !this.alignRight;
    }

    private void letterSelectorMeasure() {
        if (this.width != this.getWidth() || this.height != this.getHeight()) {
            this.requestMeasure = true;
        }
        if (!this.requestMeasure) {
            return;
        }
        String[] letters = this.mAllLetters.toArray(new String[0]);
        this.checkLayoutDirection();
        this.requestMeasure = false;
        this.width = this.getWidth();
        this.height = this.getHeight();
        this.mBottom = this.height - this.selectorPaddingBottom;
        this.mTop = this.selectorPaddingTop;
        float textHeight = this.precLetterHeight;
        int lettersSize = letters.length;
        this.mLetterGridHeight = (int)(textHeight + (float)this.dpToPx(7));
        int letterGridHeightHalf = (int)((float)this.mLetterGridHeight * 0.5f);
        boolean needRecreate = true;
        LetterBlock[] sourceLetterBlock = this.mLetterBlocks;
        if (sourceLetterBlock != null && sourceLetterBlock.length == lettersSize) {
            boolean fullEqual = true;
            for (int i = 0; i < lettersSize; ++i) {
                String letter = letters[i];
                if (letter.equals(sourceLetterBlock[i].letter)) continue;
                fullEqual = false;
                break;
            }
            if (fullEqual) {
                needRecreate = false;
            }
        }
        LetterBlock[] blockArray = null;
        if (needRecreate) {
            blockArray = new LetterBlock[lettersSize];
        }
        float maxLetterWidth = 0.0f;
        int yStart = letterGridHeightHalf + this.selectorPaddingTop;
        int yEndOffset = (int)(((float)this.mLetterGridHeight - this.mTextHeight) * 0.6f);
        this.mLetterHeight = this.mLetterGridHeight * lettersSize + this.mTop;
        int i = 0;
        while (i < lettersSize) {
            float txtWidth;
            LetterBlock letterBlock;
            String letter = letters[i];
            if (needRecreate) {
                blockArray[i] = letterBlock = new LetterBlock();
            } else {
                letterBlock = sourceLetterBlock[i];
            }
            letterBlock.letter = letter;
            letterBlock.index = i++;
            letterBlock.y = yStart;
            letterBlock.yTouchStart = (int)((float)yStart - this.mTextHeight - (float)yEndOffset);
            letterBlock.yTouchEnd = yStart + yEndOffset;
            letterBlock.letterNormalWidth = txtWidth = this.txtPaint.measureText(letter);
            letterBlock.letterNormalWidthHalf = txtWidth * 0.5f;
            letterBlock.enable = this.mLetters.contains(letter);
            maxLetterWidth = Math.max(maxLetterWidth, txtWidth);
            yStart += this.mLetterGridHeight;
        }
        if (needRecreate) {
            this.mLetterBlocks = blockArray;
        }
        for (i = 0; i < lettersSize; ++i) {
            LetterBlock alphabetBlock = this.mLetterBlocks[i];
            alphabetBlock.x = this.isLeft ? (float)this.selectorPaddingStart + (maxLetterWidth - alphabetBlock.letterNormalWidth) * 0.5f : (float)(this.width - this.selectorPaddingStart) - (maxLetterWidth - alphabetBlock.letterNormalWidth) * 0.5f - alphabetBlock.letterNormalWidth;
        }
        this.letterTouchVerticalDistance = this.letterIndicatorStart - this.selectorPaddingStart;
    }

    private float getTextHeightOffset(Paint textPaint) {
        Paint.FontMetrics fm = textPaint.getFontMetrics();
        float dy = (fm.bottom - fm.top - textPaint.getTextSize()) * 0.5f;
        float textHeightY = -dy;
        return textHeightY += textPaint.getTextSize();
    }

    private float toDeltaTime(long time, long pduration) {
        return (float)((double)time * 1.0 / (double)pduration);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (!this.showSelector) {
            return;
        }
        if (this.letterSelectorListener != null && !this.letterSelectorListener.enabledDrawLetters()) {
            return;
        }
        if (this.mLetterBlocks == null || this.mLetterBlocks.length == 0 || this.requestMeasure) {
            this.letterSelectorMeasure();
        }
        LetterAnimationStatus animationStatus = this.animationStatus;
        boolean finishIndicatorAnimation = true;
        float indicatorDuration = 0.8f * (float)this.duration;
        if (!this.touchIndicatorEnable && animationStatus.indicator) {
            long time = SystemClock.uptimeMillis() - animationStatus.indicatorTime;
            if ((float)time < indicatorDuration) {
                float valueIndicator = this.toDeltaTime(time, (long)indicatorDuration);
                finishIndicatorAnimation = false;
                animationStatus.indicatorValue = valueIndicator;
            } else {
                animationStatus.indicator = false;
            }
        }
        float valueLetterMove = 1.0f;
        boolean finshLetterMoveAnimation = true;
        if (animationStatus.letterMove) {
            long time = SystemClock.uptimeMillis() - animationStatus.letterMoveTime;
            if (time < this.duration) {
                valueLetterMove = this.toDeltaTime(time, this.duration);
                finshLetterMoveAnimation = false;
                animationStatus.letterMoveValue = valueLetterMove;
                if (!this.touching) {
                    valueLetterMove = 1.0f - valueLetterMove;
                }
                valueLetterMove = this.animationInterpolator.getInterpolation(valueLetterMove);
            } else {
                animationStatus.letterMove = false;
                if (!this.touching) {
                    this.clearLetterTouchDistance();
                }
            }
        }
        this.drawLetters(canvas, valueLetterMove, finshLetterMoveAnimation);
        canvas.save();
        this.drawLetterIndicator(canvas, finishIndicatorAnimation);
        canvas.restore();
    }

    private void drawLetterIndicator(Canvas canvas, boolean animFinish) {
        float cx;
        if (this.mTouchBlock == null || this.animationFinish) {
            return;
        }
        float txtMeasure = this.txtAnimationPaint.measureText(this.mTouchBlock.letter);
        float pivotY = this.mEnableTouchY > (float)this.mBottom ? (float)this.mBottom - this.mTextHeight / 2.0f : (this.mEnableTouchY < (float)this.mTop ? (float)this.mTop + this.mTextHeight / 2.0f : this.mEnableTouchY);
        this.indicatorLetterPaint.setAlpha(this.mAlpha);
        this.indicatorPaint.setAlpha(this.mAlpha);
        float textHeight = this.precLetterIndicatorHeight;
        float txtX = -txtMeasure * 0.5f;
        float dx = this.letterIndicatorStart;
        if (this.isLeft) {
            txtX = txtX + dx + (float)this.dpToPx(2);
            cx = dx;
        } else {
            cx = (float)this.width - dx;
            txtX += cx;
        }
        if (this.letterIndicatorBitmapEnable) {
            int sizeWidth = this.letterIndicatorBitmapWidth;
            float heightHalf = (float)this.letterIndicatorBitmap.getHeight() / 2.0f;
            RectF tmpRect = this.tmpRect;
            float start = cx - heightHalf - (this.isLeft ? (float)this.selectorPaddingStart - txtMeasure * 0.5f : 0.0f);
            float end = cx + (float)sizeWidth - heightHalf - (this.isLeft ? (float)this.selectorPaddingStart - txtMeasure * 0.5f : 0.0f);
            tmpRect.set(start, pivotY - heightHalf, end, pivotY + heightHalf);
            float pivotX = this.isLeft ? start : start + (float)sizeWidth;
            canvas.scale(this.mScale, this.mScale, pivotX, pivotY);
            canvas.drawBitmap(this.letterIndicatorBitmap, null, tmpRect, this.indicatorPaint);
        } else {
            canvas.drawCircle(cx, pivotY, (float)this.letterIndicatorRadius, this.indicatorPaint);
        }
        canvas.drawText(this.mTouchBlock.letter, txtX, pivotY + textHeight * 0.5f, this.indicatorLetterPaint);
    }

    private void drawLetters(Canvas canvas, float deltaTime, boolean animFinish) {
        for (LetterBlock block : this.mLetterBlocks) {
            if (block.y < this.mTop) continue;
            if (block.y > this.mBottom) break;
            if (!this.touching && (block.letter.equals(this.selectedLetter) || this.selectedLetters != null && this.selectedLetters.contains(block.letter))) {
                canvas.drawText(block.letter, block.x, (float)block.y, this.selectedLetterPaint);
                continue;
            }
            if (block.enable) {
                this.txtPaint.setColor(this.mEnableColor);
            } else {
                this.txtPaint.setColor(this.mDisableColor);
            }
            canvas.drawText(block.letter, block.x, (float)block.y, this.txtPaint);
        }
    }

    private void initAnimation() {
        int duration = 200;
        int alphaDuration = 100;
        if (this.mShowAnimation == null) {
            this.mShowAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 200.0f});
            this.mShowAnimation.setDuration(200L);
            this.mShowAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    float cent = value / 200.0f;
                    LetterSelectorLayout.this.mAlpha = (int)(cent * 255.0f);
                    LetterSelectorLayout.this.mScale = 0.13f + 0.87f * cent;
                    LetterSelectorLayout.this.invalidate();
                }
            });
            this.mShowAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (!(LetterSelectorLayout.this.mShowAnimationCancel || LetterSelectorLayout.this.mTouched || LetterSelectorLayout.this.mHideScaleAnimation == null || LetterSelectorLayout.this.mHideScaleAnimation.isRunning() || LetterSelectorLayout.this.mHideAlphaAnimation == null || LetterSelectorLayout.this.mHideAlphaAnimation.isRunning())) {
                        LetterSelectorLayout.this.startHideAnimation();
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    LetterSelectorLayout.this.mShowAnimationCancel = true;
                }
            });
            this.mShowAnimation.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.2f, 0.0f, 0.1f, 1.0f));
        }
        if (this.mHideScaleAnimation == null) {
            this.mHideScaleAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 200.0f});
            this.mHideScaleAnimation.setDuration(200L);
            this.mHideScaleAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    float centScale = value / 200.0f;
                    LetterSelectorLayout.this.mScale = 1.0f - 0.87f * centScale;
                    LetterSelectorLayout.this.invalidate();
                }
            });
            this.mHideScaleAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    LetterSelectorLayout.this.animationFinish = true;
                    LetterSelectorLayout.this.mAnimationShowed = false;
                    LetterSelectorLayout.this.invalidate();
                }
            });
            this.mHideScaleAnimation.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.4f, 0.0f, 1.0f, 1.0f));
            this.mHideScaleRunnable = new Runnable(){

                @Override
                public void run() {
                    if (LetterSelectorLayout.this.mHideScaleAnimation != null && !LetterSelectorLayout.this.mHideScaleAnimation.isRunning()) {
                        LetterSelectorLayout.this.mHideScaleAnimation.start();
                        LetterSelectorLayout.this.mHideAlphaAnimation.start();
                    }
                }
            };
        }
        if (this.mHideAlphaAnimation == null) {
            this.mHideAlphaAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 100.0f});
            this.mHideAlphaAnimation.setDuration(150L);
            this.mHideAlphaAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    float centAlpha = value / 100.0f;
                    LetterSelectorLayout.this.mAlpha = (int)(255.0f - centAlpha * 255.0f);
                }
            });
            this.mHideAlphaAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    LetterSelectorLayout.this.animationFinish = true;
                }
            });
            this.mHideAlphaAnimation.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.4f, 0.0f, 1.0f, 1.0f));
        }
    }

    private void startHideAnimation() {
        this.cancelAnimation();
        if (this.getHandler() != null) {
            this.getHandler().postDelayed(this.mHideScaleRunnable, 300L);
        }
    }

    private void startShowAnimation() {
        if (this.getHandler() != null) {
            this.getHandler().removeCallbacks(this.touchIndicatorRunnable);
            this.getHandler().removeCallbacks(this.mHideScaleRunnable);
        }
        if (this.mHideScaleAnimation != null && this.mHideScaleAnimation.isRunning()) {
            this.mHideScaleAnimation.cancel();
        }
        if (this.mHideAlphaAnimation != null && this.mHideAlphaAnimation.isRunning()) {
            this.mHideAlphaAnimation.cancel();
        }
        if (this.mShowAnimation != null && !this.mShowAnimation.isRunning()) {
            this.mShowAnimation.start();
            this.mTouched = true;
            this.animationFinish = false;
            this.mAnimationShowed = true;
            this.mShowAnimationCancel = false;
        }
    }

    private void cancelAnimation() {
        if (this.getHandler() != null) {
            this.getHandler().removeCallbacks(this.touchIndicatorRunnable);
            this.getHandler().removeCallbacks(this.mHideScaleRunnable);
        }
        if (this.mShowAnimation != null && this.mShowAnimation.isRunning()) {
            this.mShowAnimation.cancel();
        }
        if (this.mHideScaleAnimation != null && this.mHideScaleAnimation.isRunning()) {
            this.mHideScaleAnimation.cancel();
        }
        if (this.mHideAlphaAnimation != null && this.mHideAlphaAnimation.isRunning()) {
            this.mHideAlphaAnimation.cancel();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isSelectorDisable()) {
            return super.onInterceptTouchEvent(ev);
        }
        if (ev.getAction() == 0 && this.touchEnable(ev.getX(), ev.getY())) {
            this.requestDisallowInterceptTouchEvent(true);
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    private boolean touchEnable(float x, float y) {
        if (this.mLetterBlocks == null || this.mLetterBlocks.length == 0) {
            return false;
        }
        if (!this.topAndBottomClickableEnable && (y < (float)this.mLetterBlocks[0].yTouchStart || y > (float)this.mLetterBlocks[this.mLetterBlocks.length - 1].yTouchEnd)) {
            return false;
        }
        if (this.isLeft && x <= this.letterTouchAbleWidth + this.touchFrameOffset && x >= this.touchFrameOffset) {
            return true;
        }
        return !this.isLeft && x >= (float)this.width - this.letterTouchAbleWidth - this.touchFrameOffset && x <= (float)this.width - this.touchFrameOffset;
    }

    private boolean isSelectorDisable() {
        return this.mLetterBlocks == null || this.mLetterBlocks.length == 0 || this.letterSelectorListener != null && !this.letterSelectorListener.enabledDrawLetters();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        if (this.isSelectorDisable() || !this.showSelector) {
            if (this.touching) {
                this.handleTouchUpLetter();
            }
            return super.onTouchEvent(event);
        }
        this.touchX = x;
        this.touchY = y;
        this.mTouchY = y;
        if (event.getAction() == 0 && !this.touchEnable(x, y)) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.mLastTouchY = y;
                this.mMoveStart = y;
                this.requestDisallowInterceptTouchEvent(true);
                this.touchMoving = false;
                this.touchTime = SystemClock.uptimeMillis();
                this.touchMove = -1L;
                this.downX = x;
                this.downY = y;
                LetterBlock itouchBlock = this.getTouchLetter(y);
                if (itouchBlock != null && itouchBlock.enable) {
                    this.mEnableTouchY = (float)itouchBlock.y - this.mTextHeight / 2.0f;
                    this.callTouchLetter(itouchBlock, 1);
                }
                if (itouchBlock == null) {
                    return false;
                }
                if (!itouchBlock.enable) break;
                this.handleTouchDownLetter(y);
                this.startShowAnimation();
                break;
            }
            case 1: 
            case 3: {
                this.mHandler.removeMessages(1);
                if (this.touchY > this.mLetterHeight) {
                    this.touchY = this.mLetterHeight + this.precLetterHeight / 2.0f;
                }
                this.handleTouchUpLetter();
                this.mTouched = false;
                if (this.mShowAnimation != null && this.mShowAnimation.isRunning() || this.mHideScaleAnimation == null || this.mHideScaleAnimation.isRunning()) break;
                this.startHideAnimation();
                break;
            }
            case 2: {
                if (!this.touchEnable(x, y)) {
                    return true;
                }
                if (this.touchSlotEnable && !this.touchMoving) {
                    if (Math.abs(y - this.downY) > this.touchSlot || Math.abs(x - this.downX) > this.touchSlot) {
                        this.touchMoving = true;
                    }
                    if (!this.touchMoving) break;
                }
                if (!this.mAnimationShowed) {
                    this.startShowAnimation();
                }
                this.handleTouchMoveLetter(this.touchY, 3);
                this.mLastTouchY = this.mTouchY;
                this.invalidate();
            }
        }
        return true;
    }

    private void invalidateClip() {
        int maxHalf = Math.round(Math.max((float)this.letterIndicatorRadius, (float)this.letterIndicatorBitmapWidth * 0.5f));
        if (this.isLeft) {
            this.invalidate(0, 0, this.letterIndicatorStart + maxHalf, this.height);
        } else {
            this.invalidate(this.width - this.letterIndicatorStart - maxHalf, 0, this.width, this.height);
        }
    }

    private void handleTouchUpLetter() {
        long deltaTime = SystemClock.uptimeMillis() - this.touchTime;
        if (this.touching) {
            if (deltaTime < this.letterIndicatorMinDurationTime) {
                this.touchIndicatorEnable = true;
                if (this.getHandler() != null) {
                    this.getHandler().postDelayed(this.touchIndicatorRunnable, this.letterIndicatorMinDurationTime - deltaTime);
                }
            } else {
                this.animationStatus.startIndicator();
            }
        }
        if (this.letterSelectorListener != null) {
            this.letterSelectorListener.onTouchLetter(null, 0, 2, false);
        }
        this.animationStatus.startLetterTouchUp();
        for (LetterBlock block : this.mLetterBlocks) {
            block.unpressed();
        }
        this.touching = false;
    }

    private void clearLetterTouchDistance() {
        for (LetterBlock block : this.mLetterBlocks) {
            block.updateTouchDistanceValue(this.letterTouchVerticalDistance + 1.0f);
        }
    }

    private void handleTouchDownLetter(float y) {
        LetterBlock itouchBlock = this.getTouchLetter(y);
        if (itouchBlock != null) {
            this.mTouchBlock = itouchBlock;
            if (itouchBlock.enable) {
                this.selectedLetter = itouchBlock.letter;
            }
            this.touching = true;
            this.touchIndicatorEnable = false;
            if (this.getHandler() != null) {
                this.getHandler().removeCallbacks(this.touchIndicatorRunnable);
            }
            this.animationStatus.startIndicator();
            if (!this.touchSlotEnable) {
                this.updateTouchDistance();
            }
        }
    }

    private void updateTouchDistance() {
        float textHeight = this.precLetterHeight;
        float textHeightHalf = textHeight * 0.5f;
        float touchY = this.touchY;
        for (LetterBlock block : this.mLetterBlocks) {
            block.updateTouchDistanceValue(touchY - (float)block.y - textHeightHalf);
        }
        this.animationStatus.startLetterTouchMove();
    }

    private void handleTouchMoveLetter(float y, int touchType) {
        LetterBlock itouchBlock = this.getTouchLetter(y);
        this.touching = true;
        if (itouchBlock != null) {
            if (Math.abs(y - this.mMoveStart) >= (float)this.mLetterGridHeight) {
                this.mDirection = y > this.mMoveStart ? 0 : 1;
                if (this.canScroll()) {
                    this.mHandler.sendEmptyMessage(1);
                }
                this.mMoveStart = y;
            }
            if (this.mLastTouchBlock != null && itouchBlock.letter.equals(this.mLastTouchBlock.letter)) {
                return;
            }
            this.mLastTouchBlock = itouchBlock;
            if (itouchBlock.enable) {
                this.mTouchBlock = itouchBlock;
                this.mEnableTouchY = (float)this.mTouchBlock.y - this.mTextHeight / 2.0f;
            } else {
                this.mTouchBlock = this.getNextEnableLetter(itouchBlock.index);
                this.mEnableTouchY = (float)itouchBlock.y - this.mTextHeight / 2.0f;
            }
            if (this.mTouchBlock != null) {
                this.selectedLetter = this.mTouchBlock.letter;
                this.callTouchLetter(this.mTouchBlock, 3);
            }
        }
        this.updateTouchDistance();
    }

    private LetterBlock getNextEnableLetter(int index) {
        if (this.mTouchY > this.mLastTouchY) {
            if (index == this.mLetterBlocks.length - 1) {
                return null;
            }
            for (int i = index; i < this.mLetterBlocks.length; ++i) {
                if (!this.mLetterBlocks[i].enable) continue;
                return this.mLetterBlocks[i];
            }
        } else {
            if (index == 0) {
                return null;
            }
            for (int i = index; i >= 0; --i) {
                if (!this.mLetterBlocks[i].enable) continue;
                return this.mLetterBlocks[i];
            }
        }
        return null;
    }

    private LetterBlock getTouchLetter(float y) {
        LetterBlock itouchBlock = null;
        int size = this.mLetterBlocks.length;
        for (int i = 0; i < size; ++i) {
            LetterBlock block = this.mLetterBlocks[i];
            if (block.inTouch(y)) {
                itouchBlock = block;
                break;
            }
            if (this.touching && i == 0 && block.isTouchTop(y)) {
                itouchBlock = block;
                break;
            }
            if (this.touching && i == size - 1 && block.isTouchBottom(y)) {
                itouchBlock = block;
                break;
            }
            block.unpressed();
        }
        return itouchBlock;
    }

    private void callTouchLetter(LetterBlock block, int touchType) {
        if (this.letterSelectorListener != null) {
            this.letterSelectorListener.onTouchLetter(String.valueOf(block.letter), block.index, touchType, block.enable);
        }
        block.pressed();
    }

    public void setTypeface(Typeface typeface) {
        if (this.txtPaint != null) {
            this.txtPaint.setTypeface(typeface);
        }
        if (this.txtMaxPaint != null) {
            this.txtMaxPaint.setTypeface(typeface);
        }
        if (this.txtAnimationPaint != null) {
            this.txtAnimationPaint.setTypeface(typeface);
        }
        if (this.indicatorPaint != null) {
            this.indicatorPaint.setTypeface(typeface);
        }
        if (this.indicatorLetterPaint != null) {
            this.indicatorLetterPaint.setTypeface(typeface);
        }
        if (this.selectedLetterPaint != null) {
            this.selectedLetterPaint.setTypeface(typeface);
        }
    }

    private void scrollLetters() {
        if (this.mLetterBlocks != null && this.mLetterBlocks.length > 0) {
            if (!this.canScroll()) {
                return;
            }
            float dis = this.mDirection == 0 ? (float)(-this.mLetterGridHeight) : (float)this.mLetterGridHeight;
            for (LetterBlock letterBlock : this.mLetterBlocks) {
                letterBlock.y = (int)((float)letterBlock.y + dis);
                letterBlock.yTouchStart = (int)((float)letterBlock.yTouchStart + dis);
                letterBlock.yTouchEnd = (int)((float)letterBlock.yTouchEnd + dis);
            }
            this.invalidate();
        }
    }

    private boolean canScroll() {
        if (this.mDirection == 0) {
            return this.mLetterBlocks[this.mLetterBlocks.length - 1].y > this.mBottom;
        }
        return this.mLetterBlocks[0].y < this.mTop;
    }

    private void measureTextHeight(Paint paint) {
        if (null == paint) {
            this.mTextHeight = 0.0f;
            return;
        }
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        this.mTextHeight = (fontMetrics.descent - fontMetrics.ascent) * 0.5f;
    }

    public class LetterBlock {
        public int index;
        public String letter;
        public float x;
        public int y;
        public int yTouchStart;
        public int yTouchEnd;
        public boolean enable = true;
        public float letterNormalWidth;
        public float letterNormalWidthHalf;
        public boolean pressed = false;
        public float targetTouchDistance = 0.0f;
        public float targetTouchScale = 1.0f;
        public boolean targetTouchMove = false;

        public boolean inTouch(float ty) {
            return ty >= (float)this.yTouchStart && ty <= (float)this.yTouchEnd;
        }

        public boolean isTouchTop(float ty) {
            return ty < (float)this.yTouchStart;
        }

        public boolean isTouchBottom(float ty) {
            return ty > (float)this.yTouchEnd;
        }

        public boolean pressed() {
            if (this.pressed) {
                return false;
            }
            this.pressed = true;
            return true;
        }

        public boolean unpressed() {
            if (!this.pressed) {
                return false;
            }
            this.pressed = false;
            return true;
        }

        public void updateTouchDistanceValue(float touchDistance) {
            float absTouchDistance = Math.abs(touchDistance);
            if (absTouchDistance >= LetterSelectorLayout.this.letterTouchVerticalDistance) {
                this.targetTouchMove = false;
                this.targetTouchScale = 1.0f;
                this.targetTouchDistance = 0.0f;
                return;
            }
            absTouchDistance = LetterSelectorLayout.this.letterTouchVerticalDistance - absTouchDistance;
            this.targetTouchMove = true;
            this.targetTouchDistance = absTouchDistance;
            this.targetTouchScale = this.targetTouchDistance / LetterSelectorLayout.this.letterTouchVerticalDistance;
        }
    }

    private class LetterAnimationStatus {
        public boolean indicator = false;
        public long indicatorTime;
        public float indicatorValue;
        public boolean letterMove = false;
        public long letterMoveTime;
        public float letterMoveValue;
        public boolean letterMoving = false;

        private LetterAnimationStatus() {
        }

        public void startIndicator() {
            this.indicatorTime = SystemClock.uptimeMillis();
            if (this.indicator && this.indicatorValue < 1.0f) {
                float delta = 1.0f - this.indicatorValue;
                long deltaTime = (long)((float)LetterSelectorLayout.this.duration * delta);
                this.indicatorTime -= deltaTime;
            }
            this.indicator = true;
        }

        public void startLetterTouchMove() {
            if (this.letterMoving) {
                return;
            }
            this.letterMoving = true;
            this.startLetterMove();
        }

        private void startLetterMove() {
            this.letterMoveTime = SystemClock.uptimeMillis();
            if (this.letterMove && this.letterMoveValue < 1.0f) {
                float delta = 1.0f - this.letterMoveValue;
                long deltaTime = (long)((float)LetterSelectorLayout.this.duration * delta);
                this.letterMoveTime -= deltaTime;
            }
            this.letterMove = true;
        }

        public void startLetterTouchUp() {
            this.letterMoving = false;
            this.startLetterMove();
        }
    }

    public static class LetterSelectorConfig {
        private final LetterSelectorLayout letterSelector;
        private final Context context;
        private boolean dimenDP = true;

        public static int dpToPx(Context context, int dp) {
            return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }

        public static int spToPx(Context context, int dp) {
            return (int)TypedValue.applyDimension((int)2, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }

        private int dimenSize(int size) {
            if (this.dimenDP) {
                return LetterSelectorConfig.dpToPx(this.context, size);
            }
            return size;
        }

        private int dimenSpSize(int size) {
            if (this.dimenDP) {
                return LetterSelectorConfig.spToPx(this.context, size);
            }
            return size;
        }

        private LetterSelectorConfig(LetterSelectorLayout alphabetSearchLayout) {
            this.letterSelector = alphabetSearchLayout;
            this.context = this.letterSelector.getContext();
        }

        public void initConfig(Context context) {
            Resources res = context.getResources();
            this.setSelectorPadding(context.getResources().getDimensionPixelSize(R.dimen.letter_top_padding), res.getDimensionPixelSize(R.dimen.letter_bottom_padding), res.getDimensionPixelSize(Utils.isWaterfallScreen(context) ? R.dimen.os_letter_padding_curse : R.dimen.os_letter_padding));
            this.setSelectorFontSize(res.getDimensionPixelSize(R.dimen.blade_list_section_font_Size), res.getDimensionPixelSize(R.dimen.blade_list_section_max_font_Size), res.getDimensionPixelSize(R.dimen.blade_list_section_indicate_font_Size));
            this.letterSelector.mEnableColor = ContextCompat.getColor((Context)context, (int)R.color.os_text_secondary_color);
            this.letterSelector.mDisableColor = ContextCompat.getColor((Context)context, (int)R.color.os_text_quaternary_color);
            this.setSelectorFontColor(this.letterSelector.mEnableColor, this.letterSelector.mDisableColor, ContextCompat.getColor((Context)context, (int)R.color.letter_select_color));
            String osType = Utils.getOsType();
            int selectorColor = R.color.os_platform_basic_color_hios;
            if (TextUtils.isEmpty((CharSequence)osType) || osType.equalsIgnoreCase(Utils.mOsType[0])) {
                selectorColor = R.color.os_platform_basic_color_hios;
            } else if (osType.equalsIgnoreCase(Utils.mOsType[1])) {
                selectorColor = R.color.os_platform_basic_color_xos;
            } else if (osType.equalsIgnoreCase(Utils.mOsType[2])) {
                selectorColor = R.color.os_platform_basic_color_itel;
            }
            this.setSelectorSelectedLetterColor(ContextCompat.getColor((Context)context, (int)selectorColor));
            Drawable touchBg = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_touch_bg);
            Bitmap bitmap = ImageUtils.drawable2Bitmap(touchBg);
            if (Utils.isRtl()) {
                bitmap = ImageUtils.convert(bitmap);
            }
            this.setSelectorLetterIndicatorBitmap(bitmap, bitmap.getWidth(), bitmap.getHeight());
            this.setTouchFrameStart(res.getDimensionPixelSize(R.dimen.blade_touch_width));
        }

        public LetterSelectorConfig registerLetterSelectorListener(LetterSelectorListener letterSelectorTouchListener) {
            this.letterSelector.letterSelectorListener = letterSelectorTouchListener;
            return this;
        }

        public LetterSelectorConfig setSelectorPadding(int paddingTop, int paddingBottom, int paddingStart) {
            this.letterSelector.selectorPaddingTop = this.dimenSize(paddingTop);
            this.letterSelector.selectorPaddingBottom = this.dimenSize(paddingBottom);
            this.letterSelector.selectorPaddingStart = this.dimenSize(paddingStart);
            return this;
        }

        public LetterSelectorConfig updateSelectorTopPadding(int paddingTop) {
            this.letterSelector.selectorPaddingTop = this.dimenSize(paddingTop);
            this.requestSelectorLayout();
            return this;
        }

        public LetterSelectorConfig setTouchFrameStart(int touchStart) {
            this.letterSelector.letterTouchAbleWidth = this.dimenSize(touchStart);
            return this;
        }

        public LetterSelectorConfig setSelectorLetterIndicatorStart(int letterIndicatorStart) {
            this.letterSelector.letterIndicatorStart = this.dimenSize(letterIndicatorStart);
            return this;
        }

        public LetterSelectorConfig setSelectorFontSize(int letterSize, int letterMaxSize, int letterIndicatorSize) {
            this.letterSelector.letterSize = this.dimenSpSize(letterSize);
            this.letterSelector.letterMaxSize = this.dimenSpSize(letterMaxSize);
            this.letterSelector.letterIndicatorSize = this.dimenSpSize(letterIndicatorSize);
            this.letterSelector.txtPaint.setTextSize(this.letterSelector.letterSize);
            this.letterSelector.selectedLetterPaint.setTextSize(this.letterSelector.letterSize);
            this.letterSelector.txtMaxPaint.setTextSize(this.letterSelector.letterMaxSize);
            this.letterSelector.indicatorLetterPaint.setTextSize(this.letterSelector.letterIndicatorSize);
            this.letterSelector.updateFontHeight();
            return this;
        }

        public LetterSelectorConfig setSelectorFontColor(int enableColor, int disableColor, int letterIndicatorColor) {
            this.letterSelector.mEnableColor = enableColor;
            this.letterSelector.mDisableColor = disableColor;
            this.letterSelector.txtPaint.setColor(enableColor);
            this.letterSelector.txtMaxPaint.setColor(enableColor);
            this.letterSelector.letterIndicatorColor = letterIndicatorColor;
            this.letterSelector.indicatorLetterPaint.setColor(letterIndicatorColor);
            return this;
        }

        public LetterSelectorConfig setSelectorFontColor(int enableColor, int disableColor) {
            this.setSelectorFontColor(enableColor, disableColor, ContextCompat.getColor((Context)this.context, (int)R.color.letter_select_color));
            return this;
        }

        public LetterSelectorConfig setSelectorIndicatorColor(int indicatorColor) {
            this.letterSelector.indicatorColor = indicatorColor;
            this.letterSelector.indicatorPaint.setColor(indicatorColor);
            return this;
        }

        public LetterSelectorConfig setSelectorIndicatorSize(int radiusTouchIndicator, int radiusLetterIndicator) {
            this.letterSelector.letterIndicatorRadius = this.dimenSize(radiusLetterIndicator);
            return this;
        }

        public LetterSelectorConfig setSelectorLetterIndicatorMinDurationTime(long letterIndicatorMinDurationTime) {
            this.letterSelector.letterIndicatorMinDurationTime = letterIndicatorMinDurationTime;
            return this;
        }

        public LetterSelectorConfig setSelectorAnimationInterpolator(Interpolator animationInterpolator) {
            if (animationInterpolator == null) {
                animationInterpolator = new LinearInterpolator();
            }
            this.letterSelector.animationInterpolator = animationInterpolator;
            return this;
        }

        public LetterSelectorConfig requestSelectorInvalidate() {
            this.letterSelector.invalidate();
            return this;
        }

        public LetterSelectorConfig requestSelectorLayout() {
            this.letterSelector.requestMeasure = true;
            this.letterSelector.invalidate();
            return this;
        }

        public LetterSelectorConfig setTouchIndicator(int indicatorColor, int indicatorRadius) {
            this.letterSelector.indicatorPaint.setColor(indicatorColor);
            return this;
        }

        public LetterSelectorConfig setSelectorSelectedLetterColor(int selectedLetterColor) {
            this.letterSelector.selectedLetterColor = selectedLetterColor;
            this.letterSelector.selectedLetterPaint.setColor(selectedLetterColor);
            return this;
        }

        public LetterSelectorConfig setSelectorSelectedLetter(String selectedLetter) {
            if (selectedLetter == null || selectedLetter.equals(this.letterSelector.selectedLetter)) {
                return this;
            }
            this.letterSelector.selectedLetter = selectedLetter;
            this.letterSelector.invalidate();
            return this;
        }

        public LetterSelectorConfig setSelectorSelectedLetters(ArrayList<String> letters) {
            this.letterSelector.selectedLetters = letters;
            this.letterSelector.invalidate();
            return this;
        }

        public LetterSelectorConfig setSelectorTopAndBottomClickableEnable(boolean topAndBottomClickableEnable) {
            this.letterSelector.topAndBottomClickableEnable = topAndBottomClickableEnable;
            return this;
        }

        public LetterSelectorConfig setSelectorLetterIndicatorBitmap(Bitmap letterIndicatorBitmap, int bitmapDrawWidth, int bitmapDrawHeight) {
            this.letterSelector.letterIndicatorBitmap = letterIndicatorBitmap;
            this.letterSelector.letterIndicatorBitmapWidth = this.dimenSize(bitmapDrawWidth);
            this.letterSelector.letterIndicatorBitmapEnable = letterIndicatorBitmap != null;
            return this;
        }

        public LetterSelectorConfig setAlphabetAnimationDuration(int duration) {
            this.letterSelector.duration = duration;
            return this;
        }

        @Deprecated
        public LetterSelectorConfig setSelectorLetters(String[] letters) {
            return this.setSelectorLettersAll(letters);
        }

        @Deprecated
        public LetterSelectorConfig setSelectorLettersSort(String[] letters) {
            return this.setSelectorLettersAll(letters);
        }

        private void initLettersSort() {
            boolean purgeAZ = true;
            for (String letter : this.letterSelector.mLetters) {
                char ascii;
                if (letter == null || letter.length() != 1) {
                    purgeAZ = false;
                    break;
                }
                if (SPECIAL_LETTERS.contains(letter) || (ascii = letter.charAt(0)) >= 'A' && ascii <= 'Z') continue;
                purgeAZ = false;
                break;
            }
            this.letterSelector.mAllLetters.clear();
            if (purgeAZ) {
                this.letterSelector.mAllLetters.addAll(this.letterSelector.mChangelessLetters);
                for (String letter : this.letterSelector.mLetters) {
                    if (this.letterSelector.mChangelessLetters.contains(letter)) continue;
                    this.letterSelector.mAllLetters.add(letter);
                }
            } else {
                this.letterSelector.mAllLetters.addAll(this.letterSelector.mLetters);
            }
            SortUtil sortUtil = new SortUtil(this.context);
            sortUtil.sortString(this.letterSelector.mAllLetters);
            if (this.letterSelector.mAllLetters.contains(LetterSelectorLayout.mHeart)) {
                this.letterSelector.mAllLetters.remove(LetterSelectorLayout.mHeart);
                this.letterSelector.mAllLetters.add(0, LetterSelectorLayout.mHeart);
            }
        }

        private void initAllLetters() {
            this.letterSelector.mAllLetters.clear();
            for (String letter : this.letterSelector.mLetters) {
                if (this.letterSelector.mChangelessLetters.contains(letter)) continue;
                this.letterSelector.mAllLetters.add(letter);
            }
            this.letterSelector.mAllLetters.addAll(this.letterSelector.mChangelessLetters);
        }

        public LetterSelectorConfig setSelectorLettersAll(String[] letters) {
            this.letterSelector.mLetters = Arrays.asList(letters);
            this.letterSelector.mAllLetters.clear();
            this.letterSelector.mAllLetters.addAll(this.letterSelector.mLetters);
            return this;
        }

        public LetterSelectorConfig showSelector(boolean isShow, boolean animation) {
            return this;
        }

        public LetterSelectorConfig showSelector(boolean isShow) {
            this.letterSelector.showSelector(isShow);
            return this;
        }

        public boolean isSelectorTouching() {
            return this.letterSelector.touching;
        }

        public LetterSelectorConfig setTouchSlotEnable(boolean touchSlotEnable) {
            this.letterSelector.touchSlotEnable = touchSlotEnable;
            return this;
        }

        public static interface LetterSelectorListener {
            public void onTouchLetter(String var1, int var2, int var3, boolean var4);

            public boolean enabledDrawLetters();
        }
    }
}

