/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.widget.timepicker.wheel.EaseCubicInterpolator;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class FootOperationBar
extends FrameLayout {
    private static final int DEFAULT_MAX_VISIBLE_TAB_COUNT = 5;
    private static final int DEFAULT_MIN_VISIBLE_TAB_COUNT = 3;
    private static final int ANIM_TIME = 150;
    private int mScreenWidth;
    private LinearLayout mContainer;
    private OnFootOptBarClickListener mItemClickListener;
    private List<String> mPopupItems;
    private ListPopupWindow mPopup;
    private View mMoreView;
    private boolean mShow = false;
    private boolean mAnim = false;
    private boolean mInitShow = false;
    private boolean[] mMenuEnables;
    private int mTextColor;
    private boolean mHaveTextColor;
    private int mClickTextColor;
    private int mClickImageTintColor;
    private int mNormalImageTintColor;
    private boolean mHaveNormalImageTintColor;
    private boolean mHaveClickImageTintColor;
    private boolean isFootActionBar;
    private boolean needChangeImgColor = true;
    private int mMaxVisibleTabCount;
    private int mVisibleTabCount;
    private List<View> mFootItemViews = new ArrayList<View>();
    private Context mContext;
    private int mMoreIconRes;
    private View mGuestureView;
    private int mItemBackgroundRes;
    private final MyOnPreDrawListener mMyOnPreDrawListener;
    private int mTintColor = -1;

    public FootOperationBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        LayoutInflater.from((Context)context).inflate(R.layout.os_foot_opt_bar_root, (ViewGroup)this);
        this.mContainer = (LinearLayout)this.findViewById(R.id.os_foot_opt_bar_container);
        this.mGuestureView = this.findViewById(R.id.os_guesture_view);
        if (Utils.isGestureNavigationBarOn(context)) {
            this.mGuestureView.setVisibility(0);
        } else {
            this.mGuestureView.setVisibility(8);
        }
        this.mPopupItems = new ArrayList<String>();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FootOperationBar);
        this.isFootActionBar = ta.getBoolean(R.styleable.FootOperationBar_isFootActionBar, false);
        this.needChangeImgColor = ta.getBoolean(R.styleable.FootOperationBar_foot_need_change_img_color, false);
        this.mHaveTextColor = ta.hasValue(R.styleable.FootOperationBar_foot_text_color);
        this.mTextColor = ta.getColor(R.styleable.FootOperationBar_foot_text_color, this.getResources().getColor(R.color.os_text_secondary_color));
        this.mItemBackgroundRes = ta.getResourceId(R.styleable.FootOperationBar_foot_item_background, R.drawable.os_foot_option_bar_item_bg);
        this.mTintColor = ta.getColor(R.styleable.FootOperationBar_foot_item_icon_tint, ContextCompat.getColor((Context)this.mContext, (int)R.color.os_fill_icon_primary_color));
        int[] attrs1 = new int[]{R.attr.os_platform_basic_color, R.attr.os_foot_more};
        TypedArray typedArray = context.obtainStyledAttributes(attrs1);
        int clickTextColorDefault = typedArray.getColor(0, this.getResources().getColor(R.color.os_platform_basic_color_hios));
        this.mMoreIconRes = typedArray.getResourceId(1, R.drawable.os_ic_foot_more_hios);
        typedArray.recycle();
        this.mClickTextColor = ta.getColor(R.styleable.FootOperationBar_foot_click_text_color, clickTextColorDefault);
        this.mHaveClickImageTintColor = ta.hasValue(R.styleable.FootOperationBar_foot_click_image_color);
        if (this.mHaveClickImageTintColor) {
            this.mClickImageTintColor = ta.getColor(R.styleable.FootOperationBar_foot_click_image_color, -1);
        }
        this.mHaveNormalImageTintColor = ta.hasValue(R.styleable.FootOperationBar_foot_normal_image_color);
        if (this.mHaveNormalImageTintColor) {
            this.mNormalImageTintColor = ta.getColor(R.styleable.FootOperationBar_foot_normal_image_color, -65536);
        }
        this.mMaxVisibleTabCount = ta.getInt(R.styleable.FootOperationBar_foot_max_visible_tab_count, 5);
        if (this.mMaxVisibleTabCount < 3) {
            this.mMaxVisibleTabCount = 3;
        }
        this.initDefaultParameter(context);
        if (ta.hasValue(R.styleable.FootOperationBar_foot_opt_menu)) {
            this.inflateMenu(ta.getResourceId(R.styleable.FootOperationBar_foot_opt_menu, 0));
        }
        this.mInitShow = ta.getBoolean(R.styleable.FootOperationBar_foot_init_show, false);
        ta.recycle();
        this.mMyOnPreDrawListener = new MyOnPreDrawListener(this);
        this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mMyOnPreDrawListener);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.initDefaultParameter(this.getContext());
    }

    private void initDefaultParameter(Context context) {
        boolean isWaterFallScreen;
        if (context == null) {
            return;
        }
        this.setMinimumHeight(this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_min_height));
        int guestureViewHeight = this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_guesture_height);
        if (this.getBackground() == null) {
            int[] attrs = new int[]{R.attr.OsAltitudePrimary};
            TypedArray typedArray = context.obtainStyledAttributes(attrs);
            this.setBackgroundColor(typedArray.getColor(0, context.getResources().getColor(R.color.os_altitude_primary_color)));
            if (this.mGuestureView != null && this.mGuestureView.getVisibility() == 0) {
                this.mGuestureView.setBackgroundColor(typedArray.getColor(0, context.getResources().getColor(R.color.os_altitude_primary_color)));
            }
            typedArray.recycle();
        }
        if (Build.VERSION.SDK_INT >= 30 && (isWaterFallScreen = Utils.isWaterfallScreen(this.mContext))) {
            int rotation = this.mContext.getDisplay().getRotation();
            int leftPadding = this.mContainer.getPaddingLeft();
            int topPadding = this.mContainer.getPaddingTop();
            int rightPadding = this.mContainer.getPaddingRight();
            int bottomPadding = this.mContainer.getPaddingBottom();
            switch (rotation) {
                case 0: 
                case 2: {
                    rightPadding = leftPadding = this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_padding) + this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curve_land);
                    break;
                }
                case 1: {
                    leftPadding = this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curve_land);
                    rightPadding = 0;
                    this.setMinimumHeight(this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_min_height_curve_land));
                    guestureViewHeight = this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_guesture_height_curve_land);
                    break;
                }
                case 3: {
                    leftPadding = 0;
                    rightPadding = this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curve_land);
                    this.setMinimumHeight(this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_min_height_curve_land));
                    guestureViewHeight = this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_guesture_height_curve_land);
                }
            }
            this.mContainer.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
        }
        if (this.mGuestureView != null) {
            this.mGuestureView.setMinimumHeight(guestureViewHeight);
        }
    }

    public void setContainerBackground(int colorResId) {
        this.setBackgroundColor(this.mContext.getResources().getColor(colorResId));
        if (this.mGuestureView != null && this.mGuestureView.getVisibility() == 0) {
            this.mGuestureView.setBackgroundColor(this.mContext.getResources().getColor(colorResId));
        }
    }

    public void setContainerBackgroundNoOverlay(int colorResId) {
        this.setBackgroundColor(this.mContext.getResources().getColor(colorResId));
        if (this.mGuestureView != null && this.mGuestureView.getVisibility() == 0) {
            this.mGuestureView.setBackgroundColor(Color.parseColor((String)"#00000000"));
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    public void inflateMenu(int menuResId) {
        MenuInflater inflater = new MenuInflater(this.getContext());
        MenuBuilder menu = new MenuBuilder(this.getContext());
        inflater.inflate(menuResId, (Menu)menu);
        this.setMenu(menu);
    }

    @SuppressLint(value={"RestrictedApi"})
    private void setMenu(MenuBuilder menu) {
        this.mContainer.removeAllViews();
        this.mPopupItems.clear();
        this.mPopup = null;
        int count = menu.size();
        this.setContainerWidth(count);
        if (!this.isFootActionBar || count <= this.mMaxVisibleTabCount - 1) {
            this.addItemView(menu, count);
        } else {
            this.mVisibleTabCount = this.mMaxVisibleTabCount > 5 ? 4 : this.mMaxVisibleTabCount - 1;
            this.addItemView(menu, this.mVisibleTabCount);
            this.mMoreView = this.getMenuItem(this.mMoreIconRes, this.mContext.getResources().getString(R.string.os_foot_opt_bar_more));
            this.mMoreView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FootOperationBar.this.mMoreView.setSelected(true);
                    FootOperationBar.this.mPopup.show();
                }
            });
            this.mContainer.addView(this.mMoreView);
            this.setPopupItems(menu, count);
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    private void addItemView(MenuBuilder menu, int count) {
        this.mFootItemViews.clear();
        for (int i = 0; i < count; ++i) {
            MenuItem item = menu.getItem(i);
            View itemView = this.getMenuItem(item.getIcon(), item.getTitle().toString());
            this.addItemView(itemView, i);
        }
    }

    public void removeItemView(int index) {
        if (this.mFootItemViews != null && this.mFootItemViews.size() > index) {
            this.mFootItemViews.remove(this.mFootItemViews.get(index));
            this.mContainer.removeViewAt(index);
            this.resetClickListener();
            this.requestLayout();
            this.invalidate();
        }
    }

    private void addItemView(int[] resId, String[] titleId, int count) {
        this.mFootItemViews.clear();
        for (int i = 0; i < count; ++i) {
            View itemView = this.getMenuItem(resId[i], titleId[i]);
            this.addItemView(itemView, i);
        }
    }

    private void addItemView(View view, int i) {
        this.mFootItemViews.add(view);
        final int index = i;
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FootOperationBar.this.mItemClickListener != null) {
                    FootOperationBar.this.mItemClickListener.onItemClick(index);
                    if (!FootOperationBar.this.isFootActionBar) {
                        FootOperationBar.this.setItemSelectState(index);
                    }
                }
            }
        });
        this.mContainer.addView(view);
    }

    public void resetClickListener() {
        for (int index = 0; index < this.mFootItemViews.size(); ++index) {
            final int finalIndex = index;
            this.mFootItemViews.get(index).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FootOperationBar.this.mItemClickListener != null) {
                        FootOperationBar.this.mItemClickListener.onItemClick(finalIndex);
                        if (!FootOperationBar.this.isFootActionBar) {
                            FootOperationBar.this.setItemSelectState(finalIndex);
                        }
                    }
                }
            });
        }
    }

    public void addSingleItemView(int resId, int titleId, int i) {
        View itemView = this.getMenuItem(resId, this.mContext.getResources().getString(titleId));
        this.mFootItemViews.add(itemView);
        this.resetClickListener();
        if (i < this.mFootItemViews.size()) {
            this.mContainer.addView(itemView, i);
        } else {
            this.mContainer.addView(itemView);
        }
    }

    public void setItemSelectState(int index) {
        if (this.mFootItemViews != null) {
            for (int i = 0; i < this.mFootItemViews.size(); ++i) {
                TextView textView = (TextView)this.mFootItemViews.get(i).findViewById(R.id.os_foot_opt_bar_item_text);
                ImageView imageView = (ImageView)this.mFootItemViews.get(i).findViewById(R.id.os_foot_opt_bar_item_icon);
                if (i == index) {
                    textView.setTextColor(this.mClickTextColor);
                    imageView.setSelected(true);
                    continue;
                }
                textView.setTextColor(this.mTextColor);
                imageView.setSelected(false);
            }
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    private void setPopupItems(MenuBuilder menu, int count) {
        this.mMenuEnables = new boolean[count];
        for (int i = this.mVisibleTabCount = this.mMaxVisibleTabCount > 5 ? 4 : this.mMaxVisibleTabCount - 1; i < count; ++i) {
            MenuItem item = menu.getItem(i);
            this.mPopupItems.add(item.getTitle().toString());
            this.mMenuEnables[i - this.mVisibleTabCount] = true;
        }
        this.setFootPopupWindow();
    }

    private void setContainerWidth(int count) {
        int width;
        int padding = 0;
        switch (count) {
            case 1: {
                width = this.mContext.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_one_item_width);
                break;
            }
            case 2: 
            case 3: {
                width = -1;
                padding = this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_padding);
                break;
            }
            default: {
                padding = this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_padding);
                if (Utils.isWaterfallScreen(this.mContext)) {
                    padding += this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curve_land);
                }
                width = -1;
            }
        }
        ViewGroup.LayoutParams lp = this.mContainer.getLayoutParams();
        lp.width = width;
        this.mContainer.setLayoutParams(lp);
        this.mContainer.setPadding(padding, this.mContainer.getPaddingTop(), padding, this.mContainer.getPaddingBottom());
    }

    private View getMenuItem(Drawable img, String title) {
        View itemRoot = this.isFootActionBar ? LayoutInflater.from((Context)this.getContext()).inflate(R.layout.os_foot_action_bar_item, (ViewGroup)this.mContainer, false) : LayoutInflater.from((Context)this.getContext()).inflate(R.layout.os_foot_opt_bar_item, (ViewGroup)this.mContainer, false);
        itemRoot.setBackground(ContextCompat.getDrawable((Context)this.getContext(), (int)this.mItemBackgroundRes));
        ImageView icon = (ImageView)itemRoot.findViewById(R.id.os_foot_opt_bar_item_icon);
        TextView text = (TextView)itemRoot.findViewById(R.id.os_foot_opt_bar_item_text);
        if (img != null) {
            img.mutate();
            if (this.isFootActionBar) {
                img.setTint(this.mTintColor);
            }
            icon.setImageDrawable(img);
            if (this.isFootActionBar) {
                if (this.mHaveNormalImageTintColor) {
                    img.setTint(this.mNormalImageTintColor);
                }
            } else if (this.needChangeImgColor) {
                this.setImageColorStateList(icon);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)title)) {
            text.setText((CharSequence)title);
            if (!this.isFootActionBar || this.mHaveTextColor) {
                text.setTextColor(this.mTextColor);
            }
        }
        return itemRoot;
    }

    private View getMenuItem(int imgId, String title) {
        return this.getMenuItem(this.mContext.getDrawable(imgId), title);
    }

    private void setImageColorStateList(ImageView icon) {
        if (this.mHaveClickImageTintColor && this.mHaveNormalImageTintColor) {
            int[][] states = new int[][]{{0x10100A1}, new int[0]};
            int[] colors = new int[]{this.mClickImageTintColor, this.mNormalImageTintColor};
            ColorStateList colorList = new ColorStateList((int[][])states, colors);
            icon.setImageTintList(colorList);
        }
    }

    public void changeFootItem(int position, int resId, String title) {
        View itemView = this.mContainer.getChildAt(position);
        ImageView icon = (ImageView)itemView.findViewById(R.id.os_foot_opt_bar_item_icon);
        TextView text = (TextView)itemView.findViewById(R.id.os_foot_opt_bar_item_text);
        icon.setImageResource(resId);
        text.setText((CharSequence)title);
        if (!this.isFootActionBar || this.mHaveTextColor) {
            text.setTextColor(this.mTextColor);
        }
    }

    public void changeFootItem(int position, int resId, int strId) {
        this.changeFootItem(position, resId, this.getResources().getString(strId));
    }

    public void changeItems(int[] resId, int[] titleIds) {
        String[] titles = new String[titleIds.length];
        for (int i = 0; i < titleIds.length; ++i) {
            titles[i] = this.mContext.getResources().getString(titleIds[i]);
        }
        this.changeItems(resId, titles);
    }

    public void changeItems(int[] resId, String[] titleId) {
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
        this.mContainer.removeAllViews();
        this.mPopupItems.clear();
        this.mFootItemViews.clear();
        this.mPopup = null;
        int count = resId.length;
        this.setContainerWidth(count);
        if (!this.isFootActionBar || count <= this.mMaxVisibleTabCount - 1) {
            this.addItemView(resId, titleId, count);
        } else {
            this.mVisibleTabCount = this.mMaxVisibleTabCount > 5 ? 4 : this.mMaxVisibleTabCount - 1;
            this.addItemView(resId, titleId, this.mVisibleTabCount);
            this.mMoreView = this.getMenuItem(this.mMoreIconRes, this.mContext.getResources().getString(R.string.os_foot_opt_bar_more));
            this.mMoreView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FootOperationBar.this.mMoreView.setSelected(true);
                    if (FootOperationBar.this.mPopup != null && !FootOperationBar.this.mPopup.isShowing()) {
                        FootOperationBar.this.mPopup.show();
                    }
                }
            });
            this.mContainer.addView(this.mMoreView);
            this.setPopupItems(titleId, count);
        }
    }

    private void setPopupItems(String[] title, int count) {
        this.mMenuEnables = new boolean[count - this.mVisibleTabCount];
        for (int i = this.mVisibleTabCount; i < count; ++i) {
            this.mPopupItems.add(title[i]);
            this.mMenuEnables[i - this.mVisibleTabCount] = true;
        }
        this.setFootPopupWindow();
    }

    public void changeItemsEnable(boolean[] enables) {
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
        int count = Math.min(enables.length, this.getItemCount());
        for (int i = 0; i < count; ++i) {
            this.changeItemEnable(i, enables[i]);
        }
    }

    public void changeItemEnable(int position, boolean enable) {
        if (this.mPopup == null) {
            this.viewEnable(this.mContainer.getChildAt(position), enable);
        } else if (position < this.mVisibleTabCount) {
            this.viewEnable(this.mContainer.getChildAt(position), enable);
        } else {
            this.mMenuEnables[position - this.mVisibleTabCount] = enable;
        }
    }

    public void enableMore(boolean enAble) {
        if (this.mMoreView != null) {
            this.viewEnable(this.mMoreView, enAble);
            if (!enAble && this.mPopup != null && this.mPopup.isShowing()) {
                this.mPopup.dismiss();
            }
        }
    }

    private void viewEnable(View view, boolean enAble) {
        if (view != null) {
            view.setEnabled(enAble);
            view.setAlpha(enAble ? 1.0f : 0.4f);
        }
    }

    private void setFootPopupWindow() {
        FootPopupAdapter adapter = new FootPopupAdapter();
        this.mPopup = new ListPopupWindow(this.getContext(), null, 0, R.style.OsFootOptPopupStyle);
        this.mPopup.setAdapter((ListAdapter)adapter);
        int contentWidth = this.measureMaxWidth((ListAdapter)adapter, this.mScreenWidth / 2);
        this.mPopup.setContentWidth(contentWidth);
        this.mPopup.setModal(true);
        this.mPopup.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                FootOperationBar.this.mMoreView.setSelected(false);
            }
        });
        this.mPopup.setAnchorView((View)this.mContainer);
        this.mPopup.setDropDownGravity(0x800005);
        if (this.getResources().getConfiguration().orientation == 2 && Build.VERSION.SDK_INT >= 29) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    Display display = FootOperationBar.this.getDisplay();
                    if (display == null || display.getCutout() == null) {
                        return;
                    }
                    FootOperationBar.this.mPopup.setHorizontalOffset(-display.getCutout().getSafeInsetRight());
                }
            });
        }
        if (Build.VERSION.SDK_INT >= 30 && Utils.isWaterfallScreen(this.mContext)) {
            int offset;
            Drawable drawable2;
            int rotation = this.mContext.getDisplay().getRotation();
            switch (rotation) {
                case 1: {
                    drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.os_foot_opt_popup_background_curse_90);
                    offset = this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curse_offset_land);
                    break;
                }
                case 3: {
                    drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.os_foot_opt_popup_background_curse_270);
                    offset = this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curse_offset_land);
                    break;
                }
                default: {
                    drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.os_foot_opt_popup_background_curse_0_180);
                    offset = this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curse_offset_portrait);
                }
            }
            this.mPopup.setContentWidth(contentWidth + offset);
            this.mPopup.setBackgroundDrawable(drawable2);
        }
    }

    private int measureMaxWidth(ListAdapter adapter, int maxAllowedWidth) {
        int maxWidth = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            itemView = adapter.getView(i, itemView, null);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            int itemWidth = itemView.getMeasuredWidth();
            if (itemWidth >= maxAllowedWidth) {
                return maxAllowedWidth;
            }
            if (itemWidth <= maxWidth) continue;
            maxWidth = itemWidth;
        }
        return maxWidth;
    }

    private void openAnimator() {
        ObjectAnimator oa = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        oa.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.33f, 0.0f, 0.66f, 1.0f));
        oa.setDuration(150L);
        oa.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                FootOperationBar.this.setVisibility(0);
                FootOperationBar.this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)FootOperationBar.this.mMyOnPreDrawListener);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FootOperationBar.this.mAnim = false;
            }
        });
        oa.start();
    }

    private void closeAnimator() {
        ObjectAnimator oa = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        oa.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.33f, 0.0f, 0.66f, 1.0f));
        oa.setDuration(150L);
        oa.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FootOperationBar.this.setVisibility(8);
                FootOperationBar.this.mAnim = false;
                if (FootOperationBar.this.mMoreView != null) {
                    FootOperationBar.this.mMoreView.setEnabled(true);
                }
                FootOperationBar.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)FootOperationBar.this.mMyOnPreDrawListener);
            }
        });
        oa.start();
    }

    public void openFootOperationBar() {
        if (!this.mAnim && !this.mShow) {
            this.mAnim = true;
            this.mShow = true;
            this.openAnimator();
        }
    }

    public void closeFootOperationBar() {
        if (!this.mAnim && this.mShow) {
            if (this.mPopup != null && this.mPopup.isShowing()) {
                this.mPopup.dismiss();
            }
            if (this.mMoreView != null) {
                this.mMoreView.setEnabled(false);
            }
            this.mAnim = true;
            this.mShow = false;
            this.closeAnimator();
        }
    }

    public void toggleFootOperationBar() {
        if (this.mShow) {
            this.closeFootOperationBar();
        } else {
            this.openFootOperationBar();
        }
    }

    public void initShow(boolean initShow) {
        this.mInitShow = initShow;
    }

    public int getItemCount() {
        return this.mPopupItems.size() > 0 ? this.mContainer.getChildCount() + this.mPopupItems.size() - 1 : this.mContainer.getChildCount();
    }

    public void updateFootBarView() {
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        this.setContainerWidth(this.mContainer.getChildCount());
        if (Utils.isGestureNavigationBarOn(this.mContext)) {
            this.mGuestureView.setVisibility(0);
        } else {
            this.mGuestureView.setVisibility(8);
        }
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateFootBarView();
        if (this.mShow) {
            this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mMyOnPreDrawListener);
        }
    }

    public void setOnFootOptBarClickListener(OnFootOptBarClickListener l) {
        this.mItemClickListener = l;
    }

    public void setFootOptBarTextColor(@ColorInt int color2) {
        if (!this.isFootActionBar) {
            this.mTextColor = color2;
        }
    }

    public void setFootOptBarClickTextColor(@ColorInt int color2) {
        if (!this.isFootActionBar) {
            this.mClickTextColor = color2;
        }
    }

    private class FootPopupAdapter
    extends BaseAdapter {
        private FootPopupAdapter() {
        }

        public int getCount() {
            return FootOperationBar.this.mPopupItems.size();
        }

        public Object getItem(int position) {
            return FootOperationBar.this.mPopupItems.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)FootOperationBar.this.getContext()).inflate(R.layout.os_foot_opt_bar_popup_item, parent, false);
                holder = new ViewHolder();
                holder.title = (TextView)convertView.findViewById(R.id.os_foot_opt_bar_popup_item_text);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            holder.title.setText((CharSequence)FootOperationBar.this.mPopupItems.get(position));
            FootOperationBar.this.viewEnable(convertView, FootOperationBar.this.mMenuEnables[position]);
            final int index = position + FootOperationBar.this.mVisibleTabCount;
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FootOperationBar.this.mItemClickListener != null) {
                        FootOperationBar.this.mItemClickListener.onItemClick(index);
                    }
                    FootOperationBar.this.mPopup.dismiss();
                }
            });
            return convertView;
        }

        private class ViewHolder {
            private TextView title;

            private ViewHolder() {
            }
        }
    }

    public static interface OnFootOptBarClickListener {
        public void onItemClick(int var1);
    }

    private static class MyOnPreDrawListener
    implements ViewTreeObserver.OnPreDrawListener {
        private final WeakReference<FootOperationBar> mFootOperationBar;

        MyOnPreDrawListener(FootOperationBar footOperationBar) {
            this.mFootOperationBar = new WeakReference<FootOperationBar>(footOperationBar);
        }

        public boolean onPreDraw() {
            FootOperationBar footOperationBar = (FootOperationBar)((Object)this.mFootOperationBar.get());
            if (footOperationBar != null) {
                footOperationBar.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                footOperationBar.offsetTopAndBottom(footOperationBar.getMeasuredHeight());
                footOperationBar.setVisibility(8);
                if (footOperationBar.mInitShow || footOperationBar.mShow) {
                    footOperationBar.setVisibility(0);
                    footOperationBar.openFootOperationBar();
                }
            }
            return true;
        }
    }
}

