/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.timepicker;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Vibrator;
import android.provider.Settings;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.widget.timepicker.wheel.WheelView;
import java.util.ArrayList;
import java.util.Calendar;

public class OSDateTimePicker
extends LinearLayout {
    private Calendar mCalendar = Calendar.getInstance();
    private WheelView mYearWheel;
    private WheelView mMonthWheel;
    private WheelView mDayWheel;
    private WheelView mMonthDayWheel;
    private WheelView mFormatWheel;
    private WheelView mHourWheel;
    private WheelView mMinuteWheel;
    public ArrayList<String> mMonthList = new ArrayList();
    private ArrayList<String> mAmPmList = new ArrayList();
    private static int START_YEAR = 1900;
    private static int END_YEAR = 2100;
    private OnDateTimeChangeListener mOnDateTimeChangeListener;
    public static final String FORMAT_Y_M_D_H_M = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_Y_M_D = "yyyy-MM-dd";
    public static final String FORMAT_M_D = "MM-dd";
    public static final String FORMAT_M_D_H_M = "MM-dd HH:mm";
    public static final String FORMAT_H_M = "HH:mm";
    private WheelView.OnWheelChangedListener mOnYearChangedListener;
    private WheelView.OnWheelChangedListener mOnMonthChangedListener;
    private WheelView.OnWheelChangedListener mOnDayChangedListener;
    private WheelView.OnWheelChangedListener mOnMonthDayChangedLister;
    private WheelView.OnWheelChangedListener mOnHourChangedListener;
    private WheelView.OnWheelChangedListener mOnMinuteChangedListener;
    private WheelView.OnWheelChangedListener mOnFormatChangedListener;
    private boolean mIs24Format;
    private String mFormat;
    private Context mContext;
    private final int DEFAULT_VISIBLE_ITEMS = 5;
    private String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private Vibrator mVibrator;
    private Runnable mVibrateRunnable = new Runnable(){

        @Override
        public void run() {
            OSDateTimePicker.this.maybeVibrate();
        }
    };

    public OSDateTimePicker(Context context) {
        super(context);
        this.mContext = context;
    }

    public OSDateTimePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
    }

    public void init(Calendar calendar, String format) {
        this.mCalendar = calendar;
        this.init(format);
    }

    public void init(String format) {
        this.mFormat = format;
        if (Utils.isRtl()) {
            LayoutInflater.from((Context)this.mContext).inflate(R.layout.os_picker_date_layout_rtl, (ViewGroup)this, true);
        } else {
            LayoutInflater.from((Context)this.mContext).inflate(R.layout.os_picker_date_layout, (ViewGroup)this, true);
        }
        this.initAndSetMargins();
        this.mVibrator = (Vibrator)this.mContext.getSystemService("vibrator");
    }

    private void initAndSetMargins() {
        switch (this.mFormat) {
            case "yyyy-MM-dd HH:mm": {
                this.initYearWheel();
                this.initMonthWheel();
                this.initDayWheel();
                this.initHourWheel();
                this.initMinuteWheel();
                break;
            }
            case "yyyy-MM-dd": {
                this.initYearWheel();
                this.initMonthWheel();
                this.initDayWheel();
                break;
            }
            case "MM-dd HH:mm": {
                this.initMonthDayWheel();
                this.initHourWheel();
                this.initMinuteWheel();
                break;
            }
            case "MM-dd": {
                this.initMonthWheel();
                this.initDayWheel();
                break;
            }
            case "HH:mm": {
                this.initHourWheel();
                this.initMinuteWheel();
                break;
            }
        }
        this.updateMargins();
    }

    private void initYearWheel() {
        int year = this.mCalendar.get(1);
        this.mYearWheel = (WheelView)this.findViewById(R.id.yearWheel);
        this.mYearWheel.setVisibility(0);
        ArrayList<Integer> yearList = new ArrayList<Integer>();
        for (int i = START_YEAR; i < Math.max(year, END_YEAR) + 1; ++i) {
            yearList.add(i);
        }
        this.mYearWheel.setData(yearList);
        this.mYearWheel.setVisibleItems(5);
        this.mYearWheel.setCyclic(true);
        this.mYearWheel.setSelectedItemPosition(year > START_YEAR ? year - START_YEAR : 0);
        this.mOnYearChangedListener = new WheelView.OnWheelChangedListener(){

            @Override
            public void onWheelScroll(int scrollOffsetY) {
            }

            @Override
            public void onWheelItemChanged(int oldValue, int newValue) {
                OSDateTimePicker.this.onYearChange(START_YEAR + newValue);
                OSDateTimePicker.this.onVibrate();
            }

            @Override
            public void onWheelSelected(int position) {
            }

            @Override
            public void onWheelScrollStateChanged(int state) {
            }
        };
        this.mYearWheel.setOnWheelChangedListener(this.mOnYearChangedListener);
    }

    private void releaseYearWheel() {
        if (this.mYearWheel != null) {
            this.mYearWheel.setOnWheelChangedListener(this.mOnYearChangedListener);
            this.mOnYearChangedListener = null;
            this.mYearWheel = null;
        }
    }

    private void initMonthWheel() {
        int month = this.mCalendar.get(2);
        this.mMonthWheel = (WheelView)this.findViewById(R.id.monthWheel);
        this.mMonthWheel.setVisibility(0);
        this.initMonthList();
        this.mMonthWheel.setData(this.mMonthList);
        this.mMonthWheel.setVisibleItems(5);
        this.mMonthWheel.setCyclic(true);
        this.mMonthWheel.setSelectedItemPosition(month);
        this.mOnMonthChangedListener = new WheelView.OnWheelChangedListener(){

            @Override
            public void onWheelScroll(int scrollOffsetY) {
            }

            @Override
            public void onWheelItemChanged(int oldValue, int newValue) {
                OSDateTimePicker.this.onMonthChange(newValue);
                OSDateTimePicker.this.onVibrate();
            }

            @Override
            public void onWheelSelected(int position) {
            }

            @Override
            public void onWheelScrollStateChanged(int state) {
            }
        };
        this.mMonthWheel.setOnWheelChangedListener(this.mOnMonthChangedListener);
    }

    private void releaseMonthWheel() {
        if (this.mMonthWheel != null) {
            this.mMonthWheel.setOnWheelChangedListener(this.mOnMonthChangedListener);
            this.mOnMonthChangedListener = null;
            this.mMonthList.clear();
            this.mMonthWheel = null;
        }
    }

    private void initDayWheel() {
        int day = this.mCalendar.get(5);
        this.mDayWheel = (WheelView)this.findViewById(R.id.dayWheel);
        this.mDayWheel.setVisibility(0);
        ArrayList<Integer> dayList = new ArrayList<Integer>();
        for (int i = 1; i < this.mCalendar.getActualMaximum(5) + 1; ++i) {
            dayList.add(i);
        }
        this.mDayWheel.setData(dayList);
        this.mDayWheel.setVisibleItems(5);
        this.mDayWheel.setCyclic(true);
        this.mDayWheel.setSelectedItemPosition(day - 1);
        this.mOnDayChangedListener = new WheelView.OnWheelChangedListener(){

            @Override
            public void onWheelScroll(int scrollOffsetY) {
            }

            @Override
            public void onWheelItemChanged(int oldValue, int newValue) {
                OSDateTimePicker.this.onDaysChange(newValue + 1);
                OSDateTimePicker.this.onVibrate();
            }

            @Override
            public void onWheelSelected(int position) {
            }

            @Override
            public void onWheelScrollStateChanged(int state) {
            }
        };
        this.mDayWheel.setOnWheelChangedListener(this.mOnDayChangedListener);
    }

    private void releaseDayWheel() {
        if (this.mDayWheel != null) {
            this.mDayWheel.setOnWheelChangedListener(this.mOnDayChangedListener);
            this.mOnDayChangedListener = null;
            this.mDayWheel = null;
        }
    }

    private void onDaysChange(int days) {
        this.mCalendar.set(5, days);
        this.change();
    }

    private void onMonthChange(int month) {
        Calendar tempCalendar = Calendar.getInstance();
        tempCalendar.set(5, 1);
        tempCalendar.set(1, this.mCalendar.get(1));
        tempCalendar.set(2, month);
        int nextMaxDays = tempCalendar.getActualMaximum(5);
        int currentDays = this.mCalendar.get(5);
        if (nextMaxDays < currentDays) {
            this.mCalendar.set(5, nextMaxDays);
        }
        this.mCalendar.set(2, month);
        this.updateDaysWheel();
        this.change();
    }

    private void onYearChange(int year) {
        Calendar tempCalendar = Calendar.getInstance();
        tempCalendar.set(1, year);
        tempCalendar.set(2, this.mCalendar.get(2));
        tempCalendar.set(5, 1);
        int tempMaxDay = tempCalendar.getActualMaximum(5);
        int currentDay = this.mDayWheel.getSelectedItemPosition() + 1;
        if (tempMaxDay < currentDay) {
            this.mCalendar.set(5, tempMaxDay);
        }
        this.mCalendar.set(1, year);
        this.updateDaysWheel();
        this.change();
    }

    private void initMonthDayWheel() {
        this.initMonthList();
        int day = this.mCalendar.get(6);
        this.mMonthDayWheel = (WheelView)this.findViewById(R.id.monthDayWheel);
        this.mMonthDayWheel.setVisibility(0);
        this.mMonthDayWheel.setYearDays(this.mCalendar, true);
        this.mMonthDayWheel.setMonthList(this.mMonthList);
        ArrayList<Integer> monthDayList = new ArrayList<Integer>();
        for (int i = 1; i < this.mCalendar.getActualMaximum(6) + 1; ++i) {
            monthDayList.add(i);
        }
        this.mMonthDayWheel.setData(monthDayList);
        this.mMonthDayWheel.setVisibleItems(5);
        this.mMonthDayWheel.setCyclic(true);
        this.mMonthDayWheel.setSelectedItemPosition(day - 1);
        this.mOnMonthDayChangedLister = new WheelView.OnWheelChangedListener(){

            @Override
            public void onWheelScroll(int scrollOffsetY) {
            }

            @Override
            public void onWheelItemChanged(int oldValue, int newValue) {
                if (newValue > oldValue) {
                    if (oldValue == OSDateTimePicker.this.mCalendar.getActualMinimum(6) - 1 && newValue - oldValue > 1) {
                        OSDateTimePicker.this.updateMonthDayData(OSDateTimePicker.this.mCalendar.get(1) - 1, true);
                    } else {
                        OSDateTimePicker.this.mCalendar.set(6, newValue + 1);
                    }
                } else if (newValue < oldValue) {
                    if (oldValue == OSDateTimePicker.this.mCalendar.getActualMaximum(6) - 1 && oldValue - newValue > 1) {
                        OSDateTimePicker.this.updateMonthDayData(OSDateTimePicker.this.mCalendar.get(1) + 1, false);
                    } else {
                        OSDateTimePicker.this.mCalendar.set(6, newValue + 1);
                    }
                }
                OSDateTimePicker.this.change();
                OSDateTimePicker.this.onVibrate();
            }

            @Override
            public void onWheelSelected(int position) {
            }

            @Override
            public void onWheelScrollStateChanged(int state) {
            }
        };
        this.mMonthDayWheel.setOnWheelChangedListener(this.mOnMonthDayChangedLister);
    }

    private void releaseMonthDayWheel() {
        if (this.mMonthDayWheel != null) {
            this.mMonthDayWheel.setOnWheelChangedListener(this.mOnMonthDayChangedLister);
            this.mOnMonthDayChangedLister = null;
            this.mMonthDayWheel = null;
        }
    }

    private void updateMonthDayData(int yearValue, boolean maxValue) {
        this.mCalendar.set(6, this.mCalendar.getMinimum(6));
        this.mCalendar.set(1, yearValue);
        this.mCalendar.set(6, maxValue ? this.mCalendar.getActualMaximum(6) : this.mCalendar.getMinimum(6));
        ArrayList<Integer> monthDayList = new ArrayList<Integer>();
        for (int i = 1; i < this.mCalendar.getActualMaximum(6) + 1; ++i) {
            monthDayList.add(i);
        }
        this.mMonthDayWheel.setData(monthDayList);
        int day = this.mCalendar.get(6);
        this.mMonthDayWheel.setOnWheelChangedListener(null);
        this.mMonthDayWheel.setSelectedItemPosition(day - 1);
        this.mMonthDayWheel.setOnWheelChangedListener(this.mOnMonthDayChangedLister);
    }

    private void initHourWheel() {
        int hour;
        this.mHourWheel = (WheelView)this.findViewById(R.id.hourWheel);
        this.mHourWheel.setVisibility(0);
        this.mFormatWheel = (WheelView)this.findViewById(R.id.formatWheel);
        this.mIs24Format = Utils.is24HourFormat(this.mContext);
        this.mHourWheel.setHourWheel(true);
        this.mHourWheel.set24HoursFormat(this.mIs24Format);
        int n = hour = this.mIs24Format ? this.mCalendar.get(11) : this.mCalendar.get(10);
        if (this.mIs24Format) {
            ArrayList<Integer> hourList = new ArrayList<Integer>();
            for (int i = 0; i < 24; ++i) {
                hourList.add(i);
            }
            this.mHourWheel.setData(hourList);
            this.mHourWheel.setSelectedItemPosition(hour);
        } else {
            this.mAmPmList.add(this.mContext.getString(R.string.am));
            this.mAmPmList.add(this.mContext.getString(R.string.pm));
            ArrayList<Integer> hourList = new ArrayList<Integer>();
            for (int i = 1; i < 13; ++i) {
                hourList.add(i);
            }
            this.mHourWheel.setData(hourList);
            this.mHourWheel.setSelectedItemPosition((hour + 12 - 1) % 12);
            int amPm = this.mCalendar.get(9);
            this.mFormatWheel.setData(this.mAmPmList);
            this.mFormatWheel.setVisibleItems(3);
            this.mFormatWheel.setCyclic(false);
            this.mFormatWheel.setSelectedItemPosition(amPm);
            this.mFormatWheel.setAmPmWheel(true);
            this.mOnFormatChangedListener = new WheelView.OnWheelChangedListener(){

                @Override
                public void onWheelScroll(int scrollOffsetY) {
                }

                @Override
                public void onWheelItemChanged(int oldValue, int newValue) {
                    OSDateTimePicker.this.mCalendar.set(9, newValue);
                    OSDateTimePicker.this.change();
                    OSDateTimePicker.this.onVibrate();
                }

                @Override
                public void onWheelSelected(int position) {
                }

                @Override
                public void onWheelScrollStateChanged(int state) {
                }
            };
            this.mFormatWheel.setOnWheelChangedListener(this.mOnFormatChangedListener);
        }
        this.mHourWheel.setVisibleItems(5);
        this.mHourWheel.setCyclic(true);
        this.mOnHourChangedListener = new WheelView.OnWheelChangedListener(){

            @Override
            public void onWheelScroll(int scrollOffsetY) {
            }

            @Override
            public void onWheelItemChanged(int oldValue, int newValue) {
                int realHour = OSDateTimePicker.this.mIs24Format ? newValue : (newValue + 1) % 12;
                OSDateTimePicker.this.mCalendar.set(OSDateTimePicker.this.mIs24Format ? 11 : 10, realHour);
                OSDateTimePicker.this.change();
                OSDateTimePicker.this.onVibrate();
            }

            @Override
            public void onWheelSelected(int position) {
            }

            @Override
            public void onWheelScrollStateChanged(int state) {
            }
        };
        this.mHourWheel.setOnWheelChangedListener(this.mOnHourChangedListener);
    }

    private void releaseHourWheel() {
        if (this.mHourWheel != null) {
            this.mHourWheel.setOnWheelChangedListener(this.mOnHourChangedListener);
            this.mOnHourChangedListener = null;
            this.mHourWheel = null;
        }
    }

    private void initMinuteWheel() {
        int minute = this.mCalendar.get(12);
        this.mMinuteWheel = (WheelView)this.findViewById(R.id.minWheel);
        this.mMinuteWheel.setVisibility(0);
        ArrayList<Integer> minuteList = new ArrayList<Integer>();
        for (int i = 0; i < 60; ++i) {
            minuteList.add(i);
        }
        this.mMinuteWheel.setMinuteWheel(true);
        this.mMinuteWheel.setData(minuteList);
        this.mMinuteWheel.setSelectedItemPosition(minute);
        this.mMinuteWheel.setVisibleItems(5);
        this.mMinuteWheel.setCyclic(true);
        this.mOnMinuteChangedListener = new WheelView.OnWheelChangedListener(){

            @Override
            public void onWheelScroll(int scrollOffsetY) {
            }

            @Override
            public void onWheelItemChanged(int oldValue, int newValue) {
                OSDateTimePicker.this.mCalendar.set(12, newValue);
                OSDateTimePicker.this.change();
                OSDateTimePicker.this.onVibrate();
            }

            @Override
            public void onWheelSelected(int position) {
            }

            @Override
            public void onWheelScrollStateChanged(int state) {
            }
        };
        this.mMinuteWheel.setOnWheelChangedListener(this.mOnMinuteChangedListener);
    }

    private void releaseMinuteWheel() {
        if (this.mMinuteWheel != null) {
            this.mMinuteWheel.setOnWheelChangedListener(this.mOnMinuteChangedListener);
            this.mOnMinuteChangedListener = null;
            this.mMinuteWheel = null;
        }
    }

    private void releaseFormatWheel() {
        if (this.mFormatWheel != null) {
            this.mAmPmList.clear();
            this.mFormatWheel.setOnWheelChangedListener(this.mOnFormatChangedListener);
            this.mOnFormatChangedListener = null;
            this.mFormatWheel = null;
        }
    }

    private void initMonthList() {
        Resources resources = this.mContext.getResources();
        this.mMonthList.add(resources.getString(R.string.jan));
        this.mMonthList.add(resources.getString(R.string.feb));
        this.mMonthList.add(resources.getString(R.string.mar));
        this.mMonthList.add(resources.getString(R.string.apr));
        this.mMonthList.add(resources.getString(R.string.may));
        this.mMonthList.add(resources.getString(R.string.jun));
        this.mMonthList.add(resources.getString(R.string.jul));
        this.mMonthList.add(resources.getString(R.string.aug));
        this.mMonthList.add(resources.getString(R.string.sep));
        this.mMonthList.add(resources.getString(R.string.oct));
        this.mMonthList.add(resources.getString(R.string.nov));
        this.mMonthList.add(resources.getString(R.string.dec));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void updateDaysWheel() {
        if (this.mDayWheel != null) {
            int currentDay = this.mDayWheel.getSelectedItemPosition() + 1;
            int maxValue = this.mCalendar.getActualMaximum(5);
            ArrayList<Integer> dayList = new ArrayList<Integer>();
            for (int i = 1; i < maxValue + 1; ++i) {
                dayList.add(i);
            }
            this.mDayWheel.setData(dayList);
            if (currentDay < maxValue) {
                this.mDayWheel.setSelectedItemPosition(currentDay - 1);
            } else {
                this.mDayWheel.setSelectedItemPosition(maxValue - 1);
            }
        }
    }

    private void change() {
        if (this.mOnDateTimeChangeListener != null) {
            this.mOnDateTimeChangeListener.onChange(this, this.mCalendar);
        }
    }

    public void setOnDateChangeListener(OnDateTimeChangeListener onChangeListener) {
        this.mOnDateTimeChangeListener = onChangeListener;
        this.change();
    }

    public boolean is24Format() {
        return this.mIs24Format;
    }

    public void updateMargins() {
        int yearMarginStart = 0;
        int monthMarginStart = 0;
        int dayMarginStart = 0;
        int monthDayMarginStart = 0;
        int hourMarginStart = 0;
        int minuteMarginStart = 0;
        int formatStart = 0;
        switch (this.mFormat) {
            case "yyyy-MM-dd HH:mm": {
                break;
            }
            case "yyyy-MM-dd": {
                if (Utils.isRtl()) {
                    yearMarginStart = this.dp2px(28);
                    monthMarginStart = this.dp2px(8);
                    dayMarginStart = this.dp2px(30);
                    break;
                }
                yearMarginStart = this.dp2px(36);
                monthMarginStart = this.dp2px(16);
                dayMarginStart = this.dp2px(10);
                break;
            }
            case "MM-dd HH:mm": {
                if (Utils.isRtl()) {
                    if (this.mIs24Format) {
                        monthDayMarginStart = this.dp2px(16);
                        hourMarginStart = this.dp2px(36);
                        minuteMarginStart = this.dp2px(46);
                        this.mFormatWheel.setVisibility(8);
                        break;
                    }
                    monthDayMarginStart = this.dp2px(0);
                    hourMarginStart = this.dp2px(12);
                    minuteMarginStart = this.dp2px(12);
                    formatStart = this.dp2px(0);
                    this.mFormatWheel.setVisibility(0);
                    break;
                }
                if (this.mIs24Format) {
                    monthDayMarginStart = this.dp2px(20);
                    hourMarginStart = this.dp2px(26);
                    minuteMarginStart = this.dp2px(36);
                    this.mFormatWheel.setVisibility(8);
                    break;
                }
                monthDayMarginStart = this.dp2px(6);
                hourMarginStart = this.dp2px(8);
                minuteMarginStart = this.dp2px(17);
                formatStart = this.dp2px(0);
                this.mFormatWheel.setVisibility(0);
                break;
            }
            case "MM-dd": {
                break;
            }
            case "HH:mm": {
                if (Utils.isRtl()) {
                    if (this.mIs24Format) {
                        hourMarginStart = this.dp2px(72);
                        minuteMarginStart = this.dp2px(88);
                        this.mFormatWheel.setVisibility(8);
                        break;
                    }
                    hourMarginStart = this.dp2px(56);
                    minuteMarginStart = this.dp2px(40);
                    formatStart = this.dp2px(40);
                    this.mFormatWheel.setVisibility(0);
                    break;
                }
                if (this.mIs24Format) {
                    hourMarginStart = this.dp2px(88);
                    minuteMarginStart = this.dp2px(72);
                    this.mFormatWheel.setVisibility(8);
                    break;
                }
                hourMarginStart = this.dp2px(40);
                minuteMarginStart = this.dp2px(56);
                formatStart = this.dp2px(40);
                this.mFormatWheel.setVisibility(0);
                break;
            }
        }
        this.setMarginStart(yearMarginStart, monthMarginStart, dayMarginStart, monthDayMarginStart, hourMarginStart, minuteMarginStart, formatStart);
    }

    private void setMarginStart(int yearMarginStart, int monthMarginStart, int dayMarginStart, int monthDayMarginStart, int hourMarginStart, int minuteMarginStart, int formatStart) {
        if (this.mMonthWheel != null && monthMarginStart != 0) {
            LinearLayout.LayoutParams lpMonth = (LinearLayout.LayoutParams)this.mMonthWheel.getLayoutParams();
            lpMonth.setMarginStart(monthMarginStart);
        }
        if (this.mDayWheel != null && dayMarginStart != 0) {
            LinearLayout.LayoutParams lpDay = (LinearLayout.LayoutParams)this.mDayWheel.getLayoutParams();
            lpDay.setMarginStart(dayMarginStart);
        }
        if (this.mMonthDayWheel != null && monthDayMarginStart != 0) {
            LinearLayout.LayoutParams lpMonthDay = (LinearLayout.LayoutParams)this.mMonthDayWheel.getLayoutParams();
            lpMonthDay.setMarginStart(monthDayMarginStart);
        }
        if (this.mYearWheel != null && yearMarginStart != 0) {
            LinearLayout.LayoutParams lpYear = (LinearLayout.LayoutParams)this.mYearWheel.getLayoutParams();
            lpYear.setMarginStart(yearMarginStart);
        }
        if (this.mHourWheel != null && hourMarginStart != 0) {
            LinearLayout.LayoutParams lpHour = (LinearLayout.LayoutParams)this.mHourWheel.getLayoutParams();
            lpHour.setMarginStart(hourMarginStart);
        }
        if (this.mMinuteWheel != null && minuteMarginStart != 0) {
            LinearLayout.LayoutParams lpMinute = (LinearLayout.LayoutParams)this.mMinuteWheel.getLayoutParams();
            lpMinute.setMarginStart(minuteMarginStart);
        }
        if (this.mFormatWheel != null && formatStart != 0) {
            LinearLayout.LayoutParams lpFormat = (LinearLayout.LayoutParams)this.mFormatWheel.getLayoutParams();
            lpFormat.setMarginStart(formatStart);
        }
    }

    private int dp2px(int dpValues) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValues, (DisplayMetrics)this.mContext.getResources().getDisplayMetrics());
    }

    public void setWheelBackgroundColorRes(int colorResId) {
        if (this.mContext != null) {
            this.setWheelBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)colorResId));
        }
    }

    public void setWheelBackgroundColor(int color2) {
        this.setWheelBackground(this.mYearWheel, color2);
        this.setWheelBackground(this.mMonthWheel, color2);
        this.setWheelBackground(this.mDayWheel, color2);
        this.setWheelBackground(this.mMonthDayWheel, color2);
        this.setWheelBackground(this.mFormatWheel, color2);
        this.setWheelBackground(this.mHourWheel, color2);
        this.setWheelBackground(this.mMinuteWheel, color2);
    }

    private void setWheelBackground(WheelView wheelView, int color2) {
        if (wheelView != null) {
            wheelView.setWheelBackgroundColor(color2);
        }
    }

    public void updateTime(int hour, int minute) {
        if (this.mCalendar != null) {
            this.mCalendar.set(11, hour);
            this.mCalendar.set(12, minute);
            this.release();
            this.refreshUI();
        }
    }

    public void updateDate(int year, int month, int day) {
        if (this.mCalendar != null) {
            this.mCalendar.set(1, year);
            this.mCalendar.set(2, month);
            this.mCalendar.set(5, day);
            this.release();
            this.refreshUI();
        }
    }

    public void updateDateTime(int year, int month, int day, int hour, int minute) {
        if (this.mCalendar != null) {
            this.mCalendar.set(1, year);
            this.mCalendar.set(2, month);
            this.mCalendar.set(5, day);
            this.mCalendar.set(11, hour);
            this.mCalendar.set(12, minute);
            this.release();
            this.refreshUI();
        }
    }

    public void release() {
        this.releaseYearWheel();
        this.releaseMonthWheel();
        this.releaseDayWheel();
        this.releaseMonthDayWheel();
        this.releaseHourWheel();
        this.releaseMinuteWheel();
        this.releaseFormatWheel();
    }

    private void refreshUI() {
        this.initAndSetMargins();
        if (this.mOnDateTimeChangeListener != null) {
            this.change();
        }
    }

    public void setYearDuration(int startYear, int endYear) {
        if (endYear < startYear) {
            return;
        }
        START_YEAR = startYear;
        END_YEAR = endYear;
    }

    private void onVibrate() {
        Handler viewHandler = this.getHandler();
        if (Utils.IS_4D_VIBRATE_SUPPORT && viewHandler != null && !viewHandler.hasCallbacks(this.mVibrateRunnable)) {
            viewHandler.postDelayed(this.mVibrateRunnable, 50L);
        }
    }

    private void maybeVibrate() {
        boolean hapticsDisable;
        boolean bl = hapticsDisable = Settings.System.getInt((ContentResolver)this.getContext().getContentResolver(), (String)"haptic_feedback_enabled", (int)0) == 0;
        if (!hapticsDisable && this.mVibrator != null && this.mVibrator.hasVibrator() && this.hasWindowFocus()) {
            this.mVibrator.cancel();
            this.mVibrator.vibrate(new long[]{0L, 40L}, -1);
        }
    }

    public static interface OnDateTimeChangeListener {
        public void onChange(OSDateTimePicker var1, Calendar var2);
    }
}

