/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.dialog;

import android.app.Dialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.view.LoadingView;

public class OSLoadingDialog
extends Dialog {
    private static LoadingView mOsLoading;

    private OSLoadingDialog(@NonNull Context context) {
        super(context);
    }

    private OSLoadingDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
    }

    public void dismiss() {
        super.dismiss();
        if (mOsLoading != null) {
            mOsLoading.release();
            mOsLoading = null;
        }
    }

    public static class Builder {
        private OSLoadingDialog mDialog;
        private Context mContext;
        private View mContainer;

        public Builder(Context context) {
            this(context, 0);
        }

        public Builder(Context context, int themeResId) {
            this.mContext = context;
            this.mDialog = new OSLoadingDialog(context, themeResId >= 0x1000000 ? themeResId : R.style.OS_Dialog_Loading);
            this.mDialog.setCancelable(false);
            this.mDialog.setCanceledOnTouchOutside(false);
            this.mDialog.getWindow().setGravity(17);
        }

        public Builder setMessage(String message) {
            this.setMessage(message, false);
            return this;
        }

        public Builder setMessage(String message, boolean ims) {
            this.mContainer = LayoutInflater.from((Context)this.mContext).inflate(ims ? R.layout.os_dialog_loading_mask : R.layout.os_dialog_loading, null, true);
            TextView messageTv = (TextView)this.mContainer.findViewById(R.id.messageTv);
            messageTv.setText((CharSequence)message);
            mOsLoading = (LoadingView)this.mContainer.findViewById(R.id.osLoading);
            this.mDialog.setContentView(this.mContainer, new ViewGroup.LayoutParams(-2, -2));
            this.mDialog.getWindow().setBackgroundDrawableResource(ims ? R.drawable.os_loading_dialog_ims_bg : R.drawable.os_loading_dialog_bg);
            this.mDialog.getWindow().setWindowAnimations(R.style.OsInputDialogAnimStyle);
            return this;
        }

        public Builder setMessage(int messageId) {
            this.setMessage(messageId, false);
            return this;
        }

        public Builder setMessage(int messageId, boolean ims) {
            this.setMessage(this.mContext.getResources().getString(messageId), ims);
            return this;
        }

        public OSLoadingDialog show() {
            if (this.mDialog != null) {
                this.mDialog.show();
            }
            return this.mDialog;
        }
    }
}

