/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.swipmenu;

import android.util.Log;
import com.transsion.widgetslib.view.swipmenu.Horizontal;
import com.transsion.widgetslib.view.swipmenu.OverScroller;
import com.transsion.widgetslib.view.swipmenu.SwipeMenu;

class LeftHorizontal
extends Horizontal {
    private static final String TAG = "LeftHorizontal";

    public LeftHorizontal(SwipeMenu swipeMenu) {
        super(1, swipeMenu);
    }

    @Override
    public boolean isMenuOpen(int scrollX) {
        int i = this.getMenuView().getMenuTotalWidth() * this.getDirection();
        Log.d((String)TAG, (String)("isMenuOpen: scrollX = " + scrollX + " i = " + i + " getDirection = " + this.getDirection()));
        return Math.abs(scrollX - i) <= 8 && i != 0;
    }

    @Override
    public boolean isMenuOpenNotEqual(int scrollX) {
        return scrollX < -this.getMenuView().getMenuTotalWidth() * this.getDirection();
    }

    @Override
    public void autoOpenMenu(OverScroller scroller, int scrollX, int duration) {
        scroller.startScroll(Math.abs(scrollX), this.getMenuView().getMenuTotalWidth() - Math.abs(scrollX), duration);
    }

    @Override
    public void autoOpenMenuFling(OverScroller scroller, int start, int velocity, int min, int max, int over) {
        scroller.fling(start, velocity, min, max, over);
    }

    @Override
    public void autoCloseMenuFling(OverScroller scroller, int start, int velocity, int min, int max, int over) {
        scroller.fling(start, velocity, min, max, over);
    }

    @Override
    public void autoCloseMenu(OverScroller scroller, int scrollX, int duration) {
        scroller.startScroll(scrollX, -scrollX, duration);
    }

    @Override
    public Horizontal.Checker checkXY(int x, int y) {
        this.mChecker.x = x;
        this.mChecker.y = y;
        this.mChecker.shouldResetSwipe = false;
        if (this.mChecker.x == 0) {
            this.mChecker.shouldResetSwipe = true;
        }
        if (this.mChecker.x >= 0) {
            this.mChecker.x = 0;
        }
        if (this.mChecker.x <= -this.getMenuView().getMenuTotalWidth()) {
            this.mChecker.x = -this.getMenuView().getMenuTotalWidth();
        }
        return this.mChecker;
    }

    @Override
    public boolean isClickOnContentView(int contentViewWidth, float x) {
        Log.d((String)TAG, (String)("isClickOnContentView: contentViewWidth = " + contentViewWidth + " x = " + x));
        return x < (float)contentViewWidth;
    }

    @Override
    int getClickMenuItemIndex(int measuredWidth, float rawX) {
        int menuItemCount = this.getMenuItemCount();
        if (menuItemCount <= 0 || rawX < (float)(measuredWidth - this.getMenuWidth())) {
            return -1;
        }
        int menuWidth = this.getMenuWidth();
        float dis = rawX - (float)(measuredWidth - menuWidth);
        return (int)dis / (menuWidth / menuItemCount);
    }
}

