/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.swipmenu;

import com.transsion.widgetslib.view.swipmenu.Horizontal;
import com.transsion.widgetslib.view.swipmenu.OverScroller;
import com.transsion.widgetslib.view.swipmenu.SwipeMenu;

class RightHorizontal
extends Horizontal {
    public RightHorizontal(SwipeMenu menuView) {
        super(-1, menuView);
    }

    @Override
    public boolean isMenuOpen(int scrollX) {
        int i = this.getMenuView().getMenuTotalWidth() * this.getDirection();
        return Math.abs(scrollX - i) <= 8 && i != 0;
    }

    @Override
    public boolean isMenuOpenNotEqual(int scrollX) {
        return scrollX > -this.getMenuView().getMenuTotalWidth() * this.getDirection();
    }

    @Override
    public void autoOpenMenu(OverScroller scroller, int scrollX, int duration) {
        scroller.startScroll(scrollX, -this.getMenuView().getMenuTotalWidth() + Math.abs(scrollX), duration);
    }

    @Override
    public void autoOpenMenuFling(OverScroller scroller, int start, int velocity, int min, int max, int over) {
        scroller.fling(start, velocity, min, max, over);
    }

    @Override
    public void autoCloseMenuFling(OverScroller scroller, int start, int velocity, int min, int max, int over) {
        scroller.fling(start, velocity, min, max, over);
    }

    @Override
    public void autoCloseMenu(OverScroller scroller, int scrollX, int duration) {
        scroller.startScroll(scrollX, -scrollX, duration);
    }

    @Override
    public Horizontal.Checker checkXY(int x, int y) {
        this.mChecker.x = x;
        this.mChecker.y = y;
        this.mChecker.shouldResetSwipe = false;
        if (this.mChecker.x == 0) {
            this.mChecker.shouldResetSwipe = true;
        }
        if (this.mChecker.x < 0) {
            this.mChecker.x = 0;
        }
        if (this.mChecker.x > this.getMenuView().getMenuTotalWidth()) {
            this.mChecker.x = this.getMenuView().getMenuTotalWidth();
        }
        return this.mChecker;
    }

    @Override
    public boolean isClickOnContentView(int contentViewWidth, float x) {
        return x > (float)this.getMenuView().getMenuTotalWidth();
    }

    @Override
    int getClickMenuItemIndex(int measuredWidth, float rawX) {
        int menuItemCount = this.getMenuItemCount();
        if (menuItemCount <= 0 || rawX > (float)this.getMenuWidth()) {
            return -1;
        }
        int menuWidth = this.getMenuWidth();
        return (int)Math.abs(rawX) / (menuWidth / menuItemCount);
    }
}

