/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.shadow;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.FrameLayout;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;

public class ShadowLayout
extends FrameLayout {
    private Context mContext;
    private static final float DEFAULT_SHADOW_RADIUS = 10.0f;
    private static final float DEFAULT_SHADOW_DISTANCE = 3.3f;
    public static final int DEFAULT_SHADOW_COLOR = -2138535800;
    private static final float MIN_RADIUS = 0.1f;
    private final Paint mPaint = new Paint(1);
    private int mShadowColor;
    private float mShadowRadius;
    private float mShadowDistance;
    private Drawable mShadowBgDrawable;
    private Bitmap mShadowBg;

    public ShadowLayout(Context context) {
        this(context, null);
    }

    public ShadowLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShadowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.setWillNotDraw(false);
        this.setLayerType(2, this.mPaint);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShadowLayout);
        try {
            float defaultRadius = TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            this.setShadowRadius(typedArray.getDimension(R.styleable.ShadowLayout_os_shadow_radius, defaultRadius));
            float defaultDistance = TypedValue.applyDimension((int)1, (float)3.3f, (DisplayMetrics)this.getResources().getDisplayMetrics());
            this.setShadowDistance(typedArray.getDimension(R.styleable.ShadowLayout_os_shadow_distance, defaultDistance));
            this.mShadowBgDrawable = context.getDrawable(R.drawable.img_shadow);
            this.setShadowColor(typedArray.getColor(R.styleable.ShadowLayout_os_shadow_color, -2138535800));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            typedArray.recycle();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mShadowBg != null) {
            this.mShadowBg.recycle();
            this.mShadowBg = null;
            this.mShadowBgDrawable = null;
        }
    }

    public float getShadowDistance() {
        return this.mShadowDistance;
    }

    public void setShadowDistance(float shadowDistance) {
        this.mShadowDistance = shadowDistance;
        this.resetShadow();
    }

    public float getShadowRadius() {
        return this.mShadowRadius;
    }

    public void setShadowRadius(float shadowRadius) {
        this.mShadowRadius = Math.max(0.1f, shadowRadius);
        if (this.isInEditMode()) {
            return;
        }
        this.resetShadow();
    }

    public int getShadowColor() {
        return this.mShadowColor;
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowColor = shadowColor;
        this.mShadowBgDrawable.setTint(this.mShadowColor);
        if (this.mShadowBg != null) {
            this.mShadowBg.recycle();
        }
        this.mShadowBg = Utils.compressBitmap(this.mContext, this.mShadowBgDrawable, (int)((this.mShadowDistance + this.mShadowRadius) * 2.0f + (float)this.mContext.getResources().getDimensionPixelSize(R.dimen.os_fab_default_size)));
        this.resetShadow();
    }

    private void resetShadow() {
        int padding = (int)(this.mShadowDistance + this.mShadowRadius);
        this.setPadding(padding, padding, padding, padding);
        this.requestLayout();
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mShadowBg != null && !this.mShadowBg.isRecycled()) {
            canvas.drawBitmap(this.mShadowBg, 0.0f, 0.0f, this.mPaint);
        }
        super.dispatchDraw(canvas);
    }
}

