/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.shadow;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FloatValueHolder;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.anim.OSSpringPressSealAnimation;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.widget.shadow.ShadowLayout;

public class SpringFloatingOvalButton
extends FrameLayout {
    private ShadowLayout mShadowLayout;
    private ImageView mImgView;
    private float mDefaultImageSize;
    private OSSpringPressSealAnimation.OnSpringClickListner mClickListener;
    private OSSpringPressSealAnimation.OnAnimationEndListener mOnAnimationEndListener;
    private OSSpringPressSealAnimation.OnAnimationUpdateListener mOnAnimationUpdateListener;
    private View.OnTouchListener mOnTouchListener;

    public SpringFloatingOvalButton(Context context) {
        this(context, null);
    }

    public SpringFloatingOvalButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setClickable(true);
        this.mShadowLayout = new ShadowLayout(context, attrs);
        this.mImgView = new ImageView(context, attrs);
        this.mShadowLayout.addView((View)this.mImgView);
        this.addView((View)this.mShadowLayout);
        this.mDefaultImageSize = context.getResources().getDimensionPixelSize(R.dimen.os_fab_default_image_size);
        float defaultImageBackgroundSize = context.getResources().getDimensionPixelSize(R.dimen.os_fab_default_size);
        int[] defaultAttrs = new int[]{R.attr.os_platform_basic_color, R.attr.os_fab_bg_pressed_color, R.attr.os_fab_shadow_color};
        TypedArray typedArray = context.obtainStyledAttributes(defaultAttrs);
        int defaultBackgroundColor = typedArray.getColor(0, context.getColor(R.color.os_platform_basic_color_hios));
        int defaultBackgroundPressedColor = typedArray.getColor(1, context.getColor(R.color.os_fab_bg_pressed_color_hios));
        int defaultShadowColor = typedArray.getColor(2, context.getColor(R.color.os_fab_shadow_color_hios));
        typedArray.recycle();
        if (Utils.getOsType().equals(Utils.mOsType[1])) {
            defaultShadowColor = 0;
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FloatingOvalButton);
        float imageWidth = ta.getDimension(R.styleable.FloatingOvalButton_float_image_width, defaultImageBackgroundSize);
        float imageHeight = ta.getDimension(R.styleable.FloatingOvalButton_float_image_height, defaultImageBackgroundSize);
        Drawable imageDrawable = ta.getDrawable(R.styleable.FloatingOvalButton_float_image_src);
        int backgroundColor = ta.getColor(R.styleable.FloatingOvalButton_float_image_background_color, defaultBackgroundColor);
        int backgroundPressedColor = ta.getColor(R.styleable.FloatingOvalButton_float_image_background_pressed_color, defaultBackgroundPressedColor);
        int shadowColor = ta.getColor(R.styleable.FloatingOvalButton_float_image_shadow_color, defaultShadowColor);
        ta.recycle();
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mImgView.getLayoutParams();
        lp.width = (int)imageWidth;
        lp.height = (int)imageHeight;
        this.mImgView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.mImgView.setImageDrawable(imageDrawable);
        this.setImageBackgroundColor(backgroundColor, backgroundPressedColor);
        this.setShadowColor(shadowColor);
        this.setImagePadding(this.mDefaultImageSize);
        new OSSpringPressSealAnimation.Builder().startValue(1.0f).finalValue(0.8f).floatVlaueHolder(new FloatValueHolder()).startStiffness(350.0f).endStiffness(250.0f).dampingRatio(1.2f).view((View)this.mShadowLayout).setOnClickListener(new OSSpringPressSealAnimation.OnSpringClickListner(){

            @Override
            public void onClick(View view, boolean isDown) {
                if (SpringFloatingOvalButton.this.mClickListener != null) {
                    SpringFloatingOvalButton.this.mClickListener.onClick(view, isDown);
                }
            }
        }).setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (SpringFloatingOvalButton.this.mOnTouchListener != null) {
                    SpringFloatingOvalButton.this.mOnTouchListener.onTouch(v, event);
                }
                return false;
            }
        }).addOnAnimationEndListener(new OSSpringPressSealAnimation.OnAnimationEndListener(){

            @Override
            public void onAnimationEnd(boolean isDownAnimation, DynamicAnimation animation, boolean canceled, boolean regret, float value, float velocity) {
                if (SpringFloatingOvalButton.this.mOnAnimationEndListener != null) {
                    SpringFloatingOvalButton.this.mOnAnimationEndListener.onAnimationEnd(isDownAnimation, animation, canceled, regret, value, velocity);
                }
            }
        }).addOnAnimationUpdateListener(new OSSpringPressSealAnimation.OnAnimationUpdateListener(){

            @Override
            public void onAnimationUpdate(boolean isDownAnimation, DynamicAnimation animation, float value, float velocity) {
                if (SpringFloatingOvalButton.this.mOnAnimationUpdateListener != null) {
                    SpringFloatingOvalButton.this.mOnAnimationUpdateListener.onAnimationUpdate(isDownAnimation, animation, value, velocity);
                }
            }
        }).build();
    }

    public void setOnTouchListener(View.OnTouchListener onTouchListener) {
        this.mOnTouchListener = onTouchListener;
    }

    public void setOnClickListener(OSSpringPressSealAnimation.OnSpringClickListner clickListener) {
        this.mClickListener = clickListener;
    }

    public ImageView getImage() {
        return this.mImgView;
    }

    public ShadowLayout getShadowLayout() {
        return this.mShadowLayout;
    }

    public void setImageDrawable(Drawable drawable2) {
        this.mImgView.setImageDrawable(drawable2);
    }

    public void setImageResource(int resId) {
        this.mImgView.setImageResource(resId);
    }

    public void setImageBackground(Drawable drawable2) {
        this.mImgView.setBackground(drawable2);
    }

    public void setImageBackgroundColor(int normalColor, int pressedColor) {
        Drawable backgroundDrawable = this.getContext().getDrawable(R.drawable.os_floating_ova_btn_bg);
        int[][] states = new int[][]{{16842919}, new int[0]};
        int[] colors = new int[]{pressedColor, normalColor};
        ColorStateList colorList = new ColorStateList((int[][])states, colors);
        backgroundDrawable.setTintList(colorList);
        this.setImageBackground(backgroundDrawable);
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowLayout.setShadowColor(shadowColor);
    }

    public void setImageSize(int width, int height) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mImgView.getLayoutParams();
        lp.width = width;
        lp.height = height;
        this.mImgView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.setImagePadding(this.mDefaultImageSize);
    }

    public void setImagePadding(float size) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mImgView.getLayoutParams();
        int paddingLeftRight = (int)(((float)lp.width - size) / 2.0f);
        int paddingTopBottom = (int)(((float)lp.height - size) / 2.0f);
        this.mImgView.setPadding(paddingLeftRight, paddingTopBottom, paddingLeftRight, paddingTopBottom);
    }

    public void setVisibility(int visibility) {
        switch (visibility) {
            case 0: {
                this.mShadowLayout.setVisibility(0);
                this.mImgView.setVisibility(0);
                break;
            }
            case 4: {
                this.mShadowLayout.setVisibility(4);
                this.mImgView.setVisibility(4);
                break;
            }
            case 8: {
                this.mShadowLayout.setVisibility(8);
                this.mImgView.setVisibility(8);
            }
        }
        super.setVisibility(visibility);
    }

    public void setOnAnimationEndListener(OSSpringPressSealAnimation.OnAnimationEndListener onAnimationEndListener) {
        this.mOnAnimationEndListener = onAnimationEndListener;
    }

    public void setOnAnimationUpdateListener(OSSpringPressSealAnimation.OnAnimationUpdateListener onAnimationUpdateListener) {
        this.mOnAnimationUpdateListener = onAnimationUpdateListener;
    }
}

