/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.transsion.effectengine.bounceeffect.IOverScrollDecor;
import com.transsion.effectengine.bounceeffect.IOverScrollListener;
import com.transsion.effectengine.bounceeffect.OverScrollDecorHelper;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.adapter.RecyclerAdapter;
import com.transsion.widgetslib.dialog.PromptParams;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.view.damping.DampingLayout;
import com.transsion.widgetslib.view.damping.OSScrollbarLayout;
import com.transsion.widgetslib.widget.timepicker.OSDateTimePicker;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PromptController {
    private final Context mContext;
    private final DialogInterface mDialogInterface;
    private final Window mWindow;
    private final LayoutInflater mInflater;
    private final Handler mHandler;
    private final FrameLayout mView;
    private final RelativeLayout mContainer;
    private final LinearLayout mBtnLayout;
    private LinearLayout mTitleView;
    private DampingLayout mScrollMessageView;
    private FrameLayout mFrameContainer;
    private View mListView;
    private CheckedTextView mCheckedView;
    private ContentAdapter mContentAdapter;
    public int mCheckedItem = -1;
    public boolean[] mCheckedItems;
    private boolean mIsButtonVertical = false;
    private boolean mIsAlert;
    private boolean mHasPositiveButton;
    private boolean mPositiveButtonEnable = true;
    private Button mButtonPositive;
    private CharSequence mButtonPositiveText;
    private Message mButtonPositiveMessage;
    private boolean mHasNegativeButton;
    private Button mButtonNegative;
    private CharSequence mButtonNegativeText;
    private Message mButtonNegativeMessage;
    private boolean mHasNeutralButton;
    private Button mButtonNeutral;
    private CharSequence mButtonNeutralText;
    private Message mButtonNeutralMessage;
    private Drawable mIcon;
    private boolean mAutoDismiss = true;
    private boolean mIsInputDialog = false;
    private boolean mIsAppDialogFragment = false;
    private int mNoBtnBottomInsets;
    private int mFrameContainerTrueHeight;
    private final View.OnClickListener mButtonListener = new View.OnClickListener(){

        public void onClick(View v) {
            Object m = v == PromptController.this.mButtonPositive && PromptController.this.mButtonPositiveMessage != null ? Message.obtain((Message)PromptController.this.mButtonPositiveMessage) : (v == PromptController.this.mButtonNegative && PromptController.this.mButtonNegativeMessage != null ? Message.obtain((Message)PromptController.this.mButtonNegativeMessage) : (v == PromptController.this.mButtonNeutral && PromptController.this.mButtonNeutralMessage != null ? Message.obtain((Message)PromptController.this.mButtonNeutralMessage) : null));
            if (m != null) {
                m.sendToTarget();
            }
            if (PromptController.this.mAutoDismiss) {
                PromptController.this.mHandler.obtainMessage(1, (Object)PromptController.this.mDialogInterface).sendToTarget();
            }
        }
    };

    public PromptController(Context context, DialogInterface di, Window window) {
        this.mContext = context;
        this.mDialogInterface = di;
        this.mWindow = window;
        this.mHandler = new ButtonHandler(di);
        this.mInflater = LayoutInflater.from((Context)context);
        window.requestFeature(1);
        window.setGravity(80);
        this.mView = (FrameLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_container, null);
        this.mView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                return true;
            }
        });
        this.mContainer = (RelativeLayout)this.mView.findViewById(R.id.mContainer);
        this.mBtnLayout = (LinearLayout)this.mView.findViewById(R.id.btnLayout);
    }

    public void installContent() {
        this.mWindow.setContentView((View)this.mView);
        this.mWindow.setWindowAnimations(R.style.OsInputDialogAnimStyle);
        this.setupView();
        if (this.mIsInputDialog || this.mContainer != null && PromptController.canTextInput((View)this.mContainer)) {
            Utils.setInputDialogWindowBackGround(this.mWindow.getContext(), this.mWindow);
        }
    }

    public void setTitleView(CharSequence title) {
        if (!TextUtils.isEmpty((CharSequence)title)) {
            if (this.mTitleView == null) {
                this.mTitleView = (LinearLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_title, (ViewGroup)this.mContainer, false);
            }
            TextView textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title);
            textTitle.setText(title);
        }
    }

    public void setTopTitle(CharSequence topTitle) {
        if (!TextUtils.isEmpty((CharSequence)topTitle)) {
            if (this.mTitleView == null) {
                this.mTitleView = (LinearLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_title, (ViewGroup)this.mContainer, false);
            }
            TextView topTitleView = (TextView)this.mTitleView.findViewById(R.id.text_top_title);
            topTitleView.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.os_text_tertiary_color));
            topTitleView.setVisibility(0);
            topTitleView.setText(topTitle);
        }
    }

    public void setMessageView(CharSequence message) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            this.mScrollMessageView = (DampingLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_message, (ViewGroup)this.mContainer, false);
            TextView messageView = (TextView)this.mScrollMessageView.findViewById(R.id.text_message);
            messageView.setText(message);
        }
    }

    public void setSingleChecked(CharSequence checkedText, boolean isChecked, final DialogInterface.OnClickListener listener) {
        if (!TextUtils.isEmpty((CharSequence)checkedText)) {
            this.setView(R.layout.os_prompt_dialog_singlechecked, null);
            if (this.mFrameContainer != null) {
                this.mCheckedView = (CheckedTextView)this.mFrameContainer.findViewById(R.id.text_choice);
                if (this.mCheckedView != null) {
                    this.mCheckedView.setText(checkedText);
                    this.mCheckedView.setChecked(isChecked);
                    this.mCheckedView.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            PromptController.this.mCheckedView.setChecked(!PromptController.this.mCheckedView.isChecked());
                            if (PromptController.this.mButtonPositive != null) {
                                PromptController.this.mButtonPositive.setEnabled(PromptController.this.mCheckedView.isChecked());
                            }
                            if (listener != null) {
                                listener.onClick(PromptController.this.mDialogInterface, 0);
                            }
                        }
                    });
                }
            }
        }
    }

    public CheckedTextView getCheckedView() {
        return this.mCheckedView;
    }

    public void setView(int resId, View view) {
        if (resId != 0 || view != null) {
            this.mFrameContainer = (FrameLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_view, (ViewGroup)this.mContainer, false);
            if (resId != 0) {
                this.mFrameContainer.addView(this.mInflater.inflate(resId, (ViewGroup)this.mFrameContainer, false));
            } else {
                this.mFrameContainer.addView(view);
            }
            this.mFrameContainerTrueHeight = this.mFrameContainer.getMeasuredHeight();
            if (this.mFrameContainerTrueHeight == 0) {
                this.mFrameContainer.measure(0, 0);
                this.mFrameContainerTrueHeight = this.mFrameContainer.getMeasuredHeight();
            }
        }
    }

    public void setButton(int whichButton, CharSequence text, DialogInterface.OnClickListener listener, Message msg) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        if (msg == null && listener != null) {
            msg = this.mHandler.obtainMessage(whichButton, (Object)listener);
        }
        switch (whichButton) {
            case -1: {
                this.mButtonPositiveText = text;
                this.mButtonPositiveMessage = msg;
                this.mHasPositiveButton = true;
                break;
            }
            case -2: {
                this.mButtonNegativeText = text;
                this.mButtonNegativeMessage = msg;
                this.mHasNegativeButton = true;
                break;
            }
            case -3: {
                this.mButtonNeutralText = text;
                this.mButtonNeutralMessage = msg;
                this.mHasNeutralButton = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Button does not exist");
            }
        }
    }

    public void setPositiveButtonEnable(boolean positiveButtonEnable) {
        this.mPositiveButtonEnable = positiveButtonEnable;
    }

    public void setList(CharSequence[] items, DialogInterface.OnClickListener listener) {
        List<CharSequence> dataList = Arrays.asList(items);
        ContentAdapter adapter = new ContentAdapter(dataList);
        this.setList(adapter, listener);
    }

    public void setList(RecyclerView.Adapter<?> adapter, final DialogInterface.OnClickListener listener) {
        this.mListView = this.generateListView(adapter, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (listener != null) {
                    listener.onClick(PromptController.this.mDialogInterface, position);
                    PromptController.this.mDialogInterface.dismiss();
                }
            }
        });
    }

    public void setList(Cursor cursor, String labelColumn, DialogInterface.OnClickListener listener) {
        try {
            ArrayList<CharSequence> dataList = new ArrayList<CharSequence>();
            while (cursor.moveToNext()) {
                int columnIndex = cursor.getColumnIndex(labelColumn);
                dataList.add(cursor.getString(columnIndex));
            }
            ContentAdapter adapter = new ContentAdapter((List<CharSequence>)dataList);
            this.setList(adapter, listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSingleChoiceList(CharSequence[] items, DialogInterface.OnClickListener listener) {
        List<CharSequence> dataList = Arrays.asList(items);
        ContentAdapter adapter = new ContentAdapter(dataList, 1);
        this.setSingleChoiceList(adapter, listener);
    }

    public void setSingleChoiceList(RecyclerView.Adapter<?> adapter, final DialogInterface.OnClickListener listener) {
        this.mListView = this.generateListView(adapter, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (listener != null) {
                    listener.onClick(PromptController.this.mDialogInterface, position);
                }
                if (PromptController.this.mContentAdapter != null) {
                    PromptController.this.mContentAdapter.setSelectedPst(position);
                }
                PromptController.this.setListPositiveButtonStatus();
            }
        });
    }

    public void setSingleChoiceList(Cursor cursor, String labelColumn, DialogInterface.OnClickListener listener) {
        try {
            ArrayList<CharSequence> dataList = new ArrayList<CharSequence>();
            while (cursor.moveToNext()) {
                int columnIndex = cursor.getColumnIndex(labelColumn);
                dataList.add(cursor.getString(columnIndex));
            }
            ContentAdapter adapter = new ContentAdapter(dataList, 1);
            this.setSingleChoiceList(adapter, listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMultiChoiceList(CharSequence[] items, boolean[] checkedItems, DialogInterface.OnMultiChoiceClickListener listener) {
        this.dealCheckItems(items, checkedItems);
        List<CharSequence> dataList = Arrays.asList(items);
        ContentAdapter adapter = new ContentAdapter(dataList, 2);
        this.setMultiChoiceList(adapter, listener);
    }

    private void dealCheckItems(CharSequence[] items, boolean[] checkedItems) {
        if (checkedItems == null) {
            this.mCheckedItems = new boolean[items.length];
            return;
        }
        if (items.length == checkedItems.length) {
            this.mCheckedItems = checkedItems;
        } else {
            this.mCheckedItems = new boolean[items.length];
            for (int i = 0; i < items.length; ++i) {
                this.mCheckedItems[i] = i < checkedItems.length && checkedItems[i];
            }
        }
    }

    public void setMultiChoiceList(Cursor cursor, String labelColumn, String isCheckedColumn, DialogInterface.OnMultiChoiceClickListener listener) {
        try {
            ArrayList<CharSequence> dataList = new ArrayList<CharSequence>();
            while (cursor.moveToNext()) {
                int columnIndex = cursor.getColumnIndex(labelColumn);
                dataList.add(cursor.getString(columnIndex));
            }
            ContentAdapter adapter = new ContentAdapter(dataList, 2);
            this.setMultiChoiceList(adapter, listener);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setMultiChoiceList(RecyclerView.Adapter<?> adapter, final DialogInterface.OnMultiChoiceClickListener listener) {
        this.mListView = this.generateListView(adapter, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (listener != null && PromptController.this.mListView != null && PromptController.this.mContentAdapter != null) {
                    if (PromptController.this.mCheckedItems != null) {
                        PromptController.this.mContentAdapter.setSelectedPst(position);
                    }
                    PromptController.this.setListPositiveButtonStatus();
                    listener.onClick(PromptController.this.mDialogInterface, position, PromptController.this.mContentAdapter.isItemChecked(position));
                }
            }
        });
    }

    private void setListPositiveButtonStatus() {
        if (!this.mPositiveButtonEnable && this.mButtonPositive != null && this.mListView != null) {
            if (this.mContentAdapter != null) {
                this.mButtonPositive.setEnabled(this.mContentAdapter.getCheckedItemCount() > 0);
            } else if (this.mListView instanceof ListView) {
                this.mButtonPositive.setEnabled(((ListView)this.mListView).getCheckedItemCount() > 0);
            }
        }
    }

    private RecyclerView generateListView(RecyclerView.Adapter<?> adapter, AdapterView.OnItemClickListener l) {
        View layout2 = this.mInflater.inflate(R.layout.os_prompt_dialog_list, (ViewGroup)this.mContainer, false);
        RecyclerView listView = (RecyclerView)layout2.findViewById(R.id.os_damp_list_view);
        listView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.mContext, 1, false));
        listView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        if (adapter instanceof RecyclerAdapter) {
            ((RecyclerAdapter)adapter).setOnItemClickListener(l);
            if (adapter instanceof ContentAdapter) {
                this.mContentAdapter = (ContentAdapter)adapter;
                this.mContentAdapter.setWeakReference(this);
            }
        }
        listView.setAdapter(adapter);
        IOverScrollDecor overScrollDecor = OverScrollDecorHelper.setUpOverScroll((RecyclerView)listView, (int)0, (boolean)false);
        View view = layout2.findViewById(R.id.os_damp_list_view_parent);
        if (view instanceof OSScrollbarLayout && overScrollDecor != null) {
            final OSScrollbarLayout scrollBarLayout = (OSScrollbarLayout)view;
            scrollBarLayout.setOverScrollView((View)listView);
            overScrollDecor.setOverScrollListener(new IOverScrollListener(){

                public void onOverScrollUpdated(float v) {
                    scrollBarLayout.onOverScrollUpdated(v);
                }
            });
        }
        return listView;
    }

    private View generateListView(ListAdapter adapter, AdapterView.OnItemClickListener l) {
        View layout2 = this.mInflater.inflate(R.layout.os_prompt_dialog_list_compat, (ViewGroup)this.mContainer, false);
        ListView listView = (ListView)layout2.findViewById(R.id.os_damp_list_view_compat);
        listView.setAdapter(adapter);
        listView.setOnItemClickListener(l);
        listView.setDivider(null);
        return listView;
    }

    public void setSingleChoiceList(ListAdapter adapter, final DialogInterface.OnClickListener listener) {
        this.mListView = this.generateListView(adapter, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (listener != null) {
                    listener.onClick(PromptController.this.mDialogInterface, position);
                }
                PromptController.this.setListPositiveButtonStatus();
            }
        });
        if (this.mListView instanceof ListView) {
            ((ListView)this.mListView).setChoiceMode(1);
        }
    }

    public void setList(ListAdapter adapter, final DialogInterface.OnClickListener listener) {
        this.mListView = this.generateListView(adapter, new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (listener != null) {
                    listener.onClick(PromptController.this.mDialogInterface, position);
                    PromptController.this.mDialogInterface.dismiss();
                }
            }
        });
    }

    public void onPrepareListView(PromptParams.OnPrepareListViewListener listener) {
        if (this.mListView instanceof ListView) {
            listener.onPrepareListView((ListView)this.mListView);
        }
    }

    public void setCheckedItem(int checkedItem) {
        this.mCheckedItem = checkedItem;
        if (this.mListView instanceof ListView) {
            ListView listView = (ListView)this.mListView;
            listView.setItemChecked(checkedItem, true);
            listView.setSelection(checkedItem);
        }
    }

    private void setupView() {
        TextView titleView;
        ViewGroup parent;
        boolean hasListView;
        this.mContainer.removeAllViews();
        this.mBtnLayout.removeAllViews();
        boolean hasTitle = this.mTitleView != null;
        boolean hasMessage = this.mScrollMessageView != null;
        boolean hasCustomView = this.mFrameContainer != null;
        boolean bl = hasListView = this.mListView != null;
        if (hasTitle) {
            this.mTitleView.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.os_altitude_secondary_color));
            this.mTitleView.setId(R.id.os_module_dialog_damping_layout_title);
        }
        if (hasMessage) {
            if (hasTitle) {
                this.mScrollMessageView.setPadding(0, (int)this.mContext.getResources().getDimension(R.dimen.os_dialog_message_padding_top), 0, 0);
            } else if (hasCustomView) {
                this.mScrollMessageView.setPadding(0, 0, 0, (int)this.mContext.getResources().getDimension(R.dimen.os_dialog_message_padding_top));
            } else {
                this.mScrollMessageView.setPadding(0, 0, 0, 0);
            }
            if (hasTitle) {
                this.mContainer.addView((View)this.mScrollMessageView, (ViewGroup.LayoutParams)this.getLayoutParamsContentLayout());
            } else {
                this.mContainer.addView((View)this.mScrollMessageView);
            }
        }
        if (hasListView && !hasMessage) {
            parent = (ViewGroup)this.mListView.getParent();
            if (hasTitle) {
                this.mContainer.addView((View)parent, (ViewGroup.LayoutParams)this.getLayoutParamsContentLayout());
            } else {
                this.mContainer.addView((View)parent);
            }
        }
        if (hasListView && hasTitle && (titleView = this.getTitleView()) != null) {
            titleView.setPaddingRelative((int)this.mContext.getResources().getDimension(R.dimen.os_dialog_padding_left_right), 0, (int)this.mContext.getResources().getDimension(R.dimen.os_dialog_title_padding_end), (int)this.mContext.getResources().getDimension(R.dimen.os_dialog_title_padding_bottom));
        }
        if (hasListView && !hasTitle) {
            this.mContainer.setPadding(0, 0, 0, 0);
        }
        if (hasCustomView) {
            TextView textTitle;
            RelativeLayout.LayoutParams lp;
            if (hasMessage) {
                lp = (RelativeLayout.LayoutParams)this.mScrollMessageView.getLayoutParams();
                lp.height = -2;
                this.mScrollMessageView.setLayoutParams((ViewGroup.LayoutParams)lp);
            } else if (hasListView) {
                if (this.mContainer.indexOfChild((View)((ViewGroup)this.mListView.getParent())) != -1) {
                    lp = (RelativeLayout.LayoutParams)this.mFrameContainer.getLayoutParams();
                    lp.height = -2;
                    lp.addRule(3, R.id.os_damp_list_view_parent);
                    this.mFrameContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
                }
            } else if (this.hasPickView((View)this.mFrameContainer) && this.mTitleView != null && (textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title)) != null) {
                textTitle.setTextSize(0, this.mContext.getResources().getDimension(R.dimen.os_body_font));
                int padding = this.mContext.getResources().getDimensionPixelSize(R.dimen.os_dialog_padding_left_right);
                textTitle.setPaddingRelative(padding, 0, (int)((float)padding / 1.5f), 0);
            }
            if (hasMessage) {
                this.mFrameContainer.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.os_altitude_secondary_color));
                this.mContainer.addView((View)this.mFrameContainer, (ViewGroup.LayoutParams)this.getLayoutParamsCustomLayout());
            } else if (hasListView) {
                parent = (ViewGroup)this.mListView.getParent();
                parent.post(new Runnable(){

                    @Override
                    public void run() {
                        if (parent.getHeight() < PromptController.this.mListView.getHeight() || PromptController.this.mFrameContainerTrueHeight > 0 && PromptController.this.mFrameContainer.getHeight() < PromptController.this.mFrameContainerTrueHeight) {
                            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)PromptController.this.mFrameContainer.getLayoutParams();
                            lp.removeRule(3);
                            lp.addRule(12);
                            PromptController.this.mFrameContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
                            RelativeLayout.LayoutParams lvp = (RelativeLayout.LayoutParams)parent.getLayoutParams();
                            lp.removeRule(3);
                            lvp.addRule(3, R.id.os_module_dialog_damping_layout_title);
                            lvp.addRule(2, R.id.os_module_dialog_custom_view);
                            parent.setLayoutParams((ViewGroup.LayoutParams)lvp);
                        }
                    }
                });
                this.mFrameContainer.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.os_altitude_secondary_color));
                this.mContainer.addView((View)this.mFrameContainer);
            } else {
                this.mContainer.addView((View)this.mFrameContainer, (ViewGroup.LayoutParams)this.getLayoutParamsContentLayout());
            }
        }
        if (hasTitle && this.mContainer.indexOfChild((View)this.mTitleView) == -1) {
            this.mContainer.addView((View)this.mTitleView, (ViewGroup.LayoutParams)this.getLayoutParamsTitleLayout());
        }
        this.setupButtons(hasCustomView);
    }

    private RelativeLayout.LayoutParams getLayoutParamsCustomLayout() {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(3, R.id.os_module_dialog_damping_layout_content);
        return layoutParams;
    }

    private RelativeLayout.LayoutParams getLayoutParamsContentLayout() {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(3, R.id.os_module_dialog_damping_layout_title);
        return layoutParams;
    }

    private RelativeLayout.LayoutParams getLayoutParamsTitleLayout() {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
        layoutParams.addRule(10);
        return layoutParams;
    }

    public int getNoBtnBottomInsets() {
        return this.mNoBtnBottomInsets;
    }

    public void setNoBtnBottomInsets(int mNoBtnBottomInsets) {
        this.mNoBtnBottomInsets = mNoBtnBottomInsets;
    }

    private void noButtonInsets() {
        ((FrameLayout.LayoutParams)this.mContainer.getLayoutParams()).setMargins(0, 0, 0, this.mNoBtnBottomInsets);
    }

    private boolean hasPickView(View view) {
        if (view.getVisibility() == 0 && view instanceof OSDateTimePicker) {
            return true;
        }
        if (!(view instanceof ViewGroup)) {
            return false;
        }
        ViewGroup vg = (ViewGroup)view;
        int i = vg.getChildCount();
        while (i > 0) {
            if ((view = vg.getChildAt(--i)).getVisibility() != 0 || !this.hasPickView(view)) continue;
            return true;
        }
        return false;
    }

    private void setupButtons(boolean hasCustomView) {
        if (!(this.mHasPositiveButton || this.mHasNegativeButton || this.mHasNeutralButton)) {
            this.noButtonInsets();
            return;
        }
        if (hasCustomView && PromptController.canTextInput((View)this.mFrameContainer)) {
            this.mIsButtonVertical = false;
        } else {
            this.mBtnLayout.addView(this.mInflater.inflate(R.layout.os_dialog_horizontal_divider, (ViewGroup)this.mBtnLayout, false));
            this.mWindow.setFlags(131072, 131072);
        }
        View buttonsView = this.mInflater.inflate(this.mIsButtonVertical ? R.layout.os_prompt_dialog_buttons_vertical : R.layout.os_prompt_dialog_buttons_horizontal, (ViewGroup)this.mBtnLayout, false);
        this.mButtonPositive = (Button)buttonsView.findViewById(R.id.btn_positive);
        if (this.mHasPositiveButton) {
            this.mButtonPositive.setText(this.mButtonPositiveText);
            this.mButtonPositive.setOnClickListener(this.mButtonListener);
            if (this.mCheckedView != null) {
                this.mButtonPositive.setEnabled(this.mCheckedView.isChecked());
            } else {
                this.mButtonPositive.setEnabled(this.mPositiveButtonEnable);
            }
            if (this.mIsAlert) {
                this.mButtonPositive.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.os_dialog_positive_btn_alert_color));
            }
        } else {
            this.mButtonPositive.setVisibility(8);
        }
        this.mButtonNegative = (Button)buttonsView.findViewById(R.id.btn_negative);
        if (this.mHasNegativeButton) {
            this.mButtonNegative.setText(this.mButtonNegativeText);
            this.mButtonNegative.setOnClickListener(this.mButtonListener);
        } else {
            this.mButtonNegative.setVisibility(8);
        }
        this.mButtonNeutral = (Button)buttonsView.findViewById(R.id.btn_neutral);
        if (this.mHasNeutralButton) {
            this.mButtonNeutral.setText(this.mButtonNeutralText);
            this.mButtonNeutral.setOnClickListener(this.mButtonListener);
        } else {
            this.mButtonNeutral.setVisibility(8);
        }
        this.mBtnLayout.addView(buttonsView);
        if (this.mContainer != null) {
            int btnHeight = (int)this.mContext.getResources().getDimension(R.dimen.os_dialog_button_height);
            if (this.mIsButtonVertical) {
                btnHeight = btnHeight * (this.mHasPositiveButton ? 1 : 0) + btnHeight * (this.mHasNegativeButton ? 1 : 0) + btnHeight * (this.mHasNeutralButton ? 1 : 0);
            }
            if (this.mIsInputDialog) {
                ((FrameLayout.LayoutParams)this.mContainer.getLayoutParams()).setMargins(0, 0, 0, (int)((float)btnHeight + this.mContext.getResources().getDimension(R.dimen.os_dialog_divider_margin_10)));
            } else {
                ((FrameLayout.LayoutParams)this.mContainer.getLayoutParams()).setMargins(0, 0, 0, btnHeight + (int)this.mContext.getResources().getDimension(this.mListView != null ? R.dimen.os_dialog_divider_margin_10 : R.dimen.os_dialog_divider_margin));
            }
        }
    }

    static boolean canTextInput(View v) {
        if (v.onCheckIsTextEditor()) {
            return true;
        }
        if (!(v instanceof ViewGroup)) {
            return false;
        }
        ViewGroup vg = (ViewGroup)v;
        int i = vg.getChildCount();
        while (i > 0) {
            if ((v = vg.getChildAt(--i)).getVisibility() != 0 || !PromptController.canTextInput(v)) continue;
            return true;
        }
        return false;
    }

    public Button getButton(int whichButton) {
        switch (whichButton) {
            case -1: {
                return this.mButtonPositive;
            }
            case -2: {
                return this.mButtonNegative;
            }
            case -3: {
                return this.mButtonNeutral;
            }
        }
        return null;
    }

    public TextView getTitleView() {
        TextView titleText = null;
        if (this.mTitleView != null) {
            titleText = (TextView)this.mTitleView.findViewById(R.id.text_title);
        }
        return titleText;
    }

    public View getListView() {
        return this.mListView;
    }

    public void setIsAlert(boolean isAlert) {
        this.mIsAlert = isAlert;
    }

    public void setTitle(CharSequence title) {
        if (this.mTitleView != null) {
            TextView textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title);
            textTitle.setText(title);
        } else {
            this.setTitleView(title);
        }
    }

    public void setTitleSingleLine() {
        if (this.mTitleView != null) {
            TextView textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title);
            textTitle.setSingleLine();
            textTitle.setEllipsize(TextUtils.TruncateAt.END);
        } else {
            this.mTitleView = (LinearLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_title, (ViewGroup)this.mContainer, false);
            TextView textTitle = (TextView)this.mTitleView.findViewById(R.id.text_title);
            textTitle.setSingleLine();
            textTitle.setEllipsize(TextUtils.TruncateAt.END);
        }
    }

    public void setIcon(Drawable icon) {
        if (this.mIcon != icon || icon != null) {
            if (this.mTitleView == null) {
                this.mTitleView = (LinearLayout)this.mInflater.inflate(R.layout.os_prompt_dialog_title, (ViewGroup)this.mContainer, false);
            }
            this.setIconContent(icon);
            this.mIcon = icon;
        }
    }

    private void setIconContent(Drawable icon) {
        ImageView iconImg = (ImageView)this.mTitleView.findViewById(R.id.iconImg);
        if (iconImg != null) {
            iconImg.setVisibility(0);
            iconImg.setImageDrawable(icon);
        }
    }

    public void setMessage(CharSequence message) {
        if (this.mScrollMessageView != null) {
            TextView messageView = (TextView)this.mScrollMessageView.findViewById(R.id.text_message);
            messageView.setText(message);
        } else {
            this.setMessageView(message);
        }
    }

    public void setIsInputDialog(boolean isInputDialog) {
        this.mIsInputDialog = isInputDialog;
    }

    public void setIsAppDialogFragment(boolean isAppDialogFragment) {
        this.mIsAppDialogFragment = isAppDialogFragment;
    }

    public boolean getIsAppDialogFragment() {
        return this.mIsAppDialogFragment;
    }

    public void setElegantTextHeight(boolean elegant) {
        TextView message;
        if (this.mScrollMessageView != null && (message = (TextView)this.mScrollMessageView.findViewById(R.id.text_message)) != null && elegant != message.getPaint().isElegantTextHeight()) {
            message.setElegantTextHeight(elegant);
        }
    }

    public void setAutoDismiss(boolean autoDismiss) {
        this.mAutoDismiss = autoDismiss;
    }

    public void setButtonVertical(boolean buttonVertical) {
        this.mIsButtonVertical = buttonVertical;
    }

    private static final class ContentHolder
    extends RecyclerAdapter.Holder {
        private final CheckedTextView mCheckedTextView;
        private final Context mContext;

        ContentHolder(ViewGroup viewGroup) {
            super(viewGroup, R.layout.os_prompt_dialog_list_item_compat);
            this.mCheckedTextView = (CheckedTextView)this.itemView.findViewById(R.id.text_list_item_compat);
            this.mContext = viewGroup.getContext();
        }

        public void setChoiceMode(int choiceMode) {
            Drawable drawable2 = null;
            TypedValue typedValue = new TypedValue();
            if (choiceMode == 1) {
                if (this.mContext.getTheme().resolveAttribute(16843289, typedValue, true)) {
                    drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)typedValue.resourceId);
                }
            } else if (choiceMode == 2 && this.mContext.getTheme().resolveAttribute(16843290, typedValue, true)) {
                drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)typedValue.resourceId);
            }
            if (drawable2 != null) {
                this.mCheckedTextView.setCompoundDrawablesRelativeWithIntrinsicBounds(null, null, drawable2, null);
            }
        }
    }

    private static final class ContentAdapter
    extends RecyclerAdapter<CharSequence, ContentHolder> {
        private WeakReference<PromptController> mWeakReference;
        private final int mChoiceMode;

        protected ContentAdapter(List<CharSequence> dataList) {
            this(dataList, 0);
        }

        protected ContentAdapter(List<CharSequence> dataList, int choiceMode) {
            super(dataList);
            this.mChoiceMode = choiceMode;
        }

        public void setWeakReference(PromptController promptController) {
            this.mWeakReference = new WeakReference<PromptController>(promptController);
        }

        @Override
        public void onBindViewHolder(@NonNull ContentHolder holder, int pst, CharSequence data) {
            holder.mCheckedTextView.setText((CharSequence)this.mDataList.get(pst));
            if (this.mWeakReference == null || this.mWeakReference.get() == null) {
                return;
            }
            if (this.mChoiceMode == 1) {
                int checkedItem = ((PromptController)this.mWeakReference.get()).mCheckedItem;
                holder.mCheckedTextView.setChecked(checkedItem == pst);
            } else if (this.mChoiceMode == 2) {
                boolean[] checkedItems = ((PromptController)this.mWeakReference.get()).mCheckedItems;
                holder.mCheckedTextView.setChecked(checkedItems != null && checkedItems[pst]);
            }
        }

        @NonNull
        public ContentHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
            ContentHolder contentHolder = new ContentHolder(viewGroup);
            contentHolder.setSetOnClickListener(this.mOnItemClickListener != null);
            contentHolder.setChoiceMode(this.mChoiceMode);
            return contentHolder;
        }

        public void setSelectedPst(int pst) {
            if (this.mWeakReference == null || this.mWeakReference.get() == null || pst < 0) {
                return;
            }
            int itemCount = this.getItemCount();
            if (this.mChoiceMode == 1) {
                int checkedItem = ((PromptController)this.mWeakReference.get()).mCheckedItem;
                if (checkedItem >= 0 && checkedItem < itemCount) {
                    this.notifyItemChanged(checkedItem);
                }
                if (pst < itemCount) {
                    ((PromptController)this.mWeakReference.get()).mCheckedItem = pst;
                    this.notifyItemChanged(((PromptController)this.mWeakReference.get()).mCheckedItem);
                }
            } else if (this.mChoiceMode == 2) {
                boolean[] isCheckedItems = ((PromptController)this.mWeakReference.get()).mCheckedItems;
                if (isCheckedItems == null || isCheckedItems.length > itemCount) {
                    return;
                }
                isCheckedItems[pst] = !isCheckedItems[pst];
                this.notifyItemChanged(pst);
            }
        }

        public boolean isItemChecked(int pst) {
            if (this.mWeakReference == null || this.mWeakReference.get() == null || ((PromptController)this.mWeakReference.get()).mCheckedItems == null) {
                return false;
            }
            boolean[] isCheckedItems = ((PromptController)this.mWeakReference.get()).mCheckedItems;
            return pst >= 0 && pst < isCheckedItems.length && isCheckedItems[pst];
        }

        public int getCheckedItemCount() {
            int count = 0;
            if (this.mWeakReference == null || this.mWeakReference.get() == null || ((PromptController)this.mWeakReference.get()).mCheckedItems == null) {
                return count;
            }
            for (boolean checkedItem : ((PromptController)this.mWeakReference.get()).mCheckedItems) {
                if (!checkedItem) continue;
                ++count;
            }
            return count;
        }
    }

    private static final class ButtonHandler
    extends Handler {
        private static final int MSG_DISMISS_DIALOG = 1;
        private final WeakReference<DialogInterface> mDialog;

        ButtonHandler(DialogInterface dialog) {
            this.mDialog = new WeakReference<DialogInterface>(dialog);
        }

        public void handleMessage(Message msg) {
            try {
                switch (msg.what) {
                    case -3: 
                    case -2: 
                    case -1: {
                        ((DialogInterface.OnClickListener)msg.obj).onClick((DialogInterface)this.mDialog.get(), msg.what);
                        break;
                    }
                    case 1: {
                        ((DialogInterface)msg.obj).dismiss();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

