/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.preference;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.preference.Preference;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.dialog.PromptDialog;
import com.transsion.widgetslib.util.Utils;
import java.lang.reflect.Method;

public abstract class OSDialogPreference
extends Preference
implements DialogInterface.OnClickListener,
DialogInterface.OnDismissListener,
PreferenceManager.OnActivityDestroyListener {
    private PromptDialog.Builder mBuilder;
    private CharSequence mDialogTitle;
    private CharSequence mDialogMessage;
    private Drawable mDialogIcon;
    private CharSequence mPositiveButtonText;
    private CharSequence mNegativeButtonText;
    private int mDialogLayoutResId;
    private boolean mCancelable = true;
    private boolean mCanceledOnTouchOutside = true;
    private Dialog mDialog;
    private int mWhichButtonClicked;
    private int mTitleRootPaddingStart;
    private int mTitleRootPaddingEnd;
    private final Runnable mDismissRunnable = new Runnable(){

        @Override
        public void run() {
            if (OSDialogPreference.this.mDialog != null) {
                OSDialogPreference.this.mDialog.dismiss();
            }
        }
    };

    @RequiresApi(api=21)
    public OSDialogPreference(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OsDialogPreference, defStyleAttr, defStyleRes);
        this.mDialogTitle = a.getString(R.styleable.OsDialogPreference_dialogTitle);
        if (this.mDialogTitle == null) {
            this.mDialogTitle = this.getTitle();
        }
        this.mDialogMessage = a.getString(R.styleable.OsDialogPreference_dialogMessage);
        this.mDialogIcon = a.getDrawable(R.styleable.OsDialogPreference_dialogIcon);
        this.mPositiveButtonText = a.getString(R.styleable.OsDialogPreference_positiveButtonText);
        this.mNegativeButtonText = a.getString(R.styleable.OsDialogPreference_negativeButtonText);
        this.mDialogLayoutResId = a.getResourceId(R.styleable.OsDialogPreference_dialogLayout, this.mDialogLayoutResId);
        a.recycle();
        int[] typedAttr = new int[]{16843709, 16843710};
        TypedArray typedArray = context.obtainStyledAttributes(typedAttr);
        this.mTitleRootPaddingStart = typedArray.getDimensionPixelSize(0, context.getResources().getDimensionPixelSize(R.dimen.os_no_curve_content_padding));
        this.mTitleRootPaddingEnd = typedArray.getDimensionPixelSize(1, context.getResources().getDimensionPixelSize(R.dimen.os_no_curve_content_padding));
        typedArray.recycle();
    }

    @RequiresApi(api=21)
    public OSDialogPreference(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    protected void onBindView(View view) {
        LinearLayout container;
        super.onBindView(view);
        if (view instanceof LinearLayout && (container = (LinearLayout)view).getChildCount() >= 2 && (view = container.getChildAt(1)) instanceof RelativeLayout) {
            LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)view.getLayoutParams();
            params.setMarginStart(0);
            params.setMarginEnd(0);
            view.setLayoutParams((ViewGroup.LayoutParams)params);
            container.setPadding(this.mTitleRootPaddingStart, container.getPaddingTop(), this.mTitleRootPaddingEnd, container.getPaddingBottom());
        }
    }

    @RequiresApi(api=21)
    public OSDialogPreference(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.OsDialogPreferenceStyle);
    }

    @RequiresApi(api=21)
    public OSDialogPreference(Context context) {
        this(context, null);
    }

    public void setDialogTitle(CharSequence dialogTitle) {
        this.mDialogTitle = dialogTitle;
    }

    public void setDialogTitle(int dialogTitleResId) {
        this.setDialogTitle(this.getContext().getString(dialogTitleResId));
    }

    public CharSequence getDialogTitle() {
        return this.mDialogTitle;
    }

    public void setDialogMessage(CharSequence dialogMessage) {
        this.mDialogMessage = dialogMessage;
    }

    public void setDialogMessage(int dialogMessageResId) {
        this.setDialogMessage(this.getContext().getString(dialogMessageResId));
    }

    public CharSequence getDialogMessage() {
        return this.mDialogMessage;
    }

    public void setDialogIcon(Drawable dialogIcon) {
        this.mDialogIcon = dialogIcon;
    }

    public void setDialogIcon(@DrawableRes int dialogIconRes) {
        this.mDialogIcon = ContextCompat.getDrawable((Context)this.getContext(), (int)dialogIconRes);
    }

    public Drawable getDialogIcon() {
        return this.mDialogIcon;
    }

    public void setPositiveButtonText(CharSequence positiveButtonText) {
        this.mPositiveButtonText = positiveButtonText;
    }

    public void setPositiveButtonText(@StringRes int positiveButtonTextResId) {
        this.setPositiveButtonText(this.getContext().getString(positiveButtonTextResId));
    }

    public CharSequence getPositiveButtonText() {
        return this.mPositiveButtonText;
    }

    public void setNegativeButtonText(CharSequence negativeButtonText) {
        this.mNegativeButtonText = negativeButtonText;
    }

    public void setNegativeButtonText(@StringRes int negativeButtonTextResId) {
        this.setNegativeButtonText(this.getContext().getString(negativeButtonTextResId));
    }

    public CharSequence getNegativeButtonText() {
        return this.mNegativeButtonText;
    }

    public void setDialogLayoutResource(int dialogLayoutResId) {
        this.mDialogLayoutResId = dialogLayoutResId;
    }

    public int getDialogLayoutResource() {
        return this.mDialogLayoutResId;
    }

    protected void onPrepareDialogBuilder(PromptDialog.Builder builder) {
    }

    @RequiresApi(api=21)
    protected void onClick() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            return;
        }
        this.showDialog(null);
    }

    @RequiresApi(api=3)
    protected void showDialog(Bundle state) {
        Context context = this.getContext();
        this.mWhichButtonClicked = -2;
        this.mBuilder = new PromptDialog.Builder(context).setTitle(this.mDialogTitle).setIcon(this.mDialogIcon).setPositiveButton(this.mPositiveButtonText, (DialogInterface.OnClickListener)this).setNegativeButton(this.mNegativeButtonText, (DialogInterface.OnClickListener)this);
        View contentView = this.onCreateDialogView();
        if (contentView != null) {
            this.onBindDialogView(contentView);
            this.mBuilder.setView(contentView);
        } else {
            this.mBuilder.setMessage(this.mDialogMessage);
        }
        this.onPrepareDialogBuilder(this.mBuilder);
        PreferenceManager manager = this.getPreferenceManager();
        this.invokeMethod(manager, "registerOnActivityDestroyListener");
        this.mDialog = this.mBuilder.setCancelable(this.mCancelable).setCanceledOnTouchOutside(this.mCanceledOnTouchOutside).create();
        PromptDialog dialog = this.mDialog;
        Utils.setDialogWindowBackGround(context, this.mDialog, this.mCancelable, this.mCanceledOnTouchOutside);
        if (state != null) {
            dialog.onRestoreInstanceState(state);
        }
        if (this.needInputMethod()) {
            this.requestInputMethod(dialog);
        }
        dialog.setOnDismissListener(this);
        dialog.show();
    }

    public OSDialogPreference setCancelable(boolean cancelable) {
        this.mCancelable = cancelable;
        return this;
    }

    public OSDialogPreference setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.mCanceledOnTouchOutside = canceledOnTouchOutside;
        return this;
    }

    private void invokeMethod(PreferenceManager manager, String methodName) {
        try {
            Class<?> clazz = manager.getClass();
            Method method = clazz.getDeclaredMethod(methodName, PreferenceManager.OnActivityDestroyListener.class);
            method.setAccessible(true);
            method.invoke((Object)manager, new Object[]{this});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean needInputMethod() {
        return false;
    }

    @RequiresApi(api=3)
    private void requestInputMethod(Dialog dialog) {
        Window window = dialog.getWindow();
        window.setSoftInputMode(5);
    }

    protected View onCreateDialogView() {
        if (this.mDialogLayoutResId == 0) {
            return null;
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.mBuilder.getContext());
        return inflater.inflate(this.mDialogLayoutResId, null);
    }

    @CallSuper
    protected void onBindDialogView(View view) {
        View dialogMessageView = view.findViewById(R.id.message);
        if (dialogMessageView != null) {
            CharSequence message = this.getDialogMessage();
            int newVisibility = 8;
            if (!TextUtils.isEmpty((CharSequence)message)) {
                if (dialogMessageView instanceof TextView) {
                    ((TextView)dialogMessageView).setText(message);
                }
                newVisibility = 0;
            }
            if (dialogMessageView.getVisibility() != newVisibility) {
                dialogMessageView.setVisibility(newVisibility);
            }
        }
    }

    public void onClick(DialogInterface dialog, int which) {
        this.mWhichButtonClicked = which;
    }

    public void onDismiss(DialogInterface dialog) {
        this.invokeMethod(this.getPreferenceManager(), "unregisterOnActivityDestroyListener");
        this.mDialog = null;
        this.onDialogClosed(this.mWhichButtonClicked == -1);
    }

    protected void onDialogClosed(boolean positiveResult) {
    }

    public Dialog getDialog() {
        return this.mDialog;
    }

    public void onActivityDestroy() {
        if (this.mDialog == null || !this.mDialog.isShowing()) {
            return;
        }
        this.mDialog.dismiss();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        if (this.mDialog == null || !this.mDialog.isShowing()) {
            return superState;
        }
        SavedState myState = new SavedState(superState);
        myState.isDialogShowing = true;
        myState.dialogBundle = this.mDialog.onSaveInstanceState();
        return myState;
    }

    @RequiresApi(api=21)
    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(SavedState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState myState = (SavedState)state;
        super.onRestoreInstanceState(myState.getSuperState());
        if (myState.isDialogShowing) {
            this.showDialog(myState.dialogBundle);
        }
    }

    @Nullable
    private View getDecorView() {
        if (this.mDialog != null && this.mDialog.getWindow() != null) {
            return this.mDialog.getWindow().getDecorView();
        }
        return null;
    }

    void postDismiss() {
        this.removeDismissCallbacks();
        View decorView = this.getDecorView();
        if (decorView != null) {
            decorView.post(this.mDismissRunnable);
        }
    }

    private void removeDismissCallbacks() {
        View decorView = this.getDecorView();
        if (decorView != null) {
            decorView.removeCallbacks(this.mDismissRunnable);
        }
    }

    private static class SavedState
    extends Preference.BaseSavedState {
        boolean isDialogShowing;
        Bundle dialogBundle;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcel source) {
            super(source);
            this.isDialogShowing = source.readInt() == 1;
            this.dialogBundle = source.readBundle();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.isDialogShowing ? 1 : 0);
            dest.writeBundle(this.dialogBundle);
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }
    }
}

