/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.letter;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import androidx.annotation.IntRange;
import androidx.core.content.ContextCompat;
import com.transsion.sort.SortUtil;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.ImageUtils;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.widget.timepicker.wheel.EaseCubicInterpolator;
import io.github.inflationx.calligraphy3.HasTypeface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LetterSelectorLayout
extends FrameLayout
implements HasTypeface {
    public static final int LETTER_TOUCH_ACTION_DOWN = 1;
    public static final int LETTER_TOUCH_ACTION_UP = 2;
    public static final int LETTER_TOUCH_MOVE = 3;
    public static final String mHeart = "\u2661";
    private int mEnableColor;
    private int mDisableColor;
    private ValueAnimator mShowAnimation;
    private ValueAnimator mHideScaleAnimation;
    private ValueAnimator mHideAlphaAnimation;
    private Runnable mHideScaleRunnable;
    private int mAlpha;
    private float mScale;
    private static final float SHOW_FROM_SCALE = 0.6f;
    private static final float SHOW_TO_SCALE = 1.0f;
    private static final int SHOW_TO_ALPHA = 255;
    private boolean mTouched;
    private boolean mShowAnimationCancel;
    Interpolator animationInterpolator = new DecelerateInterpolator();
    private final Paint txtPaint = new Paint(1);
    private final Paint txtMaxPaint = new Paint(1);
    private final Paint txtAnimationPaint = new Paint(1);
    private final Paint indicatorPaint = new Paint(1);
    private final Paint indicatorLetterPaint = new Paint(1);
    private final Paint selectedLetterPaint = new Paint(1);
    private float letterSize;
    private float letterMaxSize;
    private float letterIndicatorSize;
    private float precLetterHeight;
    private long duration = 200L;
    private long letterIndicatorMinDurationTime = 1000L;
    private boolean isLeft = false;
    private boolean alignRight = true;
    private LetterSelectorConfig alphabetSearchConfig;
    private List<String> mLetters;
    private final List<String> mAllLetters = new ArrayList<String>();
    private static final List<String> SPECIAL_LETTERS = Arrays.asList("\u2661", "#", "\u2026", "\u2664", "\u2606", "\u039b");
    private final List<String> mChangelessLetters = Arrays.asList("A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z");
    private float letterTouchAbleWidth = 0.0f;
    private int letterIndicatorRadius;
    private int letterIndicatorStart;
    private int mSelectorPaddingTop;
    private int mSelectorPaddingBottom;
    private int mSelectorPaddingStart;
    private int mWidth;
    private int mHeight;
    private int indicatorColor = -16731411;
    private int letterIndicatorColor = -1;
    private int selectedLetterColor = -8750470;
    private ArrayList<String> selectedLetters;
    private boolean topAndBottomClickableEnable = true;
    private Bitmap letterIndicatorBitmap;
    private int letterIndicatorBitmapWidth;
    private boolean letterIndicatorBitmapEnable;
    private final RectF mRectFBubble = new RectF();
    private boolean touchSlotEnable = true;
    private final RectF mExtraRectFTop = new RectF();
    private final RectF mExtraRectFBottom = new RectF();
    private static final String TAG = LetterSelectorLayout.class.getSimpleName();
    private final ArrayMap<RectF, LetterBlock> mArrayMap = new ArrayMap();
    private final RectF mRectFTotal = new RectF();
    private final RectF mRectFClip = new RectF();
    private final List<RectF> mRectFList = new ArrayList<RectF>();
    private String mSelectedLetter;
    private int mSelectedLetterPosition = -1;
    private final List<LetterBlock> mLetterBlockList = new ArrayList<LetterBlock>();
    private boolean mIsOverUnits;
    private boolean showSelector = true;
    private boolean mIsVerticalCentre;
    private int mBubbleHideDelayTime = 1000;
    private int mBubblePaddingStart;
    private int mPanelWidth;
    private int mSelectorPaddingStartOffset;
    private LetterSelectorConfig.LetterSelectorListener letterSelectorListener;
    boolean touching = false;

    public LetterSelectorLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public LetterSelectorLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LetterSelectorLayout(Context context) {
        super(context);
        this.init();
    }

    private int dpToPx(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    private int valueToDimen(int unit, int value) {
        return (int)TypedValue.applyDimension((int)unit, (float)value, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public boolean isShowSelector() {
        return this.showSelector;
    }

    public void setShowSelector(boolean showSelector) {
        this.showSelector = showSelector;
    }

    private void init() {
        this.setWillNotDraw(false);
        this.setClickable(true);
        this.mSelectorPaddingTop = this.dpToPx(30);
        this.mSelectorPaddingBottom = this.dpToPx(30);
        this.mSelectorPaddingStart = this.dpToPx(14);
        this.mSelectorPaddingStartOffset = this.dpToPx(4);
        this.letterSize = this.valueToDimen(2, 12);
        this.letterMaxSize = this.valueToDimen(2, 40);
        this.letterIndicatorSize = this.valueToDimen(2, 30);
        this.letterIndicatorRadius = this.getContext().getResources().getDimensionPixelOffset(R.dimen.letter_indicator_radius);
        this.letterIndicatorStart = this.dpToPx(16);
        this.txtPaint.setTextSize(this.letterSize);
        this.txtPaint.setColor(this.mEnableColor);
        this.txtPaint.setStyle(Paint.Style.FILL);
        this.txtMaxPaint.setTextSize(this.letterMaxSize);
        this.txtMaxPaint.setColor(this.mEnableColor);
        this.selectedLetterPaint.setColor(this.selectedLetterColor);
        this.selectedLetterPaint.setTextSize(this.letterSize);
        this.indicatorLetterPaint.setColor(this.letterIndicatorColor);
        this.indicatorLetterPaint.setTextSize(this.letterIndicatorSize);
        this.indicatorPaint.setColor(this.toAlphaColor(0.5f, this.indicatorColor));
        this.indicatorPaint.setStyle(Paint.Style.FILL);
        this.letterIndicatorBitmapWidth = this.dpToPx(64);
        this.letterIndicatorBitmapEnable = this.letterIndicatorBitmap != null;
        this.updateFontHeight();
        this.initAnimation();
        this.mBubblePaddingStart = this.dpToPx(3);
    }

    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (this.getHandler() != null && this.mHideScaleRunnable != null) {
            this.getHandler().removeCallbacks(this.mHideScaleRunnable);
        }
        this.cancelAnimation();
        this.mTouched = false;
        this.mScale = 0.0f;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mArrayMap.clear();
        this.mRectFList.clear();
        this.mLetterBlockList.clear();
    }

    private void updateFontHeight() {
        this.txtAnimationPaint.setTextSize(this.letterSize);
        this.precLetterHeight = this.getTextHeightOffset(this.txtAnimationPaint);
        this.txtAnimationPaint.setTextSize(this.letterMaxSize);
        this.txtAnimationPaint.setTextSize(this.letterIndicatorSize);
    }

    private void showSelector(boolean isShow) {
        if (isShow == this.showSelector) {
            return;
        }
        this.showSelector = isShow;
        this.selectedLetterPaint.setAlpha(this.showSelector ? 255 : 0);
        this.txtPaint.setAlpha(this.showSelector ? 255 : 0);
        this.txtAnimationPaint.setAlpha(this.showSelector ? 255 : 0);
        this.txtMaxPaint.setAlpha(this.showSelector ? 255 : 0);
        this.indicatorPaint.setAlpha(this.showSelector ? 255 : 0);
        this.indicatorLetterPaint.setAlpha(this.showSelector ? 255 : 0);
        this.invalidate();
    }

    private int toAlphaColor(float alpha, int color2) {
        return Color.argb((int)((int)(alpha * 255.0f) & 0xFF), (int)Color.red((int)color2), (int)Color.green((int)color2), (int)Color.blue((int)color2));
    }

    public LetterSelectorConfig getLetterSelectorConfig(boolean alignRight, boolean dimenDP) {
        if (this.alphabetSearchConfig == null) {
            this.alphabetSearchConfig = new LetterSelectorConfig(this);
        }
        this.alignRight = alignRight;
        this.alphabetSearchConfig.dimenDP = dimenDP;
        return this.alphabetSearchConfig;
    }

    private void checkLayoutDirection() {
        boolean isRTL = this.getLayoutDirection() == 1;
        this.isLeft = isRTL && this.alignRight || !isRTL && !this.alignRight;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.letterSelectorMeasure();
        this.invalidate();
    }

    private void letterSelectorMeasure() {
        int paintLen;
        if (this.mAllLetters == null || this.mAllLetters.size() == 0) {
            return;
        }
        int width = this.getWidth();
        int height = this.getHeight();
        if (width == 0 || height == 0) {
            return;
        }
        if (this.mWidth != width) {
            this.mWidth = width;
        }
        if (this.mHeight != height) {
            this.mHeight = height;
        }
        this.mArrayMap.clear();
        this.mRectFList.clear();
        this.mLetterBlockList.clear();
        this.checkLayoutDirection();
        int size = this.mAllLetters.size();
        float maxLetterWidth = 0.0f;
        for (int i = 0; i < size; ++i) {
            String letter = this.mAllLetters.get(i);
            if (TextUtils.isEmpty((CharSequence)letter)) continue;
            LetterBlock letterBlock = new LetterBlock();
            letterBlock.index = i;
            letterBlock.letter = letter;
            letterBlock.enable = this.mLetters.contains(letterBlock.letter);
            letterBlock.letterNormalWidthHalf = this.txtPaint.measureText(letter) / 2.0f;
            this.mLetterBlockList.add(letterBlock);
            float letterWidth = this.txtPaint.measureText(letter);
            maxLetterWidth = Math.max(letterWidth, maxLetterWidth);
        }
        int selectorPaddingTop = this.mSelectorPaddingTop;
        RectF rectF = new RectF();
        rectF.top = selectorPaddingTop;
        this.mPanelWidth = (int)maxLetterWidth + this.mSelectorPaddingStart * 2;
        rectF.bottom = rectF.top + this.precLetterHeight + (float)this.dpToPx(8);
        if (this.isLeft) {
            rectF.left = 0.0f;
            rectF.right = rectF.left + (float)this.mPanelWidth;
        } else {
            rectF.right = this.mWidth;
            rectF.left = rectF.right - (float)this.mPanelWidth;
        }
        float unitHeight = rectF.height();
        if (unitHeight == 0.0f) {
            return;
        }
        int length = this.mAllLetters.size();
        if (this.mIsVerticalCentre) {
            this.mSelectorPaddingBottom = selectorPaddingTop = 0;
        }
        float remainHeight = this.mHeight - selectorPaddingTop - this.mSelectorPaddingBottom;
        int units = this.mIsVerticalCentre ? (int)(remainHeight / unitHeight) - 2 : (int)(remainHeight / unitHeight);
        if (units < 1) {
            return;
        }
        this.mIsOverUnits = length > units;
        int n = paintLen = this.mIsOverUnits ? units : length;
        if (this.mIsVerticalCentre) {
            float letterPanelHeight = unitHeight * (float)paintLen;
            selectorPaddingTop = (int)(((float)this.mHeight - letterPanelHeight) / 2.0f);
            if (selectorPaddingTop < 0) {
                selectorPaddingTop = 0;
            }
            this.mSelectorPaddingBottom = selectorPaddingTop;
            rectF.top = selectorPaddingTop;
            rectF.bottom = rectF.top + unitHeight;
        }
        this.mRectFTotal.set(rectF);
        for (int i = 0; i < paintLen; ++i) {
            RectF f = new RectF(rectF.left, rectF.top, rectF.right, rectF.bottom);
            this.mRectFList.add(f);
            rectF.top = rectF.bottom;
            rectF.bottom += unitHeight;
            this.mArrayMap.put((Object)f, (Object)this.mLetterBlockList.get(i));
        }
        this.mExtraRectFBottom.set(rectF.left, rectF.top, rectF.right, rectF.top + 2.0f * unitHeight);
        this.mRectFTotal.bottom = this.mExtraRectFBottom.bottom;
        this.mExtraRectFTop.set(rectF.left, this.mRectFTotal.top - 2.0f * unitHeight, rectF.right, this.mRectFTotal.top);
        this.mRectFTotal.top = this.mExtraRectFTop.top;
        if (this.isLeft) {
            this.mRectFClip.set(this.mRectFTotal.left, this.mRectFTotal.top, this.mRectFTotal.right - (float)this.mSelectorPaddingStartOffset, this.mRectFTotal.bottom);
        } else {
            this.mRectFClip.set(this.mRectFTotal.left + (float)this.mSelectorPaddingStartOffset, this.mRectFTotal.top, this.mRectFTotal.right, this.mRectFTotal.bottom);
        }
        this.mPanelWidth = (int)this.mRectFClip.width();
        if (this.mRectFList.size() <= 0) {
            return;
        }
        float top = this.mRectFList.get((int)0).top + (float)this.valueToDimen(1, 70);
        int bubbleSize = this.getResources().getDimensionPixelOffset(R.dimen.os_letter_bubble_size);
        float left = this.mPanelWidth + this.letterIndicatorStart;
        if (!this.isLeft) {
            left = (float)this.mWidth - left - (float)bubbleSize;
        }
        this.mRectFBubble.set(left, top, left + (float)bubbleSize, top + (float)bubbleSize);
    }

    private float getTextHeightOffset(Paint textPaint) {
        Paint.FontMetrics fm = textPaint.getFontMetrics();
        float dy = (fm.bottom - fm.top - textPaint.getTextSize()) * 0.5f;
        float textHeightY = -dy;
        return textHeightY += textPaint.getTextSize();
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (!this.showSelector) {
            return;
        }
        if (this.letterSelectorListener != null && !this.letterSelectorListener.enabledDrawLetters() || this.mRectFList.size() <= 0) {
            return;
        }
        canvas.save();
        canvas.clipRect(this.mRectFClip);
        for (int i = 0; i < this.mRectFList.size(); ++i) {
            RectF rectF = this.mRectFList.get(i);
            LetterBlock letterBlock = (LetterBlock)this.mArrayMap.get((Object)rectF);
            if (letterBlock == null) continue;
            String letter = letterBlock.letter;
            float letterCentreY = (this.txtPaint.descent() + this.txtPaint.ascent()) / 2.0f;
            if (letter != null && letter.equals(this.mSelectedLetter) || this.selectedLetters != null && this.selectedLetters.contains(letter)) {
                canvas.drawText(this.mSelectedLetter, rectF.centerX() - letterBlock.letterNormalWidthHalf, rectF.centerY() - letterCentreY, this.selectedLetterPaint);
                continue;
            }
            canvas.drawText(letter, rectF.centerX() - letterBlock.letterNormalWidthHalf, rectF.centerY() - letterCentreY, this.txtPaint);
        }
        canvas.restore();
        this.drawLetterIndicator(canvas);
    }

    private void drawLetterIndicator(Canvas canvas) {
        if (TextUtils.isEmpty((CharSequence)this.mSelectedLetter) || !this.mTouched) {
            return;
        }
        canvas.save();
        this.indicatorLetterPaint.setAlpha(this.mAlpha);
        this.indicatorPaint.setAlpha(this.mAlpha);
        if (this.letterIndicatorBitmapEnable) {
            canvas.scale(this.mScale, this.mScale, this.mRectFBubble.centerX(), this.mRectFBubble.centerY());
            canvas.drawBitmap(this.letterIndicatorBitmap.extractAlpha(), null, this.mRectFBubble, this.indicatorPaint);
        } else {
            canvas.drawCircle(this.mRectFBubble.centerX(), this.mRectFBubble.centerY(), (float)this.letterIndicatorRadius, this.indicatorPaint);
        }
        canvas.save();
        float measureText = this.indicatorLetterPaint.measureText(this.mSelectedLetter);
        int spaceWidth = this.letterIndicatorBitmap.getWidth() - this.mBubblePaddingStart * 2;
        float scale = measureText > (float)spaceWidth ? (float)spaceWidth / measureText : 1.0f;
        canvas.scale(scale, scale, this.mRectFBubble.centerX(), this.mRectFBubble.centerY());
        canvas.drawText(this.mSelectedLetter, this.mRectFBubble.centerX() - measureText / 2.0f, this.mRectFBubble.centerY() - (this.indicatorLetterPaint.descent() + this.indicatorLetterPaint.ascent()) / 2.0f, this.indicatorLetterPaint);
        canvas.restore();
        canvas.restore();
    }

    private void initAnimation() {
        int duration = 200;
        int alphaDuration = 100;
        if (this.mShowAnimation == null) {
            this.mShowAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 200.0f});
            this.mShowAnimation.setDuration(200L);
            this.mShowAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    float cent = value / 200.0f;
                    LetterSelectorLayout.this.mAlpha = (int)(cent * 255.0f);
                    LetterSelectorLayout.this.mScale = 0.6f + 0.39999998f * cent;
                    LetterSelectorLayout.this.invalidate();
                }
            });
            this.mShowAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (!LetterSelectorLayout.this.mShowAnimationCancel && LetterSelectorLayout.this.mTouched && LetterSelectorLayout.this.mHideScaleAnimation != null && !LetterSelectorLayout.this.mHideScaleAnimation.isRunning() && LetterSelectorLayout.this.mHideAlphaAnimation != null && !LetterSelectorLayout.this.mHideAlphaAnimation.isRunning()) {
                        LetterSelectorLayout.this.startHideAnimation();
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    LetterSelectorLayout.this.mShowAnimationCancel = true;
                    LetterSelectorLayout.this.mTouched = false;
                    LetterSelectorLayout.this.mScale = 0.0f;
                }
            });
            this.mShowAnimation.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.2f, 0.0f, 0.1f, 1.0f));
        }
        if (this.mHideScaleAnimation == null) {
            this.mHideScaleAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 200.0f});
            this.mHideScaleAnimation.setDuration(200L);
            this.mHideScaleAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    float centScale = value / 200.0f;
                    LetterSelectorLayout.this.mScale = 1.0f - 0.39999998f * centScale;
                    LetterSelectorLayout.this.invalidate();
                }
            });
            this.mHideScaleAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    LetterSelectorLayout.this.mTouched = false;
                    LetterSelectorLayout.this.mScale = 0.0f;
                    LetterSelectorLayout.this.invalidate();
                }

                public void onAnimationCancel(Animator animation) {
                    LetterSelectorLayout.this.mTouched = false;
                    LetterSelectorLayout.this.mScale = 0.0f;
                }
            });
            this.mHideScaleAnimation.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.4f, 0.0f, 1.0f, 1.0f));
            this.mHideScaleRunnable = new Runnable(){

                @Override
                public void run() {
                    if (LetterSelectorLayout.this.mHideScaleAnimation != null && !LetterSelectorLayout.this.mHideScaleAnimation.isRunning()) {
                        LetterSelectorLayout.this.mHideScaleAnimation.start();
                        LetterSelectorLayout.this.mHideAlphaAnimation.start();
                    }
                }
            };
        }
        if (this.mHideAlphaAnimation == null) {
            this.mHideAlphaAnimation = ValueAnimator.ofFloat((float[])new float[]{0.0f, 100.0f});
            this.mHideAlphaAnimation.setDuration(150L);
            this.mHideAlphaAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float value = ((Float)animation.getAnimatedValue()).floatValue();
                    float centAlpha = value / 100.0f;
                    LetterSelectorLayout.this.mAlpha = (int)(255.0f - centAlpha * 255.0f);
                }
            });
            this.mHideAlphaAnimation.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.4f, 0.0f, 1.0f, 1.0f));
        }
    }

    private void startHideAnimation() {
        this.cancelAnimation();
        if (this.getHandler() != null && this.mTouched) {
            this.getHandler().postDelayed(this.mHideScaleRunnable, (long)this.mBubbleHideDelayTime);
        }
    }

    private void startShowAnimation() {
        if (this.getHandler() != null) {
            this.getHandler().removeCallbacks(this.mHideScaleRunnable);
        }
        if (this.mHideScaleAnimation != null && this.mHideScaleAnimation.isRunning()) {
            this.mHideScaleAnimation.cancel();
        }
        if (this.mHideAlphaAnimation != null && this.mHideAlphaAnimation.isRunning()) {
            this.mHideAlphaAnimation.cancel();
        }
        if (this.mScale == 1.0f) {
            return;
        }
        if (this.mShowAnimation != null && !this.mShowAnimation.isRunning()) {
            this.mShowAnimation.start();
            this.mTouched = true;
            this.mShowAnimationCancel = false;
        }
    }

    private void cancelAnimation() {
        if (this.getHandler() != null) {
            this.getHandler().removeCallbacks(this.mHideScaleRunnable);
        }
        if (this.mShowAnimation != null && this.mShowAnimation.isRunning()) {
            this.mShowAnimation.cancel();
        }
        if (this.mHideScaleAnimation != null && this.mHideScaleAnimation.isRunning()) {
            this.mHideScaleAnimation.cancel();
        }
        if (this.mHideAlphaAnimation != null && this.mHideAlphaAnimation.isRunning()) {
            this.mHideAlphaAnimation.cancel();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.isSelectorDisable()) {
            return super.onInterceptTouchEvent(ev);
        }
        if (ev.getAction() == 0 && this.touchEnable(ev.getX(), ev.getY())) {
            this.requestDisallowInterceptTouchEvent(true);
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    private boolean touchEnable(float x, float y) {
        if (this.mLetterBlockList.size() == 0 || this.mRectFList.size() == 0) {
            return false;
        }
        return this.topAndBottomClickableEnable && this.mRectFTotal.contains(x, y);
    }

    private boolean isSelectorDisable() {
        return this.mLetterBlockList.size() == 0 || this.letterSelectorListener != null && !this.letterSelectorListener.enabledDrawLetters() || !this.showSelector;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isSelectorDisable() || !this.showSelector) {
            if (this.touching) {
                this.handleTouchUpLetter();
            }
            return super.onTouchEvent(event);
        }
        float x = event.getX();
        float y = event.getY();
        if (event.getAction() == 0 && !this.touchEnable(x, y)) {
            return false;
        }
        block0 : switch (event.getAction()) {
            case 0: {
                this.requestDisallowInterceptTouchEvent(true);
                for (RectF rectF : this.mRectFList) {
                    LetterBlock selectedLetterBlock;
                    if (!rectF.contains(x, y) || (selectedLetterBlock = (LetterBlock)this.mArrayMap.get((Object)rectF)) == null) continue;
                    if (selectedLetterBlock.enable) {
                        this.handleTouchedLetter(selectedLetterBlock, 1);
                        this.startShowAnimation();
                        break block0;
                    }
                    if (this.letterSelectorListener == null) break block0;
                    this.letterSelectorListener.onTouchLetter(null, 0, 1, false);
                    break block0;
                }
                break;
            }
            case 2: {
                if (!this.mRectFTotal.contains(x, y)) {
                    return true;
                }
                boolean isExtraRectFTop = this.mExtraRectFTop.contains(x, y);
                boolean isExtraRectFBottom = this.mExtraRectFBottom.contains(x, y);
                if (isExtraRectFTop || isExtraRectFBottom) {
                    RectF rectF = isExtraRectFTop ? this.mRectFList.get(0) : this.mRectFList.get(this.mRectFList.size() - 1);
                    LetterBlock selectedLetterBlock = (LetterBlock)this.mArrayMap.get((Object)rectF);
                    if (selectedLetterBlock == null) {
                        return true;
                    }
                    this.handleMoveTouchLetter(rectF, selectedLetterBlock);
                    break;
                }
                for (RectF rectF : this.mRectFList) {
                    LetterBlock selectedLetterBlock;
                    if (!rectF.contains(x, y) || (selectedLetterBlock = (LetterBlock)this.mArrayMap.get((Object)rectF)) == null) continue;
                    this.handleMoveTouchLetter(rectF, selectedLetterBlock);
                }
                break;
            }
            case 1: 
            case 3: {
                this.handleTouchUpLetter();
                if (this.mShowAnimation != null && this.mShowAnimation.isRunning() || this.mHideScaleAnimation == null || this.mHideScaleAnimation.isRunning()) break;
                this.startHideAnimation();
            }
        }
        return true;
    }

    private void handleTouchUpLetter() {
        if (this.letterSelectorListener != null) {
            this.letterSelectorListener.onTouchLetter(null, 0, 2, false);
        }
    }

    public void setTypeface(Typeface typeface) {
        if (this.txtPaint != null) {
            this.txtPaint.setTypeface(typeface);
        }
        if (this.txtMaxPaint != null) {
            this.txtMaxPaint.setTypeface(typeface);
        }
        if (this.txtAnimationPaint != null) {
            this.txtAnimationPaint.setTypeface(typeface);
        }
        if (this.indicatorPaint != null) {
            this.indicatorPaint.setTypeface(typeface);
        }
        if (this.indicatorLetterPaint != null) {
            this.indicatorLetterPaint.setTypeface(typeface);
        }
        if (this.selectedLetterPaint != null) {
            this.selectedLetterPaint.setTypeface(typeface);
        }
    }

    public void setSelectedLetter(String selectedLetter) {
        if (this.mAllLetters == null || selectedLetter == null || selectedLetter.equals(this.mSelectedLetter)) {
            return;
        }
        int selectedLetterPosition = this.mAllLetters.indexOf(selectedLetter);
        if (selectedLetterPosition < 0) {
            return;
        }
        if (this.mIsOverUnits) {
            this.handleOverUnitsPst(selectedLetter, selectedLetterPosition);
        }
        this.mSelectedLetter = selectedLetter;
        this.mSelectedLetterPosition = selectedLetterPosition;
        this.invalidate();
    }

    private void handleOverUnitsPst(String selectedLetter, int selectedLetterPosition) {
        if (TextUtils.isEmpty((CharSequence)selectedLetter)) {
            return;
        }
        boolean isShowOnPanel = false;
        for (RectF rectF : this.mRectFList) {
            String letter;
            LetterBlock letterBlock = (LetterBlock)this.mArrayMap.get((Object)rectF);
            if (letterBlock == null || !selectedLetter.equals(letter = letterBlock.letter)) continue;
            isShowOnPanel = true;
            break;
        }
        if (isShowOnPanel) {
            return;
        }
        int index = this.mAllLetters.indexOf(selectedLetter);
        int sizeBlock = this.mLetterBlockList.size();
        int sizeRectF = this.mRectFList.size();
        if (this.mSelectedLetterPosition < selectedLetterPosition) {
            for (int pst = sizeRectF - 1; index >= 0 && index < sizeBlock && pst >= 0; --index, --pst) {
                this.mArrayMap.put((Object)this.mRectFList.get(pst), (Object)this.mLetterBlockList.get(index));
            }
        } else {
            for (int pst = 0; pst < sizeRectF && index < sizeBlock; ++pst, ++index) {
                this.mArrayMap.put((Object)this.mRectFList.get(pst), (Object)this.mLetterBlockList.get(index));
            }
        }
    }

    private void handleMoveTouchLetter(RectF rectF, LetterBlock selectedLetterBlock) {
        if (selectedLetterBlock == null) {
            return;
        }
        int selectedLetterPosition = this.mLetterBlockList.indexOf(selectedLetterBlock);
        if (this.mIsOverUnits) {
            int rectPst = this.mRectFList.indexOf(rectF);
            int sizeRectF = this.mRectFList.size();
            int sizeBlock = this.mLetterBlockList.size();
            if (rectPst == 0 && selectedLetterPosition > 0) {
                int topOffset;
                int tmpPst = 0;
                for (int i = topOffset = selectedLetterPosition - 1; i < topOffset + sizeRectF; ++i) {
                    if (tmpPst < sizeRectF && i < sizeBlock) {
                        this.mArrayMap.put((Object)this.mRectFList.get(tmpPst), (Object)this.mLetterBlockList.get(i));
                    }
                    ++tmpPst;
                }
            }
            if (rectPst == sizeRectF - 1 && selectedLetterPosition < sizeBlock - 1) {
                int topOffset;
                int topLetterIndex = this.mLetterBlockList.indexOf(this.mArrayMap.get((Object)this.mRectFList.get(0)));
                int tmpPst = 0;
                for (int i = topOffset = topLetterIndex + 1; i < sizeRectF + topOffset; ++i) {
                    if (tmpPst < sizeRectF && i < sizeBlock) {
                        this.mArrayMap.put((Object)this.mRectFList.get(tmpPst), (Object)this.mLetterBlockList.get(i));
                    }
                    ++tmpPst;
                }
            }
        }
        if (selectedLetterBlock.enable) {
            this.handleTouchedLetter(selectedLetterBlock, 3);
            this.startShowAnimation();
        }
    }

    private void handleTouchedLetter(LetterBlock selectedLetterBlock, int touchType) {
        if (selectedLetterBlock == null) {
            return;
        }
        String selectedLetter = selectedLetterBlock.letter;
        if (selectedLetter == null || selectedLetter.equals(this.mSelectedLetter)) {
            if (touchType == 1 && this.letterSelectorListener != null) {
                this.letterSelectorListener.onTouchLetter(selectedLetter, selectedLetterBlock.index, touchType, selectedLetterBlock.enable);
            }
            return;
        }
        this.setSelectedLetter(selectedLetter);
        if (this.letterSelectorListener != null) {
            this.letterSelectorListener.onTouchLetter(selectedLetter, selectedLetterBlock.index, touchType, selectedLetterBlock.enable);
        }
    }

    public int getPanelWidth() {
        return this.mPanelWidth;
    }

    private static class LetterBlock {
        public int index;
        public String letter;
        public boolean enable = true;
        public float letterNormalWidthHalf;

        private LetterBlock() {
        }
    }

    public static class LetterSelectorConfig {
        private final LetterSelectorLayout letterSelector;
        private final Context context;
        private boolean dimenDP = true;

        public static int dpToPx(Context context, int dp) {
            return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }

        public static int spToPx(Context context, int dp) {
            return (int)TypedValue.applyDimension((int)2, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics());
        }

        private int dimenSize(int size) {
            if (this.dimenDP) {
                return LetterSelectorConfig.dpToPx(this.context, size);
            }
            return size;
        }

        private int dimenSpSize(int size) {
            if (this.dimenDP) {
                return LetterSelectorConfig.spToPx(this.context, size);
            }
            return size;
        }

        private LetterSelectorConfig(LetterSelectorLayout alphabetSearchLayout) {
            this.letterSelector = alphabetSearchLayout;
            this.context = this.letterSelector.getContext();
        }

        public void initConfig(Context context) {
            Resources res = context.getResources();
            this.setSelectorPadding(context.getResources().getDimensionPixelSize(R.dimen.letter_top_padding), res.getDimensionPixelSize(R.dimen.letter_bottom_padding), res.getDimensionPixelSize(Utils.isWaterfallScreen(context) ? R.dimen.os_letter_padding_curse : R.dimen.os_letter_padding));
            this.setSelectorFontSize(res.getDimensionPixelSize(R.dimen.blade_list_section_font_Size), res.getDimensionPixelSize(R.dimen.blade_list_section_max_font_Size), res.getDimensionPixelSize(R.dimen.blade_list_section_indicate_font_Size));
            this.letterSelector.mEnableColor = ContextCompat.getColor((Context)context, (int)R.color.os_letter_enable_color);
            this.letterSelector.mDisableColor = ContextCompat.getColor((Context)context, (int)R.color.os_text_quaternary_color);
            this.setSelectorFontColor(this.letterSelector.mEnableColor, this.letterSelector.mDisableColor, ContextCompat.getColor((Context)context, (int)R.color.letter_select_color));
            String osType = Utils.getOsType();
            int selectorColor = R.color.os_platform_basic_color_hios;
            if (TextUtils.isEmpty((CharSequence)osType) || osType.equalsIgnoreCase(Utils.mOsType[0])) {
                selectorColor = R.color.os_platform_basic_color_hios;
            } else if (osType.equalsIgnoreCase(Utils.mOsType[1])) {
                selectorColor = R.color.os_platform_basic_color_xos;
            } else if (osType.equalsIgnoreCase(Utils.mOsType[2])) {
                selectorColor = R.color.os_platform_basic_color_itel;
            }
            this.setSelectorSelectedLetterColor(ContextCompat.getColor((Context)context, (int)selectorColor));
            Drawable touchBg = ContextCompat.getDrawable((Context)context, (int)R.drawable.ic_touch_bg);
            Bitmap bitmap = ImageUtils.drawable2Bitmap(touchBg);
            if (Utils.isRtl()) {
                bitmap = ImageUtils.convert(bitmap);
            }
            this.setSelectorLetterIndicatorBitmap(bitmap, bitmap.getWidth(), bitmap.getHeight());
            this.setTouchFrameStart(res.getDimensionPixelSize(R.dimen.blade_touch_width));
            this.letterSelector.letterIndicatorStart = res.getDimensionPixelOffset(R.dimen.os_letter_bubble_margin_end);
            this.setSelectorIndicatorColor(ContextCompat.getColor((Context)context, (int)R.color.os_letter_bubble_bg));
        }

        public LetterSelectorConfig registerLetterSelectorListener(LetterSelectorListener letterSelectorTouchListener) {
            this.letterSelector.letterSelectorListener = letterSelectorTouchListener;
            return this;
        }

        public LetterSelectorConfig setSelectorPadding(int paddingTop, int paddingBottom, int paddingStart) {
            this.letterSelector.mSelectorPaddingTop = this.dimenSize(paddingTop);
            this.letterSelector.mSelectorPaddingBottom = this.dimenSize(paddingBottom);
            this.letterSelector.mSelectorPaddingStart = this.dimenSize(paddingStart);
            return this;
        }

        public LetterSelectorConfig updateSelectorTopPadding(int paddingTop) {
            this.letterSelector.mSelectorPaddingTop = this.dimenSize(paddingTop);
            return this;
        }

        public LetterSelectorConfig updateSelectorBottomPadding(int paddingTop) {
            this.letterSelector.mSelectorPaddingBottom = this.dimenSize(paddingTop);
            return this;
        }

        public LetterSelectorConfig setVerticalCentre(boolean isVerticalCentre) {
            this.letterSelector.mIsVerticalCentre = isVerticalCentre;
            return this;
        }

        public LetterSelectorConfig setTouchFrameStart(int touchStart) {
            this.letterSelector.letterTouchAbleWidth = this.dimenSize(touchStart);
            return this;
        }

        public LetterSelectorConfig setSelectorLetterIndicatorStart(int letterIndicatorStart) {
            this.letterSelector.letterIndicatorStart = this.dimenSize(letterIndicatorStart);
            return this;
        }

        public LetterSelectorConfig setSelectorFontSize(int letterSize, int letterMaxSize, int letterIndicatorSize) {
            this.letterSelector.letterSize = this.dimenSpSize(letterSize);
            this.letterSelector.letterMaxSize = this.dimenSpSize(letterMaxSize);
            this.letterSelector.letterIndicatorSize = this.dimenSpSize(letterIndicatorSize);
            this.letterSelector.txtPaint.setTextSize(this.letterSelector.letterSize);
            this.letterSelector.selectedLetterPaint.setTextSize(this.letterSelector.letterSize);
            this.letterSelector.txtMaxPaint.setTextSize(this.letterSelector.letterMaxSize);
            this.letterSelector.indicatorLetterPaint.setTextSize(this.letterSelector.letterIndicatorSize);
            this.letterSelector.updateFontHeight();
            return this;
        }

        public LetterSelectorConfig setSelectorFontColor(int enableColor, int disableColor, int letterIndicatorColor) {
            this.letterSelector.mEnableColor = enableColor;
            this.letterSelector.mDisableColor = disableColor;
            this.letterSelector.txtPaint.setColor(enableColor);
            this.letterSelector.txtMaxPaint.setColor(enableColor);
            this.letterSelector.letterIndicatorColor = letterIndicatorColor;
            this.letterSelector.indicatorLetterPaint.setColor(letterIndicatorColor);
            return this;
        }

        public LetterSelectorConfig setSelectorFontColor(int enableColor, int disableColor) {
            this.setSelectorFontColor(enableColor, disableColor, ContextCompat.getColor((Context)this.context, (int)R.color.letter_select_color));
            return this;
        }

        public LetterSelectorConfig setSelectorIndicatorColor(int indicatorColor) {
            this.letterSelector.indicatorColor = indicatorColor;
            this.letterSelector.indicatorPaint.setColor(indicatorColor);
            return this;
        }

        public LetterSelectorConfig setSelectorIndicatorSize(int radiusTouchIndicator, int radiusLetterIndicator) {
            this.letterSelector.letterIndicatorRadius = this.dimenSize(radiusLetterIndicator);
            return this;
        }

        public LetterSelectorConfig setSelectorLetterIndicatorMinDurationTime(long letterIndicatorMinDurationTime) {
            this.letterSelector.letterIndicatorMinDurationTime = letterIndicatorMinDurationTime;
            return this;
        }

        public LetterSelectorConfig setSelectorAnimationInterpolator(Interpolator animationInterpolator) {
            if (animationInterpolator == null) {
                animationInterpolator = new LinearInterpolator();
            }
            this.letterSelector.animationInterpolator = animationInterpolator;
            return this;
        }

        public LetterSelectorConfig requestSelectorInvalidate() {
            this.letterSelector.invalidate();
            return this;
        }

        public LetterSelectorConfig requestSelectorLayout() {
            this.letterSelector.letterSelectorMeasure();
            this.letterSelector.requestLayout();
            return this;
        }

        public LetterSelectorConfig setTouchIndicator(int indicatorColor, int indicatorRadius) {
            this.letterSelector.indicatorPaint.setColor(indicatorColor);
            return this;
        }

        public LetterSelectorConfig setSelectorSelectedLetterColor(int selectedLetterColor) {
            this.letterSelector.selectedLetterColor = selectedLetterColor;
            this.letterSelector.selectedLetterPaint.setColor(selectedLetterColor);
            return this;
        }

        public LetterSelectorConfig setSelectorSelectedLetter(String selectedLetter) {
            this.letterSelector.setSelectedLetter(selectedLetter);
            return this;
        }

        public LetterSelectorConfig setSelectorSelectedLetters(ArrayList<String> letters) {
            this.letterSelector.selectedLetters = letters;
            this.letterSelector.invalidate();
            return this;
        }

        public LetterSelectorConfig setSelectorTopAndBottomClickableEnable(boolean topAndBottomClickableEnable) {
            this.letterSelector.topAndBottomClickableEnable = topAndBottomClickableEnable;
            return this;
        }

        public LetterSelectorConfig setSelectorLetterIndicatorBitmap(Bitmap letterIndicatorBitmap, int bitmapDrawWidth, int bitmapDrawHeight) {
            this.letterSelector.letterIndicatorBitmap = letterIndicatorBitmap;
            this.letterSelector.letterIndicatorBitmapWidth = this.dimenSize(bitmapDrawWidth);
            this.letterSelector.letterIndicatorBitmapEnable = letterIndicatorBitmap != null;
            return this;
        }

        public LetterSelectorConfig setAlphabetAnimationDuration(int duration) {
            this.letterSelector.duration = duration;
            return this;
        }

        @Deprecated
        public LetterSelectorConfig setSelectorLetters(String[] letters) {
            return this.setSelectorLettersAll(letters);
        }

        @Deprecated
        public LetterSelectorConfig setSelectorLettersSort(String[] letters) {
            return this.setSelectorLettersAll(letters);
        }

        private void initLettersSort() {
            boolean purgeAZ = true;
            for (String letter : this.letterSelector.mLetters) {
                char ascii;
                if (letter == null || letter.length() != 1) {
                    purgeAZ = false;
                    break;
                }
                if (SPECIAL_LETTERS.contains(letter) || (ascii = letter.charAt(0)) >= 'A' && ascii <= 'Z') continue;
                purgeAZ = false;
                break;
            }
            this.letterSelector.mAllLetters.clear();
            if (purgeAZ) {
                this.letterSelector.mAllLetters.addAll(this.letterSelector.mChangelessLetters);
                for (String letter : this.letterSelector.mLetters) {
                    if (this.letterSelector.mChangelessLetters.contains(letter)) continue;
                    this.letterSelector.mAllLetters.add(letter);
                }
            } else {
                this.letterSelector.mAllLetters.addAll(this.letterSelector.mLetters);
            }
            SortUtil sortUtil = new SortUtil(this.context);
            sortUtil.sortString(this.letterSelector.mAllLetters);
            if (this.letterSelector.mAllLetters.contains(LetterSelectorLayout.mHeart)) {
                this.letterSelector.mAllLetters.remove(LetterSelectorLayout.mHeart);
                this.letterSelector.mAllLetters.add(0, LetterSelectorLayout.mHeart);
            }
        }

        private void initAllLetters() {
            this.letterSelector.mAllLetters.clear();
            for (String letter : this.letterSelector.mLetters) {
                if (this.letterSelector.mChangelessLetters.contains(letter)) continue;
                this.letterSelector.mAllLetters.add(letter);
            }
            this.letterSelector.mAllLetters.addAll(this.letterSelector.mChangelessLetters);
        }

        public LetterSelectorConfig setSelectorLettersAll(String[] letters) {
            this.letterSelector.mLetters = Arrays.asList(letters);
            this.letterSelector.mAllLetters.clear();
            this.letterSelector.mAllLetters.addAll(this.letterSelector.mLetters);
            return this;
        }

        public LetterSelectorConfig showSelector(boolean isShow) {
            this.letterSelector.showSelector(isShow);
            return this;
        }

        public boolean isSelectorTouching() {
            return this.letterSelector.touching;
        }

        public LetterSelectorConfig setTouchSlotEnable(boolean touchSlotEnable) {
            this.letterSelector.touchSlotEnable = touchSlotEnable;
            return this;
        }

        public LetterSelectorConfig setBubbleHideDelayTime(@IntRange(from=50L, to=1000L) int bubbleHideDelayTime) {
            if (bubbleHideDelayTime < 50) {
                bubbleHideDelayTime = 50;
            }
            if (bubbleHideDelayTime > 1000) {
                bubbleHideDelayTime = 1000;
            }
            this.letterSelector.mBubbleHideDelayTime = bubbleHideDelayTime;
            return this;
        }

        public static interface LetterSelectorListener {
            public void onTouchLetter(String var1, int var2, int var3, boolean var4);

            public boolean enabledDrawLetters();
        }
    }
}

