/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.Filterable;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.CallSuper;
import androidx.annotation.DrawableRes;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.widget.timepicker.wheel.EaseCubicInterpolator;
import java.lang.ref.WeakReference;
import java.util.List;

public class SearchBar
extends FrameLayout {
    private static final int ANIM_TIME = 250;
    private static final int ANIM_TIME_FOR_TRANSITION = 250;
    private int mLeftMargin;
    private ImageView mBackView;
    private ImageView mSearchIcon;
    private TextView mClickView;
    private AutoCompleteTextView mSearchView;
    private int mWidth0;
    private int mWidth1;
    private int mMoveWidth;
    private OnItemClickListener mItemClickListener;
    private OnStateChangeListener mStateChangeListener;
    private ImageView mDeleteAll;
    private ImageView mImgCustom;
    private boolean mOnSearch;
    private TextWatcher mTextWatcher = new SearchBarTextWatcher();
    private boolean mCompleteInput;
    private View.OnClickListener mBackClickListener = new BackClickListener();
    private View.OnClickListener mCustomIconClickListener;
    private View.OnClickListener mSearchBarClickListener;
    private int mDeleteMargin;
    private boolean mIsBackMode;
    private boolean mIsIDLE;
    private boolean mIsSearStatusOnInitial;
    private WidthWrapper mSearchViewWidthWrapper;
    private WidthWrapper mClickViewWidthWrapper;
    private int mSearchBarTextPaddingEndWithDelIcon;
    private int mSearchBarTextPaddingEnd;
    private String mTipInputMax;

    public SearchBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.os_search_bar_layout, (ViewGroup)this);
        this.mDeleteMargin = context.getResources().getDimensionPixelSize(R.dimen.os_search_bar_delete_margin);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OSSearchBar);
        this.mIsBackMode = a.getBoolean(R.styleable.OSSearchBar_isBackMode, true);
        this.mIsSearStatusOnInitial = a.getBoolean(R.styleable.OSSearchBar_isSearStatusOnInitial, false);
        this.mSearchBarTextPaddingEndWithDelIcon = context.getResources().getDimensionPixelOffset(R.dimen.os_search_bar_text_padding_end_with_del_icon);
        this.mSearchBarTextPaddingEnd = context.getResources().getDimensionPixelOffset(R.dimen.os_search_bar_text_padding_end);
        a.recycle();
        this.initView();
        this.initEvent();
        this.preDraw();
        this.dealOsDiff();
        this.dealSearchViewTextPadding();
        this.mSearchViewWidthWrapper = new WidthWrapper((View)this.mSearchView);
        this.mClickViewWidthWrapper = new WidthWrapper((View)this.mClickView);
    }

    private void dealSearchViewTextPadding() {
        if (this.mSearchView.getText() != null && !TextUtils.isEmpty((CharSequence)this.mSearchView.getText().toString()) && this.isSearchBarEnabled()) {
            this.mSearchView.setPaddingRelative(this.mSearchView.getPaddingStart(), this.mSearchView.getPaddingTop(), this.mSearchBarTextPaddingEndWithDelIcon, this.mSearchView.getPaddingBottom());
        } else {
            this.mSearchView.setPaddingRelative(this.mSearchView.getPaddingStart(), this.mSearchView.getPaddingTop(), this.mSearchBarTextPaddingEnd, this.mSearchView.getPaddingBottom());
        }
    }

    private void dealOsDiff() {
        int[] attrs = new int[]{R.attr.osSearchBarMargin};
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs);
        this.mLeftMargin = typedArray.getDimensionPixelSize(0, this.getContext().getResources().getDimensionPixelSize(R.dimen.os_search_bar_margin_hios));
        typedArray.recycle();
        RelativeLayout.LayoutParams layoutParamsDelete = (RelativeLayout.LayoutParams)this.mDeleteAll.getLayoutParams();
        if (this.mIsBackMode) {
            layoutParamsDelete.setMarginEnd(this.getContext().getResources().getDimensionPixelSize(R.dimen.os_search_bar_margin_xos) + this.mDeleteMargin);
        } else {
            layoutParamsDelete.setMarginEnd(this.mLeftMargin + this.mDeleteMargin);
        }
        this.mDeleteAll.setLayoutParams((ViewGroup.LayoutParams)layoutParamsDelete);
    }

    private void initView() {
        this.mClickView = (TextView)this.findViewById(R.id.text_click);
        this.mSearchView = (AutoCompleteTextView)this.findViewById(R.id.text_search);
        this.mBackView = (ImageView)this.findViewById(R.id.img_btn_back);
        this.mSearchIcon = (ImageView)this.findViewById(R.id.img_search_icon);
        this.mDeleteAll = (ImageView)this.findViewById(R.id.img_delete_all);
        this.mImgCustom = (ImageView)this.findViewById(R.id.img_custom);
        if (!this.mIsBackMode) {
            this.mClickView.setVisibility(8);
            this.mSearchView.setVisibility(0);
            this.showSoftInput();
        }
    }

    private void initEvent() {
        this.mClickView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SearchBar.this.mIsIDLE) {
                    if (SearchBar.this.mSearchBarClickListener != null) {
                        SearchBar.this.mSearchBarClickListener.onClick(v);
                    }
                } else {
                    SearchBar.this.startSearch();
                }
            }
        });
        this.mBackView.setOnClickListener(this.mBackClickListener);
        this.mSearchView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (SearchBar.this.mItemClickListener != null) {
                    SearchBar.this.mItemClickListener.onItemClick(parent, view, position, id2);
                }
            }
        });
        this.mDeleteAll.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean isEmpty = TextUtils.isEmpty((CharSequence)SearchBar.this.mSearchView.getText());
                if (!isEmpty || SearchBar.this.mSearchView.length() > 0) {
                    SearchBar.this.mSearchView.setText(null);
                }
            }
        });
        this.mImgCustom.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SearchBar.this.mCustomIconClickListener != null) {
                    SearchBar.this.mCustomIconClickListener.onClick(v);
                }
            }
        });
    }

    public void setBackClickListener(View.OnClickListener listener) {
        this.mBackClickListener = listener;
        this.mBackView.setOnClickListener(this.mBackClickListener);
    }

    public void setIsIDLE(boolean isIdle) {
        this.mIsIDLE = isIdle;
    }

    public void setRightIcon(int customResId) {
        this.setRightIcon(customResId, null);
    }

    public void setRightIconVisibility(boolean show) {
        this.mImgCustom.setVisibility(show ? 0 : 8);
        this.syncComponentMargin(show);
    }

    public void setRightIcon(int customResId, View.OnClickListener onClickListener) {
        this.mCustomIconClickListener = onClickListener;
        this.mImgCustom.setVisibility(0);
        this.mImgCustom.setImageResource(customResId);
        this.syncComponentMargin(true);
    }

    public EditText getEditText() {
        return this.mSearchView;
    }

    private void syncComponentMargin(boolean isCustomIconShow) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mSearchView.getLayoutParams();
        RelativeLayout.LayoutParams layoutParamsClick = (RelativeLayout.LayoutParams)this.mClickView.getLayoutParams();
        RelativeLayout.LayoutParams layoutParamsDelete = (RelativeLayout.LayoutParams)this.mDeleteAll.getLayoutParams();
        layoutParams.setMarginEnd(isCustomIconShow ? 0 : this.mLeftMargin);
        layoutParamsClick.setMarginEnd(isCustomIconShow ? 0 : this.mLeftMargin);
        layoutParamsDelete.setMarginEnd(isCustomIconShow ? this.mDeleteMargin : this.mDeleteMargin + this.mLeftMargin);
        this.mSearchView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mClickView.setLayoutParams((ViewGroup.LayoutParams)layoutParamsClick);
        this.mDeleteAll.setLayoutParams((ViewGroup.LayoutParams)layoutParamsDelete);
    }

    public boolean getRightIconVisibility() {
        return this.mImgCustom.getVisibility() == 0;
    }

    @Deprecated
    public void setTextWatcher(TextWatcher textWatcher) {
        if (null == textWatcher) {
            return;
        }
        this.mSearchView.removeTextChangedListener(this.mTextWatcher);
        this.mTextWatcher = textWatcher;
        this.mSearchView.addTextChangedListener(this.mTextWatcher);
    }

    public void addTextWatcher(TextWatcher textWatcher) {
        if (null == textWatcher) {
            return;
        }
        this.mSearchView.addTextChangedListener(textWatcher);
    }

    public void removeTextWatcher(TextWatcher textWatcher) {
        this.mSearchView.removeTextChangedListener(textWatcher);
    }

    private void preDraw() {
        this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                SearchBar.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                SearchBar.this.mBackView.offsetLeftAndRight(-SearchBar.this.mBackView.getMeasuredWidth());
                SearchBar.this.mBackView.setVisibility(8);
                SearchBar.this.mWidth0 = SearchBar.this.mClickView.getMeasuredWidth();
                int leftMargin = SearchBar.this.mLeftMargin;
                SearchBar.this.mMoveWidth = SearchBar.this.mBackView.getMeasuredWidth() - leftMargin;
                SearchBar.this.mWidth1 = SearchBar.this.mWidth0 - SearchBar.this.mMoveWidth;
                if (SearchBar.this.mIsBackMode && SearchBar.this.mIsSearStatusOnInitial) {
                    SearchBar.this.mClickView.setVisibility(8);
                    SearchBar.this.mBackView.setVisibility(0);
                    SearchBar.this.mSearchView.setVisibility(0);
                    SearchBar.this.dealSearchViewWidthDiff();
                    RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)SearchBar.this.mSearchView.getLayoutParams();
                    layoutParams.width = SearchBar.this.mWidth1;
                    SearchBar.this.mSearchView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    int moveWidth = Utils.isRtl() ? -SearchBar.this.mMoveWidth : SearchBar.this.mMoveWidth;
                    SearchBar.this.mSearchView.setTranslationX((float)moveWidth);
                    SearchBar.this.mSearchIcon.setTranslationX((float)moveWidth);
                }
                SearchBar.this.dealDeleteIconVisibility();
                return true;
            }
        });
    }

    private void backEnterAnim() {
        this.dealSearchViewWidthDiff();
        boolean isRTL = this.getLayoutDirection() == 1;
        int backMove = isRTL ? this.mBackView.getWidth() : -this.mBackView.getWidth();
        ObjectAnimator backAnimator = ObjectAnimator.ofFloat((Object)this.mBackView, (String)"translationX", (float[])new float[]{backMove, 0.0f});
        ObjectAnimator wrapperAnimator = ObjectAnimator.ofInt((Object)this.mSearchViewWidthWrapper, (String)"width", (int[])new int[]{this.mWidth0, this.mWidth1});
        int moveWidth = isRTL ? -this.mMoveWidth : this.mMoveWidth;
        ObjectAnimator textMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchView, (String)"translationX", (float[])new float[]{0.0f, moveWidth});
        ObjectAnimator iconMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchIcon, (String)"translationX", (float[])new float[]{0.0f, moveWidth});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(250L);
        set.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.4f, 0.0f, 0.2f, 1.0f));
        set.playTogether(new Animator[]{backAnimator, wrapperAnimator, textMoveAnimator, iconMoveAnimator});
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                SearchBar.this.mBackView.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                SearchBar.this.mBackView.setClickable(true);
            }
        });
        set.start();
    }

    private AnimatorSet backEnterAnimForTransition() {
        this.dealSearchViewWidthDiff();
        boolean isRTL = this.getLayoutDirection() == 1;
        int backMove = isRTL ? this.mBackView.getWidth() : -this.mBackView.getWidth();
        ObjectAnimator backAnimator = ObjectAnimator.ofFloat((Object)this.mBackView, (String)"translationX", (float[])new float[]{backMove, 0.0f});
        ObjectAnimator wrapperAnimator = ObjectAnimator.ofInt((Object)this.mClickViewWidthWrapper, (String)"width", (int[])new int[]{this.mWidth0, this.mWidth1});
        int moveWidth = isRTL ? -this.mMoveWidth : this.mMoveWidth;
        ObjectAnimator textMoveAnimator = ObjectAnimator.ofFloat((Object)this.mClickView, (String)"translationX", (float[])new float[]{0.0f, moveWidth});
        ObjectAnimator iconMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchIcon, (String)"translationX", (float[])new float[]{0.0f, moveWidth});
        this.mBackView.setAlpha(0.0f);
        ValueAnimator backViewFadeInAnim = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        backViewFadeInAnim.setStartDelay(67L);
        backViewFadeInAnim.setDuration(183L);
        backViewFadeInAnim.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.33f, 0.0f, 0.66f, 1.0f));
        backViewFadeInAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                SearchBar.this.mBackView.setAlpha(value);
            }
        });
        AnimatorSet set = new AnimatorSet();
        set.setDuration(250L);
        set.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.25f, 0.0f, 0.0f, 1.0f));
        set.playTogether(new Animator[]{backAnimator, wrapperAnimator, textMoveAnimator, iconMoveAnimator, backViewFadeInAnim});
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                SearchBar.this.mBackView.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                SearchBar.this.mBackView.setClickable(true);
            }
        });
        return set;
    }

    private void dealSearchViewWidthDiff() {
        if (Utils.mOsType[0].equalsIgnoreCase(Utils.getOsType()) && this.mImgCustom.getVisibility() == 8) {
            this.mWidth1 = this.mWidth0 - this.mMoveWidth - Utils.dp2px(this.getContext(), 6);
        }
    }

    private void backExitAnim() {
        boolean isRTL = this.getLayoutDirection() == 1;
        int backMove = isRTL ? this.mBackView.getWidth() : -this.mBackView.getWidth();
        ObjectAnimator backAnimator = ObjectAnimator.ofFloat((Object)this.mBackView, (String)"translationX", (float[])new float[]{0.0f, backMove});
        ObjectAnimator wrapperAnimator = ObjectAnimator.ofInt((Object)this.mSearchViewWidthWrapper, (String)"width", (int[])new int[]{this.mWidth1, this.mWidth0});
        int moveWidth = isRTL ? -this.mMoveWidth : this.mMoveWidth;
        ObjectAnimator textMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchView, (String)"translationX", (float[])new float[]{moveWidth, 0.0f});
        ObjectAnimator iconMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchIcon, (String)"translationX", (float[])new float[]{moveWidth, 0.0f});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(250L);
        set.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.4f, 0.0f, 0.2f, 1.0f));
        set.playTogether(new Animator[]{backAnimator, wrapperAnimator, textMoveAnimator, iconMoveAnimator});
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                InputMethodManager imm = (InputMethodManager)SearchBar.this.getContext().getSystemService(InputMethodManager.class);
                if (imm != null) {
                    imm.hideSoftInputFromWindow(SearchBar.this.getWindowToken(), 0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                SearchBar.this.mBackView.setVisibility(8);
                SearchBar.this.mSearchView.setVisibility(8);
                SearchBar.this.mClickView.setVisibility(0);
            }
        });
        set.start();
    }

    private AnimatorSet backExitAnimForTransition() {
        boolean isRTL = this.getLayoutDirection() == 1;
        int backMove = isRTL ? this.mBackView.getWidth() : -this.mBackView.getWidth();
        ObjectAnimator backAnimator = ObjectAnimator.ofFloat((Object)this.mBackView, (String)"translationX", (float[])new float[]{0.0f, backMove});
        ObjectAnimator wrapperAnimator = ObjectAnimator.ofInt((Object)this.mClickViewWidthWrapper, (String)"width", (int[])new int[]{this.mWidth1, this.mWidth0});
        int moveWidth = isRTL ? -this.mMoveWidth : this.mMoveWidth;
        ObjectAnimator textMoveAnimator = ObjectAnimator.ofFloat((Object)this.mClickView, (String)"translationX", (float[])new float[]{moveWidth, 0.0f});
        ObjectAnimator iconMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchIcon, (String)"translationX", (float[])new float[]{moveWidth, 0.0f});
        ValueAnimator backViewFadeOutAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        backViewFadeOutAnim.setDuration(100L);
        backViewFadeOutAnim.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.33f, 0.0f, 0.66f, 1.0f));
        backViewFadeOutAnim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float value = ((Float)animation.getAnimatedValue()).floatValue();
                SearchBar.this.mBackView.setAlpha(value);
            }
        });
        AnimatorSet set = new AnimatorSet();
        set.setDuration(250L);
        set.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.25f, 0.0f, 0.0f, 1.0f));
        set.playTogether(new Animator[]{backAnimator, wrapperAnimator, textMoveAnimator, iconMoveAnimator, backViewFadeOutAnim});
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                SearchBar.this.mBackView.setVisibility(8);
            }
        });
        return set;
    }

    public void startSearch() {
        this.mOnSearch = true;
        this.mClickView.setVisibility(8);
        this.mSearchView.setVisibility(0);
        this.backEnterAnim();
        this.showSoftInput();
        this.dealDeleteIconVisibility();
        if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onSearchStart();
        }
    }

    private void showSoftInput() {
        if (this.mSearchView != null) {
            this.mSearchView.requestFocus();
            InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService(InputMethodManager.class);
            if (imm != null) {
                imm.showSoftInput((View)this.mSearchView, 0);
            }
        }
    }

    private void dealDeleteIconVisibility() {
        if (!TextUtils.isEmpty((CharSequence)this.mSearchView.getText()) && this.mSearchView.getText().toString().length() > 0 && this.mSearchView.getVisibility() == 0 && this.mClickView.getVisibility() != 0 && this.isSearchBarEnabled()) {
            if (this.mDeleteAll.getVisibility() != 0) {
                this.mDeleteAll.setVisibility(0);
            }
        } else if (this.mDeleteAll.getVisibility() != 8) {
            this.mDeleteAll.setVisibility(8);
        }
    }

    public void endSearch() {
        this.mOnSearch = false;
        this.mDeleteAll.setVisibility(8);
        this.mSearchView.setText(null);
        this.mBackView.setClickable(false);
        this.backExitAnim();
        if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onSearchEnd();
        }
    }

    public boolean isOnSearch() {
        return this.mOnSearch;
    }

    public void setHint(CharSequence hint) {
        this.mClickView.setText(hint);
        this.mSearchView.setHint(hint);
    }

    public void setHint(int hintId) {
        this.setHint(this.getResources().getString(hintId));
    }

    public void setSearchSource(Context context, List<String> source) {
        ArrayAdapter adapter = new ArrayAdapter(context, R.layout.os_search_source_item_layout, R.id.search_item_text, source);
        this.mSearchView.setAdapter((ListAdapter)adapter);
    }

    public void setCustomSearchIcon(@DrawableRes int searchIconResId) {
        if (this.mSearchIcon != null) {
            this.mSearchIcon.setImageResource(searchIconResId);
        }
    }

    public <T extends ListAdapter & Filterable> void setAdapter(T adapter) {
        this.mSearchView.setAdapter(adapter);
    }

    private int applyDp(int valueDp) {
        return (int)TypedValue.applyDimension((int)1, (float)valueDp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setOnStateChangeListener(OnStateChangeListener l) {
        this.mStateChangeListener = l;
    }

    public void setOnItemClickListener(OnItemClickListener l) {
        this.mItemClickListener = l;
    }

    public void setSearchBarClickListener(View.OnClickListener searchBarClickListener) {
        this.mSearchBarClickListener = searchBarClickListener;
    }

    public AnimatorSet startSearchForTransition() {
        return this.backEnterAnimForTransition();
    }

    public AnimatorSet endSearchForTransition() {
        return this.backExitAnimForTransition();
    }

    public void updateEnterForTransition() {
        if (this.mSearchIcon != null) {
            this.mSearchIcon.setVisibility(4);
        }
        if (this.mBackView != null) {
            this.mBackView.setVisibility(4);
        }
    }

    public void updateExitForTransition() {
        if (this.mSearchIcon != null) {
            this.mSearchIcon.setVisibility(0);
        }
        if (this.mBackView != null) {
            this.mBackView.setVisibility(0);
        }
    }

    public void setDeleteButtonVisibility(int visibility) {
        this.mDeleteAll.setVisibility(0);
    }

    public void setText(CharSequence c, boolean submit) {
        this.mCompleteInput = true;
        this.mSearchView.setText(c);
        this.mCompleteInput = false;
        if (submit) {
            this.startSearch();
        }
    }

    public void setSearchBarEnabled(boolean searchBarEnabled) {
        if (this.mSearchView == null || this.mSearchIcon == null || this.mClickView == null) {
            return;
        }
        this.mSearchView.setEnabled(searchBarEnabled);
        this.mClickView.setEnabled(searchBarEnabled);
        if (searchBarEnabled) {
            this.mSearchView.requestFocus();
            this.mSearchView.setAlpha(1.0f);
            this.mSearchIcon.setAlpha(1.0f);
            this.mClickView.setAlpha(1.0f);
        } else {
            this.mSearchView.setAlpha(0.65f);
            this.mSearchIcon.setAlpha(0.65f);
            this.mClickView.setAlpha(0.65f);
        }
        this.dealDeleteIconVisibility();
        this.dealSearchViewTextPadding();
    }

    public boolean isSearchBarEnabled() {
        return this.mSearchView.isEnabled();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mSearchView.addTextChangedListener(this.mTextWatcher);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mSearchView.removeTextChangedListener(this.mTextWatcher);
    }

    public void removeTextChangedListener(TextWatcher textWatcher) {
        this.mSearchView.removeTextChangedListener(textWatcher);
    }

    public void setInputMax(int max, int resId) {
        this.setInputMax(max, this.getResources().getString(resId));
    }

    public void setInputMax(int max, String resStr) {
        this.mSearchView.setFilters(new InputFilter[]{new OSLengthFilter(this.getContext(), max, resStr)});
    }

    private static class OSLengthFilter
    extends InputFilter.LengthFilter {
        private WeakReference<Context> mContextWeakReference;
        private int mTextNum;
        private Toast mToast;
        private String mTipInputMax;

        public OSLengthFilter(Context context, int max, String tipInputMax) {
            super(max);
            if (context != null) {
                this.mContextWeakReference = new WeakReference<Context>(context);
                this.mTextNum = max;
                this.mTipInputMax = tipInputMax;
            }
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            CharSequence result = super.filter(source, start, end, dest, dstart, dend);
            if (dest == null) {
                return result;
            }
            int length = dest.length();
            Context context = (Context)this.mContextWeakReference.get();
            if (context != null && length >= this.mTextNum && length != 0 && result != null) {
                if (TextUtils.isEmpty((CharSequence)this.mTipInputMax)) {
                    return result;
                }
                if (this.mToast == null) {
                    this.mToast = Toast.makeText((Context)context, (CharSequence)this.mTipInputMax, (int)1);
                }
                this.mToast.show();
            }
            return result;
        }
    }

    public class BackClickListener
    implements View.OnClickListener {
        public void onClick(View v) {
            SearchBar.this.endSearch();
        }
    }

    public class SearchBarTextWatcher
    implements TextWatcher {
        public void beforeTextChanged(CharSequence s, int start, int before, int count) {
            if (SearchBar.this.mCompleteInput) {
                return;
            }
        }

        @CallSuper
        public void onTextChanged(CharSequence s, int start, int before, int count) {
            SearchBar.this.dealDeleteIconVisibility();
            SearchBar.this.dealSearchViewTextPadding();
            if (SearchBar.this.mCompleteInput) {
                return;
            }
        }

        public void afterTextChanged(Editable editable) {
            if (SearchBar.this.mCompleteInput) {
                return;
            }
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(AdapterView<?> var1, View var2, int var3, long var4);
    }

    public static interface OnStateChangeListener {
        public void onSearchStart();

        public void onSearchEnd();
    }

    private class WidthWrapper {
        private View view;

        public WidthWrapper(View view) {
            this.view = view;
        }

        public int getWidth() {
            return this.view.getLayoutParams().width;
        }

        public void setWidth(int width) {
            this.view.getLayoutParams().width = width;
            this.view.requestLayout();
        }
    }
}

