/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.blur.task;

import com.transsion.widgetslib.blur.task.AsyncBlurTask;
import com.transsion.widgetslib.blur.util.Preconditions;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class BlurTaskManager {
    private static final String TAG = BlurTaskManager.class.getSimpleName();
    private static final int EXECUTOR_THREADS = Runtime.getRuntime().availableProcessors() <= 3 ? 1 : Runtime.getRuntime().availableProcessors() / 2;
    private static final ExecutorService ASYNC_BLUR_EXECUTOR = Executors.newFixedThreadPool(EXECUTOR_THREADS);
    private static final ExecutorService CONCURRENT_BLUR_EXECUTOR = Executors.newFixedThreadPool(EXECUTOR_THREADS);

    private BlurTaskManager() {
    }

    public static BlurTaskManager getInstance() {
        return BlurTaskManagerHolder.INSTANCE;
    }

    public Future submit(AsyncBlurTask task) {
        Preconditions.checkNotNull(task, "task == null");
        return ASYNC_BLUR_EXECUTOR.submit(task);
    }

    private static class BlurTaskManagerHolder {
        private static final BlurTaskManager INSTANCE = new BlurTaskManager();

        private BlurTaskManagerHolder() {
        }
    }
}

