/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.util;

import android.app.Activity;
import android.app.Dialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Insets;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.Display;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import androidx.core.content.ContextCompat;
import com.transsion.widgetscore.utils.CoreUtils;
import com.transsion.widgetslib.R;
import java.io.InputStream;
import java.lang.reflect.Method;

public class Utils {
    private static final int GESTURE_ON = 2;
    public static final int HIOS = 0;
    public static final int XOS = 1;
    public static final int ITE = 2;
    public static final String[] mOsType = CoreUtils.mOsType;
    public static final int[] mBackIcon = new int[]{R.drawable.os_ic_back_hios, R.drawable.os_ic_back_xos, R.drawable.os_ic_back_itel};
    public static final int[] mCloseIcon = new int[]{R.drawable.os_ic_close_hios, R.drawable.os_ic_close_xos, R.drawable.os_ic_close_itel};
    public static final int[] mSaveIcon = new int[]{R.drawable.os_ic_save_hios, R.drawable.os_ic_save_xos, R.drawable.os_ic_save_itel};
    public static final int[] mSearchIcon = new int[]{R.drawable.os_ic_search_hios, R.drawable.os_ic_search_xos, R.drawable.os_ic_search_itel};
    public static final int[] mEditIcon = new int[]{R.drawable.os_ic_edit_hios, R.drawable.os_ic_edit_xos, R.drawable.os_ic_edit_itel};
    public static final int[] mMoreIcon = new int[]{R.drawable.os_ic_more_hios, R.drawable.os_ic_more_xos, R.drawable.os_ic_more_itel};
    public static final int[] mSettingsIcon = new int[]{R.drawable.os_ic_settings_hios, R.drawable.os_ic_settings_xos, R.drawable.os_ic_settings_itel};
    public static final int[] mAddIcon = new int[]{R.drawable.os_ic_add_hios, R.drawable.os_ic_add_xos, R.drawable.os_ic_add_itel};
    private static final String TAG = "widgetslib.Utils";
    private static int WATERFALL_SCREEN_STATE = -1;
    private static final int WATERFALL_SCREEN_STATE_NO = 0;
    private static final int WATERFALL_SCREEN_STATE_YES = 1;
    private static final int WATERFALL_SCREEN_STATE_NO_INIT = -1;
    private static int OLED_SCREEN_STATE = -1;
    private static final int OLED_SCREEN_STATE_NO = 0;
    private static final int OLED_SCREEN_STATE_YES = 1;
    private static final int OLED_SCREEN_STATE_NO_INIT = -1;
    private static final String KEY_OLED = "ro.transsion.lcd.type";
    private static final String VALUE_OLED = "1";
    public static final int PLATFORM_MTK = 1;
    public static final int PLATFORM_SPRD = 2;
    public static String OS_TYPE = Utils.getSystemProperties("ro.tranos.type");
    public static boolean IS_4D_VIBRATE_SUPPORT = CoreUtils.IS_4D_VIBRATE_SUPPORT;

    private static int getAppTheme(boolean withActionBar) {
        String osType = Utils.getOsType();
        if (TextUtils.isEmpty((CharSequence)osType)) {
            int themeId = R.style.OS_Theme_Material_hios;
            return themeId;
        }
        int themeId = osType.equalsIgnoreCase(mOsType[0]) ? (withActionBar ? R.style.OS_Theme_Material_hios : R.style.OS_Theme_Material_hios_NoActionBar) : (osType.equalsIgnoreCase(mOsType[1]) ? (withActionBar ? R.style.OS_Theme_Material_xos : R.style.OS_Theme_Material_xos_NoActionBar) : (withActionBar ? R.style.OS_Theme_Material_itel : R.style.OS_Theme_Material_itel_NoActionBar));
        return themeId;
    }

    private static int getAppTheme(int hiosTheme, int xosTheme, int itelTheme) {
        String osType = Utils.getOsType();
        if (TextUtils.isEmpty((CharSequence)osType)) {
            return hiosTheme;
        }
        if (osType.equalsIgnoreCase(mOsType[2])) {
            return itelTheme;
        }
        if (osType.equalsIgnoreCase(mOsType[1])) {
            return xosTheme;
        }
        return hiosTheme;
    }

    @Deprecated
    public static void setAppTheme(Context context, boolean withActionBar) {
        int themeId = Utils.getAppTheme(withActionBar);
        context.setTheme(themeId);
    }

    public static void setAppTheme(Context context, int hiosTheme, int xosTheme, int itelTheme) {
        Utils.setAppTheme(context, hiosTheme, xosTheme, itelTheme, true);
    }

    public static void setAppTheme(Context context, int hiosTheme, int xosTheme, int itelTheme, boolean forePadding) {
        Utils.setAppTheme(context, hiosTheme, xosTheme, itelTheme, forePadding, true);
    }

    public static void setAppTheme(Context context, int hiosTheme, int xosTheme, int itelTheme, boolean forePadding, boolean modifiyWindowInset) {
        int themeId = Utils.getAppTheme(hiosTheme, xosTheme, itelTheme);
        context.setTheme(themeId);
        if (context instanceof ContextThemeWrapper && Build.VERSION.SDK_INT >= 30) {
            Resources.Theme theme = context.getTheme();
            boolean isWaterfallScreen = Utils.isWaterfallScreen(context);
            boolean isOLED = Utils.isOLED();
            if (isOLED) {
                theme.applyStyle(R.style.OSThemOled, true);
            }
            if (isWaterfallScreen) {
                theme.applyStyle(R.style.OsCurseSupport, true);
                if (forePadding) {
                    theme.applyStyle(R.style.actionbar_no_force_padding, true);
                }
                Utils.setCustomStylesValues(context, theme, forePadding);
                if (modifiyWindowInset) {
                    Utils.setWindowInset(context);
                }
            }
        }
    }

    private static void setCustomStylesValues(Context context, Resources.Theme theme, boolean isForce) {
        Window window;
        if (context instanceof Activity && Build.VERSION.SDK_INT >= 30 && (window = ((Activity)context).getWindow()) != null) {
            int rotation = context.getDisplay().getRotation();
            switch (rotation) {
                case 1: {
                    if (!isForce) {
                        theme.applyStyle(Utils.isRtl() ? R.style.OSThemeCurve_90_RTL : R.style.OSThemeCurve_90, true);
                    } else {
                        theme.applyStyle(R.style.OSThemeCurve_90_no_force_padding, true);
                    }
                    theme.applyStyle(R.style.popup_menu_curse_90, true);
                    break;
                }
                case 3: {
                    if (!isForce) {
                        theme.applyStyle(Utils.isRtl() ? R.style.OSThemeCurve_270_RTL : R.style.OSThemeCurve_270, true);
                    } else {
                        theme.applyStyle(R.style.OSThemeCurve_270_no_force_padding, true);
                    }
                    theme.applyStyle(R.style.popup_menu_curse_270, true);
                    break;
                }
                default: {
                    if (!isForce) {
                        theme.applyStyle(R.style.OSThemeCurve_0_180, true);
                    } else {
                        theme.applyStyle(R.style.OSThemeCurve_0_180_no_force_padding, true);
                    }
                    theme.applyStyle(R.style.popup_menu_curse, true);
                }
            }
        }
    }

    public static void setWindowInset(final Context context) {
        if (context instanceof Activity && Build.VERSION.SDK_INT >= 30) {
            ((Activity)context).getWindow().getDecorView().setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){

                public WindowInsets onApplyWindowInsets(View v, WindowInsets insets) {
                    if (context == null) {
                        return insets;
                    }
                    Insets systemBars = insets.getInsets(WindowInsets.Side.all());
                    Display display = context.getDisplay();
                    boolean isGestureNavigationBarOn = Utils.isGestureNavigationBarOn(context);
                    if (display != null) {
                        insets = display.getRotation() == 1 ? new WindowInsets.Builder(insets).setInsets(WindowInsets.Type.systemBars() | WindowInsets.Type.displayCutout(), Insets.of((int)0, (int)systemBars.top, (int)(isGestureNavigationBarOn ? 0 : systemBars.right), (int)0)).build() : (display.getRotation() == 3 ? new WindowInsets.Builder(insets).setInsets(WindowInsets.Type.systemBars() | WindowInsets.Type.displayCutout(), Insets.of((int)(isGestureNavigationBarOn ? 0 : systemBars.left), (int)systemBars.top, (int)0, (int)0)).build() : new WindowInsets.Builder(insets).setInsets(WindowInsets.Side.all(), Insets.of((int)0, (int)systemBars.top, (int)0, (int)systemBars.bottom)).build());
                    }
                    return v.onApplyWindowInsets(insets);
                }
            });
        }
    }

    public static boolean isGestureNavigationBarOn(Context context) {
        return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"navigation_mode", (int)0) == 2;
    }

    public static int getNavigationBarHeight(Resources resources) {
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        int height = resources.getDimensionPixelSize(resourceId);
        return height;
    }

    public static int getPlatformIcon(int[] icons) {
        String osType = Utils.getOsType();
        int iconId = osType.equalsIgnoreCase(mOsType[1]) ? icons[1] : (osType.equalsIgnoreCase(mOsType[2]) ? icons[2] : icons[0]);
        return iconId;
    }

    public static String getOsType() {
        String value = null;
        try {
            Class<?> cls = Class.forName("android.os.SystemProperties");
            Method getMethod = cls.getMethod("get", String.class);
            value = (String)getMethod.invoke(cls, "ro.tranos.type");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static void setDialogWindowBackGround(Context context, final Dialog dialog, final boolean cancelable, final boolean cancelOutSide) {
        Drawable windowBackGroundDrawable;
        if (dialog == null) {
            Log.i((String)TAG, (String)"setDialogWindowBackGround dialog null return");
            return;
        }
        Resources res = context.getResources();
        boolean isWaterFall = Utils.isWaterfallScreen(context);
        if (res.getConfiguration().orientation == 1) {
            windowBackGroundDrawable = Utils.isGestureNavigationBarOn(context) ? ContextCompat.getDrawable((Context)context, (int)(isWaterFall ? R.drawable.os_dialog_background_nav_gone_curve : R.drawable.os_dialog_background_nav_gone)) : ContextCompat.getDrawable((Context)context, (int)(isWaterFall ? R.drawable.os_dialog_background_curve : R.drawable.os_dialog_background));
            dialog.getWindow().setGravity(80);
        } else {
            windowBackGroundDrawable = ContextCompat.getDrawable((Context)context, (int)(isWaterFall ? R.drawable.os_dialog_background_land_curve : R.drawable.os_dialog_background_land));
            dialog.getWindow().setGravity(17);
        }
        dialog.getWindow().setBackgroundDrawable(windowBackGroundDrawable);
        dialog.getWindow().getDecorView().setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (cancelable && cancelOutSide) {
                    if (motionEvent.getAction() == 1 && dialog != null && dialog.isShowing()) {
                        dialog.cancel();
                    }
                    return true;
                }
                return false;
            }
        });
    }

    public static void setInputDialogWindowBackGround(Context context, Window window) {
        if (window == null) {
            Log.i((String)TAG, (String)"setDialogWindowBackGround window null return");
            return;
        }
        Resources res = context.getResources();
        boolean isWaterFall = Utils.isWaterfallScreen(context);
        Drawable windowBackGroundDrawable = res.getConfiguration().orientation == 1 ? (Utils.isGestureNavigationBarOn(context) ? ContextCompat.getDrawable((Context)context, (int)(isWaterFall ? R.drawable.os_input_dialog_background_nav_gone_curve : R.drawable.os_input_dialog_background_nav_gone)) : ContextCompat.getDrawable((Context)context, (int)(isWaterFall ? R.drawable.os_input_dialog_background_curve : R.drawable.os_input_dialog_background))) : ContextCompat.getDrawable((Context)context, (int)(isWaterFall ? R.drawable.os_dialog_background_land_curve : R.drawable.os_dialog_background_land));
        window.setBackgroundDrawable(windowBackGroundDrawable);
    }

    public static int getReflectFieldInt(String className, String fieldName) {
        return CoreUtils.getReflectFieldInt((String)className, (String)fieldName);
    }

    public static Bitmap compressBitmap(Context context, Drawable icon, int reqSize) {
        return CoreUtils.compressBitmap((Context)context, (Drawable)icon, (int)reqSize);
    }

    public static byte[] inputStreamToByteArray(InputStream in) {
        return CoreUtils.inputStreamToByteArray((InputStream)in);
    }

    public static InputStream drawable2InputStream(Context context, Drawable drawable2, int reqSize) {
        return CoreUtils.drawable2InputStream((Context)context, (Drawable)drawable2, (int)reqSize);
    }

    public static Bitmap drawable2Bitmap(Context context, Drawable drawable2, int reqSize) {
        return CoreUtils.drawable2Bitmap((Context)context, (Drawable)drawable2, (int)reqSize);
    }

    public static InputStream bitmap2InputStream(Bitmap bm) {
        return CoreUtils.bitmap2InputStream((Bitmap)bm);
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        return CoreUtils.calculateInSampleSize((BitmapFactory.Options)options, (int)reqWidth, (int)reqHeight);
    }

    public static boolean is24HourFormat(Context context) {
        return CoreUtils.is24HourFormat((Context)context);
    }

    public static boolean isRtl() {
        return CoreUtils.isRtl();
    }

    public static boolean isRtlDigit() {
        return CoreUtils.isRtlDigit();
    }

    public static boolean isWaterfallScreen(Context context) {
        return CoreUtils.isWaterfallScreen((Context)context);
    }

    public static boolean isOLED() {
        return CoreUtils.isOLED();
    }

    public static String getSystemProperties(String key) {
        return CoreUtils.getSystemProperties((String)key);
    }

    public static int getHardwareType() {
        return CoreUtils.getHardwareType();
    }

    public static float measureTextHeight(Paint paint) {
        return CoreUtils.measureTextHeight((Paint)paint);
    }

    public static boolean isBoldTextAdjustment(Context context) {
        return CoreUtils.isBoldTextAdjustment((Context)context);
    }

    public static boolean isDarkMode(Context context) {
        return CoreUtils.isDarkMode((Context)context);
    }

    public static int dp2px(Context context, int dpValues) {
        return CoreUtils.dp2px((Context)context, (int)dpValues);
    }

    public static int sp2px(int sp) {
        return CoreUtils.sp2px((int)sp);
    }

    public static int getOsPlatformBasicColor(Context context) {
        return CoreUtils.getOsPlatformBasicColor((Context)context);
    }

    public static Bitmap drawableToBitmap(Drawable drawable2) {
        return CoreUtils.drawableToBitmap((Drawable)drawable2);
    }

    public static boolean isXOSorITEL() {
        return TextUtils.equals((CharSequence)mOsType[1], (CharSequence)OS_TYPE) || TextUtils.equals((CharSequence)mOsType[2], (CharSequence)OS_TYPE);
    }
}

