/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.damping;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.recyclerview.widget.RecyclerView;
import com.transsion.effectengine.bounceeffect.BounceEdgeEffect;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.view.OverBoundNestedScrollView;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class OSScrollbarLayout
extends FrameLayout {
    private static final int TYPE_RECYCLER_VIEW = 1;
    private static final int TYPE_SCROLL_VIEW = 0;
    private static final String TAG = OSScrollbarLayout.class.getSimpleName();
    private int mBarPullMinLen;
    private int mBarMinLen;
    private int mBarMarginRight;
    private int mBarMarginTop;
    private int mBarWidth;
    private int mBarCanSlideDistance;
    private int mScrollRange;
    private int mOverViewHeight;
    private int mLayoutContentCanSlideDistance;
    private int mBarTop;
    private int mBarBottom;
    private boolean mHasScrollBar;
    private View mViewScrollBar;
    private final Rect mRect = new Rect();
    private ValueAnimator mAnimScrollBarFade;
    private View mViewOver;
    private SpringAnimation mSpringAnimTopEdge;
    private SpringAnimation mSpringAnimBottomEdge;
    private DynamicAnimation.OnAnimationUpdateListener mTopEdgeAnimListener;
    private DynamicAnimation.OnAnimationUpdateListener mBottomEdgeAnimListener;
    private int mLayoutType = 0;
    private boolean mIsDownScroll;
    private final Runnable mRunnableFade = new Runnable(){

        @Override
        public void run() {
            OSScrollbarLayout.this.cancelAnim((Animator)OSScrollbarLayout.this.mAnimScrollBarFade);
            OSScrollbarLayout.this.playAnimScrollBarFade();
        }
    };

    public OSScrollbarLayout(Context context) {
        super(context);
        this.init(null);
    }

    public OSScrollbarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context.obtainStyledAttributes(attrs, R.styleable.OSScrollbarLayout));
    }

    public OSScrollbarLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context.obtainStyledAttributes(attrs, R.styleable.OSScrollbarLayout, defStyle, 0));
    }

    private void init(TypedArray typedArray) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        int defBarMarginRight = (int)TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)metrics);
        int defBarMarginTop = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)metrics);
        int defBarWidth = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)metrics);
        if (typedArray == null) {
            this.mBarMarginRight = defBarMarginRight;
            this.mBarMarginTop = defBarMarginTop;
            this.mBarWidth = defBarWidth;
        } else {
            this.mBarMarginRight = typedArray.getDimensionPixelOffset(R.styleable.OSScrollbarLayout_os_scrollbar_margin_right, defBarMarginRight);
            this.mBarMarginTop = typedArray.getDimensionPixelOffset(R.styleable.OSScrollbarLayout_os_scrollbar_margin_top, defBarMarginTop);
            this.mBarWidth = typedArray.getDimensionPixelOffset(R.styleable.OSScrollbarLayout_os_scrollbar_width, defBarWidth);
            typedArray.recycle();
        }
        this.mBarPullMinLen = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)metrics);
        this.mBarMinLen = (int)TypedValue.applyDimension((int)1, (float)60.0f, (DisplayMetrics)metrics);
    }

    private void initAnimScrollBarFade() {
        this.mAnimScrollBarFade = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.mAnimScrollBarFade.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mAnimScrollBarFade.setDuration((long)this.mViewOver.getScrollBarFadeDuration());
        this.mAnimScrollBarFade.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Object object = animation.getAnimatedValue();
                if (object instanceof Float) {
                    OSScrollbarLayout.this.mViewScrollBar.setAlpha(((Float)object).floatValue());
                }
            }
        });
    }

    private void playAnimScrollBarFade() {
        if (this.mViewScrollBar == null || !this.mHasScrollBar) {
            return;
        }
        if (this.mAnimScrollBarFade == null) {
            this.initAnimScrollBarFade();
        }
        this.mAnimScrollBarFade.cancel();
        this.mViewScrollBar.setAlpha(1.0f);
        this.mAnimScrollBarFade.setStartDelay((long)this.mViewOver.getScrollBarDefaultDelayBeforeFade() * 4L);
        this.mAnimScrollBarFade.start();
    }

    public void onOverScrollUpdated(float offset) {
        if (this.mViewScrollBar == null || !this.mHasScrollBar) {
            return;
        }
        this.cancelAnim((Animator)this.mAnimScrollBarFade);
        if (this.mViewScrollBar.getAlpha() != 1.0f) {
            this.mViewScrollBar.setAlpha(1.0f);
        }
        float abs = Math.abs(offset);
        if (offset > 0.0f) {
            this.updateScrollBarBottom(abs);
        } else if (offset < 0.0f) {
            this.updateScrollBarTop((int)abs);
        } else {
            this.mRect.top = this.mBarTop;
            this.mRect.bottom = this.mBarBottom;
            this.sendScrollBarFadeMsg();
        }
        this.mViewScrollBar.layout(this.mRect.left, this.mRect.top, this.mRect.right, this.mRect.bottom);
    }

    private void updateScrollBarBottom(float abs) {
        this.mRect.bottom = (int)((float)this.mBarBottom - abs);
        if (this.mRect.bottom <= this.mBarPullMinLen + this.mBarTop) {
            this.mRect.bottom = this.mBarPullMinLen + this.mBarTop;
        }
    }

    private void updateScrollBarTop(int abs) {
        this.mRect.top = abs + this.mBarTop;
        if (this.mRect.top + this.mBarPullMinLen >= this.mBarBottom) {
            this.mRect.top = this.mBarBottom - this.mBarPullMinLen;
        }
    }

    public void setOverScrollView(View viewOver) {
        Object view;
        if (viewOver == null) {
            return;
        }
        this.mViewOver = viewOver;
        if (Build.VERSION.SDK_INT >= 29) {
            viewOver.setVerticalScrollbarThumbDrawable((Drawable)new ColorDrawable(0));
            viewOver.setVerticalScrollBarEnabled(true);
        }
        if (viewOver instanceof RecyclerView) {
            this.mLayoutType = 1;
            view = (RecyclerView)viewOver;
            view.addOnScrollListener(new RecyclerView.OnScrollListener((RecyclerView)view){
                final /* synthetic */ RecyclerView val$view;
                {
                    this.val$view = recyclerView;
                }

                public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);
                    OSScrollbarLayout.this.mIsDownScroll = dy > 0;
                    int scrollOffset = this.val$view.computeVerticalScrollOffset();
                    int scrollRange = this.val$view.computeVerticalScrollRange();
                    OSScrollbarLayout.this.updateScrollBar((View)this.val$view, scrollRange, scrollOffset);
                    OSScrollbarLayout.this.sendScrollBarFadeMsg();
                }
            });
        }
        if (viewOver instanceof OverBoundNestedScrollView) {
            view = (OverBoundNestedScrollView)viewOver;
            view.setOnScrollChangeListener(new View.OnScrollChangeListener((OverBoundNestedScrollView)((Object)view)){
                final /* synthetic */ OverBoundNestedScrollView val$view;
                {
                    this.val$view = overBoundNestedScrollView;
                }

                public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                    OSScrollbarLayout.this.updateScrollBar((View)this.val$view, this.val$view.computeVerticalScrollRange(), this.val$view.computeVerticalScrollOffset());
                    OSScrollbarLayout.this.sendScrollBarFadeMsg();
                }
            });
        }
        this.drawScrollBar();
    }

    private void drawScrollBar() {
        Object view;
        if (this.mViewOver instanceof RecyclerView) {
            view = (RecyclerView)this.mViewOver;
            this.postDelayed(new Runnable((RecyclerView)view){
                final /* synthetic */ RecyclerView val$view;
                {
                    this.val$view = recyclerView;
                }

                @Override
                public void run() {
                    int scrollRange = this.val$view.computeVerticalScrollRange();
                    if (OSScrollbarLayout.this.mScrollRange == scrollRange) {
                        return;
                    }
                    OSScrollbarLayout.this.mScrollRange = scrollRange;
                    int scrollOffset = this.val$view.computeVerticalScrollOffset();
                    OSScrollbarLayout.this.mOverViewHeight = 0;
                    OSScrollbarLayout.this.updateScrollBar((View)this.val$view, OSScrollbarLayout.this.mScrollRange, scrollOffset);
                    OSScrollbarLayout.this.playAnimScrollBarFade();
                }
            }, 100L);
        }
        if (this.mViewOver instanceof OverBoundNestedScrollView) {
            this.onEdgeEffect();
            view = (OverBoundNestedScrollView)this.mViewOver;
            this.postDelayed(new Runnable((OverBoundNestedScrollView)((Object)view)){
                final /* synthetic */ OverBoundNestedScrollView val$view;
                {
                    this.val$view = overBoundNestedScrollView;
                }

                @Override
                public void run() {
                    int scrollRange = this.val$view.computeVerticalScrollRange();
                    if (OSScrollbarLayout.this.mScrollRange == scrollRange) {
                        return;
                    }
                    OSScrollbarLayout.this.mScrollRange = scrollRange;
                    OSScrollbarLayout.this.mOverViewHeight = 0;
                    OSScrollbarLayout.this.updateScrollBar((View)this.val$view, OSScrollbarLayout.this.mScrollRange, this.val$view.computeVerticalScrollOffset());
                    OSScrollbarLayout.this.playAnimScrollBarFade();
                }
            }, 100L);
        }
    }

    public void updateScrollBar() {
        if (this.mViewOver == null) {
            return;
        }
        boolean invokeMethodFail = false;
        try {
            Method method = View.class.getDeclaredMethod("awakenScrollBars", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this.mViewOver, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Log.e((String)TAG, (String)"invoke awakenScrollBars error", (Throwable)e);
            invokeMethodFail = true;
        }
        if (invokeMethodFail) {
            return;
        }
        this.drawScrollBar();
    }

    private Object getFieldValue(Object obj, String fieldName) {
        Class<?> clazz = obj.getClass();
        Object object = null;
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            object = field.get(obj);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            Log.e((String)TAG, (String)"getFieldValue error", (Throwable)e);
        }
        return object;
    }

    private void updateScrollBar(View view, int scrollRange, int scrollY) {
        if (Build.VERSION.SDK_INT < 29 || view == null) {
            return;
        }
        int height = view.getHeight();
        Drawable originScrollBar = view.getVerticalScrollbarThumbDrawable();
        if (height <= 0 || height >= scrollRange || originScrollBar == null || originScrollBar.getBounds().isEmpty()) {
            Handler handler = this.getHandler();
            if (handler != null && handler.hasCallbacks(this.mRunnableFade)) {
                handler.removeCallbacks(this.mRunnableFade);
            }
            if (this.mHasScrollBar && this.mViewScrollBar != null) {
                this.cancelAnim((Animator)this.mAnimScrollBarFade);
                this.mViewScrollBar.setAlpha(0.0f);
            }
            this.mHasScrollBar = false;
            return;
        }
        if (this.mScrollRange == scrollRange && this.mOverViewHeight == height) {
            this.translateScrollBar(scrollY);
            return;
        }
        if (this.mViewScrollBar == null) {
            this.mViewScrollBar = new ScrollBarView(this.getContext());
            this.addView(this.mViewScrollBar);
            this.mViewScrollBar.setBackgroundColor(Color.parseColor((String)"#7FA1A1A1"));
            this.bringChildToFront(this.mViewScrollBar);
        }
        int translationX = view.getWidth() - this.mBarWidth - this.mBarMarginRight;
        this.mViewScrollBar.setTranslationX(Utils.isRtl() ? (float)(-translationX) : (float)translationX);
        Rect barBounds = originScrollBar.getBounds();
        ViewGroup.LayoutParams layoutParams = this.mViewScrollBar.getLayoutParams();
        layoutParams.height = barBounds.height();
        layoutParams.width = this.mBarWidth;
        if (layoutParams.height < this.mBarMinLen) {
            if (this.mBarMinLen > height) {
                this.mBarMinLen = height;
            }
            layoutParams.height = this.mBarMinLen;
        }
        this.updateViewLayout(this.mViewScrollBar, layoutParams);
        this.mLayoutContentCanSlideDistance = scrollRange - height;
        this.mBarCanSlideDistance = height - this.mBarMarginTop * 2 - layoutParams.height;
        if (this.mBarCanSlideDistance < 0) {
            this.mBarCanSlideDistance = 0;
        }
        this.mScrollRange = scrollRange;
        this.mOverViewHeight = height;
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                OSScrollbarLayout.this.mBarTop = OSScrollbarLayout.this.mViewScrollBar.getTop();
                OSScrollbarLayout.this.mBarBottom = OSScrollbarLayout.this.mViewScrollBar.getBottom();
                OSScrollbarLayout.this.mRect.set(OSScrollbarLayout.this.mViewScrollBar.getLeft(), OSScrollbarLayout.this.mBarTop, OSScrollbarLayout.this.mViewScrollBar.getRight(), OSScrollbarLayout.this.mBarBottom);
            }
        }, 60L);
        this.translateScrollBar(scrollY);
    }

    private void translateScrollBar(int scrollY) {
        if (this.mViewScrollBar != null) {
            this.mHasScrollBar = true;
            this.cancelAnim((Animator)this.mAnimScrollBarFade);
            if (this.mViewScrollBar.getAlpha() != 1.0f) {
                this.mViewScrollBar.setAlpha(1.0f);
            }
            float ratio = 1.0f * (float)scrollY / (float)this.mLayoutContentCanSlideDistance;
            float dy = ratio * (float)this.mBarCanSlideDistance;
            float calcTranslationY = (float)this.mBarMarginTop + dy;
            float translationY = this.mViewScrollBar.getTranslationY();
            if (this.mLayoutType == 1) {
                if (this.mIsDownScroll) {
                    if (calcTranslationY > translationY) {
                        this.mViewScrollBar.setTranslationY(calcTranslationY);
                    }
                } else if (calcTranslationY < translationY) {
                    this.mViewScrollBar.setTranslationY(calcTranslationY);
                }
            } else {
                this.mViewScrollBar.setTranslationY(calcTranslationY);
            }
        }
    }

    private void onEdgeEffect() {
        if (this.mViewOver == null) {
            return;
        }
        if (this.mSpringAnimTopEdge == null || this.mSpringAnimBottomEdge == null) {
            Object view;
            if (this.mViewOver instanceof RecyclerView) {
                Object bottomGlow;
                view = (RecyclerView)this.mViewOver;
                Object topGlow = this.getFieldValue(view, "mTopGlow");
                if (topGlow instanceof BounceEdgeEffect && this.mSpringAnimTopEdge == null) {
                    BounceEdgeEffect edgeGlowTop = (BounceEdgeEffect)topGlow;
                    this.mSpringAnimTopEdge = edgeGlowTop.z1OoOif;
                }
                if ((bottomGlow = this.getFieldValue(view, "mBottomGlow")) instanceof BounceEdgeEffect && this.mSpringAnimBottomEdge == null) {
                    BounceEdgeEffect edgeGlowBottom = (BounceEdgeEffect)bottomGlow;
                    this.mSpringAnimBottomEdge = edgeGlowBottom.z1OoOif;
                }
            }
            if (this.mViewOver instanceof OverBoundNestedScrollView) {
                view = (OverBoundNestedScrollView)this.mViewOver;
                if (view.getEdgeGlowTop() instanceof BounceEdgeEffect) {
                    BounceEdgeEffect edgeGlowTop = (BounceEdgeEffect)view.getEdgeGlowTop();
                    this.mSpringAnimTopEdge = edgeGlowTop.z1OoOif;
                }
                if (view.getEdgeGlowBottom() instanceof BounceEdgeEffect) {
                    BounceEdgeEffect edgeGlowBottom = (BounceEdgeEffect)view.getEdgeGlowBottom();
                    this.mSpringAnimBottomEdge = edgeGlowBottom.z1OoOif;
                }
            }
        }
        try {
            if (this.mSpringAnimTopEdge != null && this.mTopEdgeAnimListener == null) {
                this.mTopEdgeAnimListener = new DynamicAnimation.OnAnimationUpdateListener(){

                    public void onAnimationUpdate(DynamicAnimation dynamicAnimation, float offset, float v1) {
                        if (OSScrollbarLayout.this.mViewScrollBar == null) {
                            return;
                        }
                        OSScrollbarLayout.this.updateScrollBarBottom(offset);
                        OSScrollbarLayout.this.mViewScrollBar.layout(((OSScrollbarLayout)OSScrollbarLayout.this).mRect.left, ((OSScrollbarLayout)OSScrollbarLayout.this).mRect.top, ((OSScrollbarLayout)OSScrollbarLayout.this).mRect.right, ((OSScrollbarLayout)OSScrollbarLayout.this).mRect.bottom);
                    }
                };
                this.mSpringAnimTopEdge.addUpdateListener(this.mTopEdgeAnimListener);
            }
            if (this.mSpringAnimBottomEdge != null && this.mBottomEdgeAnimListener == null) {
                this.mBottomEdgeAnimListener = new DynamicAnimation.OnAnimationUpdateListener(){

                    public void onAnimationUpdate(DynamicAnimation dynamicAnimation, float offset, float v1) {
                        if (OSScrollbarLayout.this.mViewScrollBar == null) {
                            return;
                        }
                        OSScrollbarLayout.this.updateScrollBarTop((int)Math.abs(offset));
                        OSScrollbarLayout.this.mViewScrollBar.layout(((OSScrollbarLayout)OSScrollbarLayout.this).mRect.left, ((OSScrollbarLayout)OSScrollbarLayout.this).mRect.top, ((OSScrollbarLayout)OSScrollbarLayout.this).mRect.right, ((OSScrollbarLayout)OSScrollbarLayout.this).mRect.bottom);
                    }
                };
                this.mSpringAnimBottomEdge.addUpdateListener(this.mBottomEdgeAnimListener);
            }
        }
        catch (Exception e) {
            this.mBottomEdgeAnimListener = null;
            this.mTopEdgeAnimListener = null;
            Log.e((String)TAG, (String)"onEdgeEffect error", (Throwable)e);
        }
    }

    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (isVisible) {
            this.playAnimScrollBarFade();
        } else {
            this.cancelAnim((Animator)this.mAnimScrollBarFade);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.releaseResource();
    }

    private void releaseResource() {
        this.cancelAnim((Animator)this.mAnimScrollBarFade);
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.removeCallbacks(this.mRunnableFade);
        }
    }

    private void sendScrollBarFadeMsg() {
        Handler handler = this.getHandler();
        if (handler != null && this.mHasScrollBar) {
            if (Build.VERSION.SDK_INT >= 29) {
                if (handler.hasCallbacks(this.mRunnableFade)) {
                    handler.removeCallbacks(this.mRunnableFade);
                }
            } else {
                handler.removeCallbacks(this.mRunnableFade);
            }
            handler.postDelayed(this.mRunnableFade, 100L);
        }
    }

    private void cancelAnim(Animator animator) {
        if (animator != null) {
            animator.cancel();
        }
    }

    private static class ScrollBarView
    extends View {
        private final Path mPath = new Path();
        private final RectF mRectF = new RectF();

        public ScrollBarView(Context context) {
            super(context);
        }

        public ScrollBarView(Context context, @Nullable AttributeSet attrs) {
            super(context, attrs);
        }

        public ScrollBarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
        }

        public void draw(Canvas canvas) {
            this.mPath.reset();
            this.mRectF.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            this.mPath.addRoundRect(this.mRectF, (float)this.getWidth() / 2.0f, (float)this.getWidth() / 2.0f, Path.Direction.CCW);
            canvas.clipPath(this.mPath);
            super.draw(canvas);
        }
    }
}

