/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.swipmenu;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.util.Utils;
import java.util.HashMap;

public class SwipeMenuItem {
    private static HashMap<Integer, Bitmap> cacheIcon = new HashMap();
    public static final int MENUITEMTYPE_TEXT = 0;
    public static final int MENUITEMTYPE_ICON = 1;
    private Context mContext;
    private Drawable mBackground;
    private Drawable mCircleBackground;
    private Bitmap mIcon;
    private int mResId;
    private String title;
    private int titleColor;
    private int titleSize = 12;
    private Typeface textTypeface;
    private int textAppearance;
    private int iconItemWidth = 64;
    private int iconItemWidthHios = 54;
    private int textItemWidth = 82;
    private int height = -1;
    private int weight = 0;
    private int position;
    private boolean isHios;

    public int getResId() {
        return this.mResId;
    }

    public void setResId(int resId) {
        this.mResId = resId;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public SwipeMenuItem(Context context) {
        this.mContext = context;
    }

    public SwipeMenuItem(Context context, int position) {
        this.mContext = context;
        this.position = position;
        this.titleColor = Color.parseColor((String)"#FFFFFF");
        this.isHios = Utils.mOsType[0].equalsIgnoreCase(Utils.getOsType());
        this.iconItemWidth = Utils.dp2px(this.mContext, this.isHios ? this.iconItemWidthHios : this.iconItemWidth);
        this.textItemWidth = Utils.dp2px(this.mContext, this.textItemWidth);
        this.titleSize = Utils.sp2px(this.titleSize);
    }

    public SwipeMenuItem setBackground(@DrawableRes int resId) {
        return this.setBackground(ContextCompat.getDrawable((Context)this.mContext, (int)resId));
    }

    public SwipeMenuItem setBackground(Drawable background) {
        this.mBackground = background;
        return this;
    }

    public SwipeMenuItem setCircleBackground(Drawable background) {
        this.mCircleBackground = background;
        return this;
    }

    public SwipeMenuItem setBackgroundColorResource(@ColorRes int color2) {
        return this.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)color2));
    }

    public SwipeMenuItem setCircleBackgroundColorResource(@ColorRes int color2) {
        return this.setCircleBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)color2));
    }

    public SwipeMenuItem setBackgroundColor(@ColorInt int color2) {
        this.mBackground = new ColorDrawable(color2);
        return this;
    }

    public SwipeMenuItem setCircleBackgroundColor(@ColorInt int color2) {
        this.mCircleBackground = new ColorDrawable(color2);
        return this;
    }

    public Drawable getBackground() {
        return this.mBackground;
    }

    public Drawable getCircleBackground() {
        return this.mCircleBackground;
    }

    public SwipeMenuItem setImage(@DrawableRes int resId) {
        this.mResId = resId;
        return cacheIcon.containsKey(resId) ? this.setImage(cacheIcon.get(resId)) : this.setImage(SwipeMenuItem.getBitmap(this.mContext, resId));
    }

    private static Bitmap getBitmap(Context context, int resId) {
        if (Build.VERSION.SDK_INT > 21) {
            Drawable drawable2 = context.getDrawable(resId);
            Bitmap bitmap = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable2.draw(canvas);
            cacheIcon.put(resId, bitmap);
            return bitmap;
        }
        Bitmap bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)resId);
        cacheIcon.put(resId, bitmap);
        return bitmap;
    }

    public SwipeMenuItem setImage(Bitmap icon) {
        this.mIcon = icon;
        return this;
    }

    public Bitmap getImage() {
        if (cacheIcon == null || cacheIcon.isEmpty()) {
            return null;
        }
        return cacheIcon.get(this.mResId);
    }

    public SwipeMenuItem setText(@StringRes int resId) {
        return this.setText(this.mContext.getString(resId));
    }

    public SwipeMenuItem setText(String title) {
        this.title = title;
        return this;
    }

    public String getText() {
        return this.title;
    }

    public SwipeMenuItem setTextColorResource(@ColorRes int titleColor) {
        return this.setTextColor(ContextCompat.getColor((Context)this.mContext, (int)titleColor));
    }

    public SwipeMenuItem setTextColor(@ColorInt int titleColor) {
        this.titleColor = titleColor;
        return this;
    }

    public int getTitleColor() {
        return this.titleColor;
    }

    public SwipeMenuItem setTextSize(int titleSize) {
        this.titleSize = titleSize;
        return this;
    }

    public int getTextSize() {
        return this.titleSize;
    }

    public SwipeMenuItem setTextAppearance(@StyleRes int textAppearance) {
        this.textAppearance = textAppearance;
        return this;
    }

    public int getTextAppearance() {
        return this.textAppearance;
    }

    public SwipeMenuItem setTextTypeface(Typeface textTypeface) {
        this.textTypeface = textTypeface;
        return this;
    }

    public Typeface getTextTypeface() {
        return this.textTypeface;
    }

    public SwipeMenuItem setWidth(int width) {
        this.iconItemWidth = width;
        this.textItemWidth = width;
        return this;
    }

    public int getWidth() {
        return this.getType() == 0 ? this.textItemWidth : this.iconItemWidth;
    }

    public SwipeMenuItem setHeight(int height) {
        this.height = height;
        return this;
    }

    public int getHeight() {
        return this.height;
    }

    public SwipeMenuItem setWeight(int weight) {
        this.weight = weight;
        return this;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getType() {
        return this.mIcon == null ? 0 : 1;
    }

    public static void release() {
        if (cacheIcon == null) {
            return;
        }
        for (Bitmap bitmap : cacheIcon.values()) {
            if (bitmap.isRecycled()) continue;
            bitmap.recycle();
        }
        cacheIcon.clear();
        cacheIcon = null;
    }

    public static void resetCacheIcon(Context context) {
        if (cacheIcon == null) {
            return;
        }
        for (Integer resId : cacheIcon.keySet()) {
            SwipeMenuItem.getBitmap(context, resId);
        }
    }
}

