/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.editext;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.widget.editext.ExtendedEditText;
import java.lang.ref.WeakReference;

public class OSMaterialEditText
extends RelativeLayout
implements ViewTreeObserver.OnGlobalLayoutListener,
TextWatcher,
View.OnFocusChangeListener {
    private Context mContext;
    private int mType;
    private boolean mShowDelete;
    private ExtendedEditText mEditText;
    private ImageView mDeleteButton;
    private ImageView mRightImage;
    private Drawable mRightImageDrawable;
    private int NONE = 0;
    private int RIGHT = 1;
    private int RIGHT_BIG_IMAGE = 2;
    private int LEFT = 3;
    private int LEFT_BIG_IMAGE_TYPE_1 = 4;
    private int LEFT_BIG_IMAGE_TYPE_2 = 5;
    private TextView mLabel;
    private String mLabelText;
    private TextView mErrorText;
    private TextView mRightTextView;
    private String mRightText;
    private boolean mShowDivider;
    private View mRightDivider;
    private TextView mRightTextButton;
    private String mRightButtonText;
    private TextView mLeftTextView;
    private String mLeftText;
    private ImageView mLeftImage;
    private Drawable mLeftDrawable;
    private ImageView mLeftSecondImage;
    private Drawable mLeftSecondDrawable;
    private View mLeftlayout;
    private View mRightlayout;
    private View mRootLayout;
    private View mRootEditTextLayout;
    private View mUnderlineView;
    private TextView mNumText;
    private int mTextNum;
    private int mErrorColor;
    private int mNormalColor;
    private int mActiveColor;
    private boolean mHasFocus;
    private boolean mShowError;
    private String mTipInputMax;
    private boolean mHasContent;
    private OnInputNumListener mOnInputNumListener;

    public OSMaterialEditText(@NonNull Context context) {
        this(context, null);
    }

    public OSMaterialEditText(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OSMaterialEditText(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.OSMaterialEditText);
        int indexCount = typedArray.getIndexCount();
        for (int at = 0; at < indexCount; ++at) {
            int index = typedArray.getIndex(at);
            if (index == R.styleable.OSMaterialEditText_os_et_layout_type) {
                this.mType = typedArray.getInt(index, 0);
                continue;
            }
            if (index == R.styleable.OSMaterialEditText_os_et_right_show_delete) {
                this.mShowDelete = typedArray.getBoolean(index, false);
                continue;
            }
            if (index == R.styleable.OSMaterialEditText_os_et_right_image) {
                this.mRightImageDrawable = typedArray.getDrawable(index);
                continue;
            }
            if (index == R.styleable.OSMaterialEditText_os_et_label) {
                this.mLabelText = typedArray.getString(index);
                continue;
            }
            if (index == R.styleable.OSMaterialEditText_os_et_right_text) {
                this.mRightText = typedArray.getString(index);
                continue;
            }
            if (index == R.styleable.OSMaterialEditText_os_et_right_show_divide_line) {
                this.mShowDivider = typedArray.getBoolean(index, false);
                continue;
            }
            if (index == R.styleable.OSMaterialEditText_os_et_left_image) {
                this.mLeftDrawable = typedArray.getDrawable(index);
                continue;
            }
            if (index == R.styleable.OSMaterialEditText_os_et_left_image_secord) {
                this.mLeftSecondDrawable = typedArray.getDrawable(index);
                continue;
            }
            if (index == R.styleable.OSMaterialEditText_os_et_left_text) {
                this.mLeftText = typedArray.getString(index);
                continue;
            }
            if (index == R.styleable.OSMaterialEditText_os_et_right_button_text) {
                this.mRightButtonText = typedArray.getString(index);
                continue;
            }
            if (index != R.styleable.OSMaterialEditText_os_et_show_error) continue;
            this.mShowError = typedArray.getBoolean(index, false);
        }
        typedArray.recycle();
        this.init();
    }

    private void init() {
        OSMaterialEditText.inflate((Context)this.mContext, (int)R.layout.os_view_materal_edit_text_layout_base, (ViewGroup)this);
        this.mTipInputMax = this.mContext.getString(R.string.os_dialog_input_tip_max);
        this.mEditText = (ExtendedEditText)this.findViewById(R.id.oet_edit_text);
        this.mLeftlayout = this.findViewById(R.id.os_et_edit_text_left_layout);
        this.mRightlayout = this.findViewById(R.id.os_et_edit_text_right_layout);
        this.mRootLayout = this.findViewById(R.id.os_et_second_root_layout);
        this.mUnderlineView = this.findViewById(R.id.os_et_underline_view);
        this.mRootEditTextLayout = this.findViewById(R.id.os_et_edit_text_root);
        this.mErrorText = (TextView)this.findViewById(R.id.os_et_edit_text_error_hint);
        this.mErrorColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_red_basic_color);
        this.mNormalColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_gray_secondary_color);
        this.mActiveColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_fill_primary_color);
        if (this.mType == this.RIGHT || this.mType == this.RIGHT_BIG_IMAGE) {
            this.mRightlayout.setVisibility(0);
            if (this.mRightImageDrawable != null) {
                this.mRightImage = (ImageView)this.findViewById(R.id.os_et_edit_image_button);
                this.mRightImage.setVisibility(0);
                this.mRightImage.setImageDrawable(this.mRightImageDrawable);
            }
            if (this.mType == this.RIGHT_BIG_IMAGE && this.mRightImageDrawable != null) {
                if (Utils.isXOSorITEL()) {
                    this.setRootPaddingRelative(this.getResources().getDimensionPixelSize(R.dimen.os_text_field_padding_xos), 0, this.getResources().getDimensionPixelSize(R.dimen.os_text_field_big_icon_magin_xos), 0);
                }
                if (this.mRightImageDrawable != null) {
                    ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mRightImage.getLayoutParams();
                    layoutParams.width = layoutParams.height = this.getResources().getDimensionPixelSize(R.dimen.os_text_field_big_icon_size);
                    layoutParams.setMarginStart(Utils.dp2px(this.mContext, 16));
                    this.mRightImage.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                }
            }
            if (this.mShowDivider) {
                this.mRightDivider = this.findViewById(R.id.os_et_edit_text_divider);
                this.mRightDivider.setVisibility(0);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mRightButtonText)) {
                this.mRightTextButton = (TextView)this.findViewById(R.id.os_et_edit_text_right_text_button);
                this.mRightTextButton.setVisibility(0);
                this.mRightTextButton.setText((CharSequence)this.mRightButtonText);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mRightText)) {
                this.mRightTextView = (TextView)this.findViewById(R.id.os_et_edit_text_right_text);
                this.mRightTextView.setVisibility(0);
                this.mRightTextView.setText((CharSequence)this.mRightText);
            }
        } else if (this.mType == this.LEFT || this.mType == this.LEFT_BIG_IMAGE_TYPE_1 || this.mType == this.LEFT_BIG_IMAGE_TYPE_2) {
            this.mLeftlayout.setVisibility(0);
            if (!TextUtils.isEmpty((CharSequence)this.mLeftText)) {
                this.mLeftTextView = (TextView)this.findViewById(R.id.os_et_edit_text_left_text);
                this.mLeftTextView.setVisibility(0);
                this.mLeftTextView.setText((CharSequence)this.mLeftText);
            }
            if (this.mLeftDrawable != null) {
                this.mLeftImage = (ImageView)this.findViewById(R.id.os_et_left_edit_image_first);
                this.mLeftImage.setVisibility(0);
                this.mLeftImage.setImageDrawable(this.mLeftDrawable);
            }
            if (this.mLeftSecondDrawable != null) {
                this.mLeftSecondImage = (ImageView)this.findViewById(R.id.os_et_left_edit_image_second);
                this.mLeftSecondImage.setVisibility(0);
                this.mLeftSecondImage.setImageDrawable(this.mLeftSecondDrawable);
            }
            if (this.mType != this.LEFT) {
                ViewGroup.LayoutParams layoutParams;
                if (Utils.isXOSorITEL()) {
                    this.setRootPaddingRelative(this.getResources().getDimensionPixelSize(R.dimen.os_text_field_big_icon_magin_xos), 0, this.getResources().getDimensionPixelSize(R.dimen.os_text_field_padding_xos), 0);
                }
                if (this.mLeftDrawable != null) {
                    layoutParams = this.mLeftImage.getLayoutParams();
                    layoutParams.width = layoutParams.height = this.getResources().getDimensionPixelSize(R.dimen.os_text_field_big_icon_size);
                    this.mLeftImage.setLayoutParams(layoutParams);
                }
                if (this.mLeftSecondDrawable != null) {
                    layoutParams = this.mLeftSecondImage.getLayoutParams();
                    layoutParams.width = layoutParams.height = this.getResources().getDimensionPixelSize(R.dimen.os_text_field_big_icon_size);
                    this.mLeftSecondImage.setLayoutParams(layoutParams);
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.mLabelText)) {
            this.mLabel = (TextView)this.findViewById(R.id.os_et_edit_text_label);
            this.mLabel.setText((CharSequence)this.mLabelText);
            this.mLabel.setVisibility(0);
        }
        if (this.mShowError) {
            this.mErrorText.setVisibility(4);
        }
        if (this.mShowDelete) {
            this.mRightlayout.setVisibility(0);
            this.mDeleteButton = (ImageView)this.findViewById(R.id.os_et_edit_delete_all);
            this.mDeleteButton.setVisibility(4);
            this.mDeleteButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    OSMaterialEditText.this.mEditText.setText("");
                }
            });
        }
        this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mEditText.setSelfOnFocusChangeListener(this);
        this.mEditText.addTextChangedListener(this);
        this.afterTextChanged(this.mEditText.getText());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mEditText.setOnFocusChangeListener(null);
        this.mEditText.removeTextChangedListener(this);
    }

    public OSMaterialEditText setError(CharSequence message) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            this.mErrorText.setText(message);
            this.mErrorText.setVisibility(0);
            this.updateUnderlineView(this.mHasFocus, true);
        } else {
            this.mErrorText.setText(message);
            this.mErrorText.setVisibility(this.mShowError ? 4 : 8);
            this.updateUnderlineView(this.mHasFocus, false);
        }
        return this;
    }

    public OSMaterialEditText setTipInputMax(@StringRes int resId) {
        return this.setTipInputMax(this.mContext.getString(resId));
    }

    public OSMaterialEditText setTipInputMax(String tipText) {
        this.mTipInputMax = tipText;
        return this;
    }

    public OSMaterialEditText setErrorLine(boolean error) {
        this.updateUnderlineView(this.mHasFocus, error);
        return this;
    }

    public void updateTextPadding() {
        if (this.mType == this.LEFT_BIG_IMAGE_TYPE_2) {
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mRootEditTextLayout.getLayoutParams();
            layoutParams.setMarginStart(this.mLeftlayout.getMeasuredWidth());
            this.mRootEditTextLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mEditText.setPaddingRelative(0, 0, this.mRightlayout.getMeasuredWidth(), 0);
        } else {
            this.mEditText.setPaddingRelative(this.mLeftlayout.getMeasuredWidth(), 0, this.mRightlayout.getMeasuredWidth(), 0);
        }
    }

    public void setRootPaddingRelative(int start, int top, int end, int bottom) {
        this.mRootLayout.setPaddingRelative(start, top, end, bottom);
    }

    public void onGlobalLayout() {
        this.updateTextPadding();
        this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
    }

    public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
    }

    public void updateUnderlineView(boolean hasFocus, boolean error) {
        if (error) {
            this.mUnderlineView.setBackgroundColor(this.mErrorColor);
        } else if (hasFocus) {
            this.mUnderlineView.setBackgroundColor(this.mActiveColor);
        } else {
            this.mUnderlineView.setBackgroundColor(this.mNormalColor);
        }
    }

    public void afterTextChanged(Editable editable) {
        int length = editable.length();
        this.mHasContent = length > 0;
        this.updateDeleteButton(this.mHasContent, this.mHasFocus);
        if (this.mNumText != null && this.mNumText.getVisibility() == 0) {
            if (length < this.mTextNum) {
                this.mNumText.setText((CharSequence)new StringBuilder().append(String.format("%d", length)).append("/").append(String.format("%d", this.mTextNum)));
            } else if (length == this.mTextNum) {
                this.mNumText.setText((CharSequence)new StringBuilder().append(String.format("%d", this.mTextNum)).append("/").append(String.format("%d", this.mTextNum)));
            }
        }
        if (this.mOnInputNumListener != null) {
            this.mOnInputNumListener.onInputNum(editable, this.mNumText);
        }
    }

    public OSMaterialEditText setInputNum(int textNum, @Nullable OnInputNumListener listener) {
        this.mNumText = (TextView)this.findViewById(R.id.os_et_edit_text_help_hint);
        if (textNum <= 0) {
            this.mTextNum = -1;
            this.mNumText.setVisibility(8);
        } else {
            this.mTextNum = textNum;
            this.mNumText.setVisibility(0);
            this.mEditText.setFilters(new InputFilter[]{new OSLengthFilter(this, textNum)});
        }
        this.mOnInputNumListener = listener;
        return this;
    }

    public void onFocusChange(View v, boolean hasFocus) {
        this.mHasFocus = hasFocus;
        if (this.mErrorText != null && this.mErrorText.getVisibility() == 0) {
            this.updateUnderlineView(hasFocus, true);
        } else {
            this.updateUnderlineView(hasFocus, false);
        }
        this.updateDeleteButton(this.mHasContent, hasFocus);
    }

    public void updateDeleteButton(boolean hasContent, boolean hasFocus) {
        this.mHasFocus = hasFocus = hasFocus || this.mEditText.hasFocus();
        if (this.mDeleteButton != null && this.mShowDelete) {
            if (hasContent && hasFocus) {
                this.mDeleteButton.setVisibility(0);
                this.updateTextPadding();
            } else {
                this.mDeleteButton.setVisibility(4);
                this.updateTextPadding();
            }
        }
    }

    public ExtendedEditText getEditText() {
        return this.mEditText;
    }

    @Nullable
    public ImageView getDeleteButton() {
        return this.mDeleteButton;
    }

    @Nullable
    public ImageView getRightImage() {
        return this.mRightImage;
    }

    @Nullable
    public TextView getEditTextLabel() {
        return this.mLabel;
    }

    @Nullable
    public TextView getErrorText() {
        return this.mErrorText;
    }

    @Nullable
    public TextView getRightText() {
        return this.mRightTextView;
    }

    @Nullable
    public TextView getRightTextButton() {
        return this.mRightTextButton;
    }

    @Nullable
    public View getRightDivider() {
        return this.mRightDivider;
    }

    @Nullable
    public View getLeftlayout() {
        return this.mLeftlayout;
    }

    @Nullable
    public View getRightlayout() {
        return this.mRightlayout;
    }

    @Nullable
    public View getRootLayout() {
        return this.mRootLayout;
    }

    @Nullable
    public View getRootEditTextLayout() {
        return this.mRootEditTextLayout;
    }

    @Nullable
    public View getUnderlineView() {
        return this.mUnderlineView;
    }

    @Nullable
    public TextView getLeftTextView() {
        return this.mLeftTextView;
    }

    @Nullable
    public ImageView getLeftImage() {
        return this.mLeftImage;
    }

    @Nullable
    public ImageView getLeftSecondImage() {
        return this.mLeftSecondImage;
    }

    @Nullable
    public TextView getNumTextView() {
        return this.mNumText;
    }

    private static class OSLengthFilter
    extends InputFilter.LengthFilter {
        private WeakReference<OSMaterialEditText> mOSMaterialEditText;
        private int mTextNum;
        private Toast mToast;

        public OSLengthFilter(OSMaterialEditText osMaterialEditText, int max) {
            super(max);
            if (osMaterialEditText != null) {
                this.mOSMaterialEditText = new WeakReference<OSMaterialEditText>(osMaterialEditText);
                this.mTextNum = max;
            }
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            CharSequence result = super.filter(source, start, end, dest, dstart, dend);
            if (dest == null) {
                return result;
            }
            int length = dest.length();
            OSMaterialEditText osMaterialEditText = (OSMaterialEditText)((Object)this.mOSMaterialEditText.get());
            if (osMaterialEditText != null && length >= this.mTextNum && length != 0) {
                String tipInputMax = osMaterialEditText.mTipInputMax;
                if (tipInputMax == null || tipInputMax.isEmpty()) {
                    return result;
                }
                if (this.mToast == null) {
                    this.mToast = Toast.makeText((Context)osMaterialEditText.mContext, (CharSequence)tipInputMax, (int)1);
                }
                this.mToast.show();
            }
            return result;
        }
    }

    public static interface OnInputNumListener {
        public void onInputNum(Editable var1, TextView var2);
    }
}

