/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.anim;

import android.view.View;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FloatPropertyCompat;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import java.util.HashSet;

@Deprecated
public class OSPressSpringAnimation {
    private HashSet<SpringAnimation> mSpringAnimation;
    private final float mStartValue;
    private final float mFinalValue;
    private final View mView;
    private final float mStiffness;
    private final float mDampingRatio;
    private OnOSSpringAnimationEndListener mOSSpringAnimationEndListener;

    private OSPressSpringAnimation(Builder builder) {
        this.mStartValue = builder.startValue;
        this.mFinalValue = builder.finalValue;
        this.mView = builder.view;
        this.mStiffness = builder.stiffness;
        this.mDampingRatio = builder.dampingRatio;
        this.init();
    }

    private void init() {
        this.mSpringAnimation = new HashSet();
        SpringForce springForce = new SpringForce().setStiffness(this.mStiffness).setDampingRatio(this.mDampingRatio);
        springForce.setFinalPosition(this.mFinalValue);
        this.mSpringAnimation.add(this.initAnimation(springForce, true));
        this.mSpringAnimation.add(this.initAnimation(springForce, false));
    }

    private SpringAnimation initAnimation(SpringForce springForce, boolean isX) {
        SpringAnimation animation = isX ? new SpringAnimation((Object)this.mView, (FloatPropertyCompat)DynamicAnimation.SCALE_X) : new SpringAnimation((Object)this.mView, (FloatPropertyCompat)DynamicAnimation.SCALE_Y);
        animation.setSpring(springForce);
        animation.setStartValue(this.mStartValue);
        animation.setMinimumVisibleChange(0.002f);
        return animation;
    }

    public void start() {
        final int[] size = new int[]{this.mSpringAnimation.size()};
        if (this.mSpringAnimation.size() > 0) {
            for (SpringAnimation springAnimation : this.mSpringAnimation) {
                springAnimation.start();
                if (this.mOSSpringAnimationEndListener == null) continue;
                springAnimation.addEndListener(new DynamicAnimation.OnAnimationEndListener(){

                    public void onAnimationEnd(DynamicAnimation animation, boolean canceled, float value, float velocity) {
                        size[0] = size[0] - 1;
                        if (size[0] == 0) {
                            OSPressSpringAnimation.this.mOSSpringAnimationEndListener.onAnimationEnd(false, value);
                        }
                    }
                });
            }
        }
    }

    public void cancel() {
        if (this.mSpringAnimation.size() > 0) {
            for (SpringAnimation springAnimation : this.mSpringAnimation) {
                springAnimation.cancel();
            }
        }
    }

    public boolean isRunning() {
        if (this.mSpringAnimation.size() > 0) {
            for (SpringAnimation springAnimation : this.mSpringAnimation) {
                if (!springAnimation.isRunning()) continue;
                return true;
            }
        }
        return false;
    }

    public void addEndListener(OnOSSpringAnimationEndListener OSSpringAnimationEndListener) {
        this.mOSSpringAnimationEndListener = OSSpringAnimationEndListener;
    }

    public static class Builder {
        private float startValue = 1.0f;
        private float finalValue;
        private View view;
        private float stiffness = 790.0f;
        private float dampingRatio = 1.2f;

        public Builder startValue(float startValue) {
            this.startValue = startValue;
            return this;
        }

        public Builder finalValue(float finalValue) {
            this.finalValue = finalValue;
            return this;
        }

        public Builder view(View view) {
            this.view = view;
            return this;
        }

        public Builder stiffness(float stiffness) {
            this.stiffness = stiffness;
            return this;
        }

        public Builder dampingRatio(float dampingRatio) {
            this.dampingRatio = dampingRatio;
            return this;
        }

        public OSPressSpringAnimation build() {
            if (this.view == null) {
                throw new IllegalStateException("view == null");
            }
            if (this.finalValue == 0.0f) {
                throw new IllegalStateException("finalValue == null");
            }
            return new OSPressSpringAnimation(this);
        }
    }

    public static interface OnOSSpringAnimationEndListener {
        public void onAnimationEnd(boolean var1, float var2);
    }
}

