/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.blur;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import com.transsion.widgetslib.blur.Blur;
import com.transsion.widgetslib.blur.processor.BlurProcessor;

public class DynamicBlur {
    private View mBlurredView;
    private View mBlurView;
    private Bitmap mBlurBitmap;
    private Canvas mBlurringCanvas;
    private BlurProcessor mProcessor;
    private int mBlurRadius = 13;
    private int mCanvasScalFactor = 3;
    private float mBlurSampleFactor = 1.0f;
    private int mBlurMode = 2;
    private int mBlurScheme = 1001;
    private int mTransitonX = 0;
    private int mTransitonY = 0;
    private Bitmap mBlurredBitmap;
    private final int[] mBluredViewScreenPos = new int[2];
    private final int[] mBlurViewScreenPos = new int[2];
    private BitmapDrawable mBluredDrawable;
    private Context mContext;
    private int mEraseColor = Color.parseColor((String)"#F7F7F7");

    public DynamicBlur(Context context) {
        this.mContext = context;
        this.init(context);
    }

    private void init(Context context) {
        this.mProcessor = Blur.with(context).scheme(this.mBlurScheme).processor();
    }

    public DynamicBlur setBlurProcessor(BlurProcessor processor) {
        if (processor != null) {
            this.mProcessor = processor;
        }
        return this;
    }

    private Bitmap updateBlurData() {
        boolean isPrepared = this.prepare();
        View blurredView = this.mBlurredView;
        View blurView = this.mBlurView;
        Bitmap blurBitmap = this.mBlurBitmap;
        Canvas mBlurCanvas = this.mBlurringCanvas;
        if (isPrepared && blurredView != null && blurView != null && blurBitmap != null && mBlurCanvas != null) {
            if (blurredView.getBackground() != null && blurredView.getBackground() instanceof ColorDrawable) {
                blurBitmap.eraseColor(((ColorDrawable)blurredView.getBackground()).getColor());
            } else {
                blurBitmap.eraseColor(this.mEraseColor);
            }
            mBlurCanvas.save();
            blurredView.getLocationOnScreen(this.mBluredViewScreenPos);
            blurView.getLocationOnScreen(this.mBlurViewScreenPos);
            int translateX = this.mBluredViewScreenPos[0] - this.mBlurViewScreenPos[0] - this.mTransitonX;
            int translateY = this.mBluredViewScreenPos[1] - this.mBlurViewScreenPos[1] - this.mTransitonY;
            mBlurCanvas.translate((float)translateX, (float)translateY);
            blurredView.draw(mBlurCanvas);
            mBlurCanvas.restore();
            if (this.mBlurredBitmap != null && this.mBlurredBitmap != this.mBlurBitmap && !this.mBlurredBitmap.isRecycled()) {
                this.mBlurredBitmap.recycle();
            }
            this.mBlurredBitmap = this.mProcessor.blur(blurBitmap);
            return this.mBlurredBitmap;
        }
        return null;
    }

    private boolean prepare() {
        View blurView = this.mBlurView;
        if (blurView == null) {
            return false;
        }
        int width = blurView.getWidth();
        int height = blurView.getHeight();
        if (this.mProcessor != null) {
            this.mProcessor.mode(this.mBlurMode);
            this.mProcessor.radius(this.mBlurRadius);
            this.mProcessor.sampleFactor(this.mBlurSampleFactor);
        }
        boolean needNewCanvas = false;
        int scaledWidth = (int)Math.ceil((float)width / (float)this.mCanvasScalFactor);
        int scaleHeight = (int)Math.ceil((float)height / (float)this.mCanvasScalFactor);
        if (scaledWidth < 1 || scaleHeight < 1) {
            return false;
        }
        if (this.mBlurBitmap == null) {
            this.mBlurBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaleHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            needNewCanvas = true;
        } else if (scaledWidth != this.mBlurBitmap.getWidth() || scaleHeight != this.mBlurBitmap.getHeight()) {
            if (!this.mBlurBitmap.isRecycled()) {
                this.mBlurBitmap.recycle();
                this.mBlurBitmap = null;
            }
            this.mBlurBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaleHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            needNewCanvas = true;
        }
        if (this.mBlurBitmap == null) {
            return false;
        }
        if (needNewCanvas) {
            this.mBlurringCanvas = new Canvas(this.mBlurBitmap);
            this.mBlurringCanvas.scale(1.0f / (float)this.mCanvasScalFactor, 1.0f / (float)this.mCanvasScalFactor);
        }
        return this.mBlurringCanvas != null;
    }

    public DynamicBlur setBlurredView(View blurredView) {
        this.mBlurredView = blurredView;
        return this;
    }

    public DynamicBlur setBlurView(View blurView) {
        this.mBlurView = blurView;
        return this;
    }

    public DynamicBlur setTransitonX(int mTransitonX) {
        this.mTransitonX = mTransitonX;
        return this;
    }

    public DynamicBlur setTransitonY(int mTransitonY) {
        this.mTransitonY = mTransitonY;
        return this;
    }

    public DynamicBlur setBlurRadius(int blurRadius) {
        if (blurRadius >= 0) {
            this.mBlurRadius = blurRadius;
        }
        return this;
    }

    public DynamicBlur setCanvasScalFactor(int canvasScalFactor) {
        if (canvasScalFactor >= 1) {
            this.mCanvasScalFactor = canvasScalFactor;
        }
        return this;
    }

    public DynamicBlur release() {
        if (this.mBlurBitmap != null && !this.mBlurBitmap.isRecycled()) {
            this.mBlurBitmap.recycle();
        }
        if (this.mBlurredBitmap != null && this.mBlurredBitmap != this.mBlurBitmap && !this.mBlurredBitmap.isRecycled()) {
            this.mBlurredBitmap.recycle();
        }
        this.mBlurredView = null;
        return this;
    }

    public DynamicBlur setBlurMode(int mode) {
        this.mBlurMode = mode;
        return this;
    }

    public DynamicBlur updateBlurViewBackground() {
        Bitmap bgbitmap = this.updateBlurData();
        View blurView = this.mBlurView;
        if (bgbitmap != null && this.mContext != null && blurView != null) {
            if (this.mBluredDrawable == null) {
                this.mBluredDrawable = new BitmapDrawable(this.mContext.getResources(), bgbitmap);
                blurView.setBackground((Drawable)this.mBluredDrawable);
            } else if (bgbitmap != this.mBluredDrawable.getBitmap() && Build.VERSION.SDK_INT >= 31) {
                this.mBluredDrawable.setBitmap(bgbitmap);
            }
        }
        return this;
    }

    public DynamicBlur setEraseColor(int color2) {
        this.mEraseColor = color2;
        return this;
    }
}

