/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.blur.processor;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import com.transsion.widgetslib.blur.api.IBlurBuild;
import com.transsion.widgetslib.blur.api.IBlurResultDispatcher;
import com.transsion.widgetslib.blur.processor.BlurProcessor;
import com.transsion.widgetslib.blur.processor.BlurProcessorFactory;
import com.transsion.widgetslib.blur.task.AndroidBlurResultDispatcher;
import com.transsion.widgetslib.blur.task.AsyncBlurTask;
import java.util.concurrent.Future;

public class BlurBuild
implements IBlurBuild {
    int mMode = 2;
    int mScheme = 1001;
    int mRadius = 5;
    float mSampleFactor = 5.0f;
    boolean mIsForceCopy = false;
    boolean mNeedUpscale = true;
    int mTranslateX = 0;
    int mTranslateY = 0;
    IBlurResultDispatcher mDispatcher = AndroidBlurResultDispatcher.MAIN_THREAD_DISPATCHER;
    Context mCtx;

    public BlurBuild(Context context) {
        this.mCtx = context;
    }

    @Override
    public IBlurBuild context(Context context) {
        this.mCtx = context;
        return this;
    }

    @Override
    public IBlurBuild mode(int mode) {
        this.mMode = mode;
        return this;
    }

    @Override
    public IBlurBuild scheme(int scheme) {
        this.mScheme = scheme;
        return this;
    }

    @Override
    public IBlurBuild radius(int radius) {
        this.mRadius = radius;
        return this;
    }

    @Override
    public IBlurBuild sampleFactor(float sampleFactor) {
        this.mSampleFactor = sampleFactor;
        return this;
    }

    @Override
    public IBlurBuild forceCopy(boolean isForceCopy) {
        this.mIsForceCopy = isForceCopy;
        return this;
    }

    @Override
    public IBlurBuild needUpscale(boolean needUpscale) {
        this.mNeedUpscale = needUpscale;
        return this;
    }

    @Override
    public IBlurBuild translateX(int translateX) {
        this.mTranslateX = translateX;
        return this;
    }

    @Override
    public IBlurBuild translateY(int translateY) {
        this.mTranslateY = translateY;
        return this;
    }

    @Override
    public IBlurBuild dispatcher(IBlurResultDispatcher dispatcher) {
        this.mDispatcher = dispatcher;
        return this;
    }

    @Override
    public BlurProcessor processor() {
        return BlurProcessorFactory.getBlurProcessor(this.mScheme, this);
    }

    @Override
    public Bitmap blur(Bitmap bitmap) {
        BlurProcessor processor = this.processor();
        return processor.blur(bitmap);
    }

    @Override
    public Bitmap blur(View view) {
        BlurProcessor processor = this.processor();
        return processor.blur(view);
    }

    @Override
    public Future asyncBlur(Bitmap bitmap, AsyncBlurTask.Callback callback) {
        BlurProcessor processor = this.processor();
        return processor.asyncBlur(bitmap, callback);
    }

    @Override
    public Future asyncBlur(View view, AsyncBlurTask.Callback callback) {
        BlurProcessor processor = this.processor();
        return processor.asyncBlur(view, callback);
    }
}

