/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.blur.processor;

import android.content.Context;
import android.graphics.Bitmap;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.util.Log;
import com.transsion.widgetslib.blur.processor.BlurBuild;
import com.transsion.widgetslib.blur.processor.BlurProcessor;
import com.transsion.widgetslib.blur.util.MathUtil;
import com.transsion.widgetslib.blur.util.Preconditions;
import com.transsion.widgetslib.renderscript.ScriptC_BoxBlur;
import com.transsion.widgetslib.renderscript.ScriptC_StackBlur;

class RenderScriptBlurProcessor
extends BlurProcessor {
    private static final String TAG = RenderScriptBlurProcessor.class.getSimpleName();
    private RenderScript mRenderScript;
    private ScriptIntrinsicBlur mGaussianBlurScript;
    private ScriptC_BoxBlur mBoxBlurScript;
    private ScriptC_StackBlur mStackBlurScript;
    private Allocation mAllocationIn;
    private Allocation mAllocationOut;
    private Bitmap mLastBitemap;
    private static final int RS_MAX_RADIUS = 25;
    private volatile boolean rsRuntimeInited = false;

    RenderScriptBlurProcessor(BlurBuild builder) {
        super(builder);
        this.init(builder.mCtx);
    }

    private void init(Context context) {
        Preconditions.checkNotNull(context, "Please set context for renderscript scheme, forget to set context for builder?");
        try {
            this.mRenderScript = RenderScript.create((Context)context.getApplicationContext());
            this.mGaussianBlurScript = ScriptIntrinsicBlur.create((RenderScript)this.mRenderScript, (Element)Element.U8_4((RenderScript)this.mRenderScript));
            this.mBoxBlurScript = new ScriptC_BoxBlur(this.mRenderScript);
            this.mStackBlurScript = new ScriptC_StackBlur(this.mRenderScript);
            this.rsRuntimeInited = true;
        }
        catch (RSRuntimeException e) {
            Log.e((String)TAG, (String)"Failed to init RenderScript runtime", (Throwable)e);
            this.rsRuntimeInited = false;
        }
    }

    @Override
    protected Bitmap doInnerBlur(Bitmap bitmap, boolean concurrent) {
        Preconditions.checkNotNull(bitmap, "scaledInBitmap == null");
        if (!this.rsRuntimeInited) {
            Log.e((String)TAG, (String)"RenderScript Runtime is not initialized");
            return bitmap;
        }
        if (this.mAllocationOut == null) {
            this.mAllocationIn = Allocation.createFromBitmap((RenderScript)this.mRenderScript, (Bitmap)bitmap);
            this.mAllocationOut = Allocation.createFromBitmap((RenderScript)this.mRenderScript, (Bitmap)Bitmap.createBitmap((Bitmap)bitmap));
        } else if (this.mLastBitemap != bitmap) {
            this.mAllocationIn.destroy();
            this.mAllocationOut.destroy();
            this.mAllocationIn = Allocation.createFromBitmap((RenderScript)this.mRenderScript, (Bitmap)bitmap);
            this.mAllocationOut = Allocation.createFromBitmap((RenderScript)this.mRenderScript, (Bitmap)Bitmap.createBitmap((Bitmap)bitmap));
        } else {
            this.mAllocationIn.copyFrom(bitmap);
        }
        this.mLastBitemap = bitmap;
        try {
            switch (this.mMode) {
                case 0: {
                    this.doBoxBlur(bitmap, this.mAllocationIn, this.mAllocationOut);
                    this.mAllocationIn.copyTo(bitmap);
                    break;
                }
                case 2: {
                    this.doStackBlur(bitmap, this.mAllocationIn, this.mAllocationOut);
                    this.mAllocationIn.copyTo(bitmap);
                    break;
                }
                case 1: {
                    this.doGaussianBlur(this.mAllocationIn, this.mAllocationOut);
                    this.mAllocationOut.copyTo(bitmap);
                }
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"Blur the bitmap error", (Throwable)e);
        }
        return bitmap;
    }

    private void doBoxBlur(Bitmap input, Allocation in, Allocation out) {
        if (this.mBoxBlurScript == null) {
            throw new IllegalStateException("The blur script is unavailable");
        }
        this.mBoxBlurScript.set_input(in);
        this.mBoxBlurScript.set_output(out);
        this.mBoxBlurScript.set_width(input.getWidth());
        this.mBoxBlurScript.set_height(input.getHeight());
        this.mBoxBlurScript.set_radius(this.mRadius);
        this.mBoxBlurScript.forEach_boxblur_h(in);
        this.mBoxBlurScript.set_input(out);
        this.mBoxBlurScript.set_output(in);
        this.mBoxBlurScript.forEach_boxblur_v(out);
    }

    private void doGaussianBlur(Allocation in, Allocation out) {
        if (this.mGaussianBlurScript == null) {
            throw new IllegalStateException("The blur script is unavailable");
        }
        this.mRadius = MathUtil.clamp(this.mRadius, 0, 25);
        this.mGaussianBlurScript.setRadius((float)this.mRadius);
        this.mGaussianBlurScript.setInput(in);
        this.mGaussianBlurScript.forEach(out);
    }

    private void doStackBlur(Bitmap input, Allocation in, Allocation out) {
        if (this.mStackBlurScript == null) {
            throw new IllegalStateException("The blur script is unavailable");
        }
        this.mStackBlurScript.set_input(in);
        this.mStackBlurScript.set_output(out);
        this.mStackBlurScript.set_width(input.getWidth());
        this.mStackBlurScript.set_height(input.getHeight());
        this.mStackBlurScript.set_radius(this.mRadius);
        this.mStackBlurScript.forEach_stackblur_v(in);
        this.mStackBlurScript.set_input(out);
        this.mStackBlurScript.set_output(in);
        this.mStackBlurScript.forEach_stackblur_h(out);
    }

    @Override
    protected void free() {
        if (this.mAllocationIn != null) {
            this.mAllocationIn.destroy();
        }
        if (this.mAllocationOut != null) {
            this.mAllocationOut.destroy();
        }
        this.mLastBitemap = null;
    }

    protected void finalize() throws Throwable {
        this.free();
        super.finalize();
    }
}

