/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.damping;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowInsets;
import android.view.WindowManager;
import android.view.WindowMetrics;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.SpringAnimation;
import com.transsion.effectengine.bounceeffect.BounceEdgeEffect;
import com.transsion.effectengine.bounceeffect.IOverScrollDecor;
import com.transsion.effectengine.bounceeffect.IOverScrollListener;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.view.LoadingView;
import com.transsion.widgetslib.view.OverBoundNestedScrollView;
import com.transsion.widgetslib.widget.timepicker.wheel.EaseCubicInterpolator;

@Deprecated
public class DampingLayout
extends OverBoundNestedScrollView {
    private static final String TAG = DampingLayout.class.getSimpleName();
    private static final int ANIM_DURATION = 300;
    private static final float REFRESHING_START_ALPHA = 0.0f;
    private static final float REFRESHING_DELTA_ALPHA = 1.0f;
    private static final float REFRESHING_START_SCALE = 0.5f;
    private static final float REFRESHING_DELTA_SCALE = 0.5f;
    private static final float REFRESHING_START_SCALE_LOADING_VIEW = 0.2f;
    private static final float REFRESHING_DELTA_SCALE_LOADING_VIEW = 0.8f;
    private int mHeightRefreshLayout;
    private int mLoadingViewHeight;
    private LoadingView mLoadingView;
    private TextView mTextRefreshing;
    private Runnable mRunnable;
    private float mTextRefreshingTransDistance;
    private float mLoadingViewTransDistance;
    private float mOverScrollDistance;
    private boolean mIsAbortRefreshing;
    private OnRefreshListener mOnRefreshListener;
    private boolean mIsRefreshing;
    private View mLayoutContent;
    private EaseCubicInterpolator mCubicInterpolator;
    private ValueAnimator mAnimatorUnfold;
    private ValueAnimator mAnimRefreshFinish;
    private IOverScrollDecor mOverScrollDecor;
    private int mDampingMode;
    private boolean mIsLimitDampingEdge;
    private int mBarPullMinLen;
    private int mBarMinLen;
    private final int mBarMarginRight;
    private final int mBarMarginTop;
    private int mBarWidth;
    private int mBarCanSlideDistance;
    private int mLayoutContentHeight;
    private int mDampingLayoutHeight;
    private int mLayoutContentCanSlideDistance;
    private boolean mHasScrollBar;
    private View mViewScrollBar;
    private final Rect mRect = new Rect();
    private ValueAnimator mAnimScrollBarFade;
    private Activity mActivity;
    private float mOffsetY;
    private int mUseScene;
    private final Runnable mRunnableFade = new Runnable(){

        @Override
        public void run() {
            DampingLayout.this.cancelAnim((Animator)DampingLayout.this.mAnimScrollBarFade);
            DampingLayout.this.mAnimScrollBarFade.setStartDelay((long)DampingLayout.this.getScrollBarDefaultDelayBeforeFade());
            DampingLayout.this.mAnimScrollBarFade.start();
        }
    };

    public DampingLayout(Context context) {
        this(context, null);
    }

    public DampingLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public DampingLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.DampingLayout, defStyle, 0);
        this.mDampingMode = typedArray.getInt(R.styleable.DampingLayout_os_damping_mode, 0);
        this.mUseScene = typedArray.getInt(R.styleable.DampingLayout_os_damping_bar_use_scene, 0);
        this.mBarMarginRight = typedArray.getDimensionPixelOffset(R.styleable.DampingLayout_os_damping_bar_margin_right, (int)TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)metrics));
        this.mBarMarginTop = typedArray.getDimensionPixelOffset(R.styleable.DampingLayout_os_damping_bar_margin_top, 0);
        this.mBarWidth = typedArray.getDimensionPixelOffset(R.styleable.DampingLayout_os_damping_bar_width, (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)metrics));
        this.mIsLimitDampingEdge = typedArray.getBoolean(R.styleable.DampingLayout_os_limit_damping_edge, true);
        typedArray.recycle();
        this.init();
    }

    private void init() {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mTextRefreshingTransDistance = TypedValue.applyDimension((int)1, (float)15.0f, (DisplayMetrics)metrics);
        this.mLoadingViewTransDistance = TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)metrics);
        this.mHeightRefreshLayout = this.getResources().getDimensionPixelSize(R.dimen.os_damping_layout_loading_title);
        this.mLoadingViewHeight = this.getResources().getDimensionPixelSize(R.dimen.os_damping_layout_loading_view);
        this.mTextRefreshingTransDistance += (float)this.mLoadingViewHeight;
        this.mBarPullMinLen = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)metrics);
        this.mBarMinLen = (int)TypedValue.applyDimension((int)1, (float)60.0f, (DisplayMetrics)metrics);
        if (this.getContext() instanceof Activity) {
            this.mActivity = (Activity)this.getContext();
        }
        if (Build.VERSION.SDK_INT >= 29) {
            this.setVerticalScrollbarThumbDrawable((Drawable)new ColorDrawable(0));
            this.setVerticalScrollBarEnabled(true);
        }
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mDampingMode == 0 || this.mUseScene == 0) {
            this.initUpOverScroll();
        } else if (this.mUseScene == 1) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    DampingLayout.this.initUpOverScroll();
                }
            }, 100L);
        }
    }

    private void initUpOverScroll() {
        if (this.mOverScrollDecor != null) {
            return;
        }
        this.mOverScrollDecor = this.setUpOverScroll();
        if (this.mOverScrollDecor == null) {
            return;
        }
        IOverScrollListener overScrollListener = new IOverScrollListener(){

            public void onOverScrollUpdated(float offset) {
                DampingLayout.this.handleOverScrollDistance(offset);
            }
        };
        this.mOverScrollDecor.setOverScrollListener(overScrollListener);
        this.onEdgeEffect();
    }

    private void handleOverScrollDistance(float offset) {
        this.onOverPull(offset);
        this.mOverScrollDistance = offset;
        if (this.mIsRefreshing && offset == 0.0f && this.mIsAbortRefreshing) {
            this.refreshFinishAnim();
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() != 1) {
            return;
        }
        this.mLayoutContent = this.getChildAt(0);
        this.mLayoutContent.setNestedScrollingEnabled(false);
        this.mLayoutContent.setVerticalScrollBarEnabled(false);
        if (this.mDampingMode == 0) {
            this.setFillViewport(true);
            this.mCubicInterpolator = new EaseCubicInterpolator(0.25f, 0.0f, 0.0f, 1.0f);
            ViewGroup.LayoutParams layoutParams = this.mLayoutContent.getLayoutParams();
            this.removeView(this.mLayoutContent);
            View layoutRefresh = DampingLayout.inflate((Context)this.getContext(), (int)R.layout.os_damping_layout_title, null);
            FrameLayout layoutParent = new FrameLayout(this.getContext());
            layoutParent.addView(layoutRefresh, -1, this.mHeightRefreshLayout);
            layoutParent.addView(this.mLayoutContent, -1, -1);
            this.addView((View)layoutParent, layoutParams);
            this.mTextRefreshing = (TextView)this.findViewById(R.id.damping_text_loading);
            this.mTextRefreshing.setScaleX(0.5f);
            this.mTextRefreshing.setScaleY(this.mTextRefreshing.getScaleX());
            this.mTextRefreshing.setAlpha(0.0f);
            this.mLoadingView = (LoadingView)this.findViewById(R.id.loading_view);
            this.mLoadingView.setScaleX(0.2f);
            this.mLoadingView.setScaleY(this.mLoadingView.getScaleX());
            this.mLoadingView.setAlpha(0.0f);
            this.mLoadingView.setAutoAnim(false);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.releaseResource();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mOverScrollDecor == null) {
            return super.dispatchTouchEvent(ev);
        }
        if (!this.mIsRefreshing && this.mDampingMode == 0) {
            this.handleTouchEvent(ev);
        }
        return super.dispatchTouchEvent(ev);
    }

    private void handleTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 2: {
                if (!(this.mOverScrollDistance > 0.0f)) break;
                if (this.mOverScrollDistance <= (float)this.mHeightRefreshLayout) {
                    this.mLayoutContent.setTranslationY(this.mOverScrollDistance);
                    this.mTextRefreshing.setText(R.string.os_dampingl_down_pull_refresh);
                    this.refreshTitleLayout(this.mOverScrollDistance);
                    break;
                }
                this.mTextRefreshing.setText(R.string.os_dampingl_release_for_refresh);
                if (!(this.mLayoutContent.getTranslationY() < (float)this.mHeightRefreshLayout)) break;
                this.playAnimatorUnfold();
                break;
            }
            case 1: 
            case 3: {
                if (this.mOverScrollDistance >= (float)this.mHeightRefreshLayout) {
                    this.mIsRefreshing = true;
                    this.mTextRefreshing.setText(R.string.os_dampingl_refreshing);
                    this.mLoadingView.start();
                    if (this.mLayoutContent.getTranslationY() < (float)this.mHeightRefreshLayout) {
                        this.playAnimatorUnfold();
                    }
                    if (this.mOnRefreshListener == null) {
                        if (this.mRunnable == null) {
                            this.mRunnable = new Runnable(){

                                @Override
                                public void run() {
                                    DampingLayout.this.refreshFinishAnim();
                                }
                            };
                        }
                        if (this.getHandler() == null) break;
                        this.getHandler().postDelayed(this.mRunnable, 2000L);
                        break;
                    }
                    this.mOnRefreshListener.onRefresh();
                    break;
                }
                this.refreshFinishAnim();
                break;
            }
        }
    }

    public void abortRefreshing() {
        if (this.mOverScrollDistance == 0.0f) {
            this.mIsAbortRefreshing = false;
            if (this.mIsRefreshing) {
                this.refreshFinishAnim();
            }
        } else {
            this.mIsAbortRefreshing = true;
            this.mLoadingView.release();
            this.mTextRefreshing.setText(R.string.os_dampingl_refresh_finish);
        }
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (DampingLayout.this.computeVerticalScrollRange() > DampingLayout.this.getHeight()) {
                    DampingLayout.this.cancelAnim((Animator)DampingLayout.this.mAnimScrollBarFade);
                    if (DampingLayout.this.mViewScrollBar != null && DampingLayout.this.mViewScrollBar.getAlpha() != 1.0f) {
                        DampingLayout.this.mViewScrollBar.setAlpha(1.0f);
                    }
                    DampingLayout.this.sendScrollBarFadeMsg();
                }
            }
        }, 60L);
        this.awakenScrollBars();
    }

    private void releaseResource() {
        Handler handler;
        this.cancelAnim((Animator)this.mAnimatorUnfold);
        this.cancelAnim((Animator)this.mAnimRefreshFinish);
        this.cancelAnim((Animator)this.mAnimScrollBarFade);
        if (this.mLoadingView != null) {
            this.mLoadingView.release();
        }
        if ((handler = this.getHandler()) != null) {
            if (this.mRunnable != null) {
                handler.removeCallbacks(this.mRunnable);
            }
            handler.removeCallbacks(this.mRunnableFade);
        }
    }

    private void playAnimatorUnfold() {
        if (this.mAnimatorUnfold == null) {
            this.mAnimatorUnfold = ValueAnimator.ofFloat((float[])new float[0]);
        }
        if (this.mAnimatorUnfold.isRunning()) {
            return;
        }
        this.mAnimatorUnfold.setFloatValues(new float[]{this.mLayoutContent.getTranslationY(), this.mHeightRefreshLayout});
        this.mAnimatorUnfold.setDuration(50L);
        this.mAnimatorUnfold.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mAnimatorUnfold.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Object object = animation.getAnimatedValue();
                if (object instanceof Float) {
                    float distance = ((Float)object).floatValue();
                    DampingLayout.this.mLayoutContent.setTranslationY(distance);
                    DampingLayout.this.refreshTitleLayout(distance);
                }
            }
        });
        this.mAnimatorUnfold.start();
    }

    private void refreshFinishAnim() {
        float translationY = this.mLayoutContent.getTranslationY();
        if (translationY < 0.0f) {
            return;
        }
        if (this.mAnimRefreshFinish == null) {
            this.mAnimRefreshFinish = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
            this.mAnimRefreshFinish.setDuration(300L);
            this.mAnimRefreshFinish.setInterpolator((TimeInterpolator)this.mCubicInterpolator);
            this.mAnimRefreshFinish.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    Object object = animation.getAnimatedValue();
                    if (object instanceof Float) {
                        float distance = ((Float)object).floatValue();
                        DampingLayout.this.mLayoutContent.setTranslationY(distance);
                        DampingLayout.this.refreshTitleLayout(distance);
                    }
                }
            });
            this.mAnimRefreshFinish.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    DampingLayout.this.mIsRefreshing = false;
                    DampingLayout.this.mIsAbortRefreshing = false;
                    DampingLayout.this.mTextRefreshing.setText(R.string.os_dampingl_refresh_finish);
                    DampingLayout.this.mLoadingView.release();
                }
            });
        }
        this.mAnimRefreshFinish.setFloatValues(new float[]{translationY, 0.0f});
        this.mAnimRefreshFinish.start();
    }

    private void refreshTitleLayout(float distance) {
        try {
            if (distance > (float)this.mHeightRefreshLayout) {
                return;
            }
            float percent = distance / (float)this.mHeightRefreshLayout;
            this.mTextRefreshing.setScaleX(0.5f + 0.5f * percent);
            this.mTextRefreshing.setScaleY(this.mTextRefreshing.getScaleX());
            this.mTextRefreshing.setAlpha(0.0f + 1.0f * percent);
            float translationY = distance;
            if (translationY > this.mTextRefreshingTransDistance) {
                translationY = this.mTextRefreshingTransDistance;
            }
            this.mTextRefreshing.setTranslationY(translationY);
            translationY = distance - (float)this.mLoadingViewHeight;
            if (translationY > this.mLoadingViewTransDistance) {
                translationY = this.mLoadingViewTransDistance;
            }
            this.mLoadingView.setScaleX(0.2f + 0.8f * percent);
            this.mLoadingView.setScaleY(this.mLoadingView.getScaleX());
            this.mLoadingView.setAlpha(0.0f + 1.0f * percent);
            this.mLoadingView.setTranslationY(translationY);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"refreshTitleLayout, error", (Throwable)e);
        }
    }

    public void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
    }

    public boolean isRefreshing() {
        return this.mIsRefreshing;
    }

    public void setTextColor(int color2) {
        if (this.mTextRefreshing != null) {
            this.mTextRefreshing.setTextColor(color2);
        }
    }

    public LoadingView getLoadingView() {
        return this.mLoadingView;
    }

    private void initAnimScrollBarFade() {
        this.mAnimScrollBarFade = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        this.mAnimScrollBarFade.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mAnimScrollBarFade.setDuration((long)this.getScrollBarFadeDuration());
        this.mAnimScrollBarFade.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (DampingLayout.this.mViewScrollBar == null) {
                    return;
                }
                Object object = animation.getAnimatedValue();
                if (object instanceof Float) {
                    DampingLayout.this.mViewScrollBar.setAlpha(((Float)object).floatValue());
                }
            }
        });
    }

    private void onEdgeEffect() {
        SpringAnimation springAnimation;
        if (this.getEdgeGlowTop() instanceof BounceEdgeEffect) {
            BounceEdgeEffect edgeGlowTop = (BounceEdgeEffect)this.getEdgeGlowTop();
            springAnimation = edgeGlowTop.z1OoOif;
            if (springAnimation != null) {
                springAnimation.addUpdateListener(new DynamicAnimation.OnAnimationUpdateListener(){

                    public void onAnimationUpdate(DynamicAnimation dynamicAnimation, float offset, float v1) {
                        if (DampingLayout.this.mViewScrollBar == null) {
                            return;
                        }
                        ViewGroup.LayoutParams layoutParams = DampingLayout.this.mViewScrollBar.getLayoutParams();
                        ((DampingLayout)DampingLayout.this).mRect.bottom = (int)((float)layoutParams.height - offset);
                        if (((DampingLayout)DampingLayout.this).mRect.bottom <= DampingLayout.this.mBarPullMinLen) {
                            ((DampingLayout)DampingLayout.this).mRect.bottom = DampingLayout.this.mBarPullMinLen;
                        }
                        DampingLayout.this.mViewScrollBar.layout(((DampingLayout)DampingLayout.this).mRect.left, ((DampingLayout)DampingLayout.this).mRect.top, ((DampingLayout)DampingLayout.this).mRect.right, ((DampingLayout)DampingLayout.this).mRect.bottom);
                    }
                });
            }
        }
        if (this.getEdgeGlowBottom() instanceof BounceEdgeEffect) {
            BounceEdgeEffect edgeGlowBottom = (BounceEdgeEffect)this.getEdgeGlowBottom();
            springAnimation = edgeGlowBottom.z1OoOif;
            if (springAnimation != null) {
                springAnimation.addUpdateListener(new DynamicAnimation.OnAnimationUpdateListener(){

                    public void onAnimationUpdate(DynamicAnimation dynamicAnimation, float offset, float v1) {
                        if (DampingLayout.this.mViewScrollBar == null) {
                            return;
                        }
                        ViewGroup.LayoutParams layoutParams = DampingLayout.this.mViewScrollBar.getLayoutParams();
                        ((DampingLayout)DampingLayout.this).mRect.top = (int)Math.abs(offset);
                        if (((DampingLayout)DampingLayout.this).mRect.top + DampingLayout.this.mBarPullMinLen >= layoutParams.height) {
                            ((DampingLayout)DampingLayout.this).mRect.top = layoutParams.height - DampingLayout.this.mBarPullMinLen;
                        }
                        DampingLayout.this.mViewScrollBar.layout(((DampingLayout)DampingLayout.this).mRect.left, ((DampingLayout)DampingLayout.this).mRect.top, ((DampingLayout)DampingLayout.this).mRect.right, ((DampingLayout)DampingLayout.this).mRect.bottom);
                    }
                });
            }
        }
    }

    private void onOverPull(float offset) {
        if (this.mHasScrollBar && this.mViewScrollBar != null) {
            this.cancelAnim((Animator)this.mAnimScrollBarFade);
            if (this.mViewScrollBar.getAlpha() != 1.0f) {
                this.mViewScrollBar.setAlpha(1.0f);
            }
            ViewGroup.LayoutParams layoutParams = this.mViewScrollBar.getLayoutParams();
            float abs = Math.abs(offset);
            if (offset > 0.0f) {
                this.mRect.bottom = (int)((float)layoutParams.height - abs);
                if (this.mRect.bottom <= this.mBarPullMinLen) {
                    this.mRect.bottom = this.mBarPullMinLen;
                }
            } else if (offset < 0.0f) {
                this.mRect.top = (int)abs;
                if (this.mRect.top + this.mBarPullMinLen >= layoutParams.height) {
                    this.mRect.top = layoutParams.height - this.mBarPullMinLen;
                }
            } else {
                this.mRect.top = 0;
                this.mRect.bottom = layoutParams.height;
                this.sendScrollBarFadeMsg();
            }
            this.mViewScrollBar.layout(this.mRect.left, this.mRect.top, this.mRect.right, this.mRect.bottom);
        }
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (Build.VERSION.SDK_INT < 29) {
            return;
        }
        int contentHeight = this.computeVerticalScrollRange();
        int height = this.getHeight();
        Drawable originScrollBar = this.getVerticalScrollbarThumbDrawable();
        if (height <= 0 || height >= contentHeight || originScrollBar == null || originScrollBar.getBounds().isEmpty()) {
            if (this.mHasScrollBar && this.mViewScrollBar != null) {
                this.cancelAnim((Animator)this.mAnimScrollBarFade);
                this.mViewScrollBar.setAlpha(0.0f);
            }
            this.mHasScrollBar = false;
            return;
        }
        if (this.mLayoutContentHeight == contentHeight && this.mDampingLayoutHeight == height) {
            return;
        }
        if (this.mViewScrollBar == null) {
            ViewGroup layoutAttach = this.getBarLayoutAttach();
            if (layoutAttach == null) {
                return;
            }
            this.mViewScrollBar = new ScrollBarView(this.getContext());
            layoutAttach.addView(this.mViewScrollBar);
            this.mViewScrollBar.setBackgroundColor(Color.parseColor((String)"#7FA1A1A1"));
            layoutAttach.bringChildToFront(this.mViewScrollBar);
        }
        if (this.mUseScene == 1) {
            int translationX = this.getRight() - this.getLeft() - this.mBarWidth - this.mBarMarginRight;
            this.mViewScrollBar.setTranslationX(Utils.isRtl() ? (float)(-translationX) : (float)translationX);
            this.mOffsetY = this.getTop();
        } else {
            WindowMetrics windowMetrics;
            int[] location = new int[2];
            this.getLocationInWindow(location);
            int x = location[0];
            int y = location[1];
            int translationX = x + this.getRight() - this.getLeft() - this.mBarWidth - this.mBarMarginRight;
            int safeInsetLeft = 0;
            if (Utils.isRtl() && this.mActivity != null && this.mActivity.getWindowManager() != null && Build.VERSION.SDK_INT >= 30 && (windowMetrics = this.mActivity.getWindowManager().getCurrentWindowMetrics()) != null && windowMetrics.getBounds() != null) {
                WindowInsets windowInsets;
                Rect bounds = windowMetrics.getBounds();
                if (this.getResources().getConfiguration().orientation == 2 && (windowInsets = windowMetrics.getWindowInsets()) != null && windowInsets.getDisplayCutout() != null) {
                    safeInsetLeft = windowInsets.getDisplayCutout().getSafeInsetLeft();
                }
                translationX = x + this.mBarWidth + this.mBarMarginRight - bounds.width() + safeInsetLeft;
            }
            int resourceId = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
            int statusBarHeight = 0;
            int actionBarHeight = 0;
            if (resourceId > 0) {
                statusBarHeight = this.getResources().getDimensionPixelSize(resourceId);
            }
            if (this.mActivity != null && this.mActivity.getActionBar() != null) {
                actionBarHeight = this.mActivity.getActionBar().getHeight();
            }
            this.mOffsetY = y - statusBarHeight - actionBarHeight;
            if (this.mActivity != null && this.mActivity.getWindow() != null) {
                WindowManager.LayoutParams lp = this.mActivity.getWindow().getAttributes();
                if (lp.layoutInDisplayCutoutMode == 1) {
                    this.mOffsetY = y;
                    translationX -= safeInsetLeft;
                }
            }
            this.mViewScrollBar.setTranslationX((float)translationX);
        }
        Rect barBounds = originScrollBar.getBounds();
        ViewGroup.LayoutParams layoutParams = this.mViewScrollBar.getLayoutParams();
        layoutParams.height = barBounds.height();
        layoutParams.width = this.mBarWidth;
        if (layoutParams.height < this.mBarMinLen) {
            if (this.mBarMinLen > height) {
                this.mBarMinLen = height;
            }
            layoutParams.height = this.mBarMinLen;
        }
        ((ViewGroup)this.mViewScrollBar.getParent()).updateViewLayout(this.mViewScrollBar, layoutParams);
        this.mLayoutContentCanSlideDistance = contentHeight - height;
        this.mBarCanSlideDistance = height - layoutParams.height - this.mBarMarginTop * 2;
        if (this.mBarCanSlideDistance < 0) {
            this.mBarCanSlideDistance = 0;
        }
        this.mLayoutContentHeight = contentHeight;
        this.mDampingLayoutHeight = height;
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                DampingLayout.this.mRect.set(DampingLayout.this.mViewScrollBar.getLeft(), DampingLayout.this.mViewScrollBar.getTop(), DampingLayout.this.mViewScrollBar.getRight(), DampingLayout.this.mViewScrollBar.getBottom());
            }
        }, 100L);
        this.translateScrollBar(this.getScrollY());
    }

    private ViewGroup getBarLayoutAttach() {
        ViewGroup layoutAttach = null;
        if (this.mUseScene == 1) {
            if (this.getParent() instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)this.getParent();
                if (viewGroup instanceof FrameLayout || viewGroup instanceof RelativeLayout) {
                    layoutAttach = viewGroup;
                } else {
                    int index = viewGroup.indexOfChild((View)this);
                    ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
                    viewGroup.removeView((View)this);
                    FrameLayout frameLayout = new FrameLayout(this.getContext());
                    frameLayout.addView((View)this);
                    viewGroup.addView((View)frameLayout, index, layoutParams);
                    layoutAttach = frameLayout;
                }
            }
        } else {
            if (this.mActivity == null || this.mActivity.getWindow() == null) {
                return null;
            }
            return (ViewGroup)this.mActivity.getWindow().findViewById(0x1020002);
        }
        return layoutAttach;
    }

    @Override
    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.translateScrollBar(t);
        this.sendScrollBarFadeMsg();
    }

    private void sendScrollBarFadeMsg() {
        Handler handler = this.getHandler();
        if (handler != null) {
            if (Build.VERSION.SDK_INT >= 29) {
                if (handler.hasCallbacks(this.mRunnableFade)) {
                    handler.removeCallbacks(this.mRunnableFade);
                }
            } else {
                handler.removeCallbacks(this.mRunnableFade);
            }
            handler.postDelayed(this.mRunnableFade, 100L);
        }
    }

    private void translateScrollBar(int scrollY) {
        if (this.mViewScrollBar != null) {
            this.mHasScrollBar = true;
            this.cancelAnim((Animator)this.mAnimScrollBarFade);
            if (this.mViewScrollBar.getAlpha() != 1.0f) {
                this.mViewScrollBar.setAlpha(1.0f);
            }
            float ratio = 1.0f * (float)scrollY / (float)this.mLayoutContentCanSlideDistance;
            float dy = (float)this.mBarMarginTop + ratio * (float)this.mBarCanSlideDistance;
            this.mViewScrollBar.setTranslationY(this.mOffsetY + dy);
        }
    }

    public void onVisibilityAggregated(boolean isVisible) {
        super.onVisibilityAggregated(isVisible);
        if (isVisible) {
            if (this.mAnimScrollBarFade == null) {
                this.initAnimScrollBarFade();
            }
            if (this.mViewScrollBar != null) {
                this.mViewScrollBar.setAlpha(1.0f);
            }
            this.mAnimScrollBarFade.setStartDelay((long)this.getScrollBarDefaultDelayBeforeFade() * 4L);
            this.mAnimScrollBarFade.start();
        } else {
            this.cancelAnim((Animator)this.mAnimScrollBarFade);
        }
    }

    private void cancelAnim(Animator animator) {
        if (animator != null && animator.isRunning()) {
            animator.cancel();
        }
    }

    public void setDampingMode(int dampingMode) {
        this.mDampingMode = dampingMode;
    }

    public void setBarWidth(int barWidth) {
        this.mBarWidth = barWidth;
    }

    public void setUseScene(int useScene) {
        this.mUseScene = useScene;
    }

    public void setLimitDampingEdge(boolean limitDampingEdge) {
        this.mIsLimitDampingEdge = limitDampingEdge;
    }

    static class ScrollBarView
    extends View {
        private final Path mPath = new Path();
        private final RectF mRectF = new RectF();

        public ScrollBarView(Context context) {
            super(context);
        }

        public ScrollBarView(Context context, @Nullable AttributeSet attrs) {
            super(context, attrs);
        }

        public ScrollBarView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
        }

        public void draw(Canvas canvas) {
            this.mPath.reset();
            this.mRectF.set(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight());
            this.mPath.addRoundRect(this.mRectF, (float)this.getWidth() / 2.0f, (float)this.getWidth() / 2.0f, Path.Direction.CCW);
            canvas.clipPath(this.mPath);
            super.draw(canvas);
        }
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

