/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.animation.PathInterpolator;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.widget.timepicker.wheel.EaseCubicInterpolator;

public class OSMaskImageView
extends AppCompatImageView {
    private static final int FIRST_PHASE_ANIM_DURATION = 130;
    private static final int COMPLETE_ANIM_DURATION = 700;
    private static final float END_SCALE = 1.15f;
    private static final float START_SCALE = 1.0f;
    private final RectF mRectF = new RectF();
    private final Path mPath = new Path();
    private ValueAnimator mMaskAnimator;
    private ValueAnimator mAlphaAnimator;
    private AnimatorSet mPhaseAnimator;
    private Paint mPaint;
    private Bitmap mBitmapSrc;
    private Bitmap mBitmapDst;
    private boolean mSelected;
    private boolean mIsCanceledPhaseAnimator;
    private int mAlpha;
    private AnimatorListenerAdapter mAnimatorListenerAdapter;

    public OSMaskImageView(Context context) {
        super(context);
        this.init();
    }

    public OSMaskImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public OSMaskImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mPaint = new Paint(1);
        this.mPaint.setDither(true);
        this.mPaint.setFilterBitmap(true);
        this.initMaskAnimator();
        this.initAlphaAnimator();
        this.initPhaseAnimator();
    }

    private void initMaskAnimator() {
        this.mMaskAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
        this.mMaskAnimator.setDuration(250L);
        this.mMaskAnimator.setInterpolator((TimeInterpolator)new PathInterpolator(0.2f, 0.0f, 0.8f, 1.0f));
        this.mMaskAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Object object = animation.getAnimatedValue();
                if (object instanceof Float) {
                    float radius = ((Float)object).floatValue();
                    OSMaskImageView.this.mPath.reset();
                    OSMaskImageView.this.mPath.addCircle(OSMaskImageView.this.mRectF.centerX(), OSMaskImageView.this.mRectF.centerY(), radius, Path.Direction.CCW);
                    OSMaskImageView.this.invalidate();
                }
            }
        });
    }

    private void initAlphaAnimator() {
        this.mAlphaAnimator = ValueAnimator.ofInt((int[])new int[]{255, 0});
        this.mAlphaAnimator.setDuration(130L);
        this.mAlphaAnimator.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.01f, 0.0f, 0.1f, 1.0f));
        this.mAlphaAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Object object = animation.getAnimatedValue();
                if (object instanceof Integer && !OSMaskImageView.this.mRectF.isEmpty()) {
                    OSMaskImageView.this.mAlpha = (Integer)object;
                    OSMaskImageView.this.invalidate();
                }
            }
        });
        this.mAlphaAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                OSMaskImageView.this.mSelected = false;
                OSMaskImageView.this.setSelected(false);
            }
        });
    }

    private void initPhaseAnimator() {
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Object value = animation.getAnimatedValue();
                if (value instanceof Float) {
                    float scale = ((Float)value).floatValue();
                    OSMaskImageView.this.setScaleX(scale);
                    OSMaskImageView.this.setScaleY(scale);
                }
            }
        };
        ValueAnimator firstPhaseAnim = ValueAnimator.ofFloat((float[])new float[]{1.0f, 1.15f});
        firstPhaseAnim.setDuration(130L);
        firstPhaseAnim.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.01f, 0.0f, 0.1f, 1.0f));
        firstPhaseAnim.addUpdateListener(animatorUpdateListener);
        ValueAnimator secondPhaseAnim = ValueAnimator.ofFloat((float[])new float[]{1.15f, 1.0f});
        secondPhaseAnim.setDuration(570L);
        secondPhaseAnim.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.33f, 0.0f, 0.0f, 1.0f));
        secondPhaseAnim.addUpdateListener(animatorUpdateListener);
        this.mPhaseAnimator = new AnimatorSet();
        this.mPhaseAnimator.play((Animator)secondPhaseAnim).after((Animator)firstPhaseAnim);
        this.mPhaseAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                OSMaskImageView.this.setSelected(false);
                OSMaskImageView.this.mIsCanceledPhaseAnimator = false;
                OSMaskImageView.this.mSelected = true;
                if (OSMaskImageView.this.mAnimatorListenerAdapter != null) {
                    OSMaskImageView.this.mAnimatorListenerAdapter.onAnimationStart(animation);
                }
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                if (OSMaskImageView.this.mMaskAnimator != null && OSMaskImageView.this.mMaskAnimator.isRunning()) {
                    OSMaskImageView.this.mMaskAnimator.cancel();
                }
                OSMaskImageView.this.setSelected(!OSMaskImageView.this.mIsCanceledPhaseAnimator);
                OSMaskImageView.this.setScaleX(1.0f);
                OSMaskImageView.this.setScaleY(1.0f);
                if (OSMaskImageView.this.mAnimatorListenerAdapter != null) {
                    OSMaskImageView.this.mAnimatorListenerAdapter.onAnimationEnd(animation);
                }
            }

            public void onAnimationCancel(Animator animation) {
                super.onAnimationCancel(animation);
                OSMaskImageView.this.mIsCanceledPhaseAnimator = true;
                OSMaskImageView.this.mSelected = false;
                OSMaskImageView.this.mPath.reset();
                OSMaskImageView.this.invalidate();
                if (OSMaskImageView.this.mAnimatorListenerAdapter != null) {
                    OSMaskImageView.this.mAnimatorListenerAdapter.onAnimationCancel(animation);
                }
            }
        });
    }

    private void getSourceImage() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return;
        }
        this.mBitmapSrc = Utils.drawableToBitmap(drawable2);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.mBitmapSrc == null || width <= 0 || height <= 0 || this.mBitmapSrc.getWidth() <= 0 || this.mBitmapSrc.getHeight() <= 0) {
            return;
        }
        this.mRectF.set(0.0f, 0.0f, (float)width, (float)height);
        ColorStateList imageTintList = this.getImageTintList();
        int selectedColor = imageTintList == null ? -16776961 : imageTintList.getColorForState(new int[]{0x10100A1}, -16711936);
        this.mBitmapDst = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(this.mBitmapDst);
        float sx = 1.0f * (float)width / (float)this.mBitmapSrc.getWidth();
        canvas.scale(sx, sx);
        Paint paint = new Paint(this.mPaint);
        paint.setColor(selectedColor);
        canvas.drawBitmap(this.mBitmapSrc.extractAlpha(), 0.0f, 0.0f, paint);
        if (this.mMaskAnimator == null) {
            this.initMaskAnimator();
        }
        float radius = (float)Math.sqrt(Math.pow(1.0 * (double)this.mRectF.width() / 2.0, 2.0) + Math.pow(1.0 * (double)this.mRectF.height() / 2.0, 2.0));
        this.mMaskAnimator.setFloatValues(new float[]{0.0f, radius});
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.mSelected = selected;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mMaskAnimator != null) {
            this.mMaskAnimator.cancel();
        }
        if (this.mPhaseAnimator != null) {
            this.mPhaseAnimator.cancel();
        }
        if (this.mAlphaAnimator != null) {
            this.mAlphaAnimator.cancel();
        }
        if (this.mBitmapSrc != null && !this.mBitmapSrc.isRecycled()) {
            this.mBitmapSrc.recycle();
            this.mBitmapSrc = null;
        }
        if (this.mBitmapDst != null && !this.mBitmapDst.isRecycled()) {
            this.mBitmapDst.recycle();
            this.mBitmapDst = null;
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mBitmapSrc == null) {
            return;
        }
        if (this.mSelected) {
            canvas.save();
            canvas.clipPath(this.mPath);
            canvas.drawBitmap(this.mBitmapDst, null, this.mRectF, this.mPaint);
            canvas.restore();
        } else {
            int saveLayer = canvas.saveLayerAlpha(this.mRectF, this.mAlpha, 31);
            canvas.drawBitmap(this.mBitmapDst, null, this.mRectF, this.mPaint);
            canvas.restoreToCount(saveLayer);
        }
    }

    public void setSelectedAnim(boolean selected, AnimatorListenerAdapter animatorListenerAdapter) {
        if (this.mBitmapSrc == null) {
            this.getSourceImage();
        }
        if (this.mBitmapSrc == null) {
            return;
        }
        this.mAnimatorListenerAdapter = animatorListenerAdapter;
        if (selected) {
            if (this.mPhaseAnimator != null && this.mPhaseAnimator.isRunning()) {
                return;
            }
            if (this.mMaskAnimator == null) {
                this.initMaskAnimator();
            }
            this.mMaskAnimator.end();
            this.mMaskAnimator.start();
            if (this.mPhaseAnimator == null) {
                this.initPhaseAnimator();
            }
            for (Animator animator : this.mPhaseAnimator.getChildAnimations()) {
                animator.end();
            }
            this.mPhaseAnimator.start();
        } else {
            if (this.mAlphaAnimator != null && this.mAlphaAnimator.isRunning()) {
                return;
            }
            if (this.mAlphaAnimator == null) {
                this.initAlphaAnimator();
            }
            this.mAlphaAnimator.end();
            this.mAlphaAnimator.start();
        }
    }

    public void setSelectedAnim(boolean selected) {
        this.setSelectedAnim(selected, null);
    }

    public boolean isSelectedAnimRunning() {
        return this.mPhaseAnimator != null && this.mPhaseAnimator.isRunning();
    }

    public void cancelSelectedAnimRunning() {
        if (this.mPhaseAnimator != null) {
            this.mPhaseAnimator.cancel();
        }
    }
}

