/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.seekbar;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;

public class OSMultiSeekBar
extends View {
    private float mMin;
    private float mMax;
    private float mProgress;
    private float mTrackWidth;
    private float mSecondTTrackWidth;
    private int mTrackColor;
    private int mSecondTrackColor;
    private int mThumbColor;
    private int mThumbWidth;
    private int mProcessMarginTopBottow;
    private float mDelta;
    private float mThumbCenterX;
    private float mTrackLength;
    private boolean isThumbOnDragging;
    private float mPreThumbCenterX;
    private OnProgressChangedListener mProgressListener;
    private float mLeft;
    private float mRight;
    private final Paint mPaint;
    private final Context mContext;
    private OSMultiSeekBarBuilde mOSMultiSeekBarBuilde;
    private final Paint mCirclePaint;
    private long mStartTounchTime = 0L;
    private long mStopTounchTime = 0L;
    private float mTouchXDown;
    private float mTouchXMove;

    public OSMultiSeekBar(Context context) {
        this(context, null);
    }

    public OSMultiSeekBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OSMultiSeekBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.getConfigBuilder().build();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OSMultiSeekbar, defStyleAttr, 0);
        this.mMin = a.getFloat(R.styleable.OSMultiSeekbar_osMultiSeekbarMin, 0.0f);
        this.mMax = a.getFloat(R.styleable.OSMultiSeekbar_osMultiSeekbarMax, 100.0f);
        this.mProgress = a.getFloat(R.styleable.OSMultiSeekbar_osMultiSeekbarProgress, this.mMin);
        this.setEnabled(a.getBoolean(R.styleable.OSMultiSeekbar_android_enabled, this.isEnabled()));
        a.recycle();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mCirclePaint = new Paint();
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.initConfigByPriority();
        if (Utils.isRtl() && this.getRotation() == 0.0f) {
            this.setRotation(180.0f);
        }
    }

    private void initConfigByPriority() {
        if (this.mMin == this.mMax) {
            this.mMin = 0.0f;
            this.mMax = 100.0f;
        }
        if (this.mMin > this.mMax) {
            float tmp = this.mMax;
            this.mMax = this.mMin;
            this.mMin = tmp;
        }
        if (this.mProgress < this.mMin) {
            this.mProgress = this.mMin;
        }
        if (this.mProgress > this.mMax) {
            this.mProgress = this.mMax;
        }
        if ((float)this.mThumbWidth <= this.mSecondTTrackWidth) {
            this.mThumbWidth = (int)this.mSecondTTrackWidth + OSMultiSeekBar.dp2px(4);
        }
        this.mDelta = this.mMax - this.mMin;
        this.setProgress(this.mProgress);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int height = this.getPaddingTop() + this.mThumbWidth + this.mProcessMarginTopBottow * 2 + this.getPaddingBottom();
        this.setMeasuredDimension(OSMultiSeekBar.resolveSize((int)OSMultiSeekBar.dp2px(180), (int)widthMeasureSpec), height);
        this.mLeft = (float)this.getPaddingLeft() + (float)this.mThumbWidth * 0.5f;
        this.mRight = (float)(this.getMeasuredWidth() - this.getPaddingRight()) - this.mTrackWidth - (float)this.mThumbWidth * 0.5f;
        this.mTrackLength = this.mRight - this.mLeft;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float xLeft = this.mLeft;
        float xRight = this.mRight;
        float yTop = (float)(this.getPaddingTop() + this.mProcessMarginTopBottow) + (float)this.mThumbWidth * 0.5f;
        if (!this.isThumbOnDragging) {
            this.mThumbCenterX = xLeft + this.mTrackLength / this.mDelta * (this.mProgress - this.mMin);
        }
        this.mPaint.setColor(this.mTrackColor);
        this.mPaint.setStrokeWidth(this.mTrackWidth);
        canvas.drawLine(this.mThumbCenterX, yTop, xRight, yTop, this.mPaint);
        this.mPaint.setColor(this.mSecondTrackColor);
        this.mPaint.setStrokeWidth(this.mSecondTTrackWidth);
        canvas.drawLine(xLeft, yTop, this.mThumbCenterX, yTop, this.mPaint);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
        this.mCirclePaint.setColor(this.mThumbColor);
        float thumbInRadius = (float)this.mThumbWidth * 0.5f;
        canvas.drawCircle(this.mThumbCenterX, yTop, thumbInRadius, this.mCirclePaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.post(new Runnable(){

            @Override
            public void run() {
                OSMultiSeekBar.this.requestLayout();
            }
        });
    }

    public boolean performClick() {
        return super.performClick();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.performClick();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.isThumbOnDragging = this.isEnabled();
                if (!this.isThumbOnDragging) break;
                if (event.getX() < this.mLeft || event.getX() > this.mRight) {
                    this.isThumbOnDragging = false;
                    return false;
                }
                this.mTouchXDown = event.getX();
                this.mStartTounchTime = System.currentTimeMillis();
                if (this.mProgressListener == null) break;
                this.mProgressListener.onStartTrackingTouch(this);
                break;
            }
            case 2: {
                this.isThumbOnDragging = this.isEnabled();
                this.mStopTounchTime = System.currentTimeMillis();
                long touchDurationMove = this.mStopTounchTime - this.mStartTounchTime;
                if (!this.isThumbOnDragging) break;
                boolean flag = true;
                float x = this.calThumbCxWhenSeekStepSection(event.getX());
                this.mTouchXMove = Math.abs(x - this.mTouchXDown);
                if (x != this.mPreThumbCenterX && this.mTouchXMove > (float)OSMultiSeekBar.dp2px(1)) {
                    this.mThumbCenterX = this.mPreThumbCenterX = x;
                } else {
                    flag = false;
                }
                if (!flag) break;
                this.mProgress = this.calculateProgress();
                this.invalidate();
                if (this.mProgressListener == null) break;
                this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), true);
                break;
            }
            case 1: 
            case 3: {
                this.mStopTounchTime = System.currentTimeMillis();
                this.getParent().requestDisallowInterceptTouchEvent(false);
                long touchDurationUp = this.mStopTounchTime - this.mStartTounchTime;
                if (this.isThumbOnDragging) {
                    this.mThumbCenterX = this.mPreThumbCenterX = this.calThumbCxWhenSeekStepSection(event.getX());
                    this.mProgress = this.calculateProgress();
                    if (this.mProgressListener != null) {
                        this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), true);
                    }
                }
                this.isThumbOnDragging = false;
                if (this.mProgressListener == null) break;
                this.mProgressListener.onStopTrackingTouch(this);
            }
        }
        return this.isThumbOnDragging || super.onTouchEvent(event);
    }

    private float calThumbCxWhenSeekStepSection(float touchedX) {
        if (touchedX <= this.mLeft) {
            return this.mLeft;
        }
        if (touchedX >= this.mRight) {
            return this.mRight;
        }
        return touchedX;
    }

    private float formatFloat(float value) {
        BigDecimal bigDecimal = BigDecimal.valueOf(value);
        return bigDecimal.setScale(1, 4).floatValue();
    }

    private float calculateProgress() {
        return (this.mThumbCenterX - this.mLeft) * this.mDelta / this.mTrackLength + this.mMin;
    }

    public float getMin() {
        return this.mMin;
    }

    public float getMax() {
        return this.mMax;
    }

    public void setProgress(float progress) {
        this.mProgress = progress;
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), false);
        }
        this.postInvalidate();
    }

    public int getProgress() {
        return Math.round(this.mProgress);
    }

    public float getProgressFloat() {
        return this.mProgress;
    }

    public OnProgressChangedListener getOnProgressChangedListener() {
        return this.mProgressListener;
    }

    public void setOnProgressChangedListener(OnProgressChangedListener onProgressChangedListener) {
        this.mProgressListener = onProgressChangedListener;
    }

    public void setTrackColor(int trackColor) {
        if (this.mTrackColor != trackColor) {
            this.mTrackColor = trackColor;
            this.invalidate();
        }
    }

    public void setSecondTrackColor(int secondTrackColor) {
        if (this.mSecondTrackColor != secondTrackColor) {
            this.mSecondTrackColor = secondTrackColor;
            this.invalidate();
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("save_instance", super.onSaveInstanceState());
        bundle.putFloat("progress", this.mProgress);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mProgress = bundle.getFloat("progress");
            super.onRestoreInstanceState(bundle.getParcelable("save_instance"));
            this.setProgress(this.mProgress);
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.mSecondTrackColor = this.secondTrackColor();
            this.mThumbColor = this.thumbColor();
        } else {
            this.mSecondTrackColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_gray_primary_color);
            this.mThumbColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_gray_solid_primary_color);
        }
        this.invalidate();
    }

    private int secondTrackColor() {
        TypedValue typedValue = new TypedValue();
        if (this.mContext.getTheme().resolveAttribute(R.attr.os_platform_basic_color, typedValue, true)) {
            return ContextCompat.getColor((Context)this.mContext, (int)typedValue.resourceId);
        }
        return ContextCompat.getColor((Context)this.mContext, (int)R.color.os_platform_basic_color_hios);
    }

    private int thumbColor() {
        TypedValue typedValue = new TypedValue();
        if (this.mContext.getTheme().resolveAttribute(R.attr.os_platform_basic_color, typedValue, true)) {
            return ContextCompat.getColor((Context)this.mContext, (int)typedValue.resourceId);
        }
        return ContextCompat.getColor((Context)this.mContext, (int)R.color.os_platform_basic_color_hios);
    }

    public OSMultiSeekBarBuilde getConfigBuilder() {
        if (this.mOSMultiSeekBarBuilde == null) {
            this.mOSMultiSeekBarBuilde = new OSMultiSeekBarBuilde(this);
        }
        return this.mOSMultiSeekBarBuilde;
    }

    void config(OSMultiSeekBarBuilde builder) {
        this.mMin = builder.min;
        this.mMax = builder.max;
        this.mProgress = builder.progress;
        this.mTrackColor = builder.trackColor;
        this.mSecondTrackColor = builder.secondTrackColor;
        this.mTrackWidth = builder.trackWidth;
        this.mSecondTTrackWidth = builder.secondTrackWidth;
        this.mThumbWidth = builder.thumbWidth;
        this.mThumbColor = builder.thumbColor;
        this.mProcessMarginTopBottow = builder.processMarginTopBottow;
        this.initConfigByPriority();
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), false);
        }
        this.mOSMultiSeekBarBuilde = null;
        this.requestLayout();
    }

    static int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    static int sp2px(int sp) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static class OSMultiSeekBarBuilde {
        float min;
        float max;
        float progress;
        int trackWidth;
        int secondTrackWidth;
        int trackColor;
        int secondTrackColor;
        int thumbWidth;
        int thumbColor;
        int processMarginTopBottow;
        private WeakReference<OSMultiSeekBar> osMultiSeekbarWeakReference;

        OSMultiSeekBarBuilde(OSMultiSeekBar osWideSeekbarNew) {
            if (osWideSeekbarNew != null) {
                this.osMultiSeekbarWeakReference = new WeakReference<OSMultiSeekBar>(osWideSeekbarNew);
                this.min = 0.0f;
                this.max = 100.0f;
                this.progress = 0.0f;
                this.trackWidth = OSMultiSeekBar.dp2px(3);
                this.secondTrackWidth = OSMultiSeekBar.dp2px(3);
                this.processMarginTopBottow = OSMultiSeekBar.dp2px(8);
                this.trackColor = ContextCompat.getColor((Context)osWideSeekbarNew.mContext, (int)R.color.os_gray_primary_color);
                this.secondTrackColor = osWideSeekbarNew.secondTrackColor();
                this.thumbWidth = OSMultiSeekBar.dp2px(8);
                this.thumbColor = osWideSeekbarNew.thumbColor();
            }
        }

        public void build() {
            if (this.osMultiSeekbarWeakReference.get() != null) {
                ((OSMultiSeekBar)((Object)this.osMultiSeekbarWeakReference.get())).config(this);
            }
        }

        public OSMultiSeekBarBuilde min(float min) {
            this.min = min;
            this.progress = min;
            return this;
        }

        public OSMultiSeekBarBuilde max(float max) {
            this.max = max;
            return this;
        }

        public OSMultiSeekBarBuilde progress(float progress) {
            this.progress = progress;
            return this;
        }

        public OSMultiSeekBarBuilde trackWidth(int dp) {
            this.trackWidth = OSMultiSeekBar.dp2px(dp);
            return this;
        }

        public OSMultiSeekBarBuilde secondTrackWidth(int dp) {
            this.secondTrackWidth = OSMultiSeekBar.dp2px(dp);
            return this;
        }

        public OSMultiSeekBarBuilde thumbWidth(int dp) {
            this.thumbWidth = OSMultiSeekBar.dp2px(dp);
            return this;
        }

        public OSMultiSeekBarBuilde trackColor(int color2) {
            this.trackColor = color2;
            return this;
        }

        public OSMultiSeekBarBuilde secondTrackColor(int color2) {
            this.secondTrackColor = color2;
            return this;
        }

        public OSMultiSeekBarBuilde thumbColor(int color2) {
            this.thumbColor = color2;
            return this;
        }

        public OSMultiSeekBarBuilde processMarginTopBottow(int dp) {
            this.processMarginTopBottow = OSMultiSeekBar.dp2px(dp);
            return this;
        }
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(OSMultiSeekBar var1, int var2, float var3, boolean var4);

        public void onStartTrackingTouch(OSMultiSeekBar var1);

        public void onStopTrackingTouch(OSMultiSeekBar var1);
    }
}

