/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.seekbar;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.anim.TrackAnimator;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.widget.timepicker.wheel.EaseCubicInterpolator;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;

public class OSSeekbar
extends View {
    private float mMin;
    private float mMax;
    private float mProgress;
    private float mSourceTrackWidth;
    private float mSourceSecondTTrackWidth;
    private int mTrackColor;
    private int mSecondTrackColor;
    private float mDelta;
    private float mThumbCenterX;
    private float mThumbCenterY;
    private float mTrackLength;
    private boolean isThumbOnDragging;
    private float mPreThumbCenterX;
    private OnProgressChangedListener mProgressListener;
    private float mLeft;
    private float mRight;
    private final Paint mPaint;
    private final Context mContext;
    private OSSeekBarBuilder mOSSeekBarBuilder;
    private float mTouchXDown;
    private float mTouchXMove;
    private final Paint mThumbPaint;
    private int mThumbOutColor;
    private int mThumbInsideColor;
    private float mThumbStokeWidth;
    private float mSourceThumbInHalfWidth;
    private float mMaxThumbInHalfWidth;
    private float mSourceThumbInHalfHeight;
    private float mCurrentThumbInHalfWidth;
    private float mCurrentThumbInScal = 1.0f;
    private float mCurrentThumbOutScal = 1.0f;
    private float mMaxThumbInScal;
    private float mMaxThumbStokeScal;
    private int mThumbScalType = 0;
    private static final int ALIGNLEFT = 0;
    private static final int ALIGNCENTER = 1;
    private static final int ALIGNRIGHT = 2;
    private boolean isTouchOnThumb = false;
    private boolean isCenterXAnimation = false;
    private ValueAnimator mThumbWidthAnimator;
    private ValueAnimator mThumbInScalAnimator;
    private float mFromThumbCenterX;
    private float mToThumbCenterX;
    private float mFromThumbHalfLen;
    private float mCenterThumbHalfLen;
    private float mToThumbHalfLen;
    private ValueAnimator mThumbIntervalAnimator;
    private float mTouchThumbX;
    private boolean isEnterActionMove = false;
    private boolean isTouchMove = false;
    private final TrackAnimator mThumbWidthTrackAnimator = new TrackAnimator();
    private final TrackAnimator mThumbCenterXTrackAnimator = new TrackAnimator();

    public OSSeekbar(Context context) {
        this(context, null);
    }

    public OSSeekbar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OSSeekbar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.getConfigBuilder().build();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OSSeekbar, defStyleAttr, 0);
        this.mMin = a.getFloat(R.styleable.OSSeekbar_osSeekbarMin, 0.0f);
        this.mMax = a.getFloat(R.styleable.OSSeekbar_osSeekbarMax, 100.0f);
        this.mProgress = a.getFloat(R.styleable.OSSeekbar_osSeekbarProgress, this.mMin);
        this.setEnabled(a.getBoolean(R.styleable.OSSeekbar_android_enabled, this.isEnabled()));
        a.recycle();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mThumbPaint = new Paint();
        this.mThumbPaint.setAntiAlias(true);
        this.mThumbPaint.setDither(true);
        this.mThumbPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mThumbPaint.setTextAlign(Paint.Align.CENTER);
        this.mThumbCenterXTrackAnimator.setMaxSpeedFractor(0.25f);
        this.mThumbCenterXTrackAnimator.setMinSpeedFractor(0.25f);
        this.initConfigByPriority();
        if (Utils.isRtl() && this.getRotation() == 0.0f) {
            this.setRotation(180.0f);
        }
    }

    private void initConfigByPriority() {
        if (this.mMin == this.mMax) {
            this.mMin = 0.0f;
            this.mMax = 100.0f;
        }
        if (this.mMin > this.mMax) {
            float tmp = this.mMax;
            this.mMax = this.mMin;
            this.mMin = tmp;
        }
        if (this.mProgress < this.mMin) {
            this.mProgress = this.mMin;
        }
        if (this.mProgress > this.mMax) {
            this.mProgress = this.mMax;
        }
        this.mDelta = this.mMax - this.mMin;
        this.setProgress(this.mProgress);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int thumbHeight = (int)((this.mSourceThumbInHalfHeight * this.mMaxThumbInScal + this.mThumbStokeWidth * this.mMaxThumbStokeScal) * 2.0f);
        int contentHeight = (int)Math.max((float)thumbHeight, this.mSourceTrackWidth);
        int height = contentHeight + this.getPaddingTop() + this.getPaddingBottom();
        if (height < OSSeekbar.dp2px(20)) {
            height = OSSeekbar.dp2px(20);
        }
        this.setMeasuredDimension(OSSeekbar.resolveSize((int)OSSeekbar.dp2px(180), (int)widthMeasureSpec), height);
        float thumbhalfWidth = this.mSourceThumbInHalfWidth * this.mMaxThumbInScal + this.mThumbStokeWidth * this.mMaxThumbStokeScal;
        this.mLeft = (float)this.getPaddingLeft() + thumbhalfWidth;
        this.mRight = (float)(this.getMeasuredWidth() - this.getPaddingRight()) - thumbhalfWidth;
        this.mTrackLength = this.mRight - this.mLeft;
        this.mThumbCenterY = (float)this.getMeasuredHeight() * 0.5f;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        float thumbInRightt;
        float thumbInLeft;
        super.onDraw(canvas);
        float xLeft = this.mLeft;
        float xRight = this.mRight;
        float yTop = this.mThumbCenterY;
        if (!this.isThumbOnDragging && !this.isCenterXAnimation) {
            this.mThumbCenterX = xLeft + this.mTrackLength / this.mDelta * (this.mProgress - this.mMin);
        }
        this.mPaint.setColor(this.mTrackColor);
        this.mPaint.setStrokeWidth(this.mSourceTrackWidth);
        canvas.drawLine(xLeft, yTop, xRight, yTop, this.mPaint);
        float curThumbCenterX = this.mThumbCenterX;
        this.mPaint.setColor(this.mSecondTrackColor);
        this.mPaint.setStrokeWidth(this.mSourceSecondTTrackWidth);
        canvas.drawLine(xLeft, yTop, curThumbCenterX, yTop, this.mPaint);
        this.mThumbPaint.setColor(this.mThumbOutColor);
        this.mThumbPaint.setStyle(Paint.Style.FILL);
        boolean needUpdate = this.updateThumbWidthAndCenterXTrack();
        float currentThumbInScal = this.mCurrentThumbInScal;
        float currentThumbInHalfWidth = this.mCurrentThumbInHalfWidth;
        float thumbInTop = this.mThumbCenterY - this.mSourceThumbInHalfHeight * currentThumbInScal;
        float thumbInBottom = this.mThumbCenterY + this.mSourceThumbInHalfHeight * currentThumbInScal;
        switch (this.mThumbScalType) {
            case 0: {
                thumbInLeft = curThumbCenterX - (currentThumbInHalfWidth + (currentThumbInHalfWidth - this.mSourceThumbInHalfWidth)) * currentThumbInScal;
                thumbInRightt = curThumbCenterX + this.mSourceThumbInHalfWidth * currentThumbInScal;
                break;
            }
            case 1: {
                thumbInLeft = curThumbCenterX - currentThumbInHalfWidth * currentThumbInScal;
                thumbInRightt = curThumbCenterX + currentThumbInHalfWidth * currentThumbInScal;
                break;
            }
            case 2: {
                thumbInLeft = curThumbCenterX - this.mSourceThumbInHalfWidth * currentThumbInScal;
                thumbInRightt = curThumbCenterX + (currentThumbInHalfWidth + (currentThumbInHalfWidth - this.mSourceThumbInHalfWidth)) * currentThumbInScal;
                break;
            }
            default: {
                thumbInLeft = curThumbCenterX - currentThumbInHalfWidth * currentThumbInScal;
                thumbInRightt = curThumbCenterX + currentThumbInHalfWidth * currentThumbInScal;
            }
        }
        float thumbOutWidthDelta = this.mThumbStokeWidth * this.mCurrentThumbOutScal;
        thumbInLeft = Math.max(thumbInLeft, thumbOutWidthDelta);
        thumbInRightt = Math.min(thumbInRightt, (float)this.getWidth() - thumbOutWidthDelta);
        float thumbOutLeft = Math.max(thumbInLeft - thumbOutWidthDelta, 0.0f);
        float thumbOutTop = thumbInTop - thumbOutWidthDelta;
        float thumbOutRight = Math.min(thumbInRightt + thumbOutWidthDelta, (float)this.getWidth());
        float thumbOutBottom = thumbInBottom + thumbOutWidthDelta;
        float thumbInRadius = this.mSourceThumbInHalfHeight * currentThumbInScal;
        float thumbOutRadius = thumbInRadius + thumbOutWidthDelta;
        canvas.drawRoundRect(thumbOutLeft, thumbOutTop, thumbOutRight, thumbOutBottom, thumbOutRadius, thumbOutRadius, this.mThumbPaint);
        this.mThumbPaint.setStyle(Paint.Style.FILL);
        this.mThumbPaint.setColor(this.mThumbInsideColor);
        canvas.drawRoundRect(thumbInLeft, thumbInTop, thumbInRightt, thumbInBottom, thumbInRadius, thumbInRadius, this.mThumbPaint);
        if (needUpdate) {
            this.invalidate();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.post(new Runnable(){

            @Override
            public void run() {
                OSSeekbar.this.requestLayout();
            }
        });
    }

    public boolean performClick() {
        return super.performClick();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.performClick();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.isThumbOnDragging = this.isEnabled();
                if (!this.isThumbOnDragging) break;
                if (event.getX() < this.mLeft || event.getX() > this.mRight) {
                    this.isThumbOnDragging = false;
                    return false;
                }
                this.mTouchXDown = event.getX();
                if (this.mProgressListener != null) {
                    this.mProgressListener.onStartTrackingTouch(this);
                }
                float thumbHalfSize = this.mSourceThumbInHalfWidth * this.mMaxThumbInScal + this.mThumbStokeWidth * this.mMaxThumbStokeScal;
                if (event.getX() > this.mThumbCenterX + thumbHalfSize || event.getX() < this.mThumbCenterX - thumbHalfSize) {
                    this.isTouchOnThumb = false;
                    break;
                }
                this.isTouchOnThumb = true;
                break;
            }
            case 2: {
                this.isThumbOnDragging = this.isEnabled();
                if (this.isThumbOnDragging) {
                    if (!this.isEnterActionMove) {
                        this.startThumbScalAnimator(1.0f, this.mMaxThumbInScal);
                        this.mTouchThumbX = event.getX();
                        this.mPreThumbCenterX = this.mThumbCenterX;
                    } else {
                        float x = this.calThumbCxWhenSeekStepSection(event.getX());
                        this.mTouchXMove = Math.abs(x - this.mTouchXDown);
                        if (Math.abs(x - this.mPreThumbCenterX) >= (float)OSSeekbar.dp2px(1) && this.mTouchXMove > (float)OSSeekbar.dp2px(1)) {
                            if (!this.isTouchMove && !this.isTouchOnThumb) {
                                this.startThumbIntervalAnimation(this.mThumbCenterX, x, 500L);
                            } else {
                                float centerXDelta = Math.abs(x - this.mTouchThumbX);
                                if (centerXDelta < (float)OSSeekbar.dp2px(1)) {
                                    centerXDelta = 0.0f;
                                }
                                centerXDelta *= 1.3f;
                                this.mThumbScalType = 1;
                                float targThumbInHalfWidth = this.mSourceThumbInHalfWidth + centerXDelta;
                                if (targThumbInHalfWidth > this.mMaxThumbInHalfWidth) {
                                    targThumbInHalfWidth = this.mMaxThumbInHalfWidth;
                                }
                                if (this.isThumbIntervalAnimationRun()) {
                                    this.mToThumbCenterX = x;
                                    this.mToThumbHalfLen = targThumbInHalfWidth;
                                } else {
                                    boolean isTrackRun = !this.mThumbCenterXTrackAnimator.isRunning() && !this.mThumbWidthTrackAnimator.isRunning();
                                    this.startThumbWidthTrackAnimator(this.mCurrentThumbInHalfWidth, targThumbInHalfWidth);
                                    this.startThumbCenterXTrackAnimator(this.mThumbCenterX, x);
                                    if (isTrackRun) {
                                        this.invalidate();
                                    }
                                }
                            }
                            this.mPreThumbCenterX = x;
                            this.isTouchMove = true;
                        } else if (!this.isThumbIntervalAnimationRun() && this.mCurrentThumbInHalfWidth != this.mSourceThumbInHalfWidth) {
                            boolean isTrackRun = !this.mThumbCenterXTrackAnimator.isRunning() && !this.mThumbWidthTrackAnimator.isRunning();
                            this.startThumbWidthTrackAnimator(this.mCurrentThumbInHalfWidth, this.mSourceThumbInHalfWidth);
                            if (isTrackRun) {
                                this.invalidate();
                            }
                        }
                        this.mTouchThumbX = x;
                    }
                }
                this.isEnterActionMove = true;
                break;
            }
            case 1: 
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                if (this.isThumbOnDragging) {
                    this.mThumbWidthTrackAnimator.end();
                    this.mThumbCenterXTrackAnimator.end();
                    float thumbCenterX = this.calThumbCxWhenSeekStepSection(event.getX());
                    if (this.isEnterActionMove) {
                        this.startThumbScalAnimator(this.mCurrentThumbInScal, 1.0f);
                        boolean isTumbIntervalRun = this.isThumbIntervalAnimationRun();
                        if (isTumbIntervalRun) {
                            this.mToThumbHalfLen = this.mSourceThumbInHalfWidth;
                        }
                        if (!isTumbIntervalRun && this.mCurrentThumbInHalfWidth != this.mSourceThumbInHalfWidth) {
                            this.startThumbWidthAnimator(this.mCurrentThumbInHalfWidth, this.mSourceThumbInHalfWidth);
                        }
                    }
                    if (this.mThumbCenterX != thumbCenterX) {
                        if (this.isEnterActionMove && this.isThumbIntervalAnimationRun() && Math.abs(this.mPreThumbCenterX - thumbCenterX) < (float)OSSeekbar.dp2px(6)) {
                            this.mToThumbCenterX = thumbCenterX;
                        } else {
                            this.startThumbIntervalAnimation(this.mThumbCenterX, thumbCenterX, 500L);
                        }
                    }
                    this.mPreThumbCenterX = thumbCenterX;
                }
                this.isThumbOnDragging = false;
                if (this.mProgressListener != null) {
                    this.mProgressListener.onStopTrackingTouch(this);
                }
                this.isEnterActionMove = false;
                this.isTouchMove = false;
            }
        }
        return this.isThumbOnDragging || super.onTouchEvent(event);
    }

    private void startThumbWidthTrackAnimator(float fromValue, float toValue) {
        if (!this.mThumbWidthTrackAnimator.isRunning()) {
            this.mThumbWidthTrackAnimator.set(fromValue);
        }
        this.mThumbWidthTrackAnimator.setTargValue(toValue);
    }

    private void startThumbCenterXTrackAnimator(float fromValue, float toValue) {
        if (!this.mThumbCenterXTrackAnimator.isRunning()) {
            this.mThumbCenterXTrackAnimator.set(fromValue);
        }
        this.mThumbCenterXTrackAnimator.setTargValue(toValue);
    }

    private boolean updateThumbWidthAndCenterXTrack() {
        boolean needUpdate = false;
        if (!this.isThumbIntervalAnimationRun()) {
            if (this.mThumbWidthTrackAnimator.isRunning()) {
                needUpdate |= this.mThumbWidthTrackAnimator.update(0.064f);
                this.mCurrentThumbInHalfWidth = this.mThumbWidthTrackAnimator.getAnimatedValue();
            }
            if (this.mThumbCenterXTrackAnimator.isRunning()) {
                needUpdate |= this.mThumbCenterXTrackAnimator.update(0.256f);
                this.mThumbCenterX = this.mThumbCenterXTrackAnimator.getAnimatedValue();
                this.mProgress = this.calculateProgress(this.mThumbCenterX);
                if (this.mProgressListener != null) {
                    this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), true);
                }
            }
        }
        return needUpdate;
    }

    private boolean isThumbIntervalAnimationRun() {
        return this.mThumbIntervalAnimator != null && this.mThumbIntervalAnimator.isRunning();
    }

    private void startThumbScalAnimator(float fromScal, float toScal) {
        if (this.mThumbInScalAnimator == null) {
            this.mThumbInScalAnimator = this.createThumbInScalAnimator(fromScal, toScal);
        } else if (this.mThumbInScalAnimator.isRunning()) {
            this.mThumbInScalAnimator.cancel();
            this.mThumbInScalAnimator = this.createThumbInScalAnimator(fromScal, toScal);
        } else {
            this.mThumbInScalAnimator.setFloatValues(new float[]{fromScal, toScal});
        }
        this.mThumbInScalAnimator.start();
    }

    private void startThumbWidthAnimator(float fromThumbHalfLen, float toThumbHalfLen) {
        if (this.mThumbWidthAnimator == null) {
            this.mThumbWidthAnimator = this.createThumbWidthAnimator(fromThumbHalfLen, toThumbHalfLen);
        } else if (this.mThumbWidthAnimator.isRunning()) {
            this.mThumbWidthAnimator.cancel();
            this.mThumbWidthAnimator = this.createThumbWidthAnimator(fromThumbHalfLen, toThumbHalfLen);
        } else {
            this.mThumbWidthAnimator.setFloatValues(new float[]{fromThumbHalfLen, toThumbHalfLen});
        }
        this.mThumbWidthAnimator.start();
    }

    private void startThumbIntervalAnimation(float fromCenterx, float toCenterX, long duration) {
        this.isCenterXAnimation = true;
        if (this.mThumbIntervalAnimator == null) {
            this.mThumbIntervalAnimator = this.createThumbIntervalAnimator();
        } else if (this.mThumbIntervalAnimator.isRunning()) {
            this.mThumbIntervalAnimator.cancel();
            this.mThumbIntervalAnimator = this.createThumbIntervalAnimator();
        }
        this.mThumbIntervalAnimator.setDuration(duration);
        this.mThumbScalType = 1;
        float centerXDelta = Math.abs(toCenterX - fromCenterx);
        if (centerXDelta > this.mSourceThumbInHalfWidth) {
            float thumbLenDelta = centerXDelta - this.mSourceThumbInHalfWidth;
            float thumbHalfLen = this.mSourceThumbInHalfWidth + (thumbLenDelta *= 0.18f);
            if (thumbHalfLen > this.mMaxThumbInHalfWidth) {
                thumbHalfLen = this.mMaxThumbInHalfWidth;
            }
            this.mFromThumbHalfLen = this.mCurrentThumbInHalfWidth;
            this.mCenterThumbHalfLen = thumbHalfLen;
            this.mToThumbHalfLen = this.mSourceThumbInHalfWidth;
        } else {
            this.mFromThumbHalfLen = this.mCurrentThumbInHalfWidth;
            this.mCenterThumbHalfLen = this.mSourceThumbInHalfWidth;
            this.mToThumbHalfLen = this.mSourceThumbInHalfWidth;
        }
        this.mFromThumbCenterX = fromCenterx;
        this.mToThumbCenterX = toCenterX;
        this.mThumbIntervalAnimator.start();
    }

    private ValueAnimator createThumbWidthAnimator(float fromThumbHalfLen, float toThumbHalfLen) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{fromThumbHalfLen, toThumbHalfLen});
        valueAnimator.setDuration(250L);
        valueAnimator.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.4f, 0.0f, 0.2f, 1.0f));
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                OSSeekbar.this.mCurrentThumbInHalfWidth = ((Float)animation.getAnimatedValue()).floatValue();
                OSSeekbar.this.invalidate();
            }
        });
        return valueAnimator;
    }

    private ValueAnimator createThumbInScalAnimator(float fromScal, float toScal) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{fromScal, toScal});
        valueAnimator.setDuration(250L);
        valueAnimator.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.25f, 0.0f, 0.0f, 1.0f));
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                OSSeekbar.this.mCurrentThumbInScal = ((Float)animation.getAnimatedValue()).floatValue();
                if (OSSeekbar.this.mMaxThumbInScal != 0.0f) {
                    OSSeekbar.this.mCurrentThumbOutScal = 1.0f + OSSeekbar.this.mCurrentThumbInScal * (1.0f - OSSeekbar.this.mMaxThumbStokeScal) / OSSeekbar.this.mMaxThumbInScal;
                }
                OSSeekbar.this.invalidate();
            }
        });
        return valueAnimator;
    }

    private ValueAnimator createThumbIntervalAnimator() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.5f, 1.0f});
        valueAnimator.setDuration(500L);
        valueAnimator.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.4f, 0.0f, 0.2f, 1.0f));
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float curValue = ((Float)animation.getAnimatedValue()).floatValue();
                OSSeekbar.this.mThumbCenterX = OSSeekbar.this.mFromThumbCenterX + curValue * (OSSeekbar.this.mToThumbCenterX - OSSeekbar.this.mFromThumbCenterX);
                OSSeekbar.this.mProgress = OSSeekbar.this.calculateProgress(OSSeekbar.this.mThumbCenterX);
                if (OSSeekbar.this.mProgressListener != null) {
                    OSSeekbar.this.mProgressListener.onProgressChanged(OSSeekbar.this, OSSeekbar.this.getProgress(), OSSeekbar.this.getProgressFloat(), true);
                }
                if (curValue <= 0.5f) {
                    OSSeekbar.this.mCurrentThumbInHalfWidth = OSSeekbar.this.mFromThumbHalfLen + curValue * 2.0f * (OSSeekbar.this.mCenterThumbHalfLen - OSSeekbar.this.mFromThumbHalfLen);
                } else {
                    OSSeekbar.this.mCurrentThumbInHalfWidth = OSSeekbar.this.mCenterThumbHalfLen + (curValue - 0.5f) * 2.0f * (OSSeekbar.this.mToThumbHalfLen - OSSeekbar.this.mCenterThumbHalfLen);
                }
                OSSeekbar.this.invalidate();
            }
        });
        valueAnimator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                OSSeekbar.this.isCenterXAnimation = true;
            }

            public void onAnimationEnd(Animator animation) {
                OSSeekbar.this.isCenterXAnimation = false;
            }

            public void onAnimationCancel(Animator animation) {
                OSSeekbar.this.isCenterXAnimation = false;
            }

            public void onAnimationRepeat(Animator animation) {
                OSSeekbar.this.isCenterXAnimation = true;
            }
        });
        return valueAnimator;
    }

    private float calThumbCxWhenSeekStepSection(float touchedX) {
        if (touchedX <= this.mLeft) {
            return this.mLeft;
        }
        if (touchedX >= this.mRight) {
            return this.mRight;
        }
        return touchedX;
    }

    private float formatFloat(float value) {
        BigDecimal bigDecimal = BigDecimal.valueOf(value);
        return bigDecimal.setScale(1, 4).floatValue();
    }

    private float calculateProgress(float thumbcenterX) {
        return (thumbcenterX - this.mLeft) * this.mDelta / this.mTrackLength + this.mMin;
    }

    public float getMin() {
        return this.mMin;
    }

    public float getMax() {
        return this.mMax;
    }

    public void setProgress(float progress) {
        this.mProgress = progress;
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), false);
        }
        this.postInvalidate();
    }

    public int getProgress() {
        if (this.mThumbIntervalAnimator != null && this.mThumbIntervalAnimator.isRunning()) {
            return Math.round(this.calculateProgress(this.mToThumbCenterX));
        }
        return Math.round(this.mProgress);
    }

    public float getProgressFloat() {
        if (this.mThumbIntervalAnimator != null && this.mThumbIntervalAnimator.isRunning()) {
            return this.calculateProgress(this.mToThumbCenterX);
        }
        return this.mProgress;
    }

    public OnProgressChangedListener getOnProgressChangedListener() {
        return this.mProgressListener;
    }

    public void setOnProgressChangedListener(OnProgressChangedListener onProgressChangedListener) {
        this.mProgressListener = onProgressChangedListener;
    }

    public void setTrackColor(int trackColor) {
        if (this.mTrackColor != trackColor) {
            this.mTrackColor = trackColor;
            this.invalidate();
        }
    }

    public void setSecondTrackColor(int secondTrackColor) {
        if (this.mSecondTrackColor != secondTrackColor) {
            this.mSecondTrackColor = secondTrackColor;
            this.invalidate();
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("save_instance", super.onSaveInstanceState());
        bundle.putFloat("progress", this.mProgress);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mProgress = bundle.getFloat("progress");
            super.onRestoreInstanceState(bundle.getParcelable("save_instance"));
            this.setProgress(this.mProgress);
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.mSecondTrackColor = this.secondTrackColor();
            this.mThumbOutColor = this.thumbOutColor();
            this.mThumbInsideColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_seekbar_thumbinside_color);
        } else {
            this.mSecondTrackColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_gray_secondary_color);
            this.mThumbOutColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_gray_solid_primary_color);
            this.mThumbInsideColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_altitude_secondary_color);
        }
        this.invalidate();
    }

    public void setThumbOutColor(int thumbColor) {
        if (this.mThumbOutColor != thumbColor) {
            this.mThumbOutColor = thumbColor;
            this.invalidate();
        }
    }

    public void setThumbInsideColor(int thumbColor) {
        if (this.mThumbInsideColor != thumbColor) {
            this.mThumbInsideColor = thumbColor;
            this.invalidate();
        }
    }

    private int thumbOutColor() {
        TypedValue typedValue = new TypedValue();
        if (this.mContext.getTheme().resolveAttribute(R.attr.os_platform_basic_color, typedValue, true)) {
            return ContextCompat.getColor((Context)this.mContext, (int)typedValue.resourceId);
        }
        return ContextCompat.getColor((Context)this.mContext, (int)R.color.os_platform_basic_color_hios);
    }

    private int secondTrackColor() {
        TypedValue typedValue = new TypedValue();
        if (this.mContext.getTheme().resolveAttribute(R.attr.os_platform_basic_color, typedValue, true)) {
            return ContextCompat.getColor((Context)this.mContext, (int)typedValue.resourceId);
        }
        return ContextCompat.getColor((Context)this.mContext, (int)R.color.os_platform_basic_color_hios);
    }

    public OSSeekBarBuilder getConfigBuilder() {
        if (this.mOSSeekBarBuilder == null) {
            this.mOSSeekBarBuilder = new OSSeekBarBuilder(this);
        }
        return this.mOSSeekBarBuilder;
    }

    void config(OSSeekBarBuilder builder) {
        this.mMin = builder.min;
        this.mMax = builder.max;
        this.mProgress = builder.progress;
        this.mTrackColor = builder.trackColor;
        this.mSecondTrackColor = builder.secondTrackColor;
        this.mSourceTrackWidth = builder.trackWidth;
        this.mThumbOutColor = builder.thumbOutColor;
        this.mThumbInsideColor = builder.thumbInsideColor;
        this.mSourceSecondTTrackWidth = builder.secondTrackWidth;
        this.mThumbStokeWidth = (float)(builder.thumbOutWidth - builder.thumbInWidth) * 0.5f;
        if (this.mThumbStokeWidth < 0.0f) {
            this.mThumbStokeWidth = 0.0f;
        }
        this.mSourceThumbInHalfWidth = (float)builder.thumbInWidth * 0.5f;
        if (builder.thumbInMaxWidth < builder.thumbInWidth) {
            builder.thumbInMaxWidth = builder.thumbInWidth;
        }
        this.mMaxThumbInHalfWidth = (float)builder.thumbInMaxWidth * 0.5f;
        this.mSourceThumbInHalfHeight = this.mSourceThumbInHalfWidth;
        this.mCurrentThumbInHalfWidth = this.mSourceThumbInHalfWidth;
        this.mMaxThumbInScal = builder.thumbInMaxScal;
        if (this.mThumbStokeWidth != 0.0f) {
            this.mMaxThumbStokeScal = ((float)builder.thumbOutWidth * builder.thumbOutMaxScal - (float)builder.thumbInWidth * builder.thumbInMaxScal) / (this.mThumbStokeWidth * 2.0f);
        }
        if (this.mMaxThumbStokeScal < 1.0f) {
            this.mMaxThumbStokeScal = 1.0f;
        }
        this.initConfigByPriority();
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), false);
        }
        this.mOSSeekBarBuilder = null;
        this.requestLayout();
    }

    static int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    static int sp2px(int sp) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static class OSSeekBarBuilder {
        float min;
        float max;
        float progress;
        int trackWidth;
        int secondTrackWidth;
        int trackColor;
        int secondTrackColor;
        int thumbOutColor;
        int thumbInsideColor;
        int thumbInWidth;
        int thumbOutWidth;
        int thumbInMaxWidth;
        float thumbInMaxScal;
        float thumbOutMaxScal;
        private WeakReference<OSSeekbar> osSectionSeekbarWeakReference;

        OSSeekBarBuilder(OSSeekbar osWideSeekbarNew) {
            if (osWideSeekbarNew != null) {
                this.osSectionSeekbarWeakReference = new WeakReference<OSSeekbar>(osWideSeekbarNew);
                this.min = 0.0f;
                this.max = 100.0f;
                this.progress = 0.0f;
                this.trackWidth = OSSeekbar.dp2px(3);
                this.secondTrackWidth = OSSeekbar.dp2px(3);
                this.trackColor = ContextCompat.getColor((Context)osWideSeekbarNew.mContext, (int)R.color.os_gray_tertiary_color);
                this.secondTrackColor = osWideSeekbarNew.secondTrackColor();
                this.thumbOutColor = osWideSeekbarNew.thumbOutColor();
                this.thumbInsideColor = ContextCompat.getColor((Context)osWideSeekbarNew.mContext, (int)R.color.os_seekbar_thumbinside_color);
                this.thumbInWidth = OSSeekbar.dp2px(8);
                this.thumbOutWidth = OSSeekbar.dp2px(14);
                this.thumbInMaxWidth = OSSeekbar.dp2px(20);
                this.thumbInMaxScal = 1.25f;
                this.thumbOutMaxScal = 1.142857f;
            }
        }

        public void build() {
            if (this.osSectionSeekbarWeakReference.get() != null) {
                ((OSSeekbar)((Object)this.osSectionSeekbarWeakReference.get())).config(this);
            }
        }

        public OSSeekBarBuilder min(float min) {
            this.min = min;
            this.progress = min;
            return this;
        }

        public OSSeekBarBuilder max(float max) {
            this.max = max;
            return this;
        }

        public OSSeekBarBuilder progress(float progress) {
            this.progress = progress;
            return this;
        }

        public OSSeekBarBuilder trackWidth(int dp) {
            this.trackWidth = OSSeekbar.dp2px(dp);
            return this;
        }

        public OSSeekBarBuilder secondTrackWidth(int dp) {
            this.secondTrackWidth = OSSeekbar.dp2px(dp);
            return this;
        }

        public OSSeekBarBuilder trackColor(int color2) {
            this.trackColor = color2;
            return this;
        }

        public OSSeekBarBuilder secondTrackColor(int color2) {
            this.secondTrackColor = color2;
            return this;
        }

        public OSSeekBarBuilder thumbInWidth(int width) {
            this.thumbInWidth = width;
            return this;
        }

        public OSSeekBarBuilder thumbOutWidth(int width) {
            this.thumbOutWidth = width;
            return this;
        }

        public OSSeekBarBuilder thumbInMaxWidth(int width) {
            this.thumbInMaxWidth = width;
            return this;
        }

        public OSSeekBarBuilder thumbInMaxScal(int scal) {
            this.thumbInMaxScal = scal;
            return this;
        }

        public OSSeekBarBuilder thumbOutMaxScal(int scal) {
            this.thumbOutMaxScal = scal;
            return this;
        }
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(OSSeekbar var1, int var2, float var3, boolean var4);

        public void onStartTrackingTouch(OSSeekbar var1);

        public void onStopTrackingTouch(OSSeekbar var1);
    }
}

