/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.dialog;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.dialog.PromptDialog;
import com.transsion.widgetslib.util.DimensionUtil;
import com.transsion.widgetslib.util.Utils;
import java.util.Locale;

public class ProgressDialog {
    private static final String TAG = "ProgressDialog";
    private Context mContext;
    private PromptDialog.Builder mBuilder;
    private View mView;
    private TextView mTextView;
    private TextView mTextProgressMessage;
    private ProgressBar mProgressBar;
    private LinearLayout mLlIntro;
    private int mMaxProgress = 100;
    private boolean isNumRate = false;
    private boolean mHasTitle = false;

    public ProgressDialog(Context context) {
        this.mContext = context;
        this.mBuilder = new PromptDialog.Builder(this.mContext);
        this.setCanceledOnTouchOutside(false);
        this.setCancelable(false);
        this.mBuilder.setNoBtnBottomInsets(DimensionUtil.dpToPx(16, this.mContext));
        if (this.mView == null) {
            this.initView();
        }
    }

    public ProgressDialog setTitle(CharSequence title) {
        this.mBuilder.setTitle(title);
        this.mHasTitle = true;
        this.dealProgressMessagePadding();
        return this;
    }

    private void dealProgressMessagePadding() {
        if (this.mTextProgressMessage.getVisibility() == 0 && this.mHasTitle) {
            this.mLlIntro.setPadding(0, (int)this.mContext.getResources().getDimension(R.dimen.os_progress_intro_padding_top), 0, 0);
        }
    }

    public ProgressDialog setTitle(int title) {
        this.mBuilder.setTitle(title);
        this.mHasTitle = true;
        this.dealProgressMessagePadding();
        return this;
    }

    public ProgressDialog setIcon(Drawable icon) {
        this.mBuilder.setIcon(icon);
        this.mHasTitle = true;
        this.dealProgressMessagePadding();
        return this;
    }

    public ProgressDialog setIcon(int iconId) {
        this.mBuilder.setIcon(iconId);
        this.mHasTitle = true;
        this.dealProgressMessagePadding();
        return this;
    }

    public ProgressDialog setMessage(CharSequence title) {
        this.mBuilder.setMessage(title);
        return this;
    }

    public ProgressDialog setProgressMessage(CharSequence progressMessage) {
        if (this.mTextProgressMessage != null) {
            this.mTextProgressMessage.setVisibility(0);
            this.mTextProgressMessage.setText(progressMessage);
        }
        this.dealProgressMessagePadding();
        return this;
    }

    public ProgressDialog setMessage(int title) {
        this.mBuilder.setMessage(title);
        return this;
    }

    public ProgressDialog setProgressMessage(int progressMessage) {
        if (this.mTextProgressMessage != null) {
            this.mTextProgressMessage.setVisibility(0);
            this.mTextProgressMessage.setText(this.mContext.getText(progressMessage));
        }
        this.dealProgressMessagePadding();
        return this;
    }

    public ProgressDialog setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setPositiveButton(text, listener);
        return this;
    }

    public ProgressDialog setPositiveButton(int textId, DialogInterface.OnClickListener listener) {
        return this.setPositiveButton(this.mContext.getText(textId), listener);
    }

    public ProgressDialog setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setNegativeButton(text, listener);
        return this;
    }

    public ProgressDialog setNegativeButton(int textId, DialogInterface.OnClickListener listener) {
        return this.setNegativeButton(this.mContext.getText(textId), listener);
    }

    public ProgressDialog setProgress(int progress) {
        if (this.mView == null) {
            this.initView();
        }
        this.mProgressBar.setProgress(Math.min(progress, this.mMaxProgress));
        String localeLanguage = this.mContext.getResources().getConfiguration().locale.getLanguage();
        int digits = (int)Math.floor((float)Math.min(progress, this.mMaxProgress) / (float)this.mMaxProgress * 100.0f);
        if ("tr".equals(localeLanguage) || "ar".equals(localeLanguage)) {
            this.mTextView.setLayoutDirection(0);
            this.mTextView.setText((CharSequence)String.format(Locale.getDefault(), "%%%d", digits));
        } else if (Utils.isRtlDigit()) {
            this.mTextView.setLayoutDirection(0);
            this.mTextView.setText((CharSequence)String.format(Locale.getDefault(), "%%%d", digits));
        } else {
            this.mTextView.setText((CharSequence)String.format(Locale.getDefault(), "%d%%", digits));
        }
        return this;
    }

    public ProgressDialog setSecondaryProgress(int secondaryProgress) {
        if (this.mView == null) {
            this.initView();
        }
        this.mProgressBar.setSecondaryProgress(Math.min(secondaryProgress, this.mMaxProgress));
        return this;
    }

    private void initView() {
        this.mView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.os_dialog_progress, null);
        this.mProgressBar = (ProgressBar)this.mView.findViewById(R.id.dialog_progress_bar);
        this.mTextView = (TextView)this.mView.findViewById(R.id.dialog_progress_tv);
        this.mTextProgressMessage = (TextView)this.mView.findViewById(R.id.text_progress_message);
        this.mLlIntro = (LinearLayout)this.mView.findViewById(R.id.ll_intro);
        if (this.isNumRate) {
            this.mTextView.setVisibility(0);
        }
        this.mBuilder.setView(this.mView);
    }

    public ProgressDialog setMaxProgress(int maxProgress) {
        this.mMaxProgress = maxProgress;
        this.mProgressBar.setMax(maxProgress);
        return this;
    }

    public ProgressDialog setCancelable(boolean cancelAble) {
        this.mBuilder.setCancelable(cancelAble);
        return this;
    }

    public ProgressDialog setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.mBuilder.setCanceledOnTouchOutside(canceledOnTouchOutside);
        return this;
    }

    public PromptDialog create() {
        if (this.isNumRate) {
            this.mTextView.setVisibility(0);
        }
        PromptDialog dialog = this.mBuilder.create();
        dialog.getWindow().setSoftInputMode(0);
        return dialog;
    }

    public PromptDialog show() {
        PromptDialog dialog = this.create();
        dialog.show();
        return dialog;
    }

    public ProgressDialog setNumRate(boolean numRate) {
        this.isNumRate = numRate;
        return this;
    }
}

