/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.seekbar;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;

public class OSWideSeekbar
extends View {
    private float mMin;
    private float mMax;
    private float mProgress;
    private float mCurrentTrackWidth;
    private float mSourceTrackWidth;
    private float mCurrentSecondTrackWidth;
    private float mSourceSecondTTrackWidth;
    private int mTrackColor;
    private int mSecondTrackColor;
    private float padding = OSWideSeekbar.dp2px(2);
    private float mDelta;
    private float mThumbCenterX;
    private float mTrackLength;
    private boolean isThumbOnDragging;
    private final int mTextSpace;
    private float mPreThumbCenterX;
    private OnProgressChangedListener mProgressListener;
    private float mLeft;
    private float mRight;
    private final Paint mPaint;
    private final Rect mRectText;
    private final Context mContext;
    private OSSectionSeekBarBuilder mOSSectionSeekBarBuilder;
    private long mStartTounchTime = 0L;
    private long mStopTounchTime = 0L;
    private float mTouchXDown;
    private float mTouchXMove;
    private static final long MIN_INTERVAL_TIME = 0L;
    private ValueAnimator pressValueAnimator;
    private ValueAnimator unPressValueAnimator;

    public OSWideSeekbar(Context context) {
        this(context, null);
    }

    public OSWideSeekbar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OSWideSeekbar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        this.getConfigBuilder().build();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OSWideSeekbar, defStyleAttr, 0);
        this.mMin = a.getFloat(R.styleable.OSWideSeekbar_osWideSeekbarMin, 0.0f);
        this.mMax = a.getFloat(R.styleable.OSWideSeekbar_osWideSeekbarMax, 100.0f);
        this.mProgress = a.getFloat(R.styleable.OSWideSeekbar_osWideSeekbarProgress, this.mMin);
        this.setEnabled(a.getBoolean(R.styleable.OSWideSeekbar_android_enabled, this.isEnabled()));
        a.recycle();
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        this.mRectText = new Rect();
        this.mTextSpace = OSWideSeekbar.dp2px(2);
        this.initConfigByPriority();
        if (Utils.isRtl() && this.getRotation() == 0.0f) {
            this.setRotation(180.0f);
        }
    }

    private void initConfigByPriority() {
        if (this.mMin == this.mMax) {
            this.mMin = 0.0f;
            this.mMax = 100.0f;
        }
        if (this.mMin > this.mMax) {
            float tmp = this.mMax;
            this.mMax = this.mMin;
            this.mMin = tmp;
        }
        if (this.mProgress < this.mMin) {
            this.mProgress = this.mMin;
        }
        if (this.mProgress > this.mMax) {
            this.mProgress = this.mMax;
        }
        this.mDelta = this.mMax - this.mMin;
        this.setProgress(this.mProgress);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int height = (int)((double)this.mSourceSecondTTrackWidth * 1.6) + this.getPaddingTop() + this.getPaddingBottom();
        this.setMeasuredDimension(OSWideSeekbar.resolveSize((int)OSWideSeekbar.dp2px(180), (int)widthMeasureSpec), height += this.mTextSpace * 2);
        this.mLeft = (float)(this.getPaddingLeft() + this.mTextSpace) + this.mCurrentTrackWidth;
        this.mRight = (float)(this.getMeasuredWidth() - this.getPaddingRight() - this.mTextSpace) - this.mCurrentTrackWidth;
        this.mTrackLength = this.mRight - this.mLeft;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        float xLeft = this.mLeft;
        float xRight = this.mRight;
        float yTop = (float)this.getPaddingTop() + this.mSourceSecondTTrackWidth * 0.6f + (float)(2 * this.mTextSpace);
        if (!this.isThumbOnDragging) {
            this.mThumbCenterX = xLeft + this.mTrackLength / this.mDelta * (this.mProgress - this.mMin);
        }
        this.mPaint.setColor(this.mTrackColor);
        this.mPaint.setStrokeWidth(this.mCurrentTrackWidth);
        canvas.drawLine(xLeft, yTop, xRight, yTop, this.mPaint);
        this.mPaint.setColor(this.mSecondTrackColor);
        this.mPaint.setStrokeWidth(this.mCurrentSecondTrackWidth);
        canvas.drawLine(xLeft, yTop, this.mThumbCenterX, yTop, this.mPaint);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.post(new Runnable(){

            @Override
            public void run() {
                OSWideSeekbar.this.requestLayout();
            }
        });
    }

    public boolean performClick() {
        return super.performClick();
    }

    private ValueAnimator createPressValueAnimator() {
        float initialValue = this.mCurrentSecondTrackWidth / this.mSourceSecondTTrackWidth;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{initialValue, 1.6f});
        valueAnimator.setDuration(250L);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                OSWideSeekbar.this.mCurrentSecondTrackWidth = OSWideSeekbar.this.mSourceSecondTTrackWidth * ((Float)animation.getAnimatedValue()).floatValue();
                OSWideSeekbar.this.mCurrentTrackWidth = OSWideSeekbar.this.mSourceTrackWidth * ((Float)animation.getAnimatedValue()).floatValue();
                OSWideSeekbar.this.invalidate();
            }
        });
        return valueAnimator;
    }

    private ValueAnimator createUnPressValueAnimator() {
        float targetValue = this.mCurrentSecondTrackWidth / this.mSourceSecondTTrackWidth;
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{targetValue, 1.0f});
        valueAnimator.setDuration(250L);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                OSWideSeekbar.this.mCurrentSecondTrackWidth = OSWideSeekbar.this.mSourceSecondTTrackWidth * ((Float)animation.getAnimatedValue()).floatValue();
                OSWideSeekbar.this.mCurrentTrackWidth = OSWideSeekbar.this.mSourceTrackWidth * ((Float)animation.getAnimatedValue()).floatValue();
                OSWideSeekbar.this.invalidate();
            }
        });
        return valueAnimator;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.performClick();
                this.getParent().requestDisallowInterceptTouchEvent(true);
                this.isThumbOnDragging = this.isEnabled();
                if (!this.isThumbOnDragging) break;
                if (event.getX() < this.mLeft || event.getX() > this.mRight) {
                    this.isThumbOnDragging = false;
                    return false;
                }
                this.mTouchXDown = event.getX();
                this.mStartTounchTime = System.currentTimeMillis();
                if (this.unPressValueAnimator != null && this.unPressValueAnimator.isRunning()) {
                    this.unPressValueAnimator.cancel();
                }
                this.pressValueAnimator = this.createPressValueAnimator();
                this.pressValueAnimator.start();
                if (this.mProgressListener == null) break;
                this.mProgressListener.onStartTrackingTouch(this);
                break;
            }
            case 2: {
                this.isThumbOnDragging = this.isEnabled();
                this.mStopTounchTime = System.currentTimeMillis();
                long touchDurationMove = this.mStopTounchTime - this.mStartTounchTime;
                if (!this.isThumbOnDragging) break;
                boolean flag = true;
                float x = this.calThumbCxWhenSeekStepSection(event.getX());
                this.mTouchXMove = Math.abs(x - this.mTouchXDown);
                if (x != this.mPreThumbCenterX && this.mTouchXMove > (float)OSWideSeekbar.dp2px(1)) {
                    this.mThumbCenterX = this.mPreThumbCenterX = x;
                } else {
                    flag = false;
                }
                if (!flag) break;
                this.mProgress = this.calculateProgress();
                this.invalidate();
                if (this.mProgressListener == null) break;
                this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), true);
                break;
            }
            case 1: 
            case 3: {
                this.mStopTounchTime = System.currentTimeMillis();
                this.getParent().requestDisallowInterceptTouchEvent(false);
                long touchDurationUp = this.mStopTounchTime - this.mStartTounchTime;
                if (this.isThumbOnDragging) {
                    this.mThumbCenterX = this.mPreThumbCenterX = this.calThumbCxWhenSeekStepSection(event.getX());
                    this.mProgress = this.calculateProgress();
                    if (this.mProgressListener != null) {
                        this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), true);
                    }
                }
                if (this.pressValueAnimator != null && this.pressValueAnimator.isRunning()) {
                    this.pressValueAnimator.cancel();
                }
                this.unPressValueAnimator = this.createUnPressValueAnimator();
                this.unPressValueAnimator.start();
                this.isThumbOnDragging = false;
                if (this.mProgressListener == null) break;
                this.mProgressListener.onStopTrackingTouch(this);
            }
        }
        return this.isThumbOnDragging || super.onTouchEvent(event);
    }

    private float calThumbCxWhenSeekStepSection(float touchedX) {
        if (touchedX <= this.mLeft) {
            return this.mLeft;
        }
        if (touchedX >= this.mRight) {
            return this.mRight;
        }
        return touchedX;
    }

    private float formatFloat(float value) {
        BigDecimal bigDecimal = BigDecimal.valueOf(value);
        return bigDecimal.setScale(1, 4).floatValue();
    }

    private float calculateProgress() {
        return (this.mThumbCenterX - this.mLeft) * this.mDelta / this.mTrackLength + this.mMin;
    }

    public float getMin() {
        return this.mMin;
    }

    public float getMax() {
        return this.mMax;
    }

    public void setProgress(float progress) {
        this.mProgress = progress;
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), false);
        }
        this.postInvalidate();
    }

    public int getProgress() {
        return Math.round(this.mProgress);
    }

    public float getProgressFloat() {
        return this.mProgress;
    }

    public OnProgressChangedListener getOnProgressChangedListener() {
        return this.mProgressListener;
    }

    public void setOnProgressChangedListener(OnProgressChangedListener onProgressChangedListener) {
        this.mProgressListener = onProgressChangedListener;
    }

    public void setTrackColor(int trackColor) {
        if (this.mTrackColor != trackColor) {
            this.mTrackColor = trackColor;
            this.invalidate();
        }
    }

    public void setSecondTrackColor(int secondTrackColor) {
        if (this.mSecondTrackColor != secondTrackColor) {
            this.mSecondTrackColor = secondTrackColor;
            this.invalidate();
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("save_instance", super.onSaveInstanceState());
        bundle.putFloat("progress", this.mProgress);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mProgress = bundle.getFloat("progress");
            super.onRestoreInstanceState(bundle.getParcelable("save_instance"));
            this.setProgress(this.mProgress);
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.mSecondTrackColor = enabled ? this.secondTrackColor() : ContextCompat.getColor((Context)this.mContext, (int)R.color.os_gray_secondary_color);
        this.invalidate();
    }

    private int secondTrackColor() {
        TypedValue typedValue = new TypedValue();
        if (this.mContext.getTheme().resolveAttribute(R.attr.os_platform_basic_color, typedValue, true)) {
            return ContextCompat.getColor((Context)this.mContext, (int)typedValue.resourceId);
        }
        return ContextCompat.getColor((Context)this.mContext, (int)R.color.os_platform_basic_color_hios);
    }

    public OSSectionSeekBarBuilder getConfigBuilder() {
        if (this.mOSSectionSeekBarBuilder == null) {
            this.mOSSectionSeekBarBuilder = new OSSectionSeekBarBuilder(this);
        }
        return this.mOSSectionSeekBarBuilder;
    }

    void config(OSSectionSeekBarBuilder builder) {
        this.mMin = builder.min;
        this.mMax = builder.max;
        this.mProgress = builder.progress;
        this.mCurrentTrackWidth = builder.trackWidth;
        this.mCurrentSecondTrackWidth = builder.secondTrackWidth;
        this.mTrackColor = builder.trackColor;
        this.mSecondTrackColor = builder.secondTrackColor;
        this.mSourceTrackWidth = builder.trackWidth;
        this.mSourceSecondTTrackWidth = builder.secondTrackWidth;
        this.initConfigByPriority();
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgressChanged(this, this.getProgress(), this.getProgressFloat(), false);
        }
        this.mOSSectionSeekBarBuilder = null;
        this.requestLayout();
    }

    static int dp2px(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    static int sp2px(int sp) {
        return (int)TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static class OSSectionSeekBarBuilder {
        float min;
        float max;
        float progress;
        int trackWidth;
        int secondTrackWidth;
        int trackColor;
        int secondTrackColor;
        private WeakReference<OSWideSeekbar> osSectionSeekbarWeakReference;

        OSSectionSeekBarBuilder(OSWideSeekbar osWideSeekbarNew) {
            if (osWideSeekbarNew != null) {
                this.osSectionSeekbarWeakReference = new WeakReference<OSWideSeekbar>(osWideSeekbarNew);
                this.min = 0.0f;
                this.max = 100.0f;
                this.progress = 0.0f;
                this.trackWidth = OSWideSeekbar.dp2px(10);
                this.secondTrackWidth = OSWideSeekbar.dp2px(10);
                this.trackColor = ContextCompat.getColor((Context)osWideSeekbarNew.mContext, (int)R.color.os_gray_tertiary_color);
                this.secondTrackColor = osWideSeekbarNew.secondTrackColor();
            }
        }

        public void build() {
            if (this.osSectionSeekbarWeakReference.get() != null) {
                ((OSWideSeekbar)((Object)this.osSectionSeekbarWeakReference.get())).config(this);
            }
        }

        public OSSectionSeekBarBuilder min(float min) {
            this.min = min;
            this.progress = min;
            return this;
        }

        public OSSectionSeekBarBuilder max(float max) {
            this.max = max;
            return this;
        }

        public OSSectionSeekBarBuilder progress(float progress) {
            this.progress = progress;
            return this;
        }

        public OSSectionSeekBarBuilder trackWidth(int dp) {
            this.trackWidth = OSWideSeekbar.dp2px(dp);
            return this;
        }

        public OSSectionSeekBarBuilder secondTrackWidth(int dp) {
            this.secondTrackWidth = OSWideSeekbar.dp2px(dp);
            return this;
        }

        public OSSectionSeekBarBuilder trackColor(int color2) {
            this.trackColor = color2;
            return this;
        }

        public OSSectionSeekBarBuilder secondTrackColor(int color2) {
            this.secondTrackColor = color2;
            return this;
        }
    }

    public static interface OnProgressChangedListener {
        public void onProgressChanged(OSWideSeekbar var1, int var2, float var3, boolean var4);

        public void onStartTrackingTouch(OSWideSeekbar var1);

        public void onStopTrackingTouch(OSWideSeekbar var1);
    }
}

