/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.shadow;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.PathInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.widget.shadow.ShadowLayout;

public class FloatingOvalButton
extends FrameLayout {
    private ShadowLayout mShadowLayout;
    private ImageView mImgView;
    private ValueAnimator mPressAnimator;
    private ValueAnimator mUnPressAnimator;
    private float mDefaultImageSize;
    private float mCurrentScale;
    private PathInterpolator mPathInterpolator;

    public FloatingOvalButton(Context context) {
        this(context, null);
    }

    public FloatingOvalButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setClickable(true);
        this.mShadowLayout = new ShadowLayout(context, attrs, false);
        this.mImgView = new ImageView(context, attrs);
        this.mShadowLayout.addView((View)this.mImgView);
        this.addView((View)this.mShadowLayout);
        this.mDefaultImageSize = context.getResources().getDimensionPixelSize(R.dimen.os_fab_default_image_size);
        float defaultImageBackgroundSize = context.getResources().getDimensionPixelSize(R.dimen.os_fab_default_size);
        int[] defaultAttrs = new int[]{R.attr.os_platform_basic_color, R.attr.os_fab_bg_pressed_color, R.attr.os_fab_shadow_color};
        TypedArray typedArray = context.obtainStyledAttributes(defaultAttrs);
        int defaultBackgroundColor = typedArray.getColor(0, context.getColor(R.color.os_platform_basic_color_hios));
        int defaultBackgroundPressedColor = typedArray.getColor(1, context.getColor(R.color.os_fab_bg_pressed_color_hios));
        int defaultShadowColor = typedArray.getColor(2, context.getColor(R.color.os_fab_shadow_color_hios));
        typedArray.recycle();
        if (Utils.getOsType().equals(Utils.mOsType[1])) {
            defaultShadowColor = 0;
        }
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FloatingOvalButton);
        float imageWidth = ta.getDimension(R.styleable.FloatingOvalButton_float_image_width, defaultImageBackgroundSize);
        float imageHeight = ta.getDimension(R.styleable.FloatingOvalButton_float_image_height, defaultImageBackgroundSize);
        Drawable imageDrawable = ta.getDrawable(R.styleable.FloatingOvalButton_float_image_src);
        int backgroundColor = ta.getColor(R.styleable.FloatingOvalButton_float_image_background_color, defaultBackgroundColor);
        int backgroundPressedColor = ta.getColor(R.styleable.FloatingOvalButton_float_image_background_pressed_color, defaultBackgroundPressedColor);
        int shadowColor = ta.getColor(R.styleable.FloatingOvalButton_float_image_shadow_color, defaultShadowColor);
        ta.recycle();
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mImgView.getLayoutParams();
        lp.width = (int)imageWidth;
        lp.height = (int)imageHeight;
        this.mImgView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.mImgView.setImageDrawable(imageDrawable);
        this.setImageBackgroundColor(backgroundColor, backgroundPressedColor);
        this.setShadowColor(shadowColor);
        this.setImagePadding(this.mDefaultImageSize);
        this.mPathInterpolator = new PathInterpolator(0.45f, 0.0f, 0.55f, 1.0f);
    }

    public ImageView getImage() {
        return this.mImgView;
    }

    public ShadowLayout getShadowLayout() {
        return this.mShadowLayout;
    }

    public void setImageDrawable(Drawable drawable2) {
        this.mImgView.setImageDrawable(drawable2);
    }

    public void setImageResource(int resId) {
        this.mImgView.setImageResource(resId);
    }

    public void setImageBackground(Drawable drawable2) {
        this.mImgView.setBackground(drawable2);
    }

    public void setImageBackgroundColor(int normalColor, int pressedColor) {
        Drawable backgroundDrawable = this.getContext().getDrawable(R.drawable.os_floating_ova_btn_bg);
        int[][] states = new int[][]{{16842919}, new int[0]};
        int[] colors = new int[]{pressedColor, normalColor};
        ColorStateList colorList = new ColorStateList((int[][])states, colors);
        backgroundDrawable.setTintList(colorList);
        this.setImageBackground(backgroundDrawable);
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowLayout.setShadowColor(shadowColor);
    }

    public void setImageSize(int width, int height) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mImgView.getLayoutParams();
        lp.width = width;
        lp.height = height;
        this.mImgView.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.setImagePadding(this.mDefaultImageSize);
    }

    public void setImagePadding(float size) {
        FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)this.mImgView.getLayoutParams();
        int paddingLeftRight = (int)(((float)lp.width - size) / 2.0f);
        int paddingTopBottom = (int)(((float)lp.height - size) / 2.0f);
        this.mImgView.setPadding(paddingLeftRight, paddingTopBottom, paddingLeftRight, paddingTopBottom);
    }

    public void setVisibility(int visibility) {
        switch (visibility) {
            case 0: {
                this.mShadowLayout.setVisibility(0);
                this.mImgView.setVisibility(0);
                break;
            }
            case 4: {
                this.mShadowLayout.setVisibility(4);
                this.mImgView.setVisibility(4);
                break;
            }
            case 8: {
                this.mShadowLayout.setVisibility(8);
                this.mImgView.setVisibility(8);
            }
        }
        super.setVisibility(visibility);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 0: {
                this.startPressAnimator();
                break;
            }
            case 1: 
            case 3: {
                this.stopPressAnimator();
                this.startUnPressAnimator();
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    private void startPressAnimator() {
        this.mPressAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.9f});
        this.mPressAnimator.setDuration(200L);
        this.mPressAnimator.setInterpolator((TimeInterpolator)this.mPathInterpolator);
        this.mPressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FloatingOvalButton.this.mCurrentScale = ((Float)animation.getAnimatedValue()).floatValue();
                Log.d((String)"FloatingOvalButton", (String)("mCurrentScale: " + FloatingOvalButton.this.mCurrentScale));
                FloatingOvalButton.this.mShadowLayout.setScaleX(FloatingOvalButton.this.mCurrentScale);
                FloatingOvalButton.this.mShadowLayout.setScaleY(FloatingOvalButton.this.mCurrentScale);
            }
        });
        this.mPressAnimator.start();
    }

    private void stopPressAnimator() {
        if (this.mPressAnimator != null && this.mPressAnimator.isRunning()) {
            this.mPressAnimator.cancel();
        }
    }

    private void startUnPressAnimator() {
        this.mUnPressAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mCurrentScale, 1.0f});
        this.mUnPressAnimator.setDuration(150L);
        this.mUnPressAnimator.setInterpolator((TimeInterpolator)this.mPathInterpolator);
        this.mUnPressAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                FloatingOvalButton.this.mCurrentScale = ((Float)animation.getAnimatedValue()).floatValue();
                Log.d((String)"FloatingOvalButton", (String)("mCurrentScale1: " + FloatingOvalButton.this.mCurrentScale));
                FloatingOvalButton.this.mShadowLayout.setScaleX(FloatingOvalButton.this.mCurrentScale);
                FloatingOvalButton.this.mShadowLayout.setScaleY(FloatingOvalButton.this.mCurrentScale);
            }
        });
        this.mUnPressAnimator.start();
    }
}

