/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.sort;

import android.text.TextUtils;
import android.util.Log;
import java.util.Locale;

public class LocaleSet {
    private static final String CHINESE_LANGUAGE = Locale.CHINESE.getLanguage().toLowerCase();
    private static final String JAPANESE_LANGUAGE = Locale.JAPANESE.getLanguage().toLowerCase();
    private static final String KOREAN_LANGUAGE = Locale.KOREAN.getLanguage().toLowerCase();
    private final LocaleWrapper mPrimaryLocale;
    private final LocaleWrapper mSecondaryLocale;
    private static final String SCRIPT_SIMPLIFIED_CHINESE = "Hans";
    private static final String SCRIPT_TRADITIONAL_CHINESE = "Hant";

    public static LocaleSet getDefault() {
        return new LocaleSet(Locale.getDefault());
    }

    public LocaleSet(Locale locale) {
        this(locale, null);
    }

    public static LocaleSet getLocaleSet(String localeString) {
        try {
            String[] locales;
            Locale primaryLocale;
            if (localeString != null && localeString.indexOf(95) == -1 && (primaryLocale = Locale.forLanguageTag((locales = localeString.split(";"))[0])) != null && !TextUtils.equals((CharSequence)primaryLocale.toLanguageTag(), (CharSequence)"und")) {
                Locale secondaryLocale;
                if (locales.length > 1 && locales[1] != null && (secondaryLocale = Locale.forLanguageTag(locales[1])) != null && !TextUtils.equals((CharSequence)secondaryLocale.toLanguageTag(), (CharSequence)"und")) {
                    return new LocaleSet(primaryLocale, secondaryLocale);
                }
                return new LocaleSet(primaryLocale);
            }
        }
        catch (Exception e) {
            Log.e((String)"ContactLocaleUtils", (String)("getLocaleSet error:" + e));
        }
        return LocaleSet.getDefault();
    }

    public LocaleSet(Locale primaryLocale, Locale secondaryLocale) {
        this.mPrimaryLocale = new LocaleWrapper(primaryLocale);
        this.mSecondaryLocale = new LocaleWrapper(this.mPrimaryLocale.equals(secondaryLocale) ? null : secondaryLocale);
    }

    public LocaleSet normalize() {
        Locale primaryLocale = this.getPrimaryLocale();
        if (primaryLocale == null) {
            return LocaleSet.getDefault();
        }
        Locale secondaryLocale = this.getSecondaryLocale();
        if (secondaryLocale == null || this.isPrimaryLanguage(secondaryLocale.getLanguage()) || this.isPrimaryLocaleCJK() && this.isSecondaryLocaleCJK()) {
            return new LocaleSet(primaryLocale);
        }
        if (this.isSecondaryLanguage(Locale.ENGLISH.getLanguage())) {
            return new LocaleSet(primaryLocale);
        }
        return this;
    }

    public boolean hasSecondaryLocale() {
        return this.mSecondaryLocale.hasLocale();
    }

    public Locale getPrimaryLocale() {
        return this.mPrimaryLocale.getLocale();
    }

    public Locale getSecondaryLocale() {
        return this.mSecondaryLocale.getLocale();
    }

    public boolean isPrimaryLocale(Locale locale) {
        return this.mPrimaryLocale.isLocale(locale);
    }

    public boolean isSecondaryLocale(Locale locale) {
        return this.mSecondaryLocale.isLocale(locale);
    }

    public static boolean isLocaleSimplifiedChinese(Locale locale) {
        if (locale == null || !TextUtils.equals((CharSequence)locale.getLanguage(), (CharSequence)CHINESE_LANGUAGE)) {
            return false;
        }
        try {
            if (!TextUtils.isEmpty((CharSequence)locale.getScript())) {
                return locale.getScript().equals(SCRIPT_SIMPLIFIED_CHINESE);
            }
            return locale.equals(Locale.SIMPLIFIED_CHINESE);
        }
        catch (NoSuchMethodError e) {
            Log.e((String)"ContactLocaleUtils", (String)("isLocaleSimplifiedChinese NoSuchMethodError:" + e + "locale.getLanguage():" + locale.getLanguage()));
            return locale.getLanguage().equals("zh");
        }
    }

    public boolean isPrimaryLocaleSimplifiedChinese() {
        return LocaleSet.isLocaleSimplifiedChinese(this.getPrimaryLocale());
    }

    public boolean isSecondaryLocaleSimplifiedChinese() {
        return LocaleSet.isLocaleSimplifiedChinese(this.getSecondaryLocale());
    }

    public static boolean isLocaleTraditionalChinese(Locale locale) {
        if (locale == null || !TextUtils.equals((CharSequence)locale.getLanguage(), (CharSequence)CHINESE_LANGUAGE)) {
            return false;
        }
        try {
            if (!TextUtils.isEmpty((CharSequence)locale.getScript())) {
                return locale.getScript().equals(SCRIPT_TRADITIONAL_CHINESE);
            }
            return locale.equals(Locale.TRADITIONAL_CHINESE);
        }
        catch (NoSuchMethodError e) {
            Log.e((String)"ContactLocaleUtils", (String)("isLocaleTraditionalChinese NoSuchMethodError:" + e + "locale.getLanguage():" + locale.getLanguage()));
            return locale.getLanguage().equals("zh");
        }
    }

    public boolean isPrimaryLocaleTraditionalChinese() {
        return LocaleSet.isLocaleTraditionalChinese(this.getPrimaryLocale());
    }

    public boolean isSecondaryLocaleTraditionalChinese() {
        return LocaleSet.isLocaleTraditionalChinese(this.getSecondaryLocale());
    }

    public boolean isPrimaryLocaleCJK() {
        return this.mPrimaryLocale.isLocaleCJK();
    }

    public boolean isSecondaryLocaleCJK() {
        return this.mSecondaryLocale.isLocaleCJK();
    }

    public boolean isPrimaryLanguage(String language) {
        return this.mPrimaryLocale.isLanguage(language);
    }

    public boolean isSecondaryLanguage(String language) {
        return this.mSecondaryLocale.isLanguage(language);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LocaleSet) {
            LocaleSet other = (LocaleSet)object;
            return other.isPrimaryLocale(this.mPrimaryLocale.getLocale()) && other.isSecondaryLocale(this.mSecondaryLocale.getLocale());
        }
        return false;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.mPrimaryLocale.toString());
        if (this.hasSecondaryLocale()) {
            builder.append(";");
            builder.append(this.mSecondaryLocale.toString());
        }
        return builder.toString();
    }

    private static class LocaleWrapper {
        private final Locale mLocale;
        private final String mLanguage;
        private final boolean mLocaleIsCJK;

        private static boolean isLanguageCJK(String language) {
            return CHINESE_LANGUAGE.equals(language) || JAPANESE_LANGUAGE.equals(language) || KOREAN_LANGUAGE.equals(language);
        }

        public LocaleWrapper(Locale locale) {
            this.mLocale = locale;
            if (this.mLocale != null) {
                this.mLanguage = this.mLocale.getLanguage().toLowerCase();
                this.mLocaleIsCJK = LocaleWrapper.isLanguageCJK(this.mLanguage);
            } else {
                this.mLanguage = null;
                this.mLocaleIsCJK = false;
            }
        }

        public boolean hasLocale() {
            return this.mLocale != null;
        }

        public Locale getLocale() {
            return this.mLocale;
        }

        public boolean isLocale(Locale locale) {
            return this.mLocale == null ? locale == null : this.mLocale.equals(locale);
        }

        public boolean isLocaleCJK() {
            return this.mLocaleIsCJK;
        }

        public boolean isLanguage(String language) {
            return this.mLanguage == null ? language == null : this.mLanguage.equalsIgnoreCase(language);
        }

        public String toString() {
            String tag;
            try {
                tag = this.mLocale.toLanguageTag();
            }
            catch (NoSuchMethodError e) {
                tag = this.mLocale.toString();
            }
            return this.mLocale != null ? tag : "(null)";
        }
    }
}

