/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.AutoCompleteTextView;
import android.widget.Filterable;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.widget.timepicker.wheel.EaseCubicInterpolator;
import java.util.List;

public class SearchBar
extends FrameLayout {
    private static final int ANIM_TIME = 250;
    private static final int LEFT_MARGIN = 16;
    private ImageView mBackView;
    private ImageView mSearchIcon;
    private TextView mClickView;
    private AutoCompleteTextView mSearchView;
    private int mWidth0;
    private int mWidth1;
    private int mMoveWidth;
    private OnItemClickListener mItemClickListener;
    private OnStateChangeListener mStateChangeListener;
    private ImageView mDeleteAll;
    private boolean mOnSearch;
    private TextWatcher mTextWatcher = new SearchBarTextWatcher();
    private boolean mCompleteInput;
    private View.OnClickListener mBackClickListener = new BackClickListener();

    public SearchBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.os_search_bar_layout, (ViewGroup)this);
        this.initView();
        this.initEvent();
        this.preDraw();
    }

    private void initView() {
        this.mClickView = (TextView)this.findViewById(R.id.text_click);
        this.mSearchView = (AutoCompleteTextView)this.findViewById(R.id.text_search);
        this.mBackView = (ImageView)this.findViewById(R.id.img_btn_back);
        this.mSearchIcon = (ImageView)this.findViewById(R.id.img_search_icon);
        this.mDeleteAll = (ImageView)this.findViewById(R.id.img_delete_all);
    }

    private void initEvent() {
        this.mClickView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                SearchBar.this.startSearch();
            }
        });
        this.mBackView.setOnClickListener(this.mBackClickListener);
        this.mSearchView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (SearchBar.this.mItemClickListener != null) {
                    SearchBar.this.mItemClickListener.onItemClick(parent, view, position, id2);
                }
            }
        });
        this.mDeleteAll.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                boolean isEmpty = TextUtils.isEmpty((CharSequence)SearchBar.this.mSearchView.getText());
                if (!isEmpty || SearchBar.this.mSearchView.length() > 0) {
                    SearchBar.this.mSearchView.setText(null);
                }
            }
        });
        this.mSearchView.addTextChangedListener(this.mTextWatcher);
    }

    public void setBackClickListener(View.OnClickListener listener) {
        this.mBackClickListener = listener;
        this.mBackView.setOnClickListener(this.mBackClickListener);
    }

    public void setTextWatcher(TextWatcher textWatcher) {
        if (null == textWatcher) {
            return;
        }
        this.mSearchView.removeTextChangedListener(this.mTextWatcher);
        this.mTextWatcher = textWatcher;
        this.mSearchView.addTextChangedListener(this.mTextWatcher);
    }

    public void removeTextWatcher(TextWatcher textWatcher) {
        this.mSearchView.removeTextChangedListener(textWatcher);
    }

    private void preDraw() {
        this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                SearchBar.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                SearchBar.this.mBackView.offsetLeftAndRight(-SearchBar.this.mBackView.getMeasuredWidth());
                SearchBar.this.mBackView.setVisibility(8);
                SearchBar.this.mWidth0 = SearchBar.this.mClickView.getMeasuredWidth();
                int leftMargin = SearchBar.this.applyDp(16);
                SearchBar.this.mMoveWidth = SearchBar.this.mBackView.getMeasuredWidth() - leftMargin;
                SearchBar.this.mWidth1 = SearchBar.this.mWidth0 - SearchBar.this.mMoveWidth;
                return true;
            }
        });
    }

    private void backEnterAnim() {
        boolean isRTL = this.getLayoutDirection() == 1;
        int backMove = isRTL ? this.mBackView.getWidth() : -this.mBackView.getWidth();
        ObjectAnimator backAnimator = ObjectAnimator.ofFloat((Object)this.mBackView, (String)"translationX", (float[])new float[]{backMove, 0.0f});
        WidthWrapper wrapper = new WidthWrapper((View)this.mSearchView);
        ObjectAnimator wrapperAnimator = ObjectAnimator.ofInt((Object)wrapper, (String)"width", (int[])new int[]{this.mWidth0, this.mWidth1});
        int moveWidth = isRTL ? -this.mMoveWidth : this.mMoveWidth;
        ObjectAnimator textMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchView, (String)"translationX", (float[])new float[]{0.0f, moveWidth});
        ObjectAnimator iconMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchIcon, (String)"translationX", (float[])new float[]{0.0f, moveWidth});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(250L);
        set.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.4f, 0.0f, 0.2f, 1.0f));
        set.playTogether(new Animator[]{backAnimator, wrapperAnimator, textMoveAnimator, iconMoveAnimator});
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                SearchBar.this.mBackView.setVisibility(0);
            }

            public void onAnimationEnd(Animator animation) {
                SearchBar.this.mBackView.setClickable(true);
            }
        });
        set.start();
    }

    private void backExitAnim() {
        boolean isRTL = this.getLayoutDirection() == 1;
        int backMove = isRTL ? this.mBackView.getWidth() : -this.mBackView.getWidth();
        ObjectAnimator backAnimator = ObjectAnimator.ofFloat((Object)this.mBackView, (String)"translationX", (float[])new float[]{0.0f, backMove});
        WidthWrapper wrapper = new WidthWrapper((View)this.mSearchView);
        ObjectAnimator wrapperAnimator = ObjectAnimator.ofInt((Object)wrapper, (String)"width", (int[])new int[]{this.mWidth1, this.mWidth0});
        int moveWidth = isRTL ? -this.mMoveWidth : this.mMoveWidth;
        ObjectAnimator textMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchView, (String)"translationX", (float[])new float[]{moveWidth, 0.0f});
        ObjectAnimator iconMoveAnimator = ObjectAnimator.ofFloat((Object)this.mSearchIcon, (String)"translationX", (float[])new float[]{moveWidth, 0.0f});
        AnimatorSet set = new AnimatorSet();
        set.setDuration(250L);
        set.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.4f, 0.0f, 0.2f, 1.0f));
        set.playTogether(new Animator[]{backAnimator, wrapperAnimator, textMoveAnimator, iconMoveAnimator});
        set.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                InputMethodManager imm = (InputMethodManager)SearchBar.this.getContext().getSystemService(InputMethodManager.class);
                if (imm != null) {
                    imm.hideSoftInputFromWindow(SearchBar.this.getWindowToken(), 0);
                }
            }

            public void onAnimationEnd(Animator animation) {
                SearchBar.this.mBackView.setVisibility(8);
                SearchBar.this.mSearchView.setVisibility(8);
                SearchBar.this.mClickView.setVisibility(0);
            }
        });
        set.start();
    }

    public void startSearch() {
        this.mOnSearch = true;
        this.mClickView.setVisibility(8);
        this.mSearchView.setVisibility(0);
        this.backEnterAnim();
        this.showSoftInput();
        if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onSearchStart();
        }
    }

    private void showSoftInput() {
        if (this.mSearchView != null) {
            this.mSearchView.requestFocus();
            InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService(InputMethodManager.class);
            if (imm != null) {
                imm.showSoftInput((View)this.mSearchView, 0);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mSearchView.getText()) || this.mSearchView.getText().length() > 0) {
                this.mDeleteAll.setVisibility(0);
            } else {
                this.mDeleteAll.setVisibility(8);
            }
        }
    }

    public void endSearch() {
        this.mOnSearch = false;
        this.mDeleteAll.setVisibility(8);
        this.mSearchView.setText(null);
        this.mBackView.setClickable(false);
        this.backExitAnim();
        if (this.mStateChangeListener != null) {
            this.mStateChangeListener.onSearchEnd();
        }
    }

    public boolean isOnSearch() {
        return this.mOnSearch;
    }

    public void setHint(CharSequence hint) {
        this.mClickView.setText(hint);
        this.mSearchView.setHint(hint);
    }

    public void setHint(int hintId) {
        this.setHint(this.getResources().getString(hintId));
    }

    public void setSearchSource(Context context, List<String> source) {
        ArrayAdapter adapter = new ArrayAdapter(context, R.layout.os_search_source_item_layout, R.id.search_item_text, source);
        this.mSearchView.setAdapter((ListAdapter)adapter);
    }

    public <T extends ListAdapter & Filterable> void setAdapter(T adapter) {
        this.mSearchView.setAdapter(adapter);
    }

    private int applyDp(int valueDp) {
        return (int)TypedValue.applyDimension((int)1, (float)valueDp, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setOnStateChangeListener(OnStateChangeListener l) {
        this.mStateChangeListener = l;
    }

    public void setOnItemClickListener(OnItemClickListener l) {
        this.mItemClickListener = l;
    }

    public void setDeleteButtonVisibility(int visibility) {
        this.mDeleteAll.setVisibility(0);
    }

    public void setText(CharSequence c, boolean submit) {
        this.mCompleteInput = true;
        this.mSearchView.setText(c);
        this.mCompleteInput = false;
        if (submit) {
            this.startSearch();
        }
    }

    public class BackClickListener
    implements View.OnClickListener {
        public void onClick(View v) {
            SearchBar.this.endSearch();
        }
    }

    public class SearchBarTextWatcher
    implements TextWatcher {
        public void beforeTextChanged(CharSequence s, int start, int before, int count) {
            if (SearchBar.this.mCompleteInput) {
                return;
            }
        }

        @CallSuper
        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (count >= 0 && s.toString().trim().length() > 0) {
                SearchBar.this.mDeleteAll.setVisibility(0);
            } else {
                SearchBar.this.mDeleteAll.setVisibility(8);
            }
            if (SearchBar.this.mCompleteInput) {
                return;
            }
        }

        public void afterTextChanged(Editable editable) {
            if (SearchBar.this.mCompleteInput) {
                return;
            }
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(AdapterView<?> var1, View var2, int var3, long var4);
    }

    public static interface OnStateChangeListener {
        public void onSearchStart();

        public void onSearchEnd();
    }

    private class WidthWrapper {
        private View view;

        public WidthWrapper(View view) {
            this.view = view;
        }

        public int getWidth() {
            return this.view.getLayoutParams().width;
        }

        public void setWidth(int width) {
            this.view.getLayoutParams().width = width;
            this.view.requestLayout();
        }
    }
}

