/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.timepicker.wheel;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Camera;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.media.AudioManager;
import android.media.SoundPool;
import android.os.Build;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RawRes;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.widget.timepicker.wheel.EaseCubicInterpolator;
import com.transsion.widgetslib.widget.timepicker.wheel.FixedScroller;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class WheelView<T>
extends View {
    private static final String TAG = "WheelView";
    private static final float DEFAULT_LINE_SPACING = WheelView.dp2px(2.0f);
    private static final float DEFAULT_TEXT_SIZE = WheelView.sp2px(15.0f);
    private static final float DEFAULT_TEXT_BOUNDARY_MARGIN = 0.0f;
    private static final float DEFAULT_DIVIDER_HEIGHT = WheelView.dp2px(1.0f);
    private static final int DEFAULT_VISIBLE_ITEM = 5;
    private static final int DEFAULT_SCROLL_DURATION = 250;
    private static final int MODIFY_SCROLL_DURATION = 350;
    private static final long DEFAULT_CLICK_CONFIRM = 120L;
    private static final String DEFAULT_INTEGER_FORMAT = "%2d";
    private static final float DEFAULT_REFRACT_RATIO = 1.0f;
    public static final int TEXT_ALIGN_LEFT = 0;
    public static final int TEXT_ALIGN_CENTER = 1;
    public static final int TEXT_ALIGN_RIGHT = 2;
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SCROLLING = 2;
    public static final int CURVED_ARC_DIRECTION_LEFT = 0;
    public static final int CURVED_ARC_DIRECTION_CENTER = 1;
    public static final int CURVED_ARC_DIRECTION_RIGHT = 2;
    public static final float DEFAULT_CURVED_FACTOR = 0.75f;
    public static final int DIVIDER_TYPE_FILL = 0;
    public static final int DIVIDER_TYPE_WRAP = 1;
    private Paint mPaint = new Paint(1);
    private Paint mSecondPaint = new Paint(1);
    private Paint mSelectedPaint = new Paint(1);
    private boolean isAutoFitTextSize;
    private Paint.FontMetrics mFontMetrics;
    private int mCenterToBaselineY;
    private int mVisibleItems;
    private float mLineSpacing;
    private boolean isCyclic;
    private int mTextAlign;
    private boolean isShowDivider;
    private int mDividerColor;
    private float mDividerSize;
    private int mDividerType;
    private float mDividerPaddingForWrap;
    private Paint.Cap mDividerCap = Paint.Cap.ROUND;
    private float mDividerOffset;
    private boolean isDrawSelectedRect;
    private int mSelectedRectColor;
    private int mStartX;
    private int mCenterX;
    private int mCenterY;
    private int mSelectedItemTopLimit;
    private int mSelectedItemBottomLimit;
    private int mClipLeft;
    private int mClipTop;
    private int mClipRight;
    private int mClipBottom;
    private Rect mDrawRect;
    private float mTextBoundaryMargin;
    private Camera mCamera;
    private Matrix mMatrix;
    private boolean isCurved;
    private int mCurvedArcDirection;
    private float mCurvedArcDirectionFactor;
    private float mRefractRatio;
    @NonNull
    private List<T> mDataList = new ArrayList<T>(1);
    private boolean isResetSelectedPosition = false;
    private VelocityTracker mVelocityTracker;
    private int mMaxFlingVelocity;
    private int mMinFlingVelocity;
    private FixedScroller mScroller;
    private int mMinScrollY;
    private int mMaxScrollY;
    private float mScrollOffsetY;
    private float mScrolledY = 0.0f;
    private float mDownTouchY;
    private float mDownTouchScrollOffsetY;
    private long mDownStartTime;
    private int mSelectedItemPosition;
    private int mCurrentScrollPosition;
    private boolean mIsBoldForSelectedItem = false;
    private Typeface mNormalTypeface = null;
    private Typeface mBoldTypeface = null;
    private OnItemSelectedListener<T> mOnItemSelectedListener;
    private OnWheelChangedListener mOnWheelChangedListener;
    private SoundHelper mSoundHelper;
    private boolean isSoundEffect = false;
    private int mTextSizeFirst;
    private int mTextSizeSecond;
    private int mTextSizeSelect;
    private int mTextSelectColor;
    private int mTextFirstColor;
    private int mTextSecondColor;
    private int mTextThirdColor;
    private int mItemNormalHeight;
    private int mItemSelectHeight;
    private int mWheelWidth;
    private int mWheelHeight;
    private boolean mYearDays;
    private boolean mHourWheel;
    private boolean mMinuteWheel;
    private boolean mIs24Format;
    private Calendar mCalendar;
    private Calendar mTempCalendar;
    private List<String> mMonthList = new ArrayList<String>();
    private boolean mIsRtl;
    private int mBgColor;
    Matrix mSelectedMatrix = new Matrix();
    private TextPaint mTextPaint = new TextPaint(1);
    private float mDensity;
    float mBaseWidth = 720.0f;
    float mMinScrollGap = 2.0f;
    private int mTotalHeight;
    private boolean mNeedFling;
    private boolean mIsAmPmWheel;
    private float mAmPmMaxUpPull;
    private float mAmPmMaxDownPull;
    protected Runnable mScrollerRun = new Runnable(){

        @Override
        public void run() {
            WheelView.this.updateScroller();
            WheelView.this.runScroller();
        }
    };
    private ValueAnimator mAnimatorAmpmReset;

    public WheelView(Context context) {
        this(context, null);
    }

    public WheelView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public WheelView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttrsAndDefault(context, attrs);
        this.initValue(context);
    }

    private void initAttrsAndDefault(Context context, AttributeSet attrs) {
        this.isAutoFitTextSize = false;
        this.mIsRtl = Utils.isRtl();
        this.mTextAlign = 1;
        this.mTextBoundaryMargin = 0.0f;
        Locale locale = Locale.getDefault();
        Resources res = context.getResources();
        this.mTextSelectColor = ContextCompat.getColor((Context)context, (int)R.color.os_text_primary_color);
        this.mTextFirstColor = ContextCompat.getColor((Context)context, (int)R.color.os_text_quaternary_color);
        this.mTextSecondColor = ContextCompat.getColor((Context)context, (int)R.color.os_text_tertiary_color);
        this.mTextThirdColor = ContextCompat.getColor((Context)context, (int)R.color.os_text_tertiary_color);
        this.mBgColor = ContextCompat.getColor((Context)context, (int)R.color.os_altitude_tertiary_color);
        TypedArray taWidth = context.obtainStyledAttributes(attrs, new int[]{R.attr.wheelWidth});
        this.mWheelWidth = taWidth.getDimensionPixelSize(0, res.getDimensionPixelSize(R.dimen.picker_wheel_width_hour));
        this.mWheelHeight = res.getDimensionPixelSize(R.dimen.picker_wheel_item_height);
        taWidth.recycle();
        this.mTextSizeFirst = res.getDimensionPixelSize(R.dimen.picker_wheel_text_first);
        this.mTextSizeSecond = res.getDimensionPixelSize(R.dimen.picker_wheel_text_first);
        this.mTextSizeSelect = res.getDimensionPixelSize(R.dimen.picker_wheel_text_select);
        this.mItemNormalHeight = res.getDimensionPixelSize(R.dimen.picker_wheel_item_height);
        this.mItemSelectHeight = res.getDimensionPixelSize(R.dimen.picker_wheel_item_height_select);
        this.mSecondPaint.setTextSize((float)this.mTextSizeSecond);
        this.mSecondPaint.setColor(this.mTextSecondColor);
        this.mSelectedPaint.setTextSize((float)this.mTextSizeSecond);
        this.mLineSpacing = DEFAULT_LINE_SPACING;
        this.mVisibleItems = 5;
        this.mVisibleItems = this.adjustVisibleItems(this.mVisibleItems);
        this.mCurrentScrollPosition = this.mSelectedItemPosition = 0;
        this.isCyclic = false;
        this.isShowDivider = false;
        this.mDividerType = 0;
        this.mDividerSize = DEFAULT_DIVIDER_HEIGHT;
        this.mDividerColor = this.mTextSelectColor;
        this.mDividerPaddingForWrap = 0.0f;
        this.mDividerOffset = 0.0f;
        this.isDrawSelectedRect = false;
        this.mSelectedRectColor = 0;
        this.isCurved = false;
        this.mCurvedArcDirection = 1;
        this.mCurvedArcDirectionFactor = 0.75f;
        float curvedRefractRatio = 0.9f;
        this.mRefractRatio = 1.0f;
        float f = this.mRefractRatio = this.isCurved ? Math.min(curvedRefractRatio, this.mRefractRatio) : this.mRefractRatio;
        if (this.mRefractRatio > 1.0f) {
            this.mRefractRatio = 1.0f;
        } else if (this.mRefractRatio < 0.0f) {
            this.mRefractRatio = 1.0f;
        }
        float density = context.getResources().getDisplayMetrics().density;
        this.mBaseWidth = density * 360.0f;
        this.mMinScrollGap = 2.0f * density;
    }

    public void setTextSizeSecond(int textSizeSecond) {
        this.mTextSizeSecond = textSizeSecond;
        this.mSecondPaint.setTextSize((float)this.mTextSizeSecond);
        this.invalidate();
    }

    public int getTextSizeSecond() {
        return this.mTextSizeSecond;
    }

    public void setTextSizeSelect(int textSizeSelect) {
        this.mTextSizeSelect = textSizeSelect;
        this.mSelectedPaint.setTextSize((float)this.mTextSizeSelect);
        this.invalidate();
    }

    public int getTextSizeSelect() {
        return this.mTextSizeSelect;
    }

    public Paint getSecondPaint() {
        return this.mSecondPaint;
    }

    public Paint getSelectedPaint() {
        return this.mSelectedPaint;
    }

    public int getTextSelectColor() {
        return this.mTextSelectColor;
    }

    public void setTextSelectColor(int mTextSelectColor) {
        this.mTextSelectColor = mTextSelectColor;
        this.invalidate();
    }

    public int getTextSecondColor() {
        return this.mTextSecondColor;
    }

    public void setTextSecondColor(int mTextSecondColor) {
        this.mTextSecondColor = mTextSecondColor;
        this.invalidate();
    }

    private void initValue(Context context) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mMaxFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.mMinFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        OvershootInterpolator interpolator = new OvershootInterpolator(2.0f);
        this.mScroller = new FixedScroller(context, (Interpolator)interpolator);
        this.mDrawRect = new Rect();
        this.mCamera = new Camera();
        this.mMatrix = new Matrix();
        this.mDensity = context.getResources().getDisplayMetrics().density;
        if (this.isSoundEffect && !this.isInEditMode()) {
            this.mSoundHelper = SoundHelper.obtain();
            this.initDefaultVolume(context);
        }
        this.calculateTextSize();
        this.updateTextAlign();
        this.post(new Runnable(){

            @Override
            public void run() {
                if (WheelView.this.mIsAmPmWheel && !WheelView.this.isCyclic) {
                    String text = WheelView.this.getDataByIndex(0);
                    if (text == null || text.isEmpty()) {
                        return;
                    }
                    Paint.FontMetrics fontMetrics = WheelView.this.mSelectedPaint.getFontMetrics();
                    float viewAmPmHeight = WheelView.this.getHeight();
                    float textAmPmHeight = fontMetrics.descent - fontMetrics.ascent;
                    WheelView.this.mAmPmMaxUpPull = viewAmPmHeight - textAmPmHeight;
                    WheelView.this.mAmPmMaxDownPull = -WheelView.this.mAmPmMaxUpPull / 2.0f;
                }
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mSoundHelper != null) {
            this.mSoundHelper.release();
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (visibility == 0) {
            if (Utils.isBoldTextAdjustment(this.getContext())) {
                this.mSecondPaint.setTypeface(Typeface.DEFAULT_BOLD);
                this.mSelectedPaint.setTypeface(Typeface.DEFAULT_BOLD);
            } else {
                this.mSecondPaint.setTypeface(Typeface.DEFAULT);
                this.mSelectedPaint.setTypeface(Typeface.DEFAULT);
            }
        }
    }

    private void initDefaultVolume(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            int currentVolume = audioManager.getStreamVolume(3);
            int maxVolume = audioManager.getStreamMaxVolume(3);
            this.mSoundHelper.setPlayVolume((float)currentVolume * 1.0f / (float)maxVolume);
        } else {
            this.mSoundHelper.setPlayVolume(0.3f);
        }
    }

    private void calculateTextSize() {
        this.mPaint.setTextSize((float)this.mTextSizeSelect);
        this.mFontMetrics = this.mPaint.getFontMetrics();
    }

    private void updateTextAlign() {
        switch (this.mTextAlign) {
            case 0: {
                this.mPaint.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 2: {
                this.mPaint.setTextAlign(Paint.Align.RIGHT);
                break;
            }
            default: {
                this.mPaint.setTextAlign(Paint.Align.CENTER);
            }
        }
    }

    public int getWheelHeight() {
        return this.mWheelHeight;
    }

    public void setWheelHeight(int wheelHeight) {
        this.mWheelHeight = wheelHeight;
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = this.isCurved ? (int)((double)(this.mWheelHeight * this.mVisibleItems * 2) / Math.PI + (double)this.getPaddingTop() + (double)this.getPaddingBottom()) : this.mWheelHeight * this.mVisibleItems + this.getPaddingTop() + this.getPaddingBottom();
        int width = (int)((float)(this.mWheelWidth + this.getPaddingLeft() + this.getPaddingRight()) + this.mTextBoundaryMargin * 2.0f);
        if (this.isCurved) {
            int towardRange = (int)(Math.sin(0.06544984694978735) * (double)height);
            width += towardRange;
        }
        this.setMeasuredDimension(WheelView.resolveSizeAndState((int)width, (int)widthMeasureSpec, (int)0), WheelView.resolveSizeAndState((int)height, (int)heightMeasureSpec, (int)0));
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mDrawRect.set(this.getPaddingLeft(), this.getPaddingTop(), this.getWidth() - this.getPaddingRight(), this.getHeight() - this.getPaddingBottom());
        this.mCenterX = this.mDrawRect.centerX();
        this.mCenterY = this.mDrawRect.centerY();
        this.mSelectedItemTopLimit = (int)((float)(this.mCenterY - this.mWheelHeight / 2) - this.mDividerOffset);
        this.mSelectedItemBottomLimit = (int)((float)(this.mCenterY + this.mWheelHeight / 2) + this.mDividerOffset);
        this.mClipLeft = this.getPaddingLeft();
        this.mClipTop = this.getPaddingTop();
        this.mClipRight = this.getWidth() - this.getPaddingRight();
        this.mClipBottom = this.getHeight() - this.getPaddingBottom();
        this.calculateDrawStart();
        this.calculateLimitY();
        int itemDistance = this.calculateItemDistance(this.mSelectedItemPosition);
        if (itemDistance > 0) {
            this.doScroll(itemDistance);
        }
    }

    private void calculateDrawStart() {
        switch (this.mTextAlign) {
            case 0: {
                this.mStartX = (int)((float)this.getPaddingLeft() + this.mTextBoundaryMargin);
                break;
            }
            case 2: {
                this.mStartX = (int)((float)(this.getWidth() - this.getPaddingRight()) - this.mTextBoundaryMargin);
                break;
            }
            default: {
                this.mStartX = this.getWidth() / 2;
            }
        }
        this.mCenterToBaselineY = (int)(this.mFontMetrics.ascent + (this.mFontMetrics.descent - this.mFontMetrics.ascent) / 2.0f);
    }

    private void calculateLimitY() {
        this.mMinScrollY = this.isCyclic ? Integer.MIN_VALUE : 0;
        this.mMaxScrollY = this.isCyclic ? Integer.MAX_VALUE : (this.mDataList.size() - 1) * this.mWheelHeight;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mBgColor != 0) {
            canvas.drawColor(this.mBgColor);
        }
        int itemHeight = this.dividedItemHeight();
        int scrolledItem = (int)(this.mScrollOffsetY / (float)itemHeight);
        int OFFSET_ITEMS = 4;
        float height = this.getHeight();
        float halfHeight = height * 0.5f;
        int SCREEN_ITEMS = (int)(height / (float)itemHeight);
        int ITEMS = 4 + SCREEN_ITEMS;
        int index = scrolledItem - (ITEMS >> 1);
        float endIndex = index + ITEMS;
        float halfItemHeight = (float)itemHeight * 0.5f;
        float top = halfHeight - halfItemHeight - this.mScrollOffsetY;
        float cy = halfHeight;
        while ((float)index < endIndex) {
            float oy = top + (float)(index * itemHeight);
            float dy = Math.abs(cy - oy - halfItemHeight);
            if (dy < halfItemHeight) {
                float scale = 1.0f - dy / halfItemHeight;
                float textSizeScale = 1.0f + 1.0f * (float)(this.mTextSizeSelect - this.mTextSizeSecond) / (float)this.mTextSizeSecond * scale;
                this.mSelectedPaint.setTextSize(textSizeScale * (float)this.mTextSizeSecond);
                int textColor = this.textColorScale(scale);
                this.mSelectedPaint.setColor(textColor);
                this.drawItem2(canvas, this.mSelectedPaint, index, oy, itemHeight);
            } else {
                this.drawItem2(canvas, this.mSecondPaint, index, oy, itemHeight);
            }
            ++index;
        }
    }

    int textColorScale(float scale) {
        if (this.mTextSecondColor == this.mTextSelectColor) {
            return this.mTextSelectColor;
        }
        int srcColorA = (this.mTextSecondColor & 0xFF000000) >>> 24;
        int srcColorR = (this.mTextSecondColor & 0xFF0000) >>> 16;
        int srcColorG = (this.mTextSecondColor & 0xFF00) >>> 8;
        int srcColorB = this.mTextSecondColor & 0xFF;
        int targetColorA = (this.mTextSelectColor & 0xFF000000) >>> 24;
        int targetColorR = (this.mTextSelectColor & 0xFF0000) >>> 16;
        int targetColorG = (this.mTextSelectColor & 0xFF00) >>> 8;
        int targetColorB = this.mTextSelectColor & 0xFF;
        int colorA = (int)((float)srcColorA + (float)(targetColorA - srcColorA) * scale);
        int colorR = (int)((float)srcColorR + (float)(targetColorR - srcColorR) * scale);
        int colorG = (int)((float)srcColorG + (float)(targetColorG - srcColorG) * scale);
        int colorB = (int)((float)srcColorB + (float)(targetColorB - srcColorB) * scale);
        return colorA << 24 | colorR << 16 | colorG << 8 | colorB;
    }

    private void drawItem2(Canvas canvas, Paint paint, int index, float offsetY, float itemHeight) {
        String text = this.getDataByIndex(index);
        if (text == null) {
            return;
        }
        float textSize = paint.getTextSize();
        float textWidth = paint.measureText(text);
        float dy = (itemHeight - textSize) * 0.5f;
        float reset = (float)this.getWidth() - textWidth;
        if (reset < 0.0f) {
            text = TextUtils.ellipsize((CharSequence)text, (TextPaint)new TextPaint(paint), (float)this.getWidth(), (TextUtils.TruncateAt)TextUtils.TruncateAt.END).toString();
            reset = (float)this.getWidth() - textWidth;
        }
        float left = reset > 0.0f ? reset * 0.5f : 0.0f;
        float top = offsetY + dy + textSize;
        canvas.drawText(text, left, top, paint);
    }

    private int remeasureTextSize(String contentText) {
        float textWidth = this.mPaint.measureText(contentText);
        float textMargin = this.mTextBoundaryMargin * 2.0f;
        float drawWidth = this.getWidth();
        if (textMargin > drawWidth / 10.0f) {
            drawWidth = drawWidth * 9.0f / 10.0f;
            textMargin = drawWidth / 10.0f;
        } else {
            drawWidth -= textMargin;
        }
        if (drawWidth <= 0.0f) {
            return this.mCenterToBaselineY;
        }
        float textSize = this.mTextSizeSecond;
        while (textWidth > drawWidth && !((textSize -= 1.0f) <= 0.0f)) {
            this.mPaint.setTextSize(textSize);
            textWidth = this.mPaint.measureText(contentText);
        }
        this.recalculateStartX(textMargin / 2.0f);
        return this.recalculateCenterToBaselineY();
    }

    private void recalculateStartX(float textMargin) {
        switch (this.mTextAlign) {
            case 0: {
                this.mStartX = (int)textMargin;
                break;
            }
            case 2: {
                this.mStartX = (int)((float)this.getWidth() - textMargin);
                break;
            }
            default: {
                this.mStartX = this.getWidth() / 2;
            }
        }
    }

    private int recalculateCenterToBaselineY() {
        Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
        return (int)(fontMetrics.ascent + (fontMetrics.descent - fontMetrics.ascent) / 2.0f);
    }

    private String getDataByIndex(int index) {
        int dataSize = this.mDataList.size();
        if (dataSize == 0) {
            return null;
        }
        String itemText = null;
        if (this.isCyclic) {
            int i = index % dataSize;
            if (i < 0) {
                i += dataSize;
            }
            itemText = this.getDataText(this.mDataList.get(i));
        } else if (index >= 0 && index < dataSize) {
            itemText = this.getDataText(this.mDataList.get(index));
        }
        if (this.mYearDays && !TextUtils.isEmpty(itemText)) {
            itemText = this.dayOfYearToMonthDay(itemText);
        }
        return itemText;
    }

    protected String getDataText(T item) {
        if (item == null) {
            return "";
        }
        if (item instanceof Integer) {
            int value = (Integer)item;
            String format = this.mHourWheel ? (this.mIs24Format ? "%02d" : "%d") : (this.mMinuteWheel ? "%02d" : "%d");
            return String.format(Locale.getDefault(), format, value) + "";
        }
        if (item instanceof String) {
            return (String)item;
        }
        return item.toString();
    }

    protected void forceStopScroller() {
        if (!this.mScroller.isFinished()) {
            this.mScroller.forceFinished(true);
        }
    }

    protected void runScroller() {
        if (this.mScroller.isFinished()) {
            return;
        }
        ViewCompat.postOnAnimation((View)this, (Runnable)this.mScrollerRun);
    }

    protected void updateScroller() {
        boolean computeUpdate = this.mScroller.computeScrollOffset();
        if (!computeUpdate) {
            return;
        }
        float startAnimValue = this.mScrollOffsetY;
        boolean scrollerFinished = this.mScroller.isFinished();
        this.mScrollOffsetY = (float)this.mScroller.getCurrY() + this.mScroller.getFixedFlingValue();
        if (this.mIsAmPmWheel && !this.isCyclic) {
            if (scrollerFinished) {
                this.animResetAmpmLocation(startAnimValue, this.mScrollOffsetY);
            } else {
                this.invalidateIfYChanged();
            }
        } else {
            this.invalidateIfYChanged();
        }
    }

    float modifyScrollerPosition(boolean scrollAnimation, float clickToCenterDistance) {
        boolean isInMaxRange;
        float scrollRange = clickToCenterDistance + this.calculateDistanceToEndPoint((clickToCenterDistance + this.mScrollOffsetY) % (float)this.dividedItemHeight());
        boolean isInMinRange = scrollRange < 0.0f && this.mScrollOffsetY + scrollRange >= (float)this.mMinScrollY;
        boolean bl = isInMaxRange = scrollRange > 0.0f && this.mScrollOffsetY + scrollRange <= (float)this.mMaxScrollY;
        if (isInMinRange || isInMaxRange) {
            if (scrollAnimation) {
                this.mScroller.startScroll(0, (int)this.mScrollOffsetY, 0, (int)scrollRange, 350);
            }
            return scrollRange;
        }
        return 0.0f;
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        if (this.isAnimResetAmpmRunning()) {
            return false;
        }
        if (!this.isEnabled() || this.mDataList.isEmpty()) {
            return super.onTouchEvent(event);
        }
        this.initVelocityTracker();
        this.mVelocityTracker.addMovement(event);
        switch (event.getActionMasked()) {
            case 0: {
                if (this.getParent() != null) {
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                }
                this.forceStopScroller();
                this.mDownTouchY = event.getY();
                this.mDownTouchScrollOffsetY = this.mScrollOffsetY;
                this.mDownStartTime = System.currentTimeMillis();
                this.mTotalHeight = (int)(Utils.measureTextHeight(this.mSecondPaint) * (float)this.mDataList.size());
                this.mNeedFling = false;
                break;
            }
            case 2: {
                float moveY = event.getY();
                float deltaY = this.mDownTouchY - moveY;
                if (Math.abs(deltaY) >= (float)this.mTotalHeight) {
                    this.mNeedFling = true;
                }
                this.mScrollOffsetY = this.mDownTouchScrollOffsetY + deltaY;
                if (this.mIsAmPmWheel && !this.isCyclic) {
                    if (this.mScrollOffsetY > this.mAmPmMaxUpPull) {
                        this.mScrollOffsetY = this.mAmPmMaxUpPull;
                    }
                    if (this.mScrollOffsetY < this.mAmPmMaxDownPull) {
                        this.mScrollOffsetY = this.mAmPmMaxDownPull;
                    }
                }
                if (this.mOnWheelChangedListener != null) {
                    this.mOnWheelChangedListener.onWheelScrollStateChanged(1);
                }
                this.onWheelScrollStateChanged(1);
                this.invalidateIfYChanged();
                break;
            }
            case 1: 
            case 3: {
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaxFlingVelocity);
                float velocityY = this.mVelocityTracker.getYVelocity();
                if (Math.abs(velocityY) > (float)this.mMinFlingVelocity || this.mNeedFling) {
                    this.forceStopScroller();
                    this.mScroller.fling(0, (int)this.mScrollOffsetY, 0, (int)(-velocityY), 0, 0, this.mMinScrollY, this.mMaxScrollY);
                    float finalY = this.mScroller.getFinalY();
                    float scrollOffsetY = this.mScrollOffsetY;
                    this.mScrollOffsetY = finalY;
                    float modifyY = this.modifyScrollerPosition(false, 0.0f);
                    this.mScrollOffsetY = scrollOffsetY;
                    this.mScroller.setFixedFlingValue(modifyY);
                } else {
                    int clickToCenterDistance = 0;
                    if (System.currentTimeMillis() - this.mDownStartTime <= 120L) {
                        clickToCenterDistance = (int)(event.getY() - (float)this.mCenterY);
                    }
                    this.modifyScrollerPosition(true, clickToCenterDistance);
                }
                this.runScroller();
                this.invalidateIfYChanged();
                this.recycleVelocityTracker();
            }
        }
        return true;
    }

    private void initVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void doScroll(float distance) {
        this.mScrollOffsetY += distance;
        if (!this.isCyclic) {
            if (this.mScrollOffsetY < (float)this.mMinScrollY) {
                this.mScrollOffsetY = this.mMinScrollY;
            } else if (this.mScrollOffsetY > (float)this.mMaxScrollY) {
                this.mScrollOffsetY = this.mMaxScrollY;
            }
        }
    }

    private void invalidateIfYChanged() {
        if (this.mScrollOffsetY != this.mScrolledY) {
            this.mScrolledY = this.mScrollOffsetY;
            if (this.mOnWheelChangedListener != null) {
                this.mOnWheelChangedListener.onWheelScroll((int)this.mScrollOffsetY);
            }
            this.onWheelScroll(this.mScrollOffsetY);
            this.observeItemChanged();
            this.invalidate();
        }
    }

    private void observeItemChanged() {
        int oldPosition = this.mCurrentScrollPosition;
        int newPosition = this.getCurrentPosition();
        if (oldPosition != newPosition) {
            if (this.mOnWheelChangedListener != null && this.mScrolledY >= (float)this.mMinScrollY && this.mScrolledY <= (float)this.mMaxScrollY) {
                this.mOnWheelChangedListener.onWheelItemChanged(oldPosition, newPosition);
            }
            this.onWheelItemChanged(oldPosition, newPosition);
            this.playSoundEffect();
            this.mCurrentScrollPosition = newPosition;
            this.mSelectedItemPosition = newPosition;
        }
    }

    public void playSoundEffect() {
        if (this.mSoundHelper != null && this.isSoundEffect) {
            this.mSoundHelper.playSoundEffect();
        }
    }

    public void forceFinishScroll() {
        if (!this.mScroller.isFinished()) {
            this.mScroller.forceFinished(true);
        }
    }

    public void abortFinishScroll() {
        if (!this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
    }

    private float calculateDistanceToEndPoint(float remainder) {
        if (Math.abs(remainder) > (float)(this.mWheelHeight / 2)) {
            if (this.mScrollOffsetY < 0.0f) {
                return (float)(-this.mWheelHeight) - remainder;
            }
            return (float)this.mWheelHeight - remainder;
        }
        return -remainder;
    }

    private int getCurrentPosition() {
        if (this.mDataList.isEmpty()) {
            return -1;
        }
        int itemPosition = this.mScrollOffsetY < 0.0f ? (int)((this.mScrollOffsetY - (float)(this.mWheelHeight / 2)) / (float)this.dividedItemHeight()) : (int)((this.mScrollOffsetY + (float)(this.mWheelHeight / 2)) / (float)this.dividedItemHeight());
        int currentPosition = itemPosition % this.mDataList.size();
        if (currentPosition < 0) {
            currentPosition += this.mDataList.size();
        }
        return currentPosition;
    }

    private int dividedItemHeight() {
        return this.mWheelHeight > 0 ? this.mWheelHeight : 1;
    }

    public boolean isSoundEffect() {
        return this.isSoundEffect;
    }

    public void setSoundEffect(boolean isSoundEffect) {
        this.isSoundEffect = isSoundEffect;
    }

    public void setSoundEffectResource(@RawRes int rawResId) {
        if (this.mSoundHelper != null) {
            this.mSoundHelper.load(this.getContext(), rawResId);
        }
    }

    public float getPlayVolume() {
        return this.mSoundHelper == null ? 0.0f : this.mSoundHelper.getPlayVolume();
    }

    public void setPlayVolume(@FloatRange(from=0.0, to=1.0) float playVolume) {
        if (this.mSoundHelper != null) {
            this.mSoundHelper.setPlayVolume(playVolume);
        }
    }

    @Nullable
    public T getItemData(int position) {
        if (this.isPositionInRange(position)) {
            return this.mDataList.get(position);
        }
        if (this.mDataList.size() > 0 && position >= this.mDataList.size()) {
            return this.mDataList.get(this.mDataList.size() - 1);
        }
        if (this.mDataList.size() > 0 && position < 0) {
            return this.mDataList.get(0);
        }
        return null;
    }

    public T getSelectedItemData() {
        return this.getItemData(this.mSelectedItemPosition);
    }

    public List<T> getData() {
        return this.mDataList;
    }

    public void setData(List<T> dataList) {
        if (dataList == null) {
            return;
        }
        this.mDataList = dataList;
        if (!this.isResetSelectedPosition && this.mDataList.size() > 0) {
            if (this.mSelectedItemPosition >= this.mDataList.size()) {
                this.mCurrentScrollPosition = this.mSelectedItemPosition = this.mDataList.size() - 1;
            }
        } else {
            this.mSelectedItemPosition = 0;
            this.mCurrentScrollPosition = 0;
        }
        this.forceFinishScroll();
        this.calculateTextSize();
        this.calculateLimitY();
        this.mScrollOffsetY = this.mSelectedItemPosition * this.mWheelHeight;
        this.requestLayout();
        this.invalidate();
    }

    public boolean isResetSelectedPosition() {
        return this.isResetSelectedPosition;
    }

    public void setResetSelectedPosition(boolean isResetSelectedPosition) {
        this.isResetSelectedPosition = isResetSelectedPosition;
    }

    public boolean isAutoFitTextSize() {
        return this.isAutoFitTextSize;
    }

    public void setAutoFitTextSize(boolean isAutoFitTextSize) {
        this.isAutoFitTextSize = isAutoFitTextSize;
        this.invalidate();
    }

    public Typeface getTypeface() {
        return this.mPaint.getTypeface();
    }

    public void setTypeface(Typeface typeface) {
        this.setTypeface(typeface, false);
    }

    public void setTypeface(Typeface typeface, boolean isBoldForSelectedItem) {
        if (typeface == null || this.mPaint.getTypeface() == typeface) {
            return;
        }
        this.forceFinishScroll();
        this.mIsBoldForSelectedItem = isBoldForSelectedItem;
        if (this.mIsBoldForSelectedItem) {
            if (typeface.isBold()) {
                this.mNormalTypeface = Typeface.create((Typeface)typeface, (int)0);
                this.mBoldTypeface = typeface;
            } else {
                this.mNormalTypeface = typeface;
                this.mBoldTypeface = Typeface.create((Typeface)typeface, (int)1);
            }
            this.mPaint.setTypeface(this.mBoldTypeface);
        } else {
            this.mPaint.setTypeface(typeface);
        }
        this.calculateTextSize();
        this.calculateDrawStart();
        this.mScrollOffsetY = this.mSelectedItemPosition * this.mWheelHeight;
        this.calculateLimitY();
        this.requestLayout();
        this.invalidate();
    }

    public int getTextAlign() {
        return this.mTextAlign;
    }

    public void setTextAlign(int textAlign) {
        if (this.mTextAlign == textAlign) {
            return;
        }
        this.mTextAlign = textAlign;
        this.updateTextAlign();
        this.calculateDrawStart();
        this.invalidate();
    }

    public float getTextBoundaryMargin() {
        return this.mTextBoundaryMargin;
    }

    public void setTextBoundaryMargin(float textBoundaryMargin) {
        this.setTextBoundaryMargin(textBoundaryMargin, false);
    }

    public void setTextBoundaryMargin(float textBoundaryMargin, boolean isDp) {
        float tempTextBoundaryMargin = this.mTextBoundaryMargin;
        float f = this.mTextBoundaryMargin = isDp ? WheelView.dp2px(textBoundaryMargin) : textBoundaryMargin;
        if (tempTextBoundaryMargin == this.mTextBoundaryMargin) {
            return;
        }
        this.requestLayout();
        this.invalidate();
    }

    public float getLineSpacing() {
        return this.mLineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.setLineSpacing(lineSpacing, false);
    }

    public void setLineSpacing(float lineSpacing, boolean isDp) {
        float tempLineSpace = this.mLineSpacing;
        float f = this.mLineSpacing = isDp ? WheelView.dp2px(lineSpacing) : lineSpacing;
        if (tempLineSpace == this.mLineSpacing) {
            return;
        }
        this.mScrollOffsetY = 0.0f;
        this.calculateTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public int getVisibleItems() {
        return this.mVisibleItems;
    }

    public void setVisibleItems(int visibleItems) {
        if (this.mVisibleItems == visibleItems) {
            return;
        }
        this.mVisibleItems = this.adjustVisibleItems(visibleItems);
        this.mScrollOffsetY = 0.0f;
        this.requestLayout();
        this.invalidate();
    }

    private int adjustVisibleItems(int visibleItems) {
        return Math.abs(visibleItems / 2 * 2 + 1);
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean isCyclic) {
        if (this.isCyclic == isCyclic) {
            return;
        }
        this.isCyclic = isCyclic;
        this.forceFinishScroll();
        this.calculateLimitY();
        this.mScrollOffsetY = this.mSelectedItemPosition * this.mWheelHeight;
        this.invalidate();
    }

    public int getSelectedItemPosition() {
        return this.mSelectedItemPosition;
    }

    public void setSelectedItemPosition(int position) {
        this.setSelectedItemPosition(position, false);
    }

    public void setSelectedItemPosition(int position, boolean isSmoothScroll) {
        this.setSelectedItemPosition(position, isSmoothScroll, 0);
    }

    public void setSelectedItemPosition(int position, boolean isSmoothScroll, int smoothDuration) {
        if (!this.isPositionInRange(position)) {
            return;
        }
        int itemDistance = this.calculateItemDistance(position);
        if (itemDistance == 0) {
            return;
        }
        this.abortFinishScroll();
        if (isSmoothScroll) {
            this.mScroller.startScroll(0, (int)this.mScrollOffsetY, 0, itemDistance, smoothDuration > 0 ? smoothDuration : 250);
            this.invalidateIfYChanged();
        } else {
            this.doScroll(itemDistance);
            this.mSelectedItemPosition = position;
            if (this.mOnItemSelectedListener != null) {
                this.mOnItemSelectedListener.onItemSelected(this, this.mDataList.get(this.mSelectedItemPosition), this.mSelectedItemPosition);
            }
            this.onItemSelected(this.mDataList.get(this.mSelectedItemPosition), this.mSelectedItemPosition);
            if (this.mOnWheelChangedListener != null) {
                this.mOnWheelChangedListener.onWheelSelected(this.mSelectedItemPosition);
            }
            this.onWheelSelected(this.mSelectedItemPosition);
            this.invalidateIfYChanged();
        }
    }

    private int calculateItemDistance(int position) {
        return (int)((float)(position * this.mWheelHeight) - this.mScrollOffsetY);
    }

    public boolean isPositionInRange(int position) {
        return position >= 0 && position < this.mDataList.size();
    }

    public boolean isShowDivider() {
        return this.isShowDivider;
    }

    public void setShowDivider(boolean isShowDivider) {
        if (this.isShowDivider == isShowDivider) {
            return;
        }
        this.isShowDivider = isShowDivider;
        this.invalidate();
    }

    public int getDividerColor() {
        return this.mDividerColor;
    }

    public void setDividerColorRes(@ColorRes int dividerColorRes) {
        this.setDividerColor(ContextCompat.getColor((Context)this.getContext(), (int)dividerColorRes));
    }

    public void setDividerColor(@ColorInt int dividerColor) {
        if (this.mDividerColor == dividerColor) {
            return;
        }
        this.mDividerColor = dividerColor;
        this.invalidate();
    }

    public float getDividerHeight() {
        return this.mDividerSize;
    }

    public void setDividerHeight(float dividerHeight) {
        this.setDividerHeight(dividerHeight, false);
    }

    public void setDividerHeight(float dividerHeight, boolean isDp) {
        float tempDividerHeight = this.mDividerSize;
        float f = this.mDividerSize = isDp ? WheelView.dp2px(dividerHeight) : dividerHeight;
        if (tempDividerHeight == this.mDividerSize) {
            return;
        }
        this.invalidate();
    }

    public int getDividerType() {
        return this.mDividerType;
    }

    public void setDividerType(int dividerType) {
        if (this.mDividerType == dividerType) {
            return;
        }
        this.mDividerType = dividerType;
        this.invalidate();
    }

    public float getDividerPaddingForWrap() {
        return this.mDividerPaddingForWrap;
    }

    public void setDividerPaddingForWrap(float dividerPaddingForWrap) {
        this.setDividerPaddingForWrap(dividerPaddingForWrap, false);
    }

    public void setDividerPaddingForWrap(float dividerPaddingForWrap, boolean isDp) {
        float tempDividerPadding = this.mDividerPaddingForWrap;
        float f = this.mDividerPaddingForWrap = isDp ? WheelView.dp2px(dividerPaddingForWrap) : dividerPaddingForWrap;
        if (tempDividerPadding == this.mDividerPaddingForWrap) {
            return;
        }
        this.invalidate();
    }

    public Paint.Cap getDividerCap() {
        return this.mDividerCap;
    }

    public void setDividerCap(Paint.Cap dividerCap) {
        if (this.mDividerCap == dividerCap) {
            return;
        }
        this.mDividerCap = dividerCap;
        this.invalidate();
    }

    public boolean isDrawSelectedRect() {
        return this.isDrawSelectedRect;
    }

    public void setDrawSelectedRect(boolean isDrawSelectedRect) {
        this.isDrawSelectedRect = isDrawSelectedRect;
        this.invalidate();
    }

    public int getSelectedRectColor() {
        return this.mSelectedRectColor;
    }

    public void setSelectedRectColorRes(@ColorRes int selectedRectColorRes) {
        this.setSelectedRectColor(ContextCompat.getColor((Context)this.getContext(), (int)selectedRectColorRes));
    }

    public void setSelectedRectColor(@ColorInt int selectedRectColor) {
        this.mSelectedRectColor = selectedRectColor;
        this.invalidate();
    }

    public boolean isCurved() {
        return this.isCurved;
    }

    public void setCurved(boolean isCurved) {
        if (this.isCurved == isCurved) {
            return;
        }
        this.isCurved = isCurved;
        this.calculateTextSize();
        this.requestLayout();
        this.invalidate();
    }

    public int getCurvedArcDirection() {
        return this.mCurvedArcDirection;
    }

    public void setCurvedArcDirection(int curvedArcDirection) {
        if (this.mCurvedArcDirection == curvedArcDirection) {
            return;
        }
        this.mCurvedArcDirection = curvedArcDirection;
        this.invalidate();
    }

    public float getCurvedArcDirectionFactor() {
        return this.mCurvedArcDirectionFactor;
    }

    public void setCurvedArcDirectionFactor(@FloatRange(from=0.0, to=1.0) float curvedArcDirectionFactor) {
        if (this.mCurvedArcDirectionFactor == curvedArcDirectionFactor) {
            return;
        }
        if (curvedArcDirectionFactor < 0.0f) {
            curvedArcDirectionFactor = 0.0f;
        } else if (curvedArcDirectionFactor > 1.0f) {
            curvedArcDirectionFactor = 1.0f;
        }
        this.mCurvedArcDirectionFactor = curvedArcDirectionFactor;
        this.invalidate();
    }

    public float getRefractRatio() {
        return this.mRefractRatio;
    }

    public void setRefractRatio(@FloatRange(from=0.0, to=1.0) float refractRatio) {
        float tempRefractRatio = this.mRefractRatio;
        this.mRefractRatio = refractRatio;
        if (this.mRefractRatio > 1.0f) {
            this.mRefractRatio = 1.0f;
        } else if (this.mRefractRatio < 0.0f) {
            this.mRefractRatio = 1.0f;
        }
        if (tempRefractRatio == this.mRefractRatio) {
            return;
        }
        this.invalidate();
    }

    @Deprecated
    public float getCurvedRefractRatio() {
        return this.mRefractRatio;
    }

    @Deprecated
    public void setCurvedRefractRatio(@FloatRange(from=0.0, to=1.0) float refractRatio) {
        this.setRefractRatio(refractRatio);
    }

    public OnItemSelectedListener<T> getOnItemSelectedListener() {
        return this.mOnItemSelectedListener;
    }

    public void setOnItemSelectedListener(OnItemSelectedListener<T> onItemSelectedListener) {
        this.mOnItemSelectedListener = onItemSelectedListener;
    }

    public OnWheelChangedListener getOnWheelChangedListener() {
        return this.mOnWheelChangedListener;
    }

    public void setOnWheelChangedListener(OnWheelChangedListener onWheelChangedListener) {
        this.mOnWheelChangedListener = onWheelChangedListener;
    }

    protected void onWheelScroll(float scrollOffsetY) {
    }

    protected void onWheelItemChanged(int oldPosition, int newPosition) {
    }

    protected void onWheelSelected(int position) {
    }

    protected void onWheelScrollStateChanged(int state) {
    }

    protected void onItemSelected(T data, int position) {
    }

    protected static float dp2px(float dp) {
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    protected static float sp2px(float sp) {
        return TypedValue.applyDimension((int)2, (float)sp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public boolean isYearDays() {
        return this.mYearDays;
    }

    public void setYearDays(Calendar calendar, boolean yearDays) {
        this.mCalendar = calendar;
        this.mYearDays = yearDays;
    }

    public void setHourWheel(boolean hourWheel) {
        this.mHourWheel = hourWheel;
    }

    public void setMinuteWheel(boolean minuteWheel) {
        this.mMinuteWheel = minuteWheel;
    }

    public void setAmPmWheel(boolean amPmWheel) {
        this.mIsAmPmWheel = amPmWheel;
    }

    public void set24HoursFormat(boolean hoursFormat) {
        this.mIs24Format = hoursFormat;
    }

    public void setMonthList(List<String> monthList) {
        this.mMonthList = monthList;
    }

    private String dayOfYearToMonthDay(String dayOfYearStr) {
        if (this.mCalendar == null) {
            return null;
        }
        int dayOfYear = Integer.parseInt(dayOfYearStr);
        if (this.mTempCalendar == null) {
            this.mTempCalendar = Calendar.getInstance();
        }
        this.mTempCalendar.set(1, this.mCalendar.get(1));
        this.mTempCalendar.set(6, dayOfYear);
        int month = this.mTempCalendar.get(2);
        String result = "";
        if (this.mMonthList != null && this.mMonthList.size() > month) {
            int day = this.mTempCalendar.get(5);
            result = this.mIsRtl ? String.format(Locale.getDefault(), "%d", day) + this.getContext().getString(R.string.day_time_picker) + " " + this.mMonthList.get(month) : this.mMonthList.get(month) + " " + String.format(Locale.getDefault(), "%d", day) + this.getContext().getString(R.string.day_time_picker);
        }
        return result;
    }

    public void setWheelBackgroundColor(int color2) {
        this.mBgColor = color2;
    }

    private void resizeTextSize(Paint paint, String text) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            int width = this.getWidth();
            if (width == 0) {
                return;
            }
            this.mTextPaint.setTextSize(paint.getTextSize());
            int itemWidth = (int)Math.ceil(Layout.getDesiredWidth((CharSequence)text, (TextPaint)this.mTextPaint));
            if (itemWidth > width) {
                this.mPaint.setTextSize(this.mPaint.getTextSize() - this.mDensity);
                this.resizeTextSize(paint, text);
            }
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (!hasWindowFocus) {
            this.abortFinishScroll();
            this.setSelectedItemPosition(this.getSelectedItemPosition());
        }
    }

    private void animResetAmpmLocation(float start, float end) {
        if (start == end) {
            return;
        }
        if (this.mAnimatorAmpmReset == null) {
            this.mAnimatorAmpmReset = ValueAnimator.ofFloat((float[])new float[0]);
            this.mAnimatorAmpmReset.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.25f, 0.0f, 0.0f, 1.0f));
            this.mAnimatorAmpmReset.setDuration(200L);
            this.mAnimatorAmpmReset.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    Object animatedValue = valueAnimator.getAnimatedValue();
                    if (animatedValue instanceof Float) {
                        WheelView.this.mScrollOffsetY = ((Float)animatedValue).floatValue();
                        WheelView.this.invalidateIfYChanged();
                    }
                }
            });
        }
        this.mAnimatorAmpmReset.setFloatValues(new float[]{start, end});
        this.mAnimatorAmpmReset.start();
    }

    private boolean isAnimResetAmpmRunning() {
        return this.mAnimatorAmpmReset != null && this.mAnimatorAmpmReset.isRunning();
    }

    private static class SoundHelper {
        private SoundPool mSoundPool = Build.VERSION.SDK_INT >= 21 ? new SoundPool.Builder().build() : new SoundPool(1, 1, 1);
        private int mSoundId;
        private float mPlayVolume;

        private SoundHelper() {
        }

        static SoundHelper obtain() {
            return new SoundHelper();
        }

        void load(Context context, @RawRes int resId) {
            if (this.mSoundPool != null) {
                this.mSoundId = this.mSoundPool.load(context, resId, 1);
            }
        }

        void setPlayVolume(@FloatRange(from=0.0, to=1.0) float playVolume) {
            this.mPlayVolume = playVolume;
        }

        float getPlayVolume() {
            return this.mPlayVolume;
        }

        void playSoundEffect() {
            if (this.mSoundPool != null && this.mSoundId != 0) {
                this.mSoundPool.play(this.mSoundId, this.mPlayVolume, this.mPlayVolume, 1, 0, 1.0f);
            }
        }

        void release() {
            if (this.mSoundPool != null) {
                this.mSoundPool.release();
                this.mSoundPool = null;
            }
        }
    }

    public static interface OnWheelChangedListener {
        public void onWheelScroll(int var1);

        public void onWheelItemChanged(int var1, int var2);

        public void onWheelSelected(int var1);

        public void onWheelScrollStateChanged(int var1);
    }

    public static interface OnItemSelectedListener<T> {
        public void onItemSelected(WheelView<T> var1, T var2, int var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DividerType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CurvedArcDirection {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TextAlign {
    }
}

