/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.anim;

import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FloatValueHolder;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;

public class OSSpringPropertyAnimation {
    private SpringAnimation mSpringAnimation;
    private final float mStartValue;
    private final float mFinalValue;
    private final float mStiffness;
    private final float mDampingRatio;
    private final FloatValueHolder mFloatValueHolder;
    private final float mVelocity;
    private DynamicAnimation.OnAnimationUpdateListener mOnAnimationUpdateListener;

    private OSSpringPropertyAnimation(Builder builder) {
        this.mStartValue = builder.startValue;
        this.mFinalValue = builder.finalValue;
        this.mStiffness = builder.stiffness;
        this.mDampingRatio = builder.dampingRatio;
        this.mFloatValueHolder = builder.floatValueHolder;
        this.mVelocity = builder.velocity;
        this.mOnAnimationUpdateListener = builder.onAnimationUpdateListener;
        this.createAnimation();
    }

    private OSSpringPropertyAnimation createAnimation() {
        SpringForce springForce = new SpringForce().setStiffness(this.mStiffness).setDampingRatio(this.mDampingRatio);
        springForce.setFinalPosition(this.mFinalValue);
        this.mSpringAnimation = new SpringAnimation(this.mFloatValueHolder);
        this.mSpringAnimation.setSpring(springForce);
        this.mSpringAnimation.setStartValue(this.mStartValue);
        this.mSpringAnimation.setStartVelocity(this.mVelocity);
        this.mSpringAnimation.setMinimumVisibleChange(0.002f);
        if (this.mOnAnimationUpdateListener != null) {
            this.mSpringAnimation.addUpdateListener(this.mOnAnimationUpdateListener);
        }
        return this;
    }

    private SpringAnimation getSpringAnimation() {
        return this.mSpringAnimation;
    }

    public static class Builder {
        private float startValue = 1.0f;
        private float finalValue;
        private float stiffness = 350.0f;
        private float dampingRatio = 1.2f;
        private FloatValueHolder floatValueHolder;
        private float velocity = 0.0f;
        private DynamicAnimation.OnAnimationUpdateListener onAnimationUpdateListener;

        public Builder startValue(float startValue) {
            this.startValue = startValue;
            return this;
        }

        public Builder addOnAnimationUpdateListener(DynamicAnimation.OnAnimationUpdateListener onAnimationUpdateListener) {
            this.onAnimationUpdateListener = onAnimationUpdateListener;
            return this;
        }

        public Builder finalValue(float finalValue) {
            this.finalValue = finalValue;
            return this;
        }

        public Builder floatVlaueHolder(FloatValueHolder floatValueHolder) {
            this.floatValueHolder = floatValueHolder;
            return this;
        }

        public Builder stiffness(float stiffness) {
            this.stiffness = stiffness;
            return this;
        }

        public Builder velocity(float velocity) {
            this.velocity = velocity;
            return this;
        }

        public Builder dampingRatio(float dampingRatio) {
            this.dampingRatio = dampingRatio;
            return this;
        }

        public SpringAnimation build() {
            if (this.floatValueHolder == null) {
                throw new IllegalStateException("property == null");
            }
            return new OSSpringPropertyAnimation(this).getSpringAnimation();
        }
    }
}

