/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.anim;

public class TrackAnimator {
    private float mTargValue;
    private volatile float mAniValue;
    private volatile boolean mAlive;
    private float minSpeed;
    private float mMaxSpeedFractor = 0.2f;
    private float mMinSpeedFractor = 0.125f;

    public TrackAnimator() {
    }

    public TrackAnimator(float value) {
        this.mAniValue = value;
        this.mTargValue = value;
    }

    public final float getTargValue() {
        return this.mTargValue;
    }

    public final float getAnimatedValue() {
        return this.mAniValue;
    }

    public final void setMaxSpeedFractor(float speed) {
        this.mMaxSpeedFractor = speed;
    }

    public final void setMinSpeedFractor(float fractor) {
        this.mMinSpeedFractor = fractor;
    }

    public final void set(float value) {
        this.mAlive = false;
        this.mAniValue = value;
        this.mTargValue = value;
    }

    public final void setTargValue(float value) {
        if (this.mTargValue != value) {
            this.mTargValue = value;
            float valueDiff = this.mTargValue - this.mAniValue;
            this.computeSpeedControl(valueDiff);
            this.mAlive = true;
        }
    }

    private final void computeSpeedControl(float value) {
        if (value != 0.0f) {
            this.minSpeed = Math.abs(value * this.mMinSpeedFractor);
            if (this.minSpeed < 1.0E-4f) {
                this.minSpeed = 1.0E-4f;
            }
        }
    }

    public boolean isRunning() {
        return this.mAlive;
    }

    public final boolean update(float timeElapsedInSec) {
        if (this.mAlive) {
            this.mAniValue = TrackAnimator.animateWithMaxSpeed(this.mAniValue, this.mTargValue, timeElapsedInSec, this.mMaxSpeedFractor, this.minSpeed);
            this.mAlive = this.mAniValue != this.mTargValue;
        }
        return this.mAlive;
    }

    public final void end() {
        this.mAlive = false;
        this.mAniValue = this.mTargValue;
    }

    private static final float animateWithMaxSpeed(float prevVal, float targetVal, float timeElapsed, float maxSpeedFractor, float minSpeed) {
        float offset = targetVal - prevVal;
        if (Math.abs(offset) <= minSpeed) {
            return targetVal;
        }
        float newtargetVal = prevVal + (targetVal - prevVal) * maxSpeedFractor;
        float newPre = TrackAnimator.animateAfterFactoringSpeed(prevVal, newtargetVal, timeElapsed);
        float diff = newPre - prevVal;
        if (Math.abs(diff) < minSpeed) {
            return prevVal + Math.signum(offset) * minSpeed;
        }
        return newPre;
    }

    private static final float animateAfterFactoringSpeed(float prevVal, float targetVal, float timeElapsed) {
        if (prevVal == targetVal) {
            return targetVal;
        }
        float newVal = prevVal + (targetVal - prevVal) * timeElapsed;
        if (Math.abs(newVal - prevVal) < 1.0E-4f) {
            return targetVal;
        }
        if (newVal == prevVal) {
            return targetVal;
        }
        if (prevVal > targetVal && newVal < targetVal) {
            return targetVal;
        }
        if (prevVal < targetVal && newVal > targetVal) {
            return targetVal;
        }
        return newVal;
    }
}

