/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.blur.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.drawable.ColorDrawable;
import android.view.View;

public class BitmapUtil {
    private static final String TAG = BitmapUtil.class.getName();

    public static Bitmap getScaledBitmap(Bitmap bitmap, float factor) {
        if (bitmap == null) {
            return null;
        }
        if (factor == 1.0f) {
            return bitmap;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        float ratio = 1.0f / factor;
        Matrix matrix = new Matrix();
        matrix.postScale(ratio, ratio);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    public static Bitmap getViewBitmap(View view, int translateX, int translateY, float sampleFactor) {
        if (view == null) {
            return null;
        }
        float scale = 1.0f / sampleFactor;
        int width = view.getWidth();
        int height = view.getHeight();
        int downScaledWidth = (int)((float)(width - translateX) * scale);
        int downScaledHeight = (int)((float)(height - translateY) * scale);
        Bitmap bitmap = Bitmap.createBitmap((int)downScaledWidth, (int)downScaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (view.getBackground() != null && view.getBackground() instanceof ColorDrawable) {
            bitmap.eraseColor(((ColorDrawable)view.getBackground()).getColor());
        } else {
            bitmap.eraseColor(Color.parseColor((String)"#f6f6f6"));
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.translate((float)(-((int)((float)translateX * scale))), (float)(-((int)((float)translateY * scale))));
        if (sampleFactor > 1.0f) {
            canvas.scale(scale, scale);
        }
        view.draw(canvas);
        return bitmap;
    }

    public static Bitmap transformBitmap(Bitmap bitmap, int translateX, int translateY) {
        if (translateX == 0 && translateY == 0) {
            return bitmap;
        }
        return Bitmap.createBitmap((Bitmap)bitmap, (int)translateX, (int)translateY, (int)(bitmap.getWidth() - translateX), (int)(bitmap.getHeight() - translateY));
    }
}

