/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.blur.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Path;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.transsion.widgetslib.blur.Blur;
import com.transsion.widgetslib.blur.processor.BlurProcessor;

public class DynamicBlurView
extends View {
    private float mTouchX;
    private float mTouchY;
    private View mBlurredView;
    private Bitmap mToBlurBitmap;
    private Canvas mBlurringCanvas;
    private BlurProcessor mProcessor;
    private int mBlurRadius = 0;
    private int mCanvasScalFactor = 4;
    private float mBlurSampleFactor = 1.0f;
    private int mBlurMode = 2;
    private int mBlurScheme = 1001;
    private int mTransitonX = 0;
    private int mTransitonY = 0;
    private int mRadius = 0;
    private final Path mClibPath = new Path();
    private boolean mDragAble = false;
    private Bitmap mBlurredBitmap;
    private boolean mAutoBlur = false;
    private final int[] mBluredViewScreenPos = new int[2];
    private final int[] mBlurViewScreenPos = new int[2];

    public DynamicBlurView(Context context) {
        super(context);
        this.init(context);
    }

    public DynamicBlurView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.mProcessor = Blur.with(context).scheme(this.mBlurScheme).processor();
    }

    public DynamicBlurView setBlurProcessor(BlurProcessor processor) {
        if (processor != null) {
            this.mProcessor = processor;
        }
        return this;
    }

    public void draw(Canvas canvas) {
        if (this.mRadius > 0 && Build.VERSION.SDK_INT >= 26) {
            this.mClibPath.rewind();
            this.mClibPath.addRoundRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), (float)this.mRadius, (float)this.mRadius, Path.Direction.CW);
            canvas.clipPath(this.mClibPath);
        }
        super.draw(canvas);
    }

    protected void onDraw(Canvas canvas) {
        Bitmap blurredBitmap;
        super.onDraw(canvas);
        if (this.mBlurredBitmap == null || this.mAutoBlur) {
            this.updateBlurData();
        }
        if ((blurredBitmap = this.mBlurredBitmap) != null && !blurredBitmap.isRecycled()) {
            canvas.save();
            canvas.scale((float)this.mCanvasScalFactor, (float)this.mCanvasScalFactor);
            canvas.drawBitmap(blurredBitmap, 0.0f, 0.0f, null);
            canvas.restore();
            if (blurredBitmap != this.mToBlurBitmap && !blurredBitmap.isRecycled()) {
                blurredBitmap.recycle();
            }
        }
    }

    public DynamicBlurView updateBlurDataAndInvalidate() {
        if (!this.mAutoBlur) {
            this.updateBlurData();
        }
        this.invalidate();
        return this;
    }

    public DynamicBlurView updateBlurData() {
        boolean isPrepared = this.prepare();
        View blurredView = this.mBlurredView;
        Bitmap blurBitmap = this.mToBlurBitmap;
        Canvas mBlurCanvas = this.mBlurringCanvas;
        if (isPrepared && blurredView != null && blurBitmap != null && mBlurCanvas != null) {
            if (blurredView.getBackground() != null && blurredView.getBackground() instanceof ColorDrawable) {
                blurBitmap.eraseColor(((ColorDrawable)blurredView.getBackground()).getColor());
            } else {
                blurBitmap.eraseColor(Color.argb((int)255, (int)255, (int)0, (int)0));
            }
            mBlurCanvas.save();
            blurredView.getLocationOnScreen(this.mBluredViewScreenPos);
            this.getLocationOnScreen(this.mBlurViewScreenPos);
            int translateX = this.mBluredViewScreenPos[0] - this.mBlurViewScreenPos[0] - this.mTransitonX;
            int translateY = this.mBluredViewScreenPos[1] - this.mBlurViewScreenPos[1] - this.mTransitonY;
            mBlurCanvas.translate((float)translateX, (float)translateY);
            blurredView.draw(mBlurCanvas);
            mBlurCanvas.restore();
            if (this.mBlurredBitmap != null && this.mBlurredBitmap != this.mToBlurBitmap && !this.mBlurredBitmap.isRecycled()) {
                this.mBlurredBitmap.recycle();
            }
            this.mBlurredBitmap = this.mProcessor.blur(blurBitmap);
        }
        return this;
    }

    private boolean prepare() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.mProcessor != null) {
            this.mProcessor.mode(this.mBlurMode);
            this.mProcessor.radius(this.mBlurRadius);
            this.mProcessor.sampleFactor(this.mBlurSampleFactor);
        }
        boolean needNewCanvas = false;
        int scaledWidth = (int)Math.ceil((float)width / (float)this.mCanvasScalFactor);
        int scaleHeight = (int)Math.ceil((float)height / (float)this.mCanvasScalFactor);
        if (scaledWidth < 1 || scaleHeight < 1) {
            return false;
        }
        if (this.mToBlurBitmap == null) {
            this.mToBlurBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaleHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            needNewCanvas = true;
        } else if (scaledWidth != this.mToBlurBitmap.getWidth() || scaleHeight != this.mToBlurBitmap.getHeight()) {
            if (!this.mToBlurBitmap.isRecycled()) {
                this.mToBlurBitmap.recycle();
                this.mToBlurBitmap = null;
            }
            this.mToBlurBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaleHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            needNewCanvas = true;
        }
        if (this.mToBlurBitmap == null) {
            return false;
        }
        if (needNewCanvas) {
            this.mBlurringCanvas = new Canvas(this.mToBlurBitmap);
            this.mBlurringCanvas.scale(1.0f / (float)this.mCanvasScalFactor, 1.0f / (float)this.mCanvasScalFactor);
        }
        return this.mBlurringCanvas != null;
    }

    public DynamicBlurView setBlurredView(View blurredView) {
        this.mBlurredView = blurredView;
        return this;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mDragAble) {
            switch (event.getActionMasked()) {
                case 0: {
                    this.mTouchX = event.getRawX();
                    this.mTouchY = event.getRawY();
                    return true;
                }
                case 2: {
                    float dx = event.getRawX() - this.mTouchX;
                    float dy = event.getRawY() - this.mTouchY;
                    this.offsetLeftAndRight((int)dx);
                    this.offsetTopAndBottom((int)dy);
                    this.mTouchX = event.getRawX();
                    this.mTouchY = event.getRawY();
                    if (!this.mAutoBlur) {
                        this.updateBlurData();
                    }
                    this.invalidate();
                    break;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    public DynamicBlurView setTransitonX(int mTransitonX) {
        this.mTransitonX = mTransitonX;
        return this;
    }

    public DynamicBlurView setTransitonY(int mTransitonY) {
        this.mTransitonY = mTransitonY;
        return this;
    }

    public DynamicBlurView setBlurRadius(int blurRadius) {
        if (blurRadius >= 0) {
            this.mBlurRadius = blurRadius;
        }
        return this;
    }

    public DynamicBlurView setCanvasScalFactor(int canvasScalFactor) {
        if (canvasScalFactor >= 1) {
            this.mCanvasScalFactor = canvasScalFactor;
        }
        return this;
    }

    public DynamicBlurView setRadius(int radius) {
        if (radius >= 0) {
            this.mRadius = radius;
        }
        return this;
    }

    public DynamicBlurView setDragAble(boolean dragAble) {
        this.mDragAble = dragAble;
        return this;
    }

    public DynamicBlurView setAutoBlur(boolean autoBlur) {
        this.mAutoBlur = autoBlur;
        return this;
    }

    public DynamicBlurView release() {
        if (this.mToBlurBitmap != null && !this.mToBlurBitmap.isRecycled()) {
            this.mToBlurBitmap.recycle();
        }
        if (this.mBlurredBitmap != null && this.mBlurredBitmap != this.mToBlurBitmap && !this.mBlurredBitmap.isRecycled()) {
            this.mBlurredBitmap.recycle();
        }
        this.mBlurredView = null;
        return this;
    }

    public DynamicBlurView setBlurMode(int mode) {
        this.mBlurMode = mode;
        return this;
    }
}

