/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.dialog;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.DialogInterface;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.dialog.PromptDialog;
import com.transsion.widgetslib.widget.editext.ExtendedEditText;
import com.transsion.widgetslib.widget.editext.OSMaterialEditText;
import java.lang.ref.WeakReference;

public class InputDialog
implements View.OnFocusChangeListener {
    private Context mContext;
    private PromptDialog.Builder mBuilder;
    private ExtendedEditText mEditText;
    private ViewTreeObserver.OnGlobalLayoutListener mGlobalListener;
    private DialogInterface.OnDismissListener mDismissListener;
    private boolean mShow;
    private TextView mErrorText;
    private TextView mNumText;
    private View mInputView;
    private View mDividerView;
    private int mErrorColor;
    private int mNormalColor;
    private int mActiveColor;
    private boolean mShowSoftInput;
    private boolean mAppDialogFragment;
    private boolean needEmptyUnable = true;
    private String mTipInputMax;
    private OSMaterialEditText mOSMaterialEditText;

    public boolean getNeedEmptyUnable() {
        return this.needEmptyUnable;
    }

    public InputDialog setNeedEmptyUnable(boolean needEmptyUnable) {
        this.needEmptyUnable = needEmptyUnable;
        return this;
    }

    public InputDialog(Context context) {
        this.mContext = context;
        this.mBuilder = new PromptDialog.Builder(this.mContext);
        this.mBuilder.setInputDialog(true);
        this.mErrorColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_red_basic_color);
        this.mNormalColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_gray_secondary_color);
        this.mActiveColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_fill_primary_color);
        if (this.mInputView == null) {
            this.addInputView();
        }
        this.initView();
    }

    private void initView() {
        this.mOSMaterialEditText = (OSMaterialEditText)this.mInputView.findViewById(R.id.input_edit_text);
        this.mOSMaterialEditText.setRootPaddingRelative(0, 0, 0, 0);
        this.mEditText = this.mOSMaterialEditText.getEditText();
        this.mEditText.setOnFocusChangeListener(this);
        this.mEditText.addTextChangedListener(new MyTextWatcher(this, 0));
        this.mTipInputMax = this.mContext.getString(R.string.os_dialog_input_tip_max);
    }

    public InputDialog setTitle(CharSequence title) {
        this.mBuilder.setTitle(title);
        return this;
    }

    public InputDialog setTitle(int title) {
        this.mBuilder.setTitle(title);
        return this;
    }

    public InputDialog setCancelable(boolean cancelAble) {
        this.mBuilder.setCancelable(cancelAble);
        return this;
    }

    public InputDialog setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
        this.mBuilder.setCanceledOnTouchOutside(canceledOnTouchOutside);
        return this;
    }

    public void setTextWatcher(TextWatcher textWatcher) {
        this.mEditText.addTextChangedListener(textWatcher);
    }

    public void removeTextWatcher(TextWatcher textWatcher) {
        this.mEditText.removeTextChangedListener(textWatcher);
    }

    public InputDialog setGetInputPositiveButton(CharSequence text, final OnPositiveButtonListener listener) {
        this.mBuilder.setPositiveButton(text, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (listener != null) {
                    listener.onClick(InputDialog.this.mEditText.getText().toString());
                }
            }
        });
        return this;
    }

    public InputDialog setGetInputPositiveButton(int textId, OnPositiveButtonListener listener) {
        return this.setGetInputPositiveButton(this.mContext.getText(textId), listener);
    }

    public InputDialog setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setPositiveButton(text, listener);
        return this;
    }

    public InputDialog setPositiveButton(int textId, DialogInterface.OnClickListener listener) {
        return this.setPositiveButton(this.mContext.getText(textId), listener);
    }

    public InputDialog setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
        this.mBuilder.setNegativeButton(text, listener);
        return this;
    }

    public void setOSMaterialEditTextError(boolean error) {
        if (this.mOSMaterialEditText != null) {
            this.mOSMaterialEditText.setErrorLine(error);
        }
    }

    public InputDialog setError(int messageId) {
        this.mErrorText = (TextView)this.mInputView.findViewById(R.id.error_text);
        this.mErrorText.setText((CharSequence)this.mContext.getResources().getString(messageId));
        if (this.mDividerView != null) {
            this.mDividerView.setBackgroundColor(this.mErrorColor);
        }
        this.setOSMaterialEditTextError(messageId != 0);
        return this;
    }

    public InputDialog setError(CharSequence message) {
        this.mErrorText = (TextView)this.mInputView.findViewById(R.id.error_text);
        this.mErrorText.setText(message);
        if (TextUtils.isEmpty((CharSequence)message)) {
            this.mErrorText.setVisibility(8);
            if (this.mDividerView != null) {
                this.mDividerView.setBackgroundColor(this.mNormalColor);
            }
        } else {
            this.mErrorText.setVisibility(0);
            if (this.mDividerView != null) {
                this.mDividerView.setBackgroundColor(this.mErrorColor);
            }
        }
        this.setOSMaterialEditTextError(!TextUtils.isEmpty((CharSequence)message));
        return this;
    }

    public InputDialog setTipInputMax(@StringRes int resId) {
        return this.setTipInputMax(this.mContext.getString(resId));
    }

    public InputDialog setTipInputMax(String tipText) {
        this.mTipInputMax = tipText;
        return this;
    }

    public InputDialog setAppDialogFragment(boolean isAppDialogFragment) {
        this.mAppDialogFragment = isAppDialogFragment;
        return this;
    }

    public InputDialog setInputText(int inputTextId) {
        this.mEditText.addTextChangedListener(new MyTextWatcher(this, 0));
        this.mEditText.setText(this.mContext.getResources().getString(inputTextId));
        return this;
    }

    public InputDialog setInputText(String inputText) {
        this.mEditText.addTextChangedListener(new MyTextWatcher(this, 0));
        this.mEditText.setText(inputText);
        return this;
    }

    public InputDialog setNegativeButton(int textId, DialogInterface.OnClickListener listener) {
        return this.setNegativeButton(this.mContext.getText(textId), listener);
    }

    public InputDialog setInput(OnInputListener listener) {
        return this.setInput(null, null, listener);
    }

    public InputDialog setInput(CharSequence text, CharSequence textHint, OnInputListener listener) {
        this.mEditText.setText(text);
        this.transHintEllipsizeString(textHint);
        if (listener != null) {
            listener.onInput(this.mEditText);
        }
        return this;
    }

    private void transHintEllipsizeString(final CharSequence text) {
        if (this.mEditText == null || TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        this.mEditText.post(new Runnable(){

            @Override
            public void run() {
                int validateWidth = InputDialog.this.mEditText.getWidth() - InputDialog.this.mEditText.getPaddingStart() - InputDialog.this.mEditText.getPaddingEnd();
                String hintEllipsizeString = TextUtils.ellipsize((CharSequence)text, (TextPaint)InputDialog.this.mEditText.getPaint(), (float)validateWidth, (TextUtils.TruncateAt)TextUtils.TruncateAt.END).toString();
                InputDialog.this.mEditText.setHint(hintEllipsizeString);
            }
        });
    }

    public InputDialog setInputNum(CharSequence text, CharSequence textHint, int textNum, OnInputNumListener listener) {
        this.mEditText.setText(text);
        this.transHintEllipsizeString(textHint);
        this.mNumText = (TextView)this.mInputView.findViewById(R.id.num_text);
        this.mEditText.addTextChangedListener(new MyTextWatcher(this, textNum));
        if (textNum == 0) {
            this.mNumText.setVisibility(8);
        } else {
            this.mNumText.setVisibility(0);
            this.mEditText.setFilters(new InputFilter[]{new OSLengthFilter(this, textNum)});
        }
        if (text.toString().length() < textNum) {
            this.mEditText.setText(text);
            this.mNumText.setText((CharSequence)(String.format("%d", text.toString().length()) + "/" + String.format("%d", textNum)));
        } else {
            this.mNumText.setText((CharSequence)(String.format("%d", textNum) + "/" + String.format("%d", textNum)));
            this.mEditText.setText(text.toString().substring(0, textNum));
        }
        if (listener != null) {
            listener.onInputNum(this.mEditText, this.mNumText);
        }
        return this;
    }

    private void addInputView() {
        this.mInputView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.os_input_dialog_layout, null);
        this.mBuilder.setView(this.mInputView);
    }

    public InputDialog setShowSoftInput(boolean showSoftInput) {
        this.mShowSoftInput = showSoftInput;
        return this;
    }

    public PromptDialog create() {
        PromptDialog dialog = this.mBuilder.create();
        dialog.getWindow().setSoftInputMode(16);
        if (this.mShowSoftInput && this.mEditText != null) {
            if (this.mEditText.getText().length() != 0) {
                this.mEditText.setSelection(this.mEditText.getText().length());
            }
            this.mGlobalListener = new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    if (!InputDialog.this.mShow) {
                        InputDialog.this.mShow = true;
                        InputDialog.this.mEditText.requestFocus();
                        InputDialog.this.mEditText.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                InputMethodManager inputMethodManager = (InputMethodManager)InputDialog.this.mContext.getSystemService("input_method");
                                inputMethodManager.showSoftInput((View)InputDialog.this.mEditText, 0);
                            }
                        }, 200L);
                    }
                }
            };
            this.mEditText.getViewTreeObserver().addOnGlobalLayoutListener(this.mGlobalListener);
        }
        if (dialog != null && !this.mAppDialogFragment) {
            dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialog) {
                    InputDialog.this.dismissOprate(dialog);
                }
            });
        }
        return dialog;
    }

    public void dismissOprate(DialogInterface dialog) {
        if (this.mGlobalListener != null && this.mEditText != null && this.mEditText.getViewTreeObserver() != null) {
            this.mEditText.getViewTreeObserver().removeOnGlobalLayoutListener(this.mGlobalListener);
            this.mGlobalListener = null;
        }
        if (this.mDismissListener != null) {
            this.mDismissListener.onDismiss(dialog);
        }
        if (this.mEditText != null) {
            this.mEditText.clearTextChangedListeners();
        }
        this.mShow = false;
    }

    public PromptDialog show() {
        PromptDialog dialog = this.create();
        dialog.show();
        return dialog;
    }

    public void onFocusChange(View v, boolean hasFocus) {
        if (this.mDividerView != null) {
            this.mDividerView.setBackgroundColor(hasFocus ? this.mActiveColor : this.mNormalColor);
        }
        if (this.getButton(-1) != null && this.needEmptyUnable) {
            this.getButton(-1).setEnabled(this.mEditText.getText().toString().length() > 0);
        }
    }

    public Button getButton(int witch) {
        return this.mBuilder.dialog.getButton(witch);
    }

    public EditText getmEditText() {
        return this.mEditText;
    }

    public TextView getmErrorText() {
        return this.mErrorText;
    }

    public InputDialog setAutoDismiss(boolean autoDismiss) {
        this.mBuilder.setAutoDismiss(autoDismiss);
        return this;
    }

    public void setOnDismissListener(DialogInterface.OnDismissListener dismissListener) {
        this.mDismissListener = dismissListener;
    }

    public void setHasContent(boolean hasContent) {
        if (this.mDividerView != null) {
            this.mDividerView.setBackgroundColor(ContextCompat.getColor((Context)this.mContext, (int)(hasContent ? R.color.os_fill_primary_color : R.color.os_gray_secondary_color)));
        }
    }

    private static class OSLengthFilter
    extends InputFilter.LengthFilter {
        private WeakReference<InputDialog> mInputDialogWeakReference;
        private int mTextNum;
        private Toast mToast;

        public OSLengthFilter(InputDialog inputDialog, int max) {
            super(max);
            if (inputDialog != null) {
                this.mInputDialogWeakReference = new WeakReference<InputDialog>(inputDialog);
                this.mTextNum = max;
            }
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            CharSequence result = super.filter(source, start, end, dest, dstart, dend);
            if (dest == null) {
                return result;
            }
            int length = dest.length();
            InputDialog inputDialog = (InputDialog)this.mInputDialogWeakReference.get();
            if (inputDialog != null && length >= this.mTextNum && length != 0 && result != null) {
                String tipInputMax = inputDialog.mTipInputMax;
                if (tipInputMax == null || tipInputMax.isEmpty()) {
                    return result;
                }
                if (this.mToast == null) {
                    this.mToast = Toast.makeText((Context)inputDialog.mContext, (CharSequence)tipInputMax, (int)1);
                }
                this.mToast.show();
            }
            return result;
        }
    }

    private static class MyTextWatcher
    implements TextWatcher {
        private WeakReference<InputDialog> mInputDialogWeakReference;
        private int mTextNum;
        private int mActiveColor;
        private int mNormalColor;

        public MyTextWatcher(InputDialog inputDialog, int textNum) {
            if (inputDialog != null) {
                this.mInputDialogWeakReference = new WeakReference<InputDialog>(inputDialog);
                this.mTextNum = textNum;
                this.mNormalColor = inputDialog.mNormalColor;
                this.mActiveColor = inputDialog.mActiveColor;
            }
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
        }

        @SuppressLint(value={"DefaultLocale"})
        public void afterTextChanged(Editable s) {
            InputDialog inputDialog = (InputDialog)this.mInputDialogWeakReference.get();
            if (inputDialog == null) {
                return;
            }
            if (inputDialog.getButton(-1) != null && inputDialog.getNeedEmptyUnable()) {
                inputDialog.getButton(-1).setEnabled(s.toString().length() > 0);
            }
            if (inputDialog.mNumText != null && inputDialog.mNumText.getVisibility() == 0) {
                int length = s.length();
                if (length < this.mTextNum) {
                    inputDialog.mNumText.setText((CharSequence)new StringBuilder().append(String.format("%d", length)).append("/").append(String.format("%d", this.mTextNum)));
                } else if (length == this.mTextNum && length != 0) {
                    inputDialog.mNumText.setText((CharSequence)new StringBuilder().append(String.format("%d", this.mTextNum)).append("/").append(String.format("%d", this.mTextNum)));
                }
            }
            if (inputDialog.mErrorText != null && inputDialog.mErrorText.getVisibility() == 0) {
                inputDialog.setError("");
            }
        }
    }

    public static interface OnPositiveButtonListener {
        public void onClick(String var1);
    }

    public static interface OnInputNumListener {
        public void onInputNum(EditText var1, TextView var2);
    }

    public static interface OnInputListener {
        public void onInput(EditText var1);
    }
}

