/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Message;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListAdapter;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.dialog.PromptController;
import com.transsion.widgetslib.dialog.PromptParams;
import com.transsion.widgetslib.util.Utils;

public class PromptDialog
extends Dialog {
    private PromptController mController = new PromptController(this.getContext(), (DialogInterface)this, this.getWindow());

    public PromptDialog(Context context) {
        this(context, 0);
    }

    public PromptDialog(Context context, int themeResId) {
        super(context, PromptDialog.resolveDialogTheme(context, themeResId));
    }

    protected PromptDialog(Context context, boolean cancelable, DialogInterface.OnCancelListener cancelListener) {
        this(context, 0);
        this.setCancelable(cancelable);
        if (!this.mController.getIsAppDialogFragment()) {
            this.setOnCancelListener(cancelListener);
        }
    }

    private static int resolveDialogTheme(Context context, int themeResId) {
        if (themeResId >= 0x1000000) {
            return themeResId;
        }
        return R.style.OS_Dialog_Alert_Base;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mController.installContent();
    }

    public Button getButton(int which) {
        return this.mController.getButton(which);
    }

    public View getListView() {
        return this.mController.getListView();
    }

    public void setTitle(CharSequence title) {
        this.mController.setTitle(title);
    }

    public void setTitleSingleLine() {
        this.mController.setTitleSingleLine();
    }

    public void setTopTitle(int topTitleId) {
        String topTitle = this.getContext().getResources().getString(topTitleId);
        this.mController.setTopTitle(topTitle);
    }

    public void setTopTitle(CharSequence title) {
        this.mController.setTopTitle(title);
    }

    public void setMessage(CharSequence message) {
        this.mController.setMessage(message);
    }

    public void setView(View view) {
        this.mController.setView(0, view);
    }

    public void setButton(int whichButton, CharSequence text, Message msg) {
        this.mController.setButton(whichButton, text, null, msg);
    }

    public void setButton(int whichButton, CharSequence text, DialogInterface.OnClickListener listener) {
        this.mController.setButton(whichButton, text, listener, null);
    }

    public static class Builder2
    extends Builder {
        public Builder2(Context context, int type) {
            this(context, 0, type);
        }

        public Builder2(Context context, int themeResId, int type) {
            super(context, themeResId);
            switch (type) {
                case 3: {
                    break;
                }
                default: {
                    this.setCancelable(false);
                    this.setCanceledOnTouchOutside(false);
                }
            }
        }
    }

    public static class Builder {
        public PromptDialog dialog;
        public final PromptParams P;

        public Builder(Context context) {
            this(context, 0);
        }

        public Builder(Context context, int themeResId) {
            this.P = new PromptParams((Context)new ContextThemeWrapper(context, PromptDialog.resolveDialogTheme(context, themeResId)));
            this.dialog = new PromptDialog(this.P.mContext, PromptDialog.resolveDialogTheme(context, themeResId));
        }

        public Context getContext() {
            return this.P.mContext;
        }

        public Builder setTitle(int titleId) {
            this.P.mTitle = this.P.mContext.getText(titleId);
            return this;
        }

        public Builder setTitle(CharSequence title) {
            this.P.mTitle = title;
            return this;
        }

        public Builder setTopTitle(int titleId) {
            this.P.mTopTitle = this.P.mContext.getText(titleId);
            return this;
        }

        public Builder setTopTitle(CharSequence title) {
            this.P.mTopTitle = title;
            return this;
        }

        public Builder setMessage(int messageId) {
            this.P.mMessage = this.P.mContext.getText(messageId);
            return this;
        }

        public Builder setIcon(Drawable icon) {
            this.P.mIcon = icon;
            return this;
        }

        public Builder setIcon(int iconId) {
            this.P.mIcon = ContextCompat.getDrawable((Context)this.P.mContext, (int)iconId);
            return this;
        }

        public Builder setMessage(CharSequence message) {
            this.P.mMessage = message;
            return this;
        }

        public Builder setNoBtnBottomInsets(int insets) {
            this.P.mNoBtnInsets = insets;
            return this;
        }

        public Builder setPositiveButton(int textId, DialogInterface.OnClickListener listener) {
            this.P.mPositiveButtonText = this.P.mContext.getText(textId);
            this.P.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.P.mPositiveButtonText = text;
            this.P.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setPositiveButton(int textId, boolean isAlert, DialogInterface.OnClickListener listener) {
            this.P.mPositiveButtonText = this.P.mContext.getText(textId);
            this.P.mPositiveButtonListener = listener;
            this.P.mIsAlert = isAlert;
            return this;
        }

        public Builder setPositiveButton(CharSequence text, boolean isAlert, DialogInterface.OnClickListener listener) {
            this.P.mPositiveButtonText = text;
            this.P.mPositiveButtonListener = listener;
            this.P.mIsAlert = isAlert;
            return this;
        }

        public Builder setNegativeButton(int textId, DialogInterface.OnClickListener listener) {
            this.P.mNegativeButtonText = this.P.mContext.getText(textId);
            this.P.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.P.mNegativeButtonText = text;
            this.P.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setNeutralButton(int textId, DialogInterface.OnClickListener listener) {
            this.P.mNeutralButtonText = this.P.mContext.getText(textId);
            this.P.mNeutralButtonListener = listener;
            return this;
        }

        public Builder setNeutralButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.P.mNeutralButtonText = text;
            this.P.mNeutralButtonListener = listener;
            return this;
        }

        public Builder setCancelable(boolean cancelable) {
            this.P.mCancelable = cancelable;
            return this;
        }

        public Builder setCanceledOnTouchOutside(boolean canceledOnTouchOutside) {
            this.P.mCancelOutSide = canceledOnTouchOutside;
            return this;
        }

        public Builder setOnCancelListener(DialogInterface.OnCancelListener onCancelListener) {
            this.P.mOnCancelListener = onCancelListener;
            return this;
        }

        public Builder setOnDismissListener(DialogInterface.OnDismissListener onDismissListener) {
            this.P.mOnDismissListener = onDismissListener;
            return this;
        }

        public Builder setOnKeyListener(DialogInterface.OnKeyListener onKeyListener) {
            this.P.mOnKeyListener = onKeyListener;
            return this;
        }

        public Builder setItems(int itemsId, DialogInterface.OnClickListener listener) {
            this.P.mItems = this.P.mContext.getResources().getTextArray(itemsId);
            this.P.mOnClickListener = listener;
            return this;
        }

        public Builder setItems(CharSequence[] items, DialogInterface.OnClickListener listener) {
            this.P.mItems = items;
            this.P.mOnClickListener = listener;
            return this;
        }

        public Builder setAdapter(ListAdapter adapter, DialogInterface.OnClickListener listener) {
            this.P.mAdapter = adapter;
            this.P.mOnClickListener = listener;
            return this;
        }

        public Builder setAdapter(RecyclerView.Adapter<?> adapter, DialogInterface.OnClickListener listener) {
            this.P.mRecyclerAdapter = adapter;
            this.P.mOnClickListener = listener;
            return this;
        }

        public Builder setCursor(Cursor cursor, DialogInterface.OnClickListener listener, String labelColumn) {
            this.P.mCursor = cursor;
            this.P.mLabelColumn = labelColumn;
            this.P.mOnClickListener = listener;
            return this;
        }

        public Builder setElegantTextHeight(boolean elegant) {
            this.P.mElegant = elegant;
            return this;
        }

        public Builder setMultiChoiceItems(int itemsId, boolean[] checkedItems, DialogInterface.OnMultiChoiceClickListener listener) {
            this.P.mItems = this.P.mContext.getResources().getTextArray(itemsId);
            this.P.mCheckedItems = checkedItems;
            this.P.mOnCheckboxClickListener = listener;
            this.P.mIsMultiChoice = true;
            return this;
        }

        public Builder setMultiChoiceItems(CharSequence[] items, boolean[] checkedItems, DialogInterface.OnMultiChoiceClickListener listener) {
            this.P.mItems = items;
            this.P.mCheckedItems = checkedItems;
            this.P.mOnCheckboxClickListener = listener;
            this.P.mIsMultiChoice = true;
            return this;
        }

        public Builder setSingleChecked(CharSequence choiceText, boolean checked, DialogInterface.OnClickListener listener) {
            this.P.mSingleCheckedText = choiceText;
            this.P.mOnClickListener = listener;
            this.P.mIsSingleChecked = checked;
            return this;
        }

        public Builder setMultiChoiceItems(Cursor cursor, String isCheckedColumn, String labelColumn, DialogInterface.OnMultiChoiceClickListener listener) {
            this.P.mCursor = cursor;
            this.P.mIsCheckedColumn = isCheckedColumn;
            this.P.mLabelColumn = labelColumn;
            this.P.mOnCheckboxClickListener = listener;
            this.P.mIsMultiChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(int itemsId, int checkedItem, DialogInterface.OnClickListener listener) {
            this.P.mItems = this.P.mContext.getResources().getTextArray(itemsId);
            this.P.mCheckedItem = checkedItem;
            this.P.mOnClickListener = listener;
            this.P.mIsSingleChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(Cursor cursor, int checkedItem, String labelColumn, DialogInterface.OnClickListener listener) {
            this.P.mCursor = cursor;
            this.P.mCheckedItem = checkedItem;
            this.P.mLabelColumn = labelColumn;
            this.P.mOnClickListener = listener;
            this.P.mIsSingleChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(CharSequence[] items, int checkedItem, DialogInterface.OnClickListener listener) {
            this.P.mItems = items;
            this.P.mCheckedItem = checkedItem;
            this.P.mOnClickListener = listener;
            this.P.mIsSingleChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(ListAdapter adapter, int checkedItem, DialogInterface.OnClickListener listener) {
            this.P.mAdapter = adapter;
            this.P.mCheckedItem = checkedItem;
            this.P.mOnClickListener = listener;
            this.P.mIsSingleChoice = true;
            return this;
        }

        public Builder setSingleChoiceItems(RecyclerView.Adapter<?> adapter, int checkedItem, DialogInterface.OnClickListener listener) {
            this.P.mRecyclerAdapter = adapter;
            this.P.mCheckedItem = checkedItem;
            this.P.mOnClickListener = listener;
            this.P.mIsSingleChoice = true;
            return this;
        }

        public Builder setOnItemSelectedListener(AdapterView.OnItemSelectedListener listener) {
            this.P.mOnItemSelectedListener = listener;
            return this;
        }

        public Builder setView(int layoutResId) {
            this.P.mView = null;
            this.P.mViewLayoutResId = layoutResId;
            return this;
        }

        public Builder setView(View view) {
            this.P.mView = view;
            this.P.mViewLayoutResId = 0;
            return this;
        }

        public void setInputDialog(boolean isInputDialog) {
            this.P.mIsInputDialog = isInputDialog;
        }

        public Builder setIsAppDialogFragment(boolean isAppDialogFragment) {
            this.P.mIsAppDialogFragment = isAppDialogFragment;
            return this;
        }

        public Builder setAutoDismiss(boolean autoDismiss) {
            this.P.mAutoDismiss = autoDismiss;
            return this;
        }

        public Builder setButtonVertical(boolean buttonVertical) {
            this.P.mIsButtonVertical = buttonVertical;
            return this;
        }

        public Builder setInitPositiveButtonEnable(boolean positiveButtonEnable) {
            this.P.mPositiveButtonEnable = positiveButtonEnable;
            return this;
        }

        public PromptDialog create() {
            this.P.apply(this.dialog.mController);
            this.dialog.setCancelable(this.P.mCancelable);
            this.dialog.setCanceledOnTouchOutside(this.P.mCancelOutSide);
            if (!this.P.mIsAppDialogFragment) {
                this.dialog.setOnCancelListener(this.P.mOnCancelListener);
                this.dialog.setOnDismissListener(this.P.mOnDismissListener);
            }
            if (this.P.mOnKeyListener != null) {
                this.dialog.setOnKeyListener(this.P.mOnKeyListener);
            }
            Utils.setDialogWindowBackGround(this.P.mContext, this.dialog, this.P.mCancelable, this.P.mCancelOutSide);
            return this.dialog;
        }

        public PromptDialog show() {
            PromptDialog dialog = this.create();
            dialog.show();
            return dialog;
        }
    }

    public static final class PromptDialogType {
        public static final int WARNING = 0;
        public static final int CONFIRM = 1;
        public static final int NOTIFY = 2;
        public static final int NORMAL_LIST = 3;
        public static final int SINGLE_CHOICE = 4;
        public static final int MULTI_CHOICE = 5;
    }
}

