/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.util;

import android.content.res.Resources;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Point;
import java.util.ArrayList;

public class PointAnimUtil {
    public static float CIRCLE_RADIU;
    public static int CIRCLE_SPACING;
    public static int POINT_OFFSET;
    private final View mTargetView;
    private long mStartTime;
    private int mDuration = 300;
    private final Interpolator mInterpolator;
    private ArrayList<Point> mPoints;
    public static final int STATE_UNSELECTED = 1;
    public static final int STATE_SELECTED = 2;
    public static final int STATE_CHANGING = 4;
    public int mState = 1;
    private boolean mSelected = false;
    private int mLayoutDir = -1;
    private Point p0;
    private Point p1;
    private Point p2;
    private int mCenterX;
    private int mCenterY;

    public PointAnimUtil(View targetView) {
        this.mTargetView = targetView;
        this.mInterpolator = new AccelerateInterpolator();
        Resources mRes = this.mTargetView.getResources();
        CIRCLE_RADIU = mRes.getDimension(R.dimen.os_overflowmenu_circle_radiu);
        CIRCLE_SPACING = (int)mRes.getDimension(R.dimen.os_overflowmenu_circle_spacing);
        POINT_OFFSET = (int)((float)CIRCLE_SPACING + 2.0f * CIRCLE_RADIU);
        this.initPoint();
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    private void initPoint() {
        this.p0 = new Point();
        this.p1 = new Point();
        this.p2 = new Point();
    }

    public void setPointDir(int layoutDir, ArrayList<Point> points) {
        if (this.mLayoutDir != layoutDir) {
            points.clear();
            if (layoutDir == 0) {
                this.initLTRPostion(points);
            } else {
                this.initRTLPosition(points);
            }
        }
        this.mPoints = points;
        this.mLayoutDir = layoutDir;
    }

    private void initLTRPostion(ArrayList<Point> points) {
        int cx0;
        int cy0 = cx0 = this.mCenterX - POINT_OFFSET;
        this.p0.setStartPos(cx0, cy0, CIRCLE_RADIU);
        int cx1 = cx0;
        int cy1 = this.mCenterY;
        this.p1.setStartPos(cx1, cy1, CIRCLE_RADIU);
        int cx2 = cx0;
        int cy2 = this.mCenterY + POINT_OFFSET;
        this.p2.setStartPos(cx2, cy2, CIRCLE_RADIU);
        this.p1.setDestPos(cy2, cx2);
        this.p2.setDestPos(cy1, cy1);
        points.add(0, this.p0);
        points.add(1, this.p1);
        points.add(2, this.p2);
    }

    private void initRTLPosition(ArrayList<Point> points) {
        int cx0 = this.mCenterX + POINT_OFFSET;
        int cy0 = this.mCenterY - POINT_OFFSET;
        this.p0.setStartPos(cx0, cy0, CIRCLE_RADIU);
        int cx1 = cx0;
        int cy1 = this.mCenterY;
        this.p1.setStartPos(cx1, cy1, CIRCLE_RADIU);
        int cx2 = cx0;
        int cy2 = this.mCenterY + POINT_OFFSET;
        this.p2.setStartPos(cx2, cy2, CIRCLE_RADIU);
        this.p1.setDestPos(cy0, cy0);
        this.p2.setDestPos(cy1, cy1);
        points.add(0, this.p0);
        points.add(1, this.p1);
        points.add(2, this.p2);
    }

    public void setCetnerPosition(int x, int y) {
        this.mCenterX = x;
        this.mCenterY = y;
    }

    public void start(boolean selected, int layoutDir) {
        if (this.mState == 4) {
            Point p1 = this.mPoints.get(1);
            Point p2 = this.mPoints.get(2);
            this.resetDestPosition(p1, p2, 1);
        }
        this.mSelected = selected;
        this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mState = 4;
        this.update();
    }

    public void abort() {
        if (this.mState != 4) {
            return;
        }
        this.mState = this.mSelected ? 2 : 1;
        Point p1 = this.mPoints.get(1);
        Point p2 = this.mPoints.get(2);
        this.resetDestPosition(p1, p2, 0);
    }

    public void update() {
        long curTime = AnimationUtils.currentAnimationTimeMillis();
        float t = Math.min((float)(curTime - this.mStartTime) / (1.0f * (float)this.mDuration), 1.0f);
        float interpolation = this.mInterpolator.getInterpolation(t);
        if (this.mPoints.size() < 3) {
            return;
        }
        Point p1 = this.mPoints.get(1);
        p1.x = (int)((float)p1.x + (float)(p1.x1 - p1.x) * interpolation);
        p1.y = (int)((float)p1.y + (float)(p1.y1 - p1.y) * interpolation);
        Point p2 = this.mPoints.get(2);
        p2.x = (int)((float)p2.x + (float)(p2.x1 - p2.x) * interpolation);
        p2.y = (int)((float)p2.y + (float)(p2.y1 - p2.y) * interpolation);
        this.mTargetView.invalidate();
        if (curTime - this.mStartTime >= (long)this.mDuration) {
            this.resetDestPosition(p1, p2, 0);
        }
    }

    private void resetDestPosition(Point p1, Point p2, int path) {
        if (this.mSelected) {
            this.mState = 2;
            if (this.mLayoutDir == 0) {
                p1.setDestPos(this.mCenterX - POINT_OFFSET, this.mCenterY);
                p2.setDestPos(this.mCenterX - POINT_OFFSET, this.mCenterY + POINT_OFFSET);
            } else {
                p1.setDestPos(this.mCenterX + POINT_OFFSET, this.mCenterY);
                p2.setDestPos(this.mCenterX + POINT_OFFSET, this.mCenterY + POINT_OFFSET);
            }
        } else {
            this.mState = 1;
            if (this.mLayoutDir == 0) {
                p1.setDestPos(this.mCenterX + POINT_OFFSET, this.mCenterY - POINT_OFFSET);
                p2.setDestPos(this.mCenterX, this.mCenterY);
            } else {
                p1.setDestPos(this.mCenterX - POINT_OFFSET, this.mCenterY - POINT_OFFSET);
                p2.setDestPos(this.mCenterX, this.mCenterY);
            }
        }
        this.mTargetView.invalidate();
    }
}

