/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.damping;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.view.LoadingView;
import com.transsion.widgetslib.view.OverBoundNestedScrollView;
import com.transsion.widgetslib.widget.timepicker.wheel.EaseCubicInterpolator;

public class OSDampingLayout
extends OverBoundNestedScrollView {
    private static final String TAG = OSDampingLayout.class.getSimpleName();
    private static final int ANIM_DURATION = 300;
    private static final float REFRESHING_START_ALPHA = 0.0f;
    private static final float REFRESHING_DELTA_ALPHA = 1.0f;
    private static final float REFRESHING_START_SCALE = 0.5f;
    private static final float REFRESHING_DELTA_SCALE = 0.5f;
    private static final float REFRESHING_START_SCALE_LOADING_VIEW = 0.2f;
    private static final float REFRESHING_DELTA_SCALE_LOADING_VIEW = 0.8f;
    private int mHeightRefreshLayout;
    private int mLoadingViewHeight;
    private LoadingView mLoadingView;
    private TextView mTextRefreshing;
    private Runnable mRunnable;
    private float mTextRefreshingTransDistance;
    private float mLoadingViewTransDistance;
    private float mOverScrollDistance;
    private boolean mIsAbortRefreshing;
    private OnRefreshListener mOnRefreshListener;
    private boolean mIsRefreshing;
    private View mLayoutContent;
    private EaseCubicInterpolator mCubicInterpolator;
    private ValueAnimator mAnimatorUnfold;
    private ValueAnimator mAnimRefreshFinish;

    public OSDampingLayout(Context context) {
        super(context);
        this.init();
    }

    public OSDampingLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public OSDampingLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        this.mTextRefreshingTransDistance = TypedValue.applyDimension((int)1, (float)15.0f, (DisplayMetrics)metrics);
        this.mLoadingViewTransDistance = TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)metrics);
        this.mHeightRefreshLayout = this.getResources().getDimensionPixelSize(R.dimen.os_damping_layout_loading_title);
        this.mLoadingViewHeight = this.getResources().getDimensionPixelSize(R.dimen.os_damping_layout_loading_view);
        this.mTextRefreshingTransDistance += (float)this.mLoadingViewHeight;
    }

    public void onOverScrollUpdated(float offset) {
        this.mOverScrollDistance = offset;
        if (this.mIsRefreshing && offset == 0.0f && this.mIsAbortRefreshing) {
            this.refreshFinishAnim();
        }
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() != 1) {
            return;
        }
        this.mLayoutContent = this.getChildAt(0);
        this.mLayoutContent.setNestedScrollingEnabled(false);
        this.mLayoutContent.setVerticalScrollBarEnabled(false);
        this.setFillViewport(true);
        this.mCubicInterpolator = new EaseCubicInterpolator(0.25f, 0.0f, 0.0f, 1.0f);
        ViewGroup.LayoutParams layoutParams = this.mLayoutContent.getLayoutParams();
        this.removeView(this.mLayoutContent);
        View layoutRefresh = OSDampingLayout.inflate((Context)this.getContext(), (int)R.layout.os_damping_layout_title, null);
        FrameLayout layoutParent = new FrameLayout(this.getContext());
        layoutParent.addView(this.mLayoutContent, -1, -1);
        layoutParent.addView(layoutRefresh, -1, this.mHeightRefreshLayout);
        this.addView((View)layoutParent, layoutParams);
        this.mTextRefreshing = (TextView)this.findViewById(R.id.damping_text_loading);
        this.mTextRefreshing.setScaleX(0.5f);
        this.mTextRefreshing.setScaleY(this.mTextRefreshing.getScaleX());
        this.mTextRefreshing.setAlpha(0.0f);
        this.mLoadingView = (LoadingView)this.findViewById(R.id.loading_view);
        this.mLoadingView.setScaleX(0.2f);
        this.mLoadingView.setScaleY(this.mLoadingView.getScaleX());
        this.mLoadingView.setAlpha(0.0f);
        this.mLoadingView.setAutoAnim(false);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.releaseResource();
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mLayoutContent == null) {
            return super.dispatchTouchEvent(ev);
        }
        if (!this.mIsRefreshing) {
            this.handleTouchEvent(ev);
        }
        return super.dispatchTouchEvent(ev);
    }

    private void handleTouchEvent(MotionEvent ev) {
        switch (ev.getAction()) {
            case 2: {
                if (!(this.mOverScrollDistance > 0.0f)) break;
                if (this.mOverScrollDistance <= (float)this.mHeightRefreshLayout) {
                    this.mLayoutContent.setTranslationY(this.mOverScrollDistance);
                    this.mTextRefreshing.setText(R.string.os_dampingl_down_pull_refresh);
                    this.refreshTitleLayout(this.mOverScrollDistance);
                    break;
                }
                this.mTextRefreshing.setText(R.string.os_dampingl_release_for_refresh);
                if (!(this.mLayoutContent.getTranslationY() < (float)this.mHeightRefreshLayout)) break;
                this.playAnimatorUnfold();
                break;
            }
            case 1: 
            case 3: {
                if (this.mOverScrollDistance >= (float)this.mHeightRefreshLayout) {
                    this.mIsRefreshing = true;
                    this.mTextRefreshing.setText(R.string.os_dampingl_refreshing);
                    this.mLoadingView.start();
                    if (this.mLayoutContent.getTranslationY() < (float)this.mHeightRefreshLayout) {
                        this.playAnimatorUnfold();
                    }
                    if (this.mOnRefreshListener == null) {
                        if (this.mRunnable == null) {
                            this.mRunnable = new Runnable(){

                                @Override
                                public void run() {
                                    OSDampingLayout.this.refreshFinishAnim();
                                }
                            };
                        }
                        if (this.getHandler() == null) break;
                        this.getHandler().postDelayed(this.mRunnable, 2000L);
                        break;
                    }
                    this.mOnRefreshListener.onRefresh();
                    break;
                }
                this.refreshFinishAnim();
                break;
            }
        }
    }

    public void abortRefreshing() {
        if (this.mLayoutContent == null) {
            return;
        }
        if (this.mOverScrollDistance == 0.0f) {
            this.mIsAbortRefreshing = false;
            if (this.mIsRefreshing) {
                this.refreshFinishAnim();
            }
        } else {
            this.mIsAbortRefreshing = true;
            this.mLoadingView.release();
            this.mTextRefreshing.setText(R.string.os_dampingl_refresh_finish);
        }
    }

    private void releaseResource() {
        Handler handler;
        this.cancelAnim((Animator)this.mAnimatorUnfold);
        this.cancelAnim((Animator)this.mAnimRefreshFinish);
        if (this.mLoadingView != null) {
            this.mLoadingView.release();
        }
        if ((handler = this.getHandler()) != null && this.mRunnable != null) {
            handler.removeCallbacks(this.mRunnable);
        }
    }

    private void playAnimatorUnfold() {
        if (this.mAnimatorUnfold == null) {
            this.mAnimatorUnfold = ValueAnimator.ofFloat((float[])new float[0]);
        }
        if (this.mAnimatorUnfold.isRunning()) {
            return;
        }
        this.mAnimatorUnfold.setFloatValues(new float[]{this.mLayoutContent.getTranslationY(), this.mHeightRefreshLayout});
        this.mAnimatorUnfold.setDuration(50L);
        this.mAnimatorUnfold.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mAnimatorUnfold.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                Object object = animation.getAnimatedValue();
                if (object instanceof Float) {
                    float distance = ((Float)object).floatValue();
                    OSDampingLayout.this.mLayoutContent.setTranslationY(distance);
                    OSDampingLayout.this.refreshTitleLayout(distance);
                }
            }
        });
        this.mAnimatorUnfold.start();
    }

    private void refreshFinishAnim() {
        float translationY = this.mLayoutContent.getTranslationY();
        if (translationY < 0.0f) {
            return;
        }
        if (this.mAnimRefreshFinish == null) {
            this.mAnimRefreshFinish = ValueAnimator.ofFloat((float[])new float[]{0.0f, 0.0f});
            this.mAnimRefreshFinish.setDuration(300L);
            this.mAnimRefreshFinish.setInterpolator((TimeInterpolator)this.mCubicInterpolator);
            this.mAnimRefreshFinish.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    Object object = animation.getAnimatedValue();
                    if (object instanceof Float) {
                        float distance = ((Float)object).floatValue();
                        OSDampingLayout.this.mLayoutContent.setTranslationY(distance);
                        OSDampingLayout.this.refreshTitleLayout(distance);
                    }
                }
            });
            this.mAnimRefreshFinish.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    OSDampingLayout.this.mIsRefreshing = false;
                    OSDampingLayout.this.mIsAbortRefreshing = false;
                    OSDampingLayout.this.mTextRefreshing.setText(R.string.os_dampingl_refresh_finish);
                    OSDampingLayout.this.mLoadingView.release();
                }
            });
        }
        this.mAnimRefreshFinish.setFloatValues(new float[]{translationY, 0.0f});
        this.mAnimRefreshFinish.start();
    }

    private void refreshTitleLayout(float distance) {
        try {
            if (distance > (float)this.mHeightRefreshLayout) {
                return;
            }
            float percent = distance / (float)this.mHeightRefreshLayout;
            this.mTextRefreshing.setScaleX(0.5f + 0.5f * percent);
            this.mTextRefreshing.setScaleY(this.mTextRefreshing.getScaleX());
            this.mTextRefreshing.setAlpha(0.0f + 1.0f * percent);
            float translationY = distance;
            if (translationY > this.mTextRefreshingTransDistance) {
                translationY = this.mTextRefreshingTransDistance;
            }
            this.mTextRefreshing.setTranslationY(translationY);
            translationY = distance - (float)this.mLoadingViewHeight;
            if (translationY > this.mLoadingViewTransDistance) {
                translationY = this.mLoadingViewTransDistance;
            }
            this.mLoadingView.setScaleX(0.2f + 0.8f * percent);
            this.mLoadingView.setScaleY(this.mLoadingView.getScaleX());
            this.mLoadingView.setAlpha(0.0f + 1.0f * percent);
            this.mLoadingView.setTranslationY(translationY);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"refreshTitleLayout, error", (Throwable)e);
        }
    }

    public void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
    }

    public boolean isRefreshing() {
        return this.mIsRefreshing;
    }

    public void setTextColor(int color2) {
        if (this.mTextRefreshing != null) {
            this.mTextRefreshing.setTextColor(color2);
        }
    }

    public LoadingView getLoadingView() {
        return this.mLoadingView;
    }

    private void cancelAnim(Animator animator) {
        if (animator != null && animator.isRunning()) {
            animator.cancel();
        }
    }

    public static interface OnRefreshListener {
        public void onRefresh();
    }
}

