/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.followsoft;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.graphics.Insets;
import androidx.core.view.WindowInsetsAnimationCompat;
import androidx.core.view.WindowInsetsCompat;
import java.util.List;

public class TranslateDeferringInsetsAnimationCallback
extends WindowInsetsAnimationCompat.Callback {
    private int persistentInsetTypes;
    private int deferredInsetTypes;
    private View view;

    public TranslateDeferringInsetsAnimationCallback(View view, int persistentInsetTypes, int deferredInsetTypes, int dispatch_mode) {
        super(dispatch_mode);
        this.deferredInsetTypes = deferredInsetTypes;
        this.persistentInsetTypes = persistentInsetTypes;
        this.view = view;
        if ((persistentInsetTypes & deferredInsetTypes) != 0) {
            throw new IllegalArgumentException("persistentInsetTypes and deferredInsetTypes can not contain any of  same WindowInsetsCompat.Type values");
        }
    }

    public TranslateDeferringInsetsAnimationCallback(View view, int persistentInsetTypes, int deferredInsetTypes) {
        this(view, persistentInsetTypes, deferredInsetTypes, 0);
    }

    @NonNull
    public WindowInsetsCompat onProgress(@NonNull WindowInsetsCompat insets, @NonNull List<WindowInsetsAnimationCompat> runningAnimations) {
        Insets typesInset = insets.getInsets(this.deferredInsetTypes);
        Insets otherInset = insets.getInsets(this.persistentInsetTypes);
        Insets diff = Insets.of((int)(typesInset.left - otherInset.left), (int)(typesInset.top - otherInset.top), (int)(typesInset.right - otherInset.right), (int)(typesInset.bottom - otherInset.bottom));
        diff = Insets.of((int)Math.max(diff.left, Insets.NONE.left), (int)Math.max(diff.top, Insets.NONE.top), (int)Math.max(diff.right, Insets.NONE.right), (int)Math.max(diff.bottom, Insets.NONE.bottom));
        this.view.setTranslationX((float)(diff.left - diff.right));
        this.view.setTranslationY((float)(diff.top - diff.bottom));
        return insets;
    }

    public void onEnd(@NonNull WindowInsetsAnimationCompat animation) {
    }
}

