/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.view.swipmenu;

import android.content.Context;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.view.swipmenu.SwipeMenuItem;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class SwipeMenu {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int mOrientation;
    private List<SwipeMenuItem> mSwipeMenuItems;
    private Context mContext;
    private boolean mIsHios;
    private int mMenuPadding;
    private int mMenuItemPadding;
    private boolean mIsMenuImageType = true;
    private int mHiosCircleRadius;

    public Context getContext() {
        return this.mContext;
    }

    public void setContext(Context mContext) {
        this.mContext = mContext;
    }

    public int getHiosCircleRadius() {
        return this.mHiosCircleRadius;
    }

    public int getMenuPadding() {
        return this.mMenuPadding;
    }

    public int getMenuItemPadding() {
        return this.mMenuItemPadding;
    }

    public SwipeMenu(Context context) {
        this.mContext = context;
        this.mOrientation = 0;
        this.mIsHios = Utils.mOsType[0].equalsIgnoreCase(Utils.getOsType());
        this.mSwipeMenuItems = new ArrayList<SwipeMenuItem>(2);
        if (this.mIsHios) {
            this.mMenuPadding = Utils.dp2px(this.mContext, 9);
            this.mMenuItemPadding = Utils.dp2px(this.mContext, 7);
            this.mHiosCircleRadius = Utils.dp2px(this.mContext, 20);
        }
    }

    public void setOrientation(int orientation) {
        this.mOrientation = orientation;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void addMenuItem(SwipeMenuItem item) {
        this.mSwipeMenuItems.add(item);
        this.decidedMenuType();
    }

    private void decidedMenuType() {
        if (this.mSwipeMenuItems != null && this.mSwipeMenuItems.size() == 1) {
            this.setIsMenuImageType(this.mSwipeMenuItems.get(0).getType() == 1);
        }
    }

    public void removeMenuItem(SwipeMenuItem item) {
        this.mSwipeMenuItems.remove(item);
    }

    public List<SwipeMenuItem> getMenuItems() {
        return this.mSwipeMenuItems;
    }

    public boolean hasMenuItems() {
        return !this.mSwipeMenuItems.isEmpty();
    }

    public int getMenuTotalWidth() {
        int totalWidth = 0;
        if (this.mIsHios && this.isMenuImageType()) {
            for (int index = 0; index < this.mSwipeMenuItems.size(); ++index) {
                totalWidth += this.mSwipeMenuItems.get(index).getWidth();
            }
            if (totalWidth > 0) {
                totalWidth += this.mMenuPadding * 2;
            }
        } else {
            for (int index = 0; index < this.mSwipeMenuItems.size(); ++index) {
                totalWidth += this.mSwipeMenuItems.get(index).getWidth();
            }
        }
        return totalWidth;
    }

    public int getAdapterPosition() {
        if (this.mSwipeMenuItems != null && this.mSwipeMenuItems.size() > 0) {
            return this.mSwipeMenuItems.get(0).getPosition();
        }
        return -1;
    }

    public float getEdgeDistanceHios(int index) {
        if (index < 0 || index > this.mSwipeMenuItems.size() - 1) {
            return 0.0f;
        }
        float tempWidth = 0.0f;
        for (int index_ = this.mSwipeMenuItems.size() - 1; index_ >= index; --index_) {
            tempWidth += (float)this.mSwipeMenuItems.get(index_).getWidth();
        }
        return tempWidth += (float)this.mMenuPadding;
    }

    public float getHiosSpaceRatio() {
        if (this.mSwipeMenuItems.size() <= 0) {
            return 0.0f;
        }
        float i = (float)(this.mMenuPadding + this.mMenuItemPadding) * 2.0f / (float)this.getMenuTotalWidth();
        return i;
    }

    public boolean isHios() {
        return this.mIsHios;
    }

    public boolean isMenuImageType() {
        return this.mIsMenuImageType;
    }

    public void setIsMenuImageType(boolean isMenuImageType) {
        this.mIsMenuImageType = isMenuImageType;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OrientationMode {
    }
}

