/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.ViewTreeObserver;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.appcompat.view.menu.MenuBuilder;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.blur.DynamicBlur;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.view.BadgeView;
import com.transsion.widgetslib.widget.OSMaskImageView;
import com.transsion.widgetslib.widget.timepicker.wheel.EaseCubicInterpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class FootOperationBar
extends FrameLayout {
    private static final int DEFAULT_MAX_VISIBLE_TAB_COUNT = 5;
    private static final int DEFAULT_MIN_VISIBLE_TAB_COUNT = 3;
    private static final int ANIM_TIME = 150;
    private int mScreenWidth;
    private LinearLayout mContainer;
    private OnFootOptBarClickListener mItemClickListener;
    private List<String> mPopupItems;
    private ListPopupWindow mPopup;
    private View mMoreView;
    private boolean mShow = false;
    private boolean mAnim = false;
    private boolean mInitShow = false;
    private boolean[] mMenuEnables;
    private int mTextColor;
    private boolean mHaveTextColor;
    private int mClickTextColor;
    private int mClickImageTintColor;
    private int mNormalImageTintColor;
    private boolean mHaveNormalImageTintColor;
    private boolean mHaveClickImageTintColor;
    private boolean isFootActionBar;
    private boolean needChangeImgColor = true;
    private int mMaxVisibleTabCount;
    private int mVisibleTabCount;
    private List<View> mFootItemViews = new ArrayList<View>();
    private Context mContext;
    private int mMoreIconRes;
    private int mItemBackgroundRes;
    private final MyOnPreDrawListener mMyOnPreDrawListener;
    private int mTintColor = -1;
    private float mBlurAlp = 0.9f;
    private int mBgColor;
    private final int mTabParentHitDelegateInsert;
    private final int mTabHitDelegateExpend;
    private int mOrientation;
    private DynamicBlur mBlur;
    private ViewTreeObserver.OnDrawListener mOnDrawListener;
    private View mBlurredView;

    public FootOperationBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mContext = context;
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        LayoutInflater.from((Context)context).inflate(R.layout.os_foot_opt_bar_root, (ViewGroup)this);
        this.mContainer = (LinearLayout)this.findViewById(R.id.os_foot_opt_bar_container);
        this.mPopupItems = new ArrayList<String>();
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.FootOperationBar);
        this.isFootActionBar = ta.getBoolean(R.styleable.FootOperationBar_isFootActionBar, false);
        this.needChangeImgColor = ta.getBoolean(R.styleable.FootOperationBar_foot_need_change_img_color, false);
        this.mItemBackgroundRes = ta.getResourceId(R.styleable.FootOperationBar_foot_item_background, R.drawable.os_foot_option_bar_item_bg);
        this.mTintColor = ta.getColor(R.styleable.FootOperationBar_foot_item_icon_tint, ContextCompat.getColor((Context)this.mContext, (int)R.color.os_fill_icon_primary_color));
        int[] attrs1 = new int[]{R.attr.os_platform_basic_color, R.attr.os_foot_more};
        TypedArray typedArray = context.obtainStyledAttributes(attrs1);
        int clickTextColorDefault = typedArray.getColor(0, this.getResources().getColor(R.color.os_platform_basic_color_hios));
        this.mMoreIconRes = typedArray.getResourceId(1, R.drawable.os_ic_foot_more_hios);
        typedArray.recycle();
        if (this.isFootActionBar) {
            int alpha = 51;
            this.mNormalImageTintColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_fill_icon_primary_color);
            this.mClickImageTintColor = Color.argb((int)alpha, (int)Color.red((int)this.mNormalImageTintColor), (int)Color.green((int)this.mNormalImageTintColor), (int)Color.blue((int)this.mNormalImageTintColor));
            this.mTextColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_text_primary_color);
            this.mClickTextColor = Color.argb((int)alpha, (int)Color.red((int)this.mTextColor), (int)Color.green((int)this.mTextColor), (int)Color.blue((int)this.mTextColor));
        } else {
            this.mClickTextColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_text_primary_color);
            String osType = Utils.getOsType();
            if (Utils.mOsType[1].equalsIgnoreCase(osType)) {
                this.mClickImageTintColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_fill_icon_toggle_color);
                this.mNormalImageTintColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_fill_icon_secondary_color);
                this.mTextColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_text_tertiary_color);
            } else if (Utils.mOsType[0].equalsIgnoreCase(osType)) {
                this.mClickImageTintColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_fill_icon_tertiary_color);
                this.mNormalImageTintColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_fill_icon_quaternary_color);
                this.mTextColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_text_quinary_color);
            } else {
                this.mClickImageTintColor = Utils.getOsPlatformBasicColor(this.mContext);
                this.mNormalImageTintColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_fill_icon_secondary_color);
                this.mClickTextColor = Utils.getOsPlatformBasicColor(this.mContext);
                this.mTextColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_text_tertiary_color);
            }
        }
        this.mHaveClickImageTintColor = ta.hasValue(R.styleable.FootOperationBar_foot_click_image_color);
        if (this.mHaveClickImageTintColor) {
            this.mClickImageTintColor = ta.getColor(R.styleable.FootOperationBar_foot_click_image_color, -1);
        }
        this.mHaveNormalImageTintColor = ta.hasValue(R.styleable.FootOperationBar_foot_normal_image_color);
        if (this.mHaveNormalImageTintColor) {
            this.mNormalImageTintColor = ta.getColor(R.styleable.FootOperationBar_foot_normal_image_color, -65536);
        }
        this.mHaveTextColor = ta.hasValue(R.styleable.FootOperationBar_foot_text_color);
        if (this.mHaveTextColor) {
            this.mTextColor = ta.getColor(R.styleable.FootOperationBar_foot_text_color, this.getResources().getColor(R.color.os_text_secondary_color));
        }
        if (ta.hasValue(R.styleable.FootOperationBar_foot_click_text_color)) {
            this.mClickTextColor = ta.getColor(R.styleable.FootOperationBar_foot_click_text_color, clickTextColorDefault);
        }
        this.mMaxVisibleTabCount = ta.getInt(R.styleable.FootOperationBar_foot_max_visible_tab_count, 5);
        if (this.mMaxVisibleTabCount < 3) {
            this.mMaxVisibleTabCount = 3;
        }
        this.initDefaultParameter(context);
        if (ta.hasValue(R.styleable.FootOperationBar_foot_opt_menu)) {
            this.inflateMenu(ta.getResourceId(R.styleable.FootOperationBar_foot_opt_menu, 0));
        }
        this.mInitShow = ta.getBoolean(R.styleable.FootOperationBar_foot_init_show, false);
        ta.recycle();
        this.mMyOnPreDrawListener = new MyOnPreDrawListener(this);
        this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mMyOnPreDrawListener);
        this.setClickable(true);
        this.mTabParentHitDelegateInsert = (int)TypedValue.applyDimension((int)1, (float)12.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mTabHitDelegateExpend = (int)TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.mOrientation = this.getResources().getConfiguration().orientation;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.initDefaultParameter(this.getContext());
    }

    private void initDefaultParameter(Context context) {
        boolean isWaterFallScreen;
        if (context == null) {
            return;
        }
        this.setMinimumHeight(this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_min_height));
        if (this.getBackground() == null) {
            this.mBgColor = Utils.mOsType[0].equalsIgnoreCase(Utils.getOsType()) ? ContextCompat.getColor((Context)context, (int)R.color.os_altitude_quaternary_color) : ContextCompat.getColor((Context)context, (int)R.color.os_altitude_primary_color);
            this.setBackgroundColor(this.mBgColor);
        }
        if (Build.VERSION.SDK_INT >= 30 && (isWaterFallScreen = Utils.isWaterfallScreen(this.mContext))) {
            int rotation = this.mContext.getDisplay().getRotation();
            int leftPadding = this.mContainer.getPaddingLeft();
            int topPadding = this.mContainer.getPaddingTop();
            int rightPadding = this.mContainer.getPaddingRight();
            int bottomPadding = this.mContainer.getPaddingBottom();
            switch (rotation) {
                case 0: 
                case 2: {
                    rightPadding = leftPadding = this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_padding) + this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curve_land);
                    break;
                }
                case 1: {
                    leftPadding = this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curve_land);
                    rightPadding = 0;
                    this.setMinimumHeight(this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_min_height_curve_land));
                    break;
                }
                case 3: {
                    leftPadding = 0;
                    rightPadding = this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curve_land);
                    this.setMinimumHeight(this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_min_height_curve_land));
                }
            }
            this.mContainer.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
        }
        this.mContainer.setMinimumHeight(this.getMinimumHeight());
    }

    public void setContainerBackground(@ColorRes int colorResId) {
        this.setContainerBackgroundNoOverlay(colorResId);
    }

    public void setContainerBackgroundNoOverlay(@ColorRes int colorResId) {
        this.setContainerBackgroundColor(this.mContext.getResources().getColor(colorResId));
    }

    public void setContainerBackgroundColor(@ColorInt int color2) {
        this.mBgColor = color2;
        this.setBackgroundColor(color2);
        if (this.mBlurredView != null && this.mOnDrawListener != null) {
            this.setContainerBgColor();
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    public void inflateMenu(int menuResId) {
        MenuInflater inflater = new MenuInflater(this.getContext());
        MenuBuilder menu = new MenuBuilder(this.getContext());
        inflater.inflate(menuResId, (Menu)menu);
        this.setMenu(menu);
    }

    @SuppressLint(value={"RestrictedApi"})
    private void setMenu(MenuBuilder menu) {
        this.mContainer.removeAllViews();
        this.mPopupItems.clear();
        this.mPopup = null;
        int count = menu.size();
        this.setContainerWidth(count);
        if (!this.isFootActionBar || count <= this.mMaxVisibleTabCount - 1) {
            this.addItemView(menu, count);
        } else {
            this.mVisibleTabCount = this.mMaxVisibleTabCount > 5 ? 4 : this.mMaxVisibleTabCount - 1;
            this.addItemView(menu, this.mVisibleTabCount);
            View moreViewLayout = this.getMenuItem(this.mMoreIconRes, this.mContext.getResources().getString(R.string.os_foot_opt_bar_more));
            this.mMoreView = moreViewLayout.findViewById(R.id.os_fob_layout);
            this.mMoreView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FootOperationBar.this.mMoreView.setSelected(true);
                    FootOperationBar.this.mPopup.show();
                }
            });
            this.mContainer.addView(moreViewLayout);
            this.setPopupItems(menu, count);
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    private void addItemView(MenuBuilder menu, int count) {
        this.mFootItemViews.clear();
        for (int i = 0; i < count; ++i) {
            MenuItem item = menu.getItem(i);
            View itemView = this.getMenuItem(item.getIcon(), item.getTitle().toString());
            this.addItemView(itemView, i);
        }
    }

    public void removeItemView(int index) {
        if (this.mFootItemViews != null && this.mFootItemViews.size() > index) {
            this.mFootItemViews.remove(this.mFootItemViews.get(index));
            this.mContainer.removeViewAt(index);
            this.resetClickListener();
            this.requestLayout();
            this.invalidate();
        }
    }

    private void addItemView(int[] resId, String[] titleId, int count) {
        this.mFootItemViews.clear();
        for (int i = 0; i < count; ++i) {
            View itemView = this.getMenuItem(resId[i], titleId[i]);
            this.addItemView(itemView, i);
        }
    }

    private void addItemView(View view, int i) {
        this.mFootItemViews.add(view);
        final int index = i;
        View icon = view.findViewById(R.id.os_fob_layout);
        this.expendTabTouchDelegate(icon, view, false);
        icon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FootOperationBar.this.mItemClickListener != null) {
                    FootOperationBar.this.mItemClickListener.onItemClick(index);
                    if (FootOperationBar.this.isFootActionBar) {
                        FootOperationBar.this.setItemSelectState(index);
                    } else {
                        FootOperationBar.this.setItemSelectState(index, true);
                    }
                }
            }
        });
        this.mContainer.addView(view);
    }

    public void resetClickListener() {
        for (int index = 0; index < this.mFootItemViews.size(); ++index) {
            final int finalIndex = index;
            View view = this.mFootItemViews.get(index);
            View icon = view.findViewById(R.id.os_fob_layout);
            this.expendTabTouchDelegate(icon, view, false);
            icon.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FootOperationBar.this.mItemClickListener != null) {
                        FootOperationBar.this.mItemClickListener.onItemClick(finalIndex);
                        if (FootOperationBar.this.isFootActionBar) {
                            FootOperationBar.this.setItemSelectState(finalIndex);
                        } else {
                            FootOperationBar.this.setItemSelectState(finalIndex, true);
                        }
                    }
                }
            });
        }
    }

    public void addSingleItemView(int resId, int titleId, int i) {
        View itemView = this.getMenuItem(resId, this.mContext.getResources().getString(titleId));
        this.mFootItemViews.add(itemView);
        this.resetClickListener();
        if (i < this.mFootItemViews.size()) {
            this.mContainer.addView(itemView, i);
        } else {
            this.mContainer.addView(itemView);
        }
    }

    public void setItemSelectState(int index) {
        this.setItemSelectState(index, false);
    }

    private void setItemSelectState(int index, boolean isAnimExec) {
        if (this.mFootItemViews != null) {
            for (int i = 0; i < this.mFootItemViews.size(); ++i) {
                TextView textView = (TextView)this.mFootItemViews.get(i).findViewById(R.id.os_foot_opt_bar_item_text);
                OSMaskImageView imageView = (OSMaskImageView)this.mFootItemViews.get(i).findViewById(R.id.os_foot_opt_bar_item_icon);
                if (i == index) {
                    if (imageView.isSelected() || imageView.isSelectedAnimRunning()) {
                        return;
                    }
                    if (isAnimExec) {
                        final TextView finalTextView = textView;
                        imageView.setSelectedAnim(true, new AnimatorListenerAdapter(){

                            public void onAnimationStart(Animator animation) {
                                super.onAnimationStart(animation);
                                finalTextView.setTextColor(FootOperationBar.this.mClickTextColor);
                            }
                        });
                        continue;
                    }
                    if (this.isFootActionBar) {
                        return;
                    }
                    imageView.setSelected(true);
                    textView.setTextColor(this.mClickTextColor);
                    continue;
                }
                if (this.isFootActionBar) {
                    return;
                }
                if (imageView.isSelectedAnimRunning()) {
                    imageView.cancelSelectedAnimRunning();
                }
                textView.setTextColor(this.mTextColor);
                if (isAnimExec) {
                    if (!imageView.isSelected()) continue;
                    imageView.setSelectedAnim(false);
                    continue;
                }
                imageView.setSelected(false);
            }
        }
    }

    @SuppressLint(value={"RestrictedApi"})
    private void setPopupItems(MenuBuilder menu, int count) {
        this.mMenuEnables = new boolean[count];
        for (int i = this.mVisibleTabCount = this.mMaxVisibleTabCount > 5 ? 4 : this.mMaxVisibleTabCount - 1; i < count; ++i) {
            MenuItem item = menu.getItem(i);
            this.mPopupItems.add(item.getTitle().toString());
            this.mMenuEnables[i - this.mVisibleTabCount] = true;
        }
        this.setFootPopupWindow();
    }

    private void setContainerWidth(int count) {
        int padding;
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        switch (count) {
            case 1: {
                padding = (int)TypedValue.applyDimension((int)1, (float)99.0f, (DisplayMetrics)metrics);
                break;
            }
            case 2: 
            case 3: {
                padding = (int)TypedValue.applyDimension((int)1, (float)18.0f, (DisplayMetrics)metrics);
                break;
            }
            case 5: {
                padding = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)metrics);
                break;
            }
            default: {
                padding = this.getResources().getDimensionPixelSize(R.dimen.os_foot_bar_padding);
                if (!Utils.isWaterfallScreen(this.mContext)) break;
                padding += this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curve_land);
            }
        }
        ViewGroup.LayoutParams lp = this.mContainer.getLayoutParams();
        lp.width = -1;
        this.mContainer.setLayoutParams(lp);
        this.mContainer.setPadding(padding, this.mContainer.getPaddingTop(), padding, this.mContainer.getPaddingBottom());
    }

    private View getMenuItem(Drawable img, String title) {
        View itemRoot = this.isFootActionBar ? LayoutInflater.from((Context)this.getContext()).inflate(R.layout.os_foot_action_bar_item, (ViewGroup)this.mContainer, false) : LayoutInflater.from((Context)this.getContext()).inflate(R.layout.os_foot_opt_bar_item, (ViewGroup)this.mContainer, false);
        ImageView icon = (ImageView)itemRoot.findViewById(R.id.os_foot_opt_bar_item_icon);
        TextView text = (TextView)itemRoot.findViewById(R.id.os_foot_opt_bar_item_text);
        if (img != null) {
            img.mutate();
            icon.setImageDrawable(img);
            this.setImageColorStateList(icon);
        }
        if (!TextUtils.isEmpty((CharSequence)title)) {
            text.setText((CharSequence)title);
            if (this.isFootActionBar) {
                int[][] states = new int[][]{{16842919}, new int[0]};
                int[] colors = new int[]{this.mClickTextColor, this.mTextColor};
                ColorStateList colorList = new ColorStateList((int[][])states, colors);
                text.setTextColor(colorList);
            } else {
                text.setTextColor(this.mTextColor);
            }
        }
        return itemRoot;
    }

    private View getMenuItem(int imgId, String title) {
        return this.getMenuItem(this.mContext.getDrawable(imgId), title);
    }

    private void setImageColorStateList(ImageView icon) {
        int[][] states = new int[][]{this.isFootActionBar ? new int[]{16842919} : new int[]{0x10100A1}, new int[0]};
        int[] colors = new int[]{this.mClickImageTintColor, this.mNormalImageTintColor};
        ColorStateList colorList = new ColorStateList((int[][])states, colors);
        icon.setImageTintList(colorList);
    }

    public void changeFootItem(int position, Drawable drawable2, String title) {
        View itemView = this.mContainer.getChildAt(position);
        if (itemView == null) {
            return;
        }
        ImageView icon = (ImageView)itemView.findViewById(R.id.os_foot_opt_bar_item_icon);
        if (drawable2 != null) {
            icon.setImageDrawable(null);
            icon.setImageDrawable(drawable2);
        }
        if (title != null) {
            TextView text = (TextView)itemView.findViewById(R.id.os_foot_opt_bar_item_text);
            text.setText((CharSequence)title);
        }
    }

    public void changeFootItem(int position, int resId, String title) {
        this.changeFootItem(position, ContextCompat.getDrawable((Context)this.mContext, (int)resId), title);
    }

    public void changeFootItem(int position, int resId, int strId) {
        this.changeFootItem(position, resId, this.getResources().getString(strId));
    }

    public void changeFootItem(int position, String title) {
        this.changeFootItem(position, null, title);
    }

    public void changeFootItem(int position, Drawable drawable2) {
        this.changeFootItem(position, drawable2, null);
    }

    public void changeItems(int[] resId, int[] titleIds) {
        String[] titles = new String[titleIds.length];
        for (int i = 0; i < titleIds.length; ++i) {
            titles[i] = this.mContext.getResources().getString(titleIds[i]);
        }
        this.changeItems(resId, titles);
    }

    public void changeItems(int[] resId, String[] titleId) {
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
        this.mContainer.removeAllViews();
        this.mPopupItems.clear();
        this.mFootItemViews.clear();
        this.mPopup = null;
        int count = resId.length;
        this.setContainerWidth(count);
        if (!this.isFootActionBar || count <= this.mMaxVisibleTabCount - 1) {
            this.addItemView(resId, titleId, count);
        } else {
            this.mVisibleTabCount = this.mMaxVisibleTabCount > 5 ? 4 : this.mMaxVisibleTabCount - 1;
            this.addItemView(resId, titleId, this.mVisibleTabCount);
            View moreViewLayout = this.getMenuItem(this.mMoreIconRes, this.mContext.getResources().getString(R.string.os_foot_opt_bar_more));
            this.mMoreView = moreViewLayout.findViewById(R.id.os_fob_layout);
            this.mMoreView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FootOperationBar.this.mMoreView.setSelected(true);
                    if (FootOperationBar.this.mPopup != null && !FootOperationBar.this.mPopup.isShowing()) {
                        FootOperationBar.this.mPopup.show();
                    }
                }
            });
            this.mContainer.addView(moreViewLayout);
            this.setPopupItems(titleId, count);
        }
    }

    private void setPopupItems(String[] title, int count) {
        this.mMenuEnables = new boolean[count - this.mVisibleTabCount];
        for (int i = this.mVisibleTabCount; i < count; ++i) {
            this.mPopupItems.add(title[i]);
            this.mMenuEnables[i - this.mVisibleTabCount] = true;
        }
        this.setFootPopupWindow();
    }

    public void changeItemsEnable(boolean[] enables) {
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
        int count = Math.min(enables.length, this.getItemCount());
        for (int i = 0; i < count; ++i) {
            this.changeItemEnable(i, enables[i]);
        }
    }

    public void changeItemEnable(int position, boolean enable) {
        if (this.mPopup == null) {
            this.viewEnable(this.mContainer.getChildAt(position), enable);
        } else if (position < this.mVisibleTabCount) {
            this.viewEnable(this.mContainer.getChildAt(position), enable);
        } else {
            this.mMenuEnables[position - this.mVisibleTabCount] = enable;
        }
    }

    public void enableMore(boolean enAble) {
        if (this.mMoreView != null) {
            this.viewEnable(this.mMoreView, enAble);
            if (!enAble && this.mPopup != null && this.mPopup.isShowing()) {
                this.mPopup.dismiss();
            }
        }
    }

    private void viewEnable(View view, boolean enAble) {
        if (view != null) {
            View fotLayout = view.findViewById(R.id.os_fob_layout);
            if (fotLayout == null) {
                view.setEnabled(enAble);
                view.setAlpha(enAble ? 1.0f : 0.4f);
                return;
            }
            fotLayout.setEnabled(enAble);
            fotLayout.setAlpha(enAble ? 1.0f : 0.4f);
        }
    }

    private void setFootPopupWindow() {
        FootPopupAdapter adapter = new FootPopupAdapter();
        this.mPopup = new ListPopupWindow(this.getContext(), null, 0, R.style.OsFootOptPopupEdgeStyle);
        this.mPopup.setAdapter((ListAdapter)adapter);
        int contentWidth = this.measureMaxWidth((ListAdapter)adapter, this.mScreenWidth / 2);
        this.mPopup.setContentWidth(contentWidth);
        this.mPopup.setModal(true);
        this.mPopup.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                FootOperationBar.this.mMoreView.setSelected(false);
            }
        });
        this.mPopup.setAnchorView((View)this.mContainer);
        this.mPopup.setDropDownGravity(0x800005);
        if (this.getResources().getConfiguration().orientation == 2 && Build.VERSION.SDK_INT >= 29) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    Display display = FootOperationBar.this.getDisplay();
                    if (display == null || display.getCutout() == null) {
                        return;
                    }
                    FootOperationBar.this.mPopup.setHorizontalOffset(-display.getCutout().getSafeInsetRight());
                }
            });
        }
        if (Build.VERSION.SDK_INT >= 30 && Utils.isWaterfallScreen(this.mContext)) {
            int offset;
            Drawable drawable2;
            int rotation = this.mContext.getDisplay().getRotation();
            switch (rotation) {
                case 1: {
                    drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.os_foot_opt_popup_background_curse_90);
                    offset = this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curse_offset_land);
                    break;
                }
                case 3: {
                    drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.os_foot_opt_popup_background_curse_270);
                    offset = this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curse_offset_land);
                    break;
                }
                default: {
                    drawable2 = ContextCompat.getDrawable((Context)this.mContext, (int)R.drawable.os_foot_opt_popup_background_curse_0_180);
                    offset = this.mContext.getResources().getDimensionPixelSize(R.dimen.os_curse_offset_portrait);
                }
            }
            this.mPopup.setContentWidth(contentWidth + offset);
            this.mPopup.setBackgroundDrawable(drawable2);
        }
    }

    private int measureMaxWidth(ListAdapter adapter, int maxAllowedWidth) {
        int maxWidth = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            itemView = adapter.getView(i, itemView, null);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            int itemWidth = itemView.getMeasuredWidth();
            if (itemWidth >= maxAllowedWidth) {
                return maxAllowedWidth;
            }
            if (itemWidth <= maxWidth) continue;
            maxWidth = itemWidth;
        }
        return maxWidth;
    }

    private void openAnimator() {
        ObjectAnimator oa = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{0.0f, 1.0f});
        oa.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.33f, 0.0f, 0.66f, 1.0f));
        oa.setDuration(150L);
        oa.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationStart(Animator animation) {
                super.onAnimationStart(animation);
                FootOperationBar.this.setVisibility(0);
                FootOperationBar.this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)FootOperationBar.this.mMyOnPreDrawListener);
            }

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                FootOperationBar.this.mAnim = false;
            }
        });
        oa.start();
    }

    private void closeAnimator() {
        ObjectAnimator oa = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        oa.setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.33f, 0.0f, 0.66f, 1.0f));
        oa.setDuration(150L);
        oa.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                FootOperationBar.this.setVisibility(8);
                FootOperationBar.this.mAnim = false;
                if (FootOperationBar.this.mMoreView != null) {
                    FootOperationBar.this.mMoreView.setEnabled(true);
                }
                FootOperationBar.this.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)FootOperationBar.this.mMyOnPreDrawListener);
            }
        });
        oa.start();
    }

    public void openFootOperationBar() {
        if (!this.mAnim && !this.mShow) {
            this.mAnim = true;
            this.mShow = true;
            this.openAnimator();
        }
    }

    public void closeFootOperationBar() {
        if (!this.mAnim && this.mShow) {
            if (this.mPopup != null && this.mPopup.isShowing()) {
                this.mPopup.dismiss();
            }
            if (this.mMoreView != null) {
                this.mMoreView.setEnabled(false);
            }
            this.mAnim = true;
            this.mShow = false;
            this.closeAnimator();
        }
    }

    public void toggleFootOperationBar() {
        if (this.mShow) {
            this.closeFootOperationBar();
        } else {
            this.openFootOperationBar();
        }
    }

    public void initShow(boolean initShow) {
        this.mInitShow = initShow;
    }

    public int getItemCount() {
        return this.mPopupItems.size() > 0 ? this.mContainer.getChildCount() + this.mPopupItems.size() - 1 : this.mContainer.getChildCount();
    }

    public void updateFootBarView() {
        this.mScreenWidth = this.getResources().getDisplayMetrics().widthPixels;
        this.setContainerWidth(this.mContainer.getChildCount());
        if (this.mPopup != null && this.mPopup.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.updateFootBarView();
        if (this.mShow) {
            boolean isNeedChangeVisibility;
            int orientation = this.getResources().getConfiguration().orientation;
            boolean bl = isNeedChangeVisibility = this.mOrientation != orientation;
            if (isNeedChangeVisibility) {
                this.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mMyOnPreDrawListener);
            }
            this.mOrientation = orientation;
        }
    }

    public void setOnFootOptBarClickListener(OnFootOptBarClickListener l) {
        this.mItemClickListener = l;
    }

    public void setFootOptBarTextColor(@ColorInt int color2) {
        this.mTextColor = color2;
    }

    public void setFootOptBarClickTextColor(@ColorInt int color2) {
        this.mClickTextColor = color2;
    }

    public void setBlurAlp(@IntRange(from=0L, to=255L) int alpha) {
        if (alpha < 0 || alpha > 255) {
            return;
        }
        this.mBlurAlp = 1.0f * (float)alpha / 255.0f;
    }

    public void toggleDynamicBlur(View blurredView) {
    }

    private void setContainerBgColor() {
        int alpha = Color.alpha((int)this.mBgColor);
        final int newColor = Color.argb((int)((int)(this.mBlurAlp * (float)alpha)), (int)Color.red((int)this.mBgColor), (int)Color.green((int)this.mBgColor), (int)Color.blue((int)this.mBgColor));
        final ShapeDrawable bgBlur = new ShapeDrawable();
        final Paint paint = bgBlur.getPaint();
        this.post(new Runnable(){

            @Override
            public void run() {
                paint.setShader((Shader)new LinearGradient(0.0f, 0.0f, 0.0f, (float)FootOperationBar.this.getMeasuredHeight(), newColor, FootOperationBar.this.mBgColor, Shader.TileMode.CLAMP));
                FootOperationBar.this.mContainer.setBackground((Drawable)bgBlur);
            }
        });
    }

    public void closeDynamicBlur() {
    }

    public void closeDynamicBlurWithRestoreBackground() {
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.closeDynamicBlur();
    }

    private void redPointHideAnim(final View badgeView) {
        if (badgeView.getVisibility() != 0) {
            return;
        }
        badgeView.animate().alpha(0.0f).scaleX(0.5f).scaleY(0.5f).setInterpolator((TimeInterpolator)new EaseCubicInterpolator(0.4f, 0.0f, 1.0f, 1.0f)).setDuration(150L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                badgeView.setVisibility(8);
                badgeView.setScaleX(1.0f);
                badgeView.setScaleY(1.0f);
                badgeView.setAlpha(1.0f);
            }
        }).start();
    }

    @Nullable
    public BadgeView getItemRedPoint(int index) {
        if (this.mFootItemViews == null || this.isFootActionBar) {
            return null;
        }
        int size = this.mFootItemViews.size();
        if (index < 0 || index > size - 1) {
            return null;
        }
        BadgeView badgeView = null;
        TextView textView = (TextView)this.mFootItemViews.get(index).findViewById(R.id.os_foot_opt_bar_item_text);
        if (textView.getTag() == null) {
            badgeView = (BadgeView)((ViewStub)this.mFootItemViews.get(index).findViewById(R.id.os_stub_fpb_red_point)).inflate();
            textView.setTag((Object)badgeView);
        } else {
            Object tag = textView.getTag();
            if (tag instanceof BadgeView) {
                badgeView = (BadgeView)((Object)tag);
            }
        }
        return badgeView;
    }

    public void setItemRedPointState(int index, boolean isVisible, int type, int num) {
        BadgeView badgeView = this.getItemRedPoint(index);
        if (badgeView == null) {
            return;
        }
        if (badgeView.getRedPointType() != type) {
            badgeView.setRedPointType(type);
        }
        badgeView.setVisibility(num > 0 && isVisible ? 0 : 8);
        if (badgeView.getVisibility() == 0) {
            badgeView.setNum(num);
        }
    }

    public void updateItemRedPointNum(int index, int num) {
        BadgeView badgeView = this.getItemRedPoint(index);
        if (badgeView == null) {
            return;
        }
        if (num <= 0) {
            this.redPointHideAnim(badgeView);
        } else {
            if (badgeView.getVisibility() != 0) {
                badgeView.setVisibility(0);
            }
            badgeView.setNum(num);
        }
    }

    public boolean hasItemRedPoint(int index) {
        if (this.mFootItemViews == null || this.isFootActionBar) {
            return false;
        }
        int size = this.mFootItemViews.size();
        if (index < 0 || index > size - 1) {
            return false;
        }
        TextView textView = (TextView)this.mFootItemViews.get(index).findViewById(R.id.os_foot_opt_bar_item_text);
        Object tag = textView.getTag();
        if (tag instanceof BadgeView) {
            BadgeView badgeView = (BadgeView)((Object)tag);
            return badgeView.getVisibility() == 0;
        }
        return false;
    }

    private void expendTabTouchDelegate(final View child, final View parent, final boolean isExpend) {
        parent.post(new Runnable(){

            @Override
            public void run() {
                Rect rectChild = new Rect();
                child.getHitRect(rectChild);
                Rect rectParent = new Rect();
                parent.getHitRect(rectParent);
                rectChild.top = 0;
                rectChild.bottom = rectParent.height();
                if (isExpend) {
                    rectChild.left = FootOperationBar.this.mTabParentHitDelegateInsert;
                    rectChild.right = rectParent.width() - FootOperationBar.this.mTabParentHitDelegateInsert;
                } else {
                    rectChild.left -= FootOperationBar.this.mTabHitDelegateExpend;
                    rectChild.right += FootOperationBar.this.mTabHitDelegateExpend;
                    child.setTag((Object)rectChild);
                }
                parent.setTouchDelegate(new TouchDelegate(rectChild, child));
            }
        });
    }

    public void expendTabTouchDelegate() {
        for (View parent : this.mFootItemViews) {
            this.expendTabTouchDelegate(parent.findViewById(R.id.os_fob_layout), parent, true);
        }
    }

    public void restoreTabTouchDelegate() {
        for (View parent : this.mFootItemViews) {
            View child = parent.findViewById(R.id.os_fob_layout);
            Object tag = child.getTag();
            if (!(tag instanceof Rect)) continue;
            Rect rect = (Rect)tag;
            parent.setTouchDelegate(new TouchDelegate(rect, child));
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RedPointType {
    }

    private class FootPopupAdapter
    extends BaseAdapter {
        private FootPopupAdapter() {
        }

        public int getCount() {
            return FootOperationBar.this.mPopupItems.size();
        }

        public Object getItem(int position) {
            return FootOperationBar.this.mPopupItems.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)FootOperationBar.this.getContext()).inflate(R.layout.os_foot_opt_bar_popup_item, parent, false);
                holder = new ViewHolder();
                holder.title = (TextView)convertView.findViewById(R.id.os_foot_opt_bar_popup_item_text);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            holder.title.setText((CharSequence)FootOperationBar.this.mPopupItems.get(position));
            FootOperationBar.this.viewEnable(convertView, FootOperationBar.this.mMenuEnables[position]);
            final int index = position + FootOperationBar.this.mVisibleTabCount;
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FootOperationBar.this.mItemClickListener != null) {
                        FootOperationBar.this.mItemClickListener.onItemClick(index);
                    }
                    FootOperationBar.this.mPopup.dismiss();
                }
            });
            return convertView;
        }

        private class ViewHolder {
            private TextView title;

            private ViewHolder() {
            }
        }
    }

    public static interface OnFootOptBarClickListener {
        public void onItemClick(int var1);
    }

    private static class MyOnPreDrawListener
    implements ViewTreeObserver.OnPreDrawListener {
        private final WeakReference<FootOperationBar> mFootOperationBar;

        MyOnPreDrawListener(FootOperationBar footOperationBar) {
            this.mFootOperationBar = new WeakReference<FootOperationBar>(footOperationBar);
        }

        public boolean onPreDraw() {
            FootOperationBar footOperationBar = (FootOperationBar)((Object)this.mFootOperationBar.get());
            if (footOperationBar != null) {
                footOperationBar.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                footOperationBar.offsetTopAndBottom(footOperationBar.getMeasuredHeight());
                footOperationBar.setVisibility(8);
                if (footOperationBar.mInitShow || footOperationBar.mShow) {
                    footOperationBar.setVisibility(0);
                    footOperationBar.openFootOperationBar();
                }
            }
            return true;
        }
    }
}

