/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.actionbar;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import android.widget.PopupMenu;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Point;
import com.transsion.widgetslib.util.PointAnimUtil;
import java.util.ArrayList;

public class OverflowMenu
extends View {
    private static final int MENU_FRAME_OFFSET_BOTTOM_DP = 30;
    private static final int PAINT_COLOR = -10461088;
    private int mWidth;
    private int mMenuColor = -10461088;
    private ArrayList<Point> mPoints;
    private PointAnimUtil mPointAnimHelper;
    private Paint mCirclePaint;
    private int mLayoutDir;
    private int mMenuItemHeight;
    private final Resources mRes;
    private PopupMenu mOverflowMenu;
    public OnPopMenuListener mPopMenuListener;
    private View.OnClickListener mOutClickListener;
    private Fragment mFg;
    private Activity mActivity;
    private int fMenuId;
    private static boolean mIsMultiWindow = false;
    private boolean mIsShowing = false;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (OverflowMenu.this.mOverflowMenu != null) {
                OverflowMenu.this.mOverflowMenu.getMenu().clear();
                OverflowMenu.this.mOverflowMenu.inflate(OverflowMenu.this.fMenuId);
            }
        }
    };

    public OverflowMenu(Context context) {
        this(context, null);
    }

    public OverflowMenu(Context context, AttributeSet attrs) {
        this(context, attrs, R.style.OsPopupMenuStyle);
    }

    public OverflowMenu(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public OverflowMenu(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setClickable(true);
        this.setFocusable(true);
        this.mRes = context.getResources();
        this.mMenuItemHeight = this.mRes.getDimensionPixelSize(R.dimen.os_list_item_height_small);
        this.mPoints = new ArrayList(3);
        this.mPointAnimHelper = new PointAnimUtil(this);
        this.initCirclePaint();
    }

    public void setOverMenuColor(int color2) {
        this.mMenuColor = color2;
        this.mCirclePaint.setColor(this.mMenuColor);
    }

    public void setActivity(Activity activity) {
        this.mActivity = activity;
    }

    public void setFragment(Fragment fg) {
        this.mFg = fg;
    }

    @Deprecated
    public void setOutOnClickListener(View.OnClickListener l) {
        this.mOutClickListener = l;
    }

    public void setOnPopMenuListener(OnPopMenuListener listener) {
        this.mPopMenuListener = listener;
        this.createPopuMenu(this.mLayoutDir);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.setOverMenuColor(this.mMenuColor & Integer.MAX_VALUE);
        } else {
            this.setOverMenuColor(-10461088);
        }
    }

    private void initCirclePaint() {
        this.mCirclePaint = new Paint();
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setDither(true);
        this.mCirclePaint.setColor(this.mMenuColor);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mPointAnimHelper.abort();
        if (this.mOverflowMenu != null) {
            this.mOverflowMenu.dismiss();
        }
        this.mOverflowMenu = null;
    }

    private void initCirclePosition(int width) {
        this.mPointAnimHelper.setCetnerPosition(width / 2, width / 2);
        this.mLayoutDir = this.getLayoutDirection();
        this.mPointAnimHelper.setPointDir(this.mLayoutDir, this.mPoints);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mLayoutDir != newConfig.getLayoutDirection()) {
            this.requestLayout();
        }
    }

    public void show() {
        int[] screenLocation = new int[2];
        this.getLocationOnScreen(screenLocation);
        if (screenLocation[1] <= this.getResources().getDisplayMetrics().heightPixels / 3) {
            Log.w((String)"os_menu", (String)"Warnging, screen in a error point!");
            return;
        }
        if (!this.mIsShowing && this.mOverflowMenu != null) {
            if (this.mActivity == null && this.mFg == null) {
                throw new RuntimeException("Must provide a activity or fragment!");
            }
            if (this.mActivity != null) {
                this.mActivity.onPrepareOptionsMenu(this.mOverflowMenu.getMenu());
            }
            if (this.mFg != null) {
                this.mFg.onPrepareOptionsMenu(this.mOverflowMenu.getMenu());
            }
            this.mIsShowing = true;
            this.mOverflowMenu.show();
            this.mPointAnimHelper.start(true, this.mLayoutDir);
        }
    }

    public void dismiss() {
        if (this.mOverflowMenu != null) {
            this.mOverflowMenu.dismiss();
        }
    }

    public PopupMenu getPopWindow() {
        return this.mOverflowMenu;
    }

    public boolean isShowing() {
        return this.mIsShowing;
    }

    private void createPopuMenu(int layoutDirection) {
        this.mOverflowMenu = layoutDirection == 1 ? new PopupMenu(this.getContext(), (View)this, 0, 0, R.style.OsPopupMenuStyle) : new PopupMenu(this.getContext(), (View)this, 0, 0, R.style.OsPopupMenuStyle);
        this.mOverflowMenu.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                if (OverflowMenu.this.mActivity != null) {
                    OverflowMenu.this.mActivity.onOptionsItemSelected(item);
                }
                if (OverflowMenu.this.mFg != null) {
                    OverflowMenu.this.mFg.onOptionsItemSelected(item);
                }
                return false;
            }
        });
        this.mOverflowMenu.setOnDismissListener(new PopupMenu.OnDismissListener(){

            public void onDismiss(PopupMenu menu) {
                OverflowMenu.this.mIsShowing = false;
                OverflowMenu.this.setSelected(false);
            }
        });
        if (this.mPopMenuListener != null) {
            this.mPopMenuListener.onCreated();
        }
    }

    public void setupOverflowMenuButton(int menuId) {
        this.fMenuId = menuId;
        this.mHandler.sendEmptyMessage(2);
    }

    public void onMultiWindowModeChanged(boolean isInMultiWindow) {
        mIsMultiWindow = isInMultiWindow;
    }

    @SuppressLint(value={"WrongConstant"})
    public void getWindowVisibleDisplayFrame(Rect outRect) {
        super.getWindowVisibleDisplayFrame(outRect);
        if (this.mActivity != null && this.getDisplay() != null && this.mRes != null) {
            outRect.bottom -= this.mRes.getDimensionPixelSize(R.dimen.os_shadowbutton_width_height);
            outRect.top = mIsMultiWindow && outRect.bottom - outRect.top > 0 ? outRect.bottom - this.mMenuItemHeight * 4 : (this.getDisplay().getRotation() % 2 != 0 ? outRect.bottom - this.mMenuItemHeight * 4 : outRect.bottom - this.mMenuItemHeight * 6);
        }
    }

    public boolean performClick() {
        if (super.performClick()) {
            return true;
        }
        this.setSelected(true);
        this.playSoundEffect(0);
        if (this.mOutClickListener != null) {
            this.mOutClickListener.onClick((View)this);
        }
        return true;
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        if (selected) {
            this.show();
        } else {
            this.mPointAnimHelper.start(false, this.mLayoutDir);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mWidth == 0) {
            this.mWidth = this.getMeasuredWidth();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.initCirclePosition(this.mWidth);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (Point point : this.mPoints) {
            point.draw(canvas, this.mCirclePaint);
        }
        if (this.mPointAnimHelper.mState == 4) {
            this.mPointAnimHelper.update();
        }
    }

    public static interface OnPopMenuListener {
        public void onCreated();
    }
}

