/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.actionbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.ImageButton;
import com.transsion.widgetslib.R;

@SuppressLint(value={"AppCompatCustomView"})
public class ShadowButton
extends ImageButton {
    private static final String TAG = "FloatButton";
    private static final boolean DEBUG = false;
    private static final int BG_INSET = 4;
    private static final int SHADOW_RADIUS = 3;
    private Paint mPaint;
    private int mWidth;
    private int mHeight;
    private float mShadowRadius;
    private int mShadowColor;
    private float mBgInset;
    private int mBgWidth;
    private boolean mIsMultiWin;

    public ShadowButton(Context context) {
        this(context, null);
    }

    public ShadowButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        float density = context.getResources().getDisplayMetrics().density;
        this.mShadowRadius = 3.0f * density;
        this.mBgInset = 4.0f * density;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.osFloatButton, 0, 0);
        this.mShadowRadius = a.getDimension(R.styleable.osFloatButton_fbshadowRadius, this.mShadowRadius) - density;
        this.mShadowColor = a.getColor(R.styleable.osFloatButton_fbshadowColor, 1711516148);
        a.recycle();
        if (this.getBackground() != null) {
            this.mBgWidth = this.getBackground().getIntrinsicWidth();
        }
        this.setLayerType(1, null);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        if (this.getBackgroundTintList() != null) {
            int bgTintColor = this.getBackgroundTintList().getDefaultColor();
            this.mPaint.setColor(bgTintColor);
        } else {
            this.mPaint.setColor(0);
        }
        this.initShadowPaint(this.mShadowRadius, this.mShadowColor);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w > 0) {
            this.mBgWidth = this.mWidth = w;
            this.mHeight = h;
            this.mBgWidth = (int)((float)this.mBgWidth - this.mBgInset * 2.0f);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mIsMultiWin) {
            this.setMeasuredDimension((int)((float)widthSize * 0.75f), (int)((double)heightSize * 0.75));
        } else {
            this.setMeasuredDimension(widthSize, heightSize);
        }
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawCircle((float)(this.mWidth / 2), (float)(this.mBgWidth / 2), (float)(this.mBgWidth / 2), this.mPaint);
        super.onDraw(canvas);
    }

    public void setMultiWindowMode(boolean isMultiWin) {
        this.mIsMultiWin = isMultiWin;
        if (isMultiWin) {
            this.setShadowRadius(this.mShadowRadius * 0.75f);
        }
        Log.i((String)"os_fb", (String)("FloatButton, setMultiWindowMode() isMultiWin=" + isMultiWin));
        this.requestLayout();
    }

    public void setShadowColor(int shadowColor) {
        this.mShadowColor = shadowColor;
        this.initShadowPaint(this.mShadowRadius, shadowColor);
        this.invalidate();
    }

    public void setShadowRadius(float shadowRadius) {
        this.mShadowRadius = shadowRadius;
        this.initShadowPaint(shadowRadius, this.mShadowColor);
        this.invalidate();
    }

    private void initShadowPaint(float shadowRadius, int shadowColor) {
        this.mPaint.setShadowLayer(shadowRadius, 0.0f, shadowRadius, shadowColor);
    }
}

