/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.editext;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.Editable;
import android.text.InputFilter;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.util.Utils;
import com.transsion.widgetslib.widget.editext.ExtendedEditText;

public class OSMaterialEditField
extends RelativeLayout
implements TextWatcher {
    private Context mContext;
    private ExtendedEditText mEditText;
    private View mRootLayout;
    private View mBGLayout;
    private TextView mLabel;
    private String mLabelText;
    private TextView mErrorText;
    private boolean mShowError;
    private String mTipInputMax;
    private int mBGRadius;
    private int mTextNum;
    private TextView mNumText;
    private OnInputNumListener mOnInputNumListener;
    private int mErrorColor;
    private int mNormalColor;
    private GradientDrawable mGradientDrawable;
    private Toast mToast;

    public OSMaterialEditField(@NonNull Context context) {
        this(context, null);
    }

    public OSMaterialEditField(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public OSMaterialEditField(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.OSMaterialEditField);
        int indexCount = typedArray.getIndexCount();
        for (int at = 0; at < indexCount; ++at) {
            int index = typedArray.getIndex(at);
            if (index == R.styleable.OSMaterialEditField_os_ef_field_label) {
                this.mLabelText = typedArray.getString(index);
                continue;
            }
            if (index == R.styleable.OSMaterialEditField_os_ef_show_error) {
                this.mShowError = typedArray.getBoolean(index, false);
                continue;
            }
            if (index != R.styleable.OSMaterialEditField_os_ef_field_radius) continue;
            this.mBGRadius = typedArray.getDimensionPixelSize(index, Utils.dp2px(context, 6));
        }
        typedArray.recycle();
        this.init();
    }

    private void init() {
        OSMaterialEditField.inflate((Context)this.mContext, (int)R.layout.os_view_materal_edit_field_layout_base, (ViewGroup)this);
        this.mTipInputMax = this.mContext.getString(R.string.os_dialog_input_tip_max);
        this.mEditText = (ExtendedEditText)this.findViewById(R.id.os_ef_edit_field);
        this.mErrorText = (TextView)this.findViewById(R.id.os_ef_edit_text_error_hint);
        if (this.mShowError) {
            this.mErrorText.setVisibility(4);
        }
        this.mRootLayout = this.findViewById(R.id.os_ef_second_root_layout);
        this.mBGLayout = this.findViewById(R.id.os_ef_edit_field_bg);
        this.mErrorColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_red_basic_color);
        this.mNormalColor = ContextCompat.getColor((Context)this.mContext, (int)R.color.os_gray_quaternary_color);
        this.mGradientDrawable = new GradientDrawable();
        this.mGradientDrawable.setColor(this.mNormalColor);
        this.mGradientDrawable.setCornerRadius((float)this.mBGRadius);
        this.mBGLayout.setBackground((Drawable)this.mGradientDrawable);
        if (!TextUtils.isEmpty((CharSequence)this.mLabelText)) {
            this.mLabel = (TextView)this.findViewById(R.id.os_ef_edit_text_label);
            this.mLabel.setText((CharSequence)this.mLabelText);
            this.mLabel.setVisibility(0);
        }
        if (Utils.isXOSorITEL()) {
            this.setRootPaddingRelative(this.getResources().getDimensionPixelSize(R.dimen.os_text_field_big_icon_magin_xos), 0, this.getResources().getDimensionPixelSize(R.dimen.os_text_field_big_icon_magin_xos), 0);
            if (this.mLabel != null) {
                ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mLabel.getLayoutParams();
                layoutParams.setMarginStart(Utils.dp2px(this.mContext, 2));
                layoutParams.setMarginEnd(Utils.dp2px(this.mContext, 2));
                this.mLabel.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
    }

    @Nullable
    public TextView getEditTextLabel() {
        return this.mLabel;
    }

    public ExtendedEditText getEditText() {
        return this.mEditText;
    }

    @Nullable
    public TextView getNumText() {
        return this.mNumText;
    }

    public OSMaterialEditField setError(CharSequence message) {
        if (!TextUtils.isEmpty((CharSequence)message)) {
            this.mErrorText.setText(message);
            this.mErrorText.setVisibility(0);
            this.updateUnderlineView(true);
        } else {
            this.mErrorText.setText(message);
            this.mErrorText.setVisibility(this.mShowError ? 4 : 8);
            this.updateUnderlineView(false);
        }
        return this;
    }

    public OSMaterialEditField setTipInputMax(@StringRes int resId) {
        return this.setTipInputMax(this.mContext.getString(resId));
    }

    public OSMaterialEditField setTipInputMax(String tipText) {
        this.mTipInputMax = tipText;
        return this;
    }

    public void updateUnderlineView(boolean error) {
        if (error) {
            this.mGradientDrawable.setStroke(2, this.mErrorColor);
        } else {
            this.mGradientDrawable.setStroke(0, 0);
        }
    }

    public OSMaterialEditField setInputNum(int textNum, OnInputNumListener listener) {
        this.mNumText = (TextView)this.findViewById(R.id.os_ef_num_text);
        if (textNum <= 0) {
            this.mTextNum = -1;
            this.mNumText.setVisibility(8);
        } else {
            this.mTextNum = textNum;
            this.mNumText.setVisibility(0);
            this.mEditText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(textNum)});
            this.mNumText.setText((CharSequence)new StringBuilder().append(String.format("%d", this.mEditText.getText().length())).append("/").append(String.format("%d", textNum)));
        }
        this.mOnInputNumListener = listener;
        return this;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mEditText.addTextChangedListener(this);
        this.afterTextChanged(this.mEditText.getText());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mEditText.removeTextChangedListener(this);
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        if (this.mNumText != null && this.mNumText.getVisibility() == 0) {
            int length = s.length();
            if (length < this.mTextNum) {
                this.mNumText.setText((CharSequence)new StringBuilder().append(String.format("%d", length)).append("/").append(String.format("%d", this.mTextNum)));
            } else if (length == this.mTextNum) {
                this.mNumText.setText((CharSequence)new StringBuilder().append(String.format("%d", this.mTextNum)).append("/").append(String.format("%d", this.mTextNum)));
                if (!TextUtils.isEmpty((CharSequence)this.mTipInputMax)) {
                    if (this.mToast == null) {
                        this.mToast = Toast.makeText((Context)this.mContext, (CharSequence)this.mTipInputMax, (int)1);
                    }
                    this.mToast.show();
                }
            }
            if (length > 0) {
                this.mNumText.setTextColor(this.mContext.getColor(R.color.os_text_secondary_color));
            } else if (length == 0) {
                this.mNumText.setTextColor(this.mContext.getColor(R.color.os_text_quaternary_color));
            }
        }
        if (this.mOnInputNumListener != null) {
            this.mOnInputNumListener.onInputNum(s, this.mNumText);
        }
    }

    public void setRootPaddingRelative(int start, int top, int end, int bottom) {
        this.mRootLayout.setPaddingRelative(start, top, end, bottom);
    }

    public static interface OnInputNumListener {
        public void onInputNum(Editable var1, TextView var2);
    }
}

