/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.tablayout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListPopupWindow;
import android.widget.TextView;
import androidx.annotation.ArrayRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.transsion.widgetslib.R;
import com.transsion.widgetslib.widget.tablayout.TabLayout;
import java.util.Arrays;
import java.util.List;

public class OSTabLayout
extends LinearLayout
implements View.OnClickListener,
View.OnScrollChangeListener {
    private static final String TAG = "OSTabLayout";
    private TabLayout mTabLayout;
    private ImageView mOverflowButton;
    private LinearLayout mLlIconContainer;
    private List<String> mPopupItems;
    private ListPopupWindow mPopupWindow;
    private OnItemClickListener mItemClickListener;
    private View.OnClickListener mOnClickListener;
    private boolean[] mOverflowState;
    private boolean mShowBottomLine;
    private boolean mIsFirstLevelTab;
    private TextView mTvLeftMask;
    private TextView mTvRightMask;
    private View mBottomLine;
    private View mLlTabIconContainer;
    private int mTabPaddingStart;

    public OSTabLayout(Context context) {
        this(context, null);
    }

    public OSTabLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.os_tab_layout, null);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OSTabLayout);
        this.mShowBottomLine = a.getBoolean(R.styleable.OSTabLayout_osShowBottomLine, false);
        this.mIsFirstLevelTab = a.getBoolean(R.styleable.OSTabLayout_osIsFirstLevelTab, false);
        int[] attrBg = new int[]{R.attr.OsBgPrimary};
        TypedArray typedArray = context.obtainStyledAttributes(attrBg);
        int defaultColor = typedArray.getColor(0, ContextCompat.getColor((Context)context, (int)R.color.os_bg_primary_color));
        typedArray.recycle();
        int background = a.getColor(R.styleable.OSTabLayout_osTabLayoutBackground, defaultColor);
        view.setBackgroundColor(background);
        a.recycle();
        int[] attrsPaddingStart = new int[]{R.attr.tabPaddingStart};
        TypedArray typedArrayPaddingStart = context.obtainStyledAttributes(R.style.OSTablayout, attrsPaddingStart);
        this.mTabPaddingStart = typedArrayPaddingStart.getDimensionPixelSize(0, context.getResources().getDimensionPixelSize(R.dimen.os_tab_item_padding_start));
        typedArrayPaddingStart.recycle();
        this.mBottomLine = view.findViewById(R.id.tablayout_underline);
        if (this.mShowBottomLine) {
            this.mBottomLine.setVisibility(0);
        } else {
            this.mBottomLine.setVisibility(4);
        }
        this.mTabLayout = (TabLayout)view.findViewById(R.id.tablayout);
        this.mTabLayout.setOnScrollChangeListener(this);
        this.mTabLayout.bindOSTabLayout(this);
        this.mOverflowButton = (ImageView)view.findViewById(R.id.overFlowButton);
        this.mLlIconContainer = (LinearLayout)view.findViewById(R.id.ll_icon_container);
        this.mOverflowButton.setOnClickListener((View.OnClickListener)this);
        this.mTvLeftMask = (TextView)view.findViewById(R.id.tv_left_mask);
        this.mTvRightMask = (TextView)view.findViewById(R.id.tv_right_mask);
        this.mTabLayout.isFirstLevelTab(this.mIsFirstLevelTab);
        this.mLlTabIconContainer = view.findViewById(R.id.ll_tab_icon_container);
        this.addView(view, (ViewGroup.LayoutParams)params);
        this.post(new Runnable(){

            @Override
            public void run() {
                OSTabLayout.this.handleFilter();
            }
        });
    }

    public void setShowBottomLine(boolean showBottomLine) {
        if (showBottomLine) {
            this.mBottomLine.setVisibility(0);
        } else {
            this.mBottomLine.setVisibility(4);
        }
    }

    public TabLayout getTabLayout() {
        return this.mTabLayout;
    }

    public void onClick(View v) {
        if (v == this.mOverflowButton) {
            if (this.mPopupWindow != null) {
                this.mPopupWindow.setVerticalOffset((this.getHeight() - this.mOverflowButton.getHeight()) / 2);
                this.mPopupWindow.show();
            }
            if (this.mOnClickListener != null) {
                this.mOnClickListener.onClick(v);
            }
        }
    }

    public void setBackground(int resId) {
        this.setBackgroundResource(resId);
    }

    public void setOverflowImage(@DrawableRes int resId) {
        if (this.mOverflowButton != null) {
            this.mOverflowButton.setBackground(this.getResources().getDrawable(resId));
        }
    }

    public void setOverflowButtonVisible(boolean visible) {
        if (this.mOverflowButton != null) {
            if (visible) {
                this.mOverflowButton.setVisibility(0);
            } else {
                this.mOverflowButton.setVisibility(8);
            }
        }
    }

    public void setOverflowItemState(int position, boolean enable) {
        if (this.mOverflowState != null) {
            this.mOverflowState[position] = enable;
        }
    }

    public void setOverFlowMenuItem(@ArrayRes int resId) {
        this.mOverflowButton.setVisibility(0);
        this.mPopupItems = Arrays.asList(this.getResources().getStringArray(resId));
        this.initOverflowItemState(this.mPopupItems);
        TabOverflowPopupAdapter adapter = new TabOverflowPopupAdapter();
        this.mPopupWindow = new ListPopupWindow(this.getContext(), null, 0, R.style.OSTabOverflow);
        this.mPopupWindow.setAnchorView((View)this.mOverflowButton);
        this.mPopupWindow.setAdapter((ListAdapter)adapter);
        this.mPopupWindow.setModal(true);
        this.mPopupWindow.setContentWidth(this.measureMaxWidth((ListAdapter)adapter, this.getResources().getDisplayMetrics().widthPixels / 2));
    }

    private void initOverflowItemState(List<String> popupItems) {
        if (popupItems != null) {
            this.mOverflowState = new boolean[this.mPopupItems.size()];
            for (int i = 0; i < popupItems.size(); ++i) {
                this.mOverflowState[i] = true;
            }
        }
    }

    private int measureMaxWidth(ListAdapter adapter, int maxAllowedWidth) {
        int maxWidth = 0;
        View itemView = null;
        int itemType = 0;
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            int positionType = adapter.getItemViewType(i);
            if (positionType != itemType) {
                itemType = positionType;
                itemView = null;
            }
            itemView = adapter.getView(i, itemView, null);
            itemView.measure(widthMeasureSpec, heightMeasureSpec);
            int itemWidth = itemView.getMeasuredWidth();
            if (itemWidth >= maxAllowedWidth) {
                return maxAllowedWidth;
            }
            if (itemWidth <= maxWidth) continue;
            maxWidth = itemWidth;
        }
        return maxWidth;
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mItemClickListener = onItemClickListener;
    }

    public void setOnItemClickListener(View.OnClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
    }

    private void viewEnable(View view, boolean enAble) {
        view.setEnabled(enAble);
        view.setAlpha(enAble ? 1.0f : 0.3f);
    }

    public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
        this.handleFilter();
    }

    private boolean isTabLayoutScroll() {
        return this.mTabLayout.getMeasuredWidth() != this.mTabLayout.getChildAt(0).getMeasuredWidth();
    }

    private void handleFilter() {
        boolean toEndEdge;
        if (!this.isTabLayoutScroll()) {
            this.mTvLeftMask.setVisibility(8);
            this.mTvRightMask.setVisibility(8);
            return;
        }
        int scrollX = this.mTabLayout.getScrollX();
        boolean bl = toEndEdge = scrollX + this.mTabLayout.getMeasuredWidth() >= this.mTabLayout.getChildAt(0).getMeasuredWidth();
        if (scrollX > 0 && toEndEdge) {
            this.mTvLeftMask.setVisibility(0);
            this.mTvRightMask.setVisibility(8);
        } else if (scrollX > 0) {
            this.mTvLeftMask.setVisibility(0);
            this.mTvRightMask.setVisibility(0);
        } else {
            this.mTvLeftMask.setVisibility(8);
            this.mTvRightMask.setVisibility(0);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.handleFilter();
        this.handleInsets();
    }

    protected void handleInsets() {
        int endPadding;
        int startPadding;
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mBottomLine.getLayoutParams();
        if (!this.isTabLayoutScroll()) {
            int marginStart = this.getResources().getDimensionPixelSize(R.dimen.os_tab_second_underline_margin_start);
            int marginEnd = this.getResources().getDimensionPixelSize(R.dimen.os_tab_second_underline_margin_end);
            layoutParams.setMarginStart(marginStart);
            layoutParams.setMarginEnd(marginEnd);
        } else {
            layoutParams.setMarginStart(0);
            layoutParams.setMarginEnd(0);
        }
        this.mBottomLine.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (this.mTabLayout.getTabCount() <= 2 && this.mTabLayout.getTabMode() == 1) {
            startPadding = this.getResources().getDimensionPixelSize(R.dimen.os_tab_padding_for_two);
            endPadding = this.getResources().getDimensionPixelSize(R.dimen.os_tab_padding_for_two);
        } else {
            startPadding = this.getResources().getDimensionPixelSize(R.dimen.os_tab_padding);
            endPadding = this.getResources().getDimensionPixelSize(R.dimen.os_tab_padding);
            if (this.mTabLayout.getTabMode() == 0) {
                startPadding = this.getResources().getDimensionPixelSize(R.dimen.os_tab_padding_for_two) - this.mTabPaddingStart;
            }
        }
        if (this.mOverflowButton.getVisibility() == 0) {
            endPadding = this.getResources().getDimensionPixelSize(R.dimen.os_tab_overflow_image_edge_distance) - this.getResources().getDimensionPixelSize(R.dimen.os_tab_overflow_image_margin_end);
        }
        this.mLlTabIconContainer.setPaddingRelative(0, this.mLlTabIconContainer.getPaddingTop(), endPadding, this.mLlTabIconContainer.getPaddingBottom());
        if (this.mTabLayout.getChildAt(0) != null) {
            this.mTabLayout.getChildAt(0).setPaddingRelative(startPadding, this.mTabLayout.getPaddingTop(), 0, this.mTabLayout.getPaddingBottom());
        }
    }

    public void setCustomMenuView(View viewGroup) {
        if (this.mLlIconContainer != null) {
            this.mLlIconContainer.removeAllViews();
            this.mLlIconContainer.addView(viewGroup);
            ViewGroup.LayoutParams layoutParams = viewGroup.getLayoutParams();
            layoutParams.width = -2;
            layoutParams.height = -1;
            viewGroup.setLayoutParams(layoutParams);
        }
    }

    private class TabOverflowPopupAdapter
    extends BaseAdapter {
        private TabOverflowPopupAdapter() {
        }

        public int getCount() {
            return OSTabLayout.this.mPopupItems.size();
        }

        public Object getItem(int position) {
            return OSTabLayout.this.mPopupItems.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(final int position, View convertView, ViewGroup parent) {
            ViewHolder holder;
            if (convertView == null) {
                holder = new ViewHolder();
                convertView = LayoutInflater.from((Context)OSTabLayout.this.getContext()).inflate(R.layout.os_tab_overflow_popup_item, parent, false);
                holder.title = (TextView)convertView.findViewById(R.id.os_tab_overflow_popup_item_text);
                convertView.setTag((Object)holder);
            } else {
                holder = (ViewHolder)convertView.getTag();
            }
            convertView.setBackgroundResource(R.drawable.os_press_primary_bg);
            holder.title.setText((CharSequence)OSTabLayout.this.mPopupItems.get(position));
            OSTabLayout.this.viewEnable(convertView, OSTabLayout.this.mOverflowState[position]);
            convertView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (OSTabLayout.this.mItemClickListener != null) {
                        OSTabLayout.this.mItemClickListener.onItemClick(position);
                    }
                    OSTabLayout.this.mPopupWindow.dismiss();
                }
            });
            return convertView;
        }

        private class ViewHolder {
            private TextView title;

            private ViewHolder() {
            }
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(int var1);
    }
}

