/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.widgetslib.widget.timepicker.wheel;

import java.util.Calendar;

public class DateObject {
    private int mYear;
    private int mMonth;
    private int mDay;
    private int mWeek;
    private int mHour;
    private int mMinute;
    private String mListItem;

    public DateObject(int year, int month, int day) {
        this.mYear = year;
        int maxDayOfMonth = Calendar.getInstance().getActualMaximum(5);
        if (day > maxDayOfMonth) {
            this.mYear = month + 1;
            this.mDay = day % maxDayOfMonth;
        } else {
            this.mMonth = month;
            this.mDay = day;
        }
        this.mListItem = String.format("%02d", month) + "\u6708" + String.format("%02d", this.mDay) + "\u65e5";
    }

    public DateObject(int hour2, int minute2, boolean isHourType) {
        if (isHourType && hour2 != -1) {
            this.mHour = hour2 > 24 ? hour2 % 24 : hour2;
            this.mListItem = this.mHour + "";
        } else if (!isHourType && minute2 != -1) {
            this.mMinute = minute2 > 60 ? minute2 % 60 : minute2;
            this.mListItem = this.mMinute + "";
        }
    }

    public int getHour() {
        return this.mHour;
    }

    public void setHour(int hour) {
        this.mHour = hour;
    }

    public int getMinute() {
        return this.mMinute;
    }

    public void setMinute(int minute) {
        this.mMinute = minute;
    }

    public int getWeek() {
        return this.mWeek;
    }

    public void setWeek(int week) {
        this.mWeek = week;
    }

    public int getmYear() {
        return this.mYear;
    }

    public void setmYear(int mYear) {
        this.mYear = mYear;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public void setMonth(int month) {
        this.mMonth = month;
    }

    public int getDay() {
        return this.mDay;
    }

    public void setDay(int day) {
        this.mDay = day;
    }

    public String getListItem() {
        return this.mListItem;
    }

    public void setListItem(String listItem) {
        this.mListItem = listItem;
    }
}

